---\napplies_to:
- family_law_motions
- electronic_filing
- pro_se_litigants
- attorney_filing
case_numbers:
- 20-3-03830-3-SEA
- 25-2-11308-6-SEA
court: king_county_superior
created: '2025-08-15'
document_type: filing_reference_guide
jurisdiction: washington_state
priority: critical
related_documents:
- description: Current case filing status for August 25 hearing
  relationship_type: case_specific_status
  uri: 01_ACTIVE_HEARING_AUG_25/FILING_READY_STATUS_AUGUST_25_2025.md
- description: Specific filing instructions for current case
  relationship_type: case_specific_instructions
  uri: 01_ACTIVE_HEARING_AUG_25/00_FILING_INSTRUCTIONS.md
research_date: '2025-08-15'
scope: comprehensive_filing_guide
search_keywords:
- King County filing requirements
- GR 14 formatting
- KC Script Portal
- family law motions
- electronic filing deadlines
semantic_concepts: []
sources:
- King County Superior Court Official Website
- Washington State General Rule 14
- King County Local Family Law Rules
- KC Script Portal Documentation
status: active_reference
tags:
- filing-requirements
- king-county-superior-court
- document-formatting
- electronic-filing
- deadlines
- service-requirements
- fees
title: King County Superior Court Filing Requirements - Complete Reference Guide
updated: '2025-08-15'
---
# 📋 KING COUNTY SUPERIOR COURT FILING REQUIREMENTS
## Complete Reference Guide for Family Law Cases

**Court:** King County Superior Court, Washington State  
**Jurisdiction:** Family Law Division  
**System:** KC Script Portal Electronic Filing  
**Research Date:** August 15, 2025  
**Document Status:** Complete Reference - Save for All Future Filings  

---

## 🚨 CRITICAL DEADLINE FRAMEWORK

### **⏰ FAMILY LAW MOTION DEADLINES**
```
FILING DEADLINE CALCULATION:
• Motion Documents: 9 judicial days before hearing
• Service Requirement: 14 calendar days before hearing  
• Working Papers: 5 judicial days before hearing (by NOON)
• Filing Time: Documents must be filed by 4:30 PM (except special deadlines)

IMPORTANT: "Judicial days" = weekdays only (excludes weekends/holidays)
```

### **📅 AUGUST 25, 2025 HEARING DEADLINES (RESPONDING PARTY)**
- **ABSOLUTE FILING DEADLINE:** August 18, 2025 @ **NOON** (5 judicial days before hearing)
- **Moving Party Service:** Matt served motions July 11 (14 days before Aug 25 - deadline met)
- **Working Papers Due:** August 18, 2025 @ NOON (same as response deadline)
- **Confirmation Required:** Working Papers Submission List must be filed to confirm hearing

---

## 📄 DOCUMENT FORMATTING REQUIREMENTS (WA GR 14)

### **📐 PAPER & MARGINS**
```
PAPER SPECIFICATIONS:
• Size: 8½ x 11 inches
• Color: White only
• Sides: Single-sided only
• Quality: Standard copy paper acceptable

MARGIN REQUIREMENTS:
• First Page: 3 inches from top, 1 inch from other sides
• Subsequent Pages: 1 inch margins on all sides
• Text: Double-spaced
• Binding: No spiral binding, staples OK for short docs
```

### **🔤 FONT REQUIREMENTS (ADA COMPLIANT ONLY)**
```
ACCEPTABLE FONTS:
✅ Arial               ✅ Times New Roman
✅ Calibri             ✅ Verdana  
✅ Cambria             ✅ Tahoma
✅ Geneva              ✅ Times

FONT SPECIFICATIONS:
• Size: 12-point minimum
• Color: Black only
• Style: Regular (no bold/italic in body text)
• Handwriting: If any, must be printed in black/dark blue ink
```

### **🚫 PROHIBITED ELEMENTS**
```
ABSOLUTELY FORBIDDEN:
❌ Colored pages or paper
❌ Highlighting (any color)
❌ Colored ink or markings
❌ Non-ADA compliant fonts
❌ Font sizes below 12-point
❌ Double-sided printing
❌ Spiral binding
```

### **📏 PAGE LIMITS**
```
FAMILY LAW DECLARATION LIMITS:
• Moving Party: 25 pages total (initial + reply)
• Responding Party: 20 pages total
• Exhibits: No specific limit, but must be relevant
• Court may reject overlength filings
```

---

## ⚡ ELECTRONIC FILING - KC SCRIPT PORTAL

### **🌐 SYSTEM ACCESS**
```
PRIMARY PORTAL: https://dja-efsp.kingcounty.gov/efiling/
BACKUP STATUS: http://www.kcscclerkefilingstatus.com/
ACCOUNT REQUIRED: Yes (free registration)
MANDATORY FOR: Attorneys
OPTIONAL FOR: Pro se litigants (but strongly recommended)
```

### **💻 E-FILING PROCESS**
```
STEP-BY-STEP PROCEDURE:
1. Log into KC Script Portal
2. Select "File New Document"
3. Enter Case Number: 20-3-03830-3-SEA
4. Upload PDF documents (one by one)
5. Select document type from dropdown
6. Add document description
7. Review fee calculation
8. Submit payment (if required)
9. Receive confirmation email
10. Save confirmation for records
```

### **📁 FILE FORMAT REQUIREMENTS**
```
DOCUMENT FORMAT:
• File Type: PDF only
• File Size: Maximum 35MB per document
• File Naming: Descriptive names recommended
• Quality: Text must be searchable (not scanned images)
• Security: No password protection

DOCUMENT ORGANIZATION:
• Main Documents: Separate files
• Exhibits: Can be combined or separate
• Attachments: Must be labeled clearly
```

### **🔧 SYSTEM STATUS & MAINTENANCE**
```
REGULAR MAINTENANCE: 
• Typically Friday evenings 6 PM - Saturday 6 PM
• Recent Maintenance: August 15-16, 2025
• Status Updates: Check backup website during outages
• Emergency Filing: Paper filing allowed during system outages
```

---

## 💰 FILING FEES & PAYMENT

### **💵 FEE STRUCTURE**
```
FAMILY LAW MOTION FEES (2025):
• Motion for Temporary Orders: $20-40 (varies by type)
• Response to Motion: Usually no additional fee
• Electronic Filing: FREE (but statutory fees apply)
• Credit Card Processing: Additional $2.49

FEE PAYMENT METHODS:
• Online: Credit/debit card or electronic check
• In-Person: Cash, check, money order, card
• Mail: Check or money order only
• Check Requirements: Washington State bank, pre-printed address
```

### **🆓 FEE WAIVER PROCESS**
```
QUALIFICATION:
• Income-based eligibility
• Public assistance recipients
• Indigency determination

APPLICATION PROCESS:
• Use Washington Courts GR 34 forms
• Available at: https://www.courts.wa.gov/forms/
• File with case documents

CONTACT FOR ASSISTANCE:
• Family Law Facilitator Program
• Seattle: (206) 477-2553
• Kent: (206) 477-2781
```

---

## 📨 SERVICE REQUIREMENTS

### **👥 WHO MUST BE SERVED**
```
REQUIRED SERVICE PARTIES:
• Opposing Counsel: camdyn@familylawlt.com
• Secondary Counsel: jennifer@legalbymiller.com
• Court: Automatic through e-filing system
• Self: Keep copies of all documents

SERVICE METHOD:
• Electronic Service: Email (as agreed between parties)
• Personal Service: If no agreement
• Certified Mail: Alternative method
```

### **📋 WHAT MUST BE SERVED**
```
COMPLETE FILING PACKAGE:
1. Response Brief Opposition to Motions
2. FL135 Declaration in Opposition  
3. All Exhibits (Dr. Oreskovich evaluation, etc.)
4. Proposed Order for Court
5. Any Supplemental Declarations
6. Certificate of Service (proof of service)

TIMING REQUIREMENTS FOR RESPONDING PARTY:
• Response Filing Deadline: 5 judicial days before hearing @ NOON
• Service to Opposing Counsel: Concurrent with filing (not 14 days)
• Working Papers: Same deadline as response filing
• Confirmation: Email delivery receipts recommended

NOTE: 14-day service requirement applies to MOVING PARTY only
```

### **📜 CERTIFICATE OF SERVICE TEMPLATE**
```
CERTIFICATE OF SERVICE

I hereby certify that a true and correct copy of the foregoing 
document was served upon the following parties:

Respondent's Counsel:
Jennifer Miller, WSBA #31600
Mukilteo Divorce & Family Law LT PLLC
Email: jennifer@legalbymiller.com and camdyn@familylawlt.com

Method of Service: Email (as agreed)
Date: ____________, 2025

_________________________
[Your Name], Pro Se
```

---

## 📁 REQUIRED DOCUMENTS CHECKLIST

### **📋 PRIMARY FILING PACKAGE**
```
COURT FILING DOCUMENTS:
☐ Response Brief Opposition to Motions
☐ FL135 Declaration in Opposition to Temporary Orders
☐ Proposed Order (Custody Restoration)
☐ Supplemental Declaration (if needed)

EXHIBITS:
☐ Exhibit A: Dr. Oreskovich Psychiatric Evaluation (PDF)
☐ Exhibit B: Government Validation Documentation
☐ Additional exhibits as needed

ADMINISTRATIVE:
☐ Working Papers Submission List
☐ Certificate of Service
☐ Case Information Cover Sheet (auto-generated by e-filing)
```

### **📄 DOCUMENT FORMATTING VERIFICATION**
```
FORMAT CHECKLIST (Before Filing):
☐ Margins: 3" top on page 1, 1" all others
☐ Font: ADA-compliant, 12-point minimum
☐ Paper: 8½ x 11, white, single-sided
☐ Spacing: Double-spaced text
☐ Colors: None (black text only)
☐ Page Limits: Within declaration limits
☐ File Format: PDF, searchable text
☐ File Size: Under 35MB per document
```

---

## 🌐 ESSENTIAL WEBSITES & PORTALS

### **🏛️ COURT SYSTEMS**
```
KING COUNTY SUPERIOR COURT:
• Main Site: https://kingcounty.gov/courts/superior-court
• E-Filing: https://dja-efsp.kingcounty.gov/efiling/
• Status: http://www.kcscclerkefilingstatus.com/
• Forms: https://kingcounty.gov/courts/clerk/forms

WASHINGTON STATE COURTS:
• Main Site: https://www.courts.wa.gov/
• Forms Library: https://www.courts.wa.gov/forms/
• Court Rules: https://www.courts.wa.gov/court_rules/
```

### **📅 SCHEDULING & CALENDARS**
```
FAMILY LAW MOTIONS:
• Scheduling: https://superiorcourt.kingcounty.gov/famlaw/scheduling/
• Calendar Info: https://kingcounty.gov/courts/calendars
• Local Rules: https://kingcounty.gov/courts/superior-court/rules
```

---

## 📞 CRITICAL CONTACT INFORMATION

### **🏛️ COURT CONTACTS**
```
KING COUNTY SUPERIOR COURT CLERK:
• Phone: (206) 477-1065
• Address: 516 Third Avenue, Seattle, WA 98104
• Hours: Monday-Friday, 8:00 AM - 4:30 PM
• Emergency: After-hours filing not available

FAMILY LAW FACILITATOR PROGRAM:
• Seattle Office: (206) 477-2553
• Kent Office: (206) 477-2781
• Services: Fee waivers, form assistance, basic legal help
```

### **⚖️ OPPOSING COUNSEL**
```
MUKILTEO DIVORCE & FAMILY LAW LT PLLC:
• Primary: camdyn@familylawlt.com
• Secondary: jennifer@legalbymiller.com
• Service Method: Electronic (email as agreed)
• Courtesy Copy: Both addresses recommended
```

---

## ⚠️ COMMON FILING MISTAKES & TRAPS

### **🚨 CRITICAL DEADLINE TRAPS**
```
DANGEROUS ASSUMPTIONS:
❌ "Moving party and responding party have same deadlines"
✅ TRUTH: Responding party has 5 judicial days, moving party has 9 judicial days

❌ "14-day service requirement applies to responses"
✅ TRUTH: 14-day service is for MOVING PARTY only

❌ "Calendar days = Judicial days"  
✅ TRUTH: Judicial days exclude weekends/holidays

❌ "Response deadline is 4:30 PM"
✅ TRUTH: Response deadline is NOON (5 judicial days before hearing)
```

### **📄 FORMATTING TRAPS**
```
REJECTION RISKS:
❌ Using 1" top margin on first page (need 3")
❌ Using fonts like Comic Sans or decorative fonts
❌ Including any highlighting or colored marks
❌ Exceeding page limits for declarations
❌ Submitting password-protected PDFs
❌ Using scanned images instead of searchable text
```

### **💰 PAYMENT TRAPS**
```
FEE SURPRISES:
❌ Assuming e-filing eliminates all fees
✅ TRUTH: Statutory fees still apply + $2.49 processing fee

❌ Using out-of-state checks
✅ TRUTH: Must be Washington State bank with printed address

❌ Waiting until last minute for fee waiver
✅ TRUTH: Fee waiver process takes time, apply early
```

---

## 🗓️ FILING TIMELINE TEMPLATE (T-MINUS COUNTDOWN)

### **📅 OPTIMAL FILING SCHEDULE (FOR RESPONDING PARTY)**
```
T-MINUS 7 DAYS (Calendar):
☐ All response documents drafted and reviewed
☐ E-filing account verified and tested
☐ Exhibits organized and formatted

T-MINUS 5 DAYS (Judicial) - DEADLINE DAY:
☐ All response documents filed with court by NOON
☐ Working Papers Submission List filed by NOON
☐ Service completed to opposing counsel
☐ Filing confirmation received and saved
☐ Payment processed and confirmed

T-MINUS 3 DAYS (Judicial):
☐ Hearing officially confirmed
☐ All administrative requirements completed

T-MINUS 1 DAY:
☐ Printed copies prepared for hearing
☐ Exhibits organized with tabs
☐ Transportation and timing confirmed
```

---

## 📊 QUALITY CONTROL CHECKLIST

### **🔍 PRE-FILING VERIFICATION**
```
DOCUMENT REVIEW:
☐ All case numbers correct and consistent
☐ All dates accurate and properly formatted  
☐ All names spelled correctly throughout
☐ All exhibits properly labeled and referenced
☐ All formatting requirements met (GR 14)
☐ All required signatures included
☐ Page numbers sequential and complete

TECHNICAL VERIFICATION:
☐ All PDFs searchable (not just scanned images)
☐ All files under 35MB size limit
☐ All filenames descriptive and professional
☐ E-filing account has sufficient payment method
☐ Internet connection stable for upload
```

### **📋 POST-FILING VERIFICATION**
```
CONFIRMATION CHECKLIST:
☐ Filing confirmation email received and saved
☐ Case docket updated with new filings
☐ Payment confirmation received (if applicable)
☐ Service confirmations documented
☐ Calendar entries updated with filing status
☐ Opposing counsel receipt confirmed
☐ Working Papers deadline calendared
```

---

## 🚨 EMERGENCY PROCEDURES

### **⚡ SYSTEM FAILURE PROTOCOLS**
```
IF KC SCRIPT PORTAL DOWN:
1. Check status at: http://www.kcscclerkefilingstatus.com/
2. Contact Clerk's Office: (206) 477-1065
3. Request permission for paper filing
4. Hand-deliver to: 516 Third Avenue, Seattle, WA 98104
5. Include letter explaining electronic system failure
6. File electronically once system restored

IF DEADLINE IS TODAY:
1. Attempt e-filing until system cutoff time
2. Prepare for immediate hand-delivery
3. Have printed copies ready with filing fees
4. Contact opposing counsel about delivery method change
5. Document all emergency efforts for court record
```

### **📞 EMERGENCY CONTACTS**
```
AFTER-HOURS EMERGENCIES:
• King County Sheriff: (206) 296-3311
• Court Security: (206) 477-1065 (leave message)
• Family Law Facilitator: (206) 477-2553 (voicemail)

SAME-DAY FILING HELP:
• Clerk's Office Walk-In: Room E609, 516 Third Avenue
• Business Hours: 8:00 AM - 4:30 PM
• No after-hours filing available (plan accordingly)
```

---

## 📚 REFERENCE DOCUMENTS & RULES

### **📖 GOVERNING AUTHORITIES**
```
WASHINGTON STATE RULES:
• General Rule 14: Document formatting requirements
• General Rule 30: Electronic filing requirements  
• General Rule 34: Fee waiver procedures
• Civil Rule 10(e): Superior Court formatting

KING COUNTY LOCAL RULES:
• LGR 30: Mandatory electronic filing
• LFLR 6: Family law motions calendar procedures
• LCR 7: Civil motions (applies to family law)

FEDERAL AUTHORITY:
• ADA Compliance: Font accessibility requirements
```

### **🔗 QUICK REFERENCE LINKS**
```
ESSENTIAL BOOKMARKS:
• KC Script Portal: https://dja-efsp.kingcounty.gov/efiling/
• WA Courts Forms: https://www.courts.wa.gov/forms/
• King County Forms: https://kingcounty.gov/courts/clerk/forms
• Family Law Scheduling: https://superiorcourt.kingcounty.gov/famlaw/scheduling/
• Fee Schedule: https://kingcounty.gov/courts/clerk/fees
```

---

## 🎯 SUCCESS METRICS & BEST PRACTICES

### **✅ FILING SUCCESS INDICATORS**
```
PERFECT FILING CHECKLIST:
☐ Documents accepted without rejection
☐ All deadlines met with time to spare
☐ Opposing counsel properly served
☐ Court docket updated promptly
☐ No additional fee assessments
☐ Hearing confirmed via Working Papers
☐ All administrative requirements satisfied

PROFESSIONAL STANDARDS:
☐ Documents exceed formatting requirements
☐ Service completed well before deadlines
☐ Backup filing plans prepared
☐ Emergency contact information current
☐ Technology tested before critical deadlines
```

### **🏆 BEST PRACTICES FOR FUTURE FILINGS**
```
ONGOING EXCELLENCE:
• Maintain current KC Script Portal account
• Keep local rules bookmarked and current
• Test e-filing system monthly
• Maintain relationship with Family Law Facilitator
• Keep emergency contact list updated
• Save successful filing templates
• Document lessons learned from each filing
• Maintain backup payment methods
```

---

## 📝 DOCUMENT REVISION HISTORY

**Version 1.0** - August 15, 2025
- Initial comprehensive compilation
- Based on 2025 King County Superior Court requirements
- Includes August 25, 2025 hearing-specific deadlines
- Verified against current KC Script Portal system

**Research Sources:**
- King County Superior Court official website
- Washington State Courts rule database  
- KC Script Portal documentation
- Family Law Facilitator Program guidance

**Next Update Due:** When court rules change or after August 25, 2025 filing experience

---

**💾 SAVE THIS DOCUMENT:** This is your permanent reference for all King County Superior Court filings. Bookmark this file and update it based on experience and rule changes.

**🎯 ULTIMATE GOAL:** Perfect, professional filings that meet all requirements and deadlines, supporting the strongest possible legal position for case success.

---

**Document Status:** ✅ Complete Reference Guide - Ready for Immediate Use  
**Last Verified:** August 15, 2025  
**Next Review:** After August 25, 2025 hearing completion