---
\ncase_id: goodnight-v-ralidak
case_number: 20-3-03830-3-SEA
category: case-documentation
court: king-county-family
created: '2025-08-15'
deadline: '2025-08-20'
evidence_references:
- dr-oreskovich-psychiatric-evaluation
- therapy-notes-professional-documentation
- government-validation-4-agencies
- police-investigation-findings
hearing_date: '2025-08-25'
id: veronika-case-summary-professional
jurisdiction: washington-state
legal_basis:
- due-process-considerations
- parental-rights-framework
- separation-duration-analysis
related_documents:
- 00_PROFESSIONAL_VALIDATIONS_COMPARISON.md
- 01_ACTIVE_CASE_2025_AUG_25/COURT_FILINGS_READY/Response_Brief_Opposition_TFLO.pdf
search_keywords:
- case summary
- professional validation
- government findings
- legal documentation
semantic_concepts: []
status: professional_revision
strategic_importance: critical
subcategory: comprehensive-summary
title: Complete Case Summary - Professional Documentation
tone: professional_legal_standard
type: case-summary
updated: '2025-08-15'
uri: doc://legal/case-summary/professional-documentation
---# VERONIKA GOODNIGHT: COMPREHENSIVE CASE SUMMARY
**PROFESSIONAL DOCUMENTATION OF LEGAL PROCEEDINGS**

**Generated:** August 15, 2025  
**Source:** Legal Document Analysis and Professional Review  
**Case Numbers:** 20-3-03830-3 SEA / 25-2-11308-6 SEA  
**Purpose:** Master Reference Document - Complete Case Documentation

---

## EXECUTIVE SUMMARY

This case involves a five-year pattern of legal proceedings where Petitioner Veronika Goodnight has consistently been validated by professional evaluations and government agencies, while facing repeated motions that have resulted in extended separation from her children despite this professional support.

**Current Status (August 15, 2025):** 143-day separation from children, substantially exceeding this Court's previously established guidance of "not more than one week."

---

## PROFESSIONAL VALIDATION FRAMEWORK

### PSYCHIATRIC EVALUATION FINDINGS

**Evaluator:** Dr. Michael R. Oreskovich, MD  
**Credentials:** Board-Certified General & Addiction Psychiatrist  
**Date:** November 28, 2021  
**Scope:** 3-hour evaluation plus review of 210 documents

**Conclusion:** "There is no reason to preclude her having sole custody of her children"

**Additional Findings:** No psychiatric, mental, behavioral, or substance use disorders that would affect parenting ability

### COURT FINDINGS OF FACT

**Judge:** Judge Rampersad  
**Date:** March 3, 2022  
**Key Findings:**
- "The majority of the day-to-day child-rearing prior to separation in January 2020 was done by the Petitioner [Veronika]"
- "Ms. Goodnight is highly sensitive to children's emotional needs. Mr. Ralidak is not."
- "Children should not be away from their mother for more than one week"

### GOVERNMENT AGENCY INVESTIGATIONS

**1. Carnation Police Department**
- **Case Number:** C25010391
- **Officer:** Jennifer Kellogg, Badge #000116210
- **Finding:** "I determined there was no crime that occurred between Ralidak and Goodnight"

**2. Department of Children, Youth & Families (DCYF)**
- **Investigations:** Three separate reports filed in 2025
- **Outcome:** All closed with no findings against Respondent
- **Supervisor Assessment:** Concerns about therapeutic conduct "would best be handled by Department of Health"

**3. Washington State Department of Health**
- **Status:** Active investigation of License #MC61294206
- **Scope:** Professional conduct during therapy sessions
- **Referral Source:** DCYF official referral

**4. Superior Court Previous Determinations**
- **Finding:** Respondent performed majority of child-rearing
- **Assessment:** More emotionally sensitive to children's needs
- **Guidance:** Separations should not exceed one week

---

## CASE TIMELINE ANALYSIS

### THERAPEUTIC SERVICES COORDINATION

**October 14, 2024:** Respondent initiated mental health support for children experiencing adjustment difficulties

**Professional Response:** Respondent sought collaborative approach, attended intake appointments, and provided proper notification to co-parent

**Outcome:** Extended exclusion from therapeutic process despite being the initiating parent

### ACCOUNTABILITY AND RESPONSE PATTERNS

**April 3, 2025:** Respondent self-reported concerning incident and sought professional guidance

**Professional Response:** Immediate acknowledgment, direct apology to child, proactive therapeutic consultation

**Legal Response:** Incident used as basis for emergency proceedings despite responsible handling

### PROTECTION ADVOCACY

**March 2024:** Respondent filed police report regarding child safety concerns

**Court Recognition:** Judge Rampersad noted Respondent's sensitivity to children's emotional needs

**Pattern:** Consistent prioritization of child safety and well-being

---

## LITIGATION PATTERN ANALYSIS

### PROCEEDINGS HISTORY
- **2020 Motion:** Filed and denied with $8,500 sanctions imposed
- **May 2025 Motion:** Filed and withdrawn before hearing
- **July 2025 Motion:** Current proceedings (third similar motion)

### FINANCIAL IMPACT
- **2020 Defense:** Approximately $8,000 in legal costs
- **2025 DVPO Defense:** Approximately $7,000 in legal costs  
- **2025 Current Defense:** Approximately $10,000+ in legal costs
- **Total Burden:** Over $25,000 in defensive costs over five years

### DURATION ANALYSIS
- **Current Separation:** 143 consecutive days
- **Court Guidance:** "Not more than one week"
- **Comparison:** Substantially exceeds established judicial parameters

---

## PROFESSIONAL DOCUMENTATION OF CONCERNS

### THERAPY SESSION RECORDS

**Date:** May 1, 2025  
**Professional:** Danielle Smith, LMHCA (License #MC61294206)  
**Documentation:** Records show court order compliance issues during session  
**Regulatory Status:** Under Department of Health investigation  

### CHILD EXPRESSIONS

**Documented Statement:** "She does want to go back and live with mom" (from therapy records)  
**Context:** Statement made after extended separation from primary caregiver  
**Significance:** Child's expressed preference for reunification  

---

## GOVERNMENT VALIDATION MATRIX

### SUMMARY OF FINDINGS
- **Law Enforcement:** No criminal conduct found
- **Child Protection:** No findings against Respondent after investigation  
- **State Licensing:** Investigating therapeutic professional (not Respondent)
- **Superior Court:** Previously found Respondent to be primary caregiver

### PROFESSIONAL CONSENSUS
All professionals who have evaluated both parents support Petitioner's parenting capacity:
- Court-appointed psychiatric evaluator recommends sole custody
- Children's primary physician supports medical decision-making authority
- Court-appointed GAL documented children's positive welfare under Respondent's care

---

## CURRENT CIRCUMSTANCES ASSESSMENT

### SEPARATION IMPACT
- **Duration:** 143 days substantially exceeds judicial guidance
- **Contact:** Limited meaningful contact during this period
- **Child Development:** Evidence of regression behaviors during separation
- **Professional Recommendation:** Dr. Oreskovich supports custody restoration

### PROCEDURAL CONSIDERATIONS
- **Timeline:** Current motion filed same day protection order expired
- **Evidence:** Relies on same allegations previously investigated by police
- **Professional Validation:** Unanimous support for Petitioner's parenting capacity
- **Government Findings:** Multiple agencies found no basis for separation

---

## LEGAL FRAMEWORK ANALYSIS

### DUE PROCESS CONSIDERATIONS
The extended separation substantially exceeds established judicial parameters while contradicting professional recommendations and government agency findings.

### PARENTAL RIGHTS FRAMEWORK
The evidence demonstrates consistent validation of Petitioner's parenting capacity by all evaluating professionals and investigating agencies.

### PROCEDURAL HISTORY
The pattern of proceedings has resulted in significant defensive costs while failing to overcome existing professional evaluations supporting Respondent.

---

## CONCLUSION

The documentation demonstrates unanimous professional support for Petitioner's parenting capacity, government agency validation of her fitness, and children's expressed preferences, while the current separation substantially exceeds established judicial guidance. The evidence supports restoration of custody to the parent with consistent professional validation and established primary caregiver status.

---

**Document Status:** Professional Legal Summary  
**Intended Use:** Strategic Reference and Legal Documentation  
**Professional Review:** Completed August 15, 2025