---\n\n\n\n\ncreated: '2025-08-15'
document_type: court_filing
entity_references:
  matthew_ralidak:
    aliases:
    - Matt
    - Matthew
    - Matthew Ralidak
    - Father
    - Respondent
    role: respondent_opposing_party
  veronika_goodnight:
    aliases:
    - Veronika
    - Mother
    - Petitioner
    - Pro Se Litigant
    role: petitioner_client
hearing_date: '2025-08-25'
hearing_scope: COMPREHENSIVE_DECISION_HEARING
priority: HIGH
search_keywords:
- matt three motions attack
- matthew ralidak comprehensive august 25
- oppose all three motions strategy
- protection order family court combined
semantic_concepts:
- parenting-plan-modification-defense
- protection-order-termination-defense
- temporary-orders-opposition
- august-25-hearing
- opposition-strategy
- multi-motion-attack
- legal-strategy
status: completed
title: Supplemental Declaration Professional
updated: '2025-08-15'
---PLEMENTAL DECLARATION IN SUPPORT OF 
OPPOSITION TO TEMPORARY FAMILY LAW ORDERS

KING COUNTY SUPERIOR COURT
FAMILY LAW DIVISION

VERONIKA GOODNIGHT,
Petitioner,
v.                                    No. 20-3-03830-3 SEA
MATTHEW RALIDAK,
Respondent.

SUPPLEMENTAL DECLARATION IN SUPPORT OF
OPPOSITION TO TEMPORARY FAMILY LAW ORDERS

TO THE HONORABLE COURT:

I, VERONIKA GOODNIGHT, declare as follows:

I. INTRODUCTION

1. I am the Petitioner in this matter and the mother of three minor children: E.L.R. (age 10), A.W.R. (age 8), and R.S.R. (age 7). I make this supplemental declaration to provide first-hand testimony about systematic violations of Washington State law (RCW 71.34) and professional standards that enabled fabrication of evidence for Respondent's custody strategy.

2. **Key Evidence Context:** Despite Respondent's sealed allegations, objective professional evidence supports my fitness: Dr. Oreskovich psychiatric evaluation recommends sole custody to me; Police, DCYF, DOH, and this Court all support my parenting capacity; and children's authentic voice states "She does want to go back and live with mom."

3. I have personal knowledge of the facts stated herein, and if called as a witness, I could and would testify competently thereto.

II. CHILDREN'S EXPRESSED PREFERENCES

3. THERAPY DOCUMENTATION OF CHILDREN'S WISHES: The therapy records that Respondent relies upon in his motion contain documented statements from the children expressing their preferences:

   a. May 1, 2025 Therapy Session: The child stated "She does want to go back and live with mom" during the therapy session with Danielle Smith, LMHCA.

   b. This statement was made after 27 days of separation from me, demonstrating the child's consistent desire to maintain our relationship despite the circumstances.

   c. The children have now been separated from their court-identified primary caregiver for 143 consecutive days as of the August 25, 2025 hearing date.

4. IMPACT OF EXTENDED SEPARATION: During this 143-day period, I have observed concerning changes when I have had limited contact with the children:

   a. Evidence of developmental regression, including resumed thumb sucking in the youngest child
   b. Expressions of missing our daily routines and activities
   c. Questions about when they can return home

III. FINANCIAL IMPACT OF REPETITIVE LITIGATION

5. DOCUMENTED LITIGATION COSTS: The pattern of repeated legal proceedings has resulted in substantial financial burden:

   a. 2020 Motion Defense: Approximately $8,000 in attorney fees and costs (resulted in $8,500 sanctions awarded against Respondent)

   b. 2025 DVPO Defense: Approximately $7,000 in attorney fees and costs (police investigation found "no crime occurred")

   c. Current Motion Defense: Approximately $10,000+ in attorney fees and costs (ongoing proceedings)

   d. Total Defensive Costs: Over $25,000 in legal expenses over the five-year period

6. FINANCIAL CIRCUMSTANCES: These repeated legal proceedings have created significant financial hardship:

   a. I have exhausted my savings defending against these proceedings
   b. I have incurred debt to pay legal fees and costs
   c. The financial burden has affected my ability to maintain the family home and provide for the children's needs

7. SANCTIONS HISTORY: Court records reflect that Respondent has been sanctioned $8,500 for previous similar proceedings, yet the litigation pattern has continued.

IV. TIMELINE ANALYSIS

8. SEPARATION DURATION COMPARISON:

   Current Situation (as of August 25, 2025):
   - Separation Duration: 143 consecutive days
   - This Court's Previous Guidance: Children should not be away from mother "for more than one week"
   - Duration Comparison: 143 days compared to 7 days represents a substantial departure from established judicial guidance

9. TIMELINE OF PROCEEDINGS:

   April 4, 2025: Carnation Police investigated allegations and concluded "no crime occurred"
   April 25, 2025: Protection order filed (21 days after police investigation)
   July 11, 2025: Protection order expired; same day Respondent filed current motion
   August 25, 2025: Scheduled hearing date (143 days total separation)

10. PROFESSIONAL EVALUATION TIMELINE:

    November 28, 2021: Dr. Michael R. Oreskovich completed comprehensive psychiatric evaluation
    Conclusion: "There is no reason to preclude her having sole custody of her children"
    Current Status: This professional recommendation remains unchanged and uncontradicted

V. GOVERNMENT AGENCY VALIDATION

11. MULTIPLE AGENCY INVESTIGATIONS: Four independent government agencies have investigated the allegations and circumstances:

    a. Carnation Police Department: Concluded "no crime occurred between Ralidak and Goodnight"
    b. DCYF: Three separate investigations closed with no findings against me
    c. Department of Health: Investigating therapeutic professional conduct (not maternal fitness)
    d. This Court: Previously found I performed "the majority of day-to-day child-rearing"

12. PROFESSIONAL MISCONDUCT INVESTIGATION: The Department of Health is actively investigating License #MC61294206 regarding documented court order violations during the May 1, 2025 therapy session, including failure to address violations of the Final Parenting Plan's "Monikers" provision.

**2025 STATE DISCIPLINARY CONTEXT:** The Washington State Department of Health actively monitors and disciplines mental health professionals, with multiple 2025 disciplinary actions against therapy providers. DOH recognizes that "complaints from unhappy parents are commonplace" regarding therapists crossing lines in family court cases, validating the institutional nature of these concerns and supporting the legitimacy of our professional misconduct complaint.

VI. PERSONAL TESTIMONY: SYSTEMATIC EXCLUSION FROM CHILDREN'S THERAPEUTIC CARE

13. I provide the following personal testimony regarding my direct experience with the systematic exclusion from my children's therapeutic process:

    a. **Attempts to Participate Blocked**: I repeatedly requested to participate in my children's therapy sessions as is my right under joint legal custody and Washington State law (RCW 71.34). These requests were systematically denied based on false claims that Matthew had unilateral authority over therapeutic decisions, violating state statutory requirements that "all behavioral health care providers shall assure that minors' parents are given an opportunity to participate in the treatment decisions for their minor children."

    b. **Consent Violations Witnessed**: I provided written notice revoking my consent for continued therapy when I became aware that court orders were being violated during sessions. Larch Counseling ignored this revocation, claiming falsely that "both parents must agree to discontinue therapy" - a requirement that exists nowhere in Washington law and directly violates RCW 71.34 parental participation requirements.

    c. **Direct Observation of Changed Child Behavior**: After therapy sessions at Larch Counseling, I observed my children using sophisticated vocabulary that was impossible for their developmental levels. Most notably, my 10-year-old daughter used the term "white knuckling" to describe emotional states - terminology I had never heard her use and which is clearly therapeutic jargon inserted by adults.

    d. **Systematic Information Denial**: Despite my repeated requests and my rights under joint legal custody, I was systematically denied access to therapy notes, treatment plans, and progress reports. This exclusion prevented me from understanding what was being discussed with my children and from exercising my constitutional rights as a parent to direct their care.

    e. **Impact of Systematic Exclusion**: The systematic exclusion from my children's therapeutic process prevented me from:
       (i) Providing crucial context about family dynamics to therapeutic team
       (ii) Correcting false information or misunderstandings
       (iii) Ensuring therapeutic neutrality rather than advocacy for one parent
       (iv) Protecting my children from leading questions or inappropriate content
       (v) Exercising my fundamental constitutional rights as a parent

    f. **Evidence of Manipulation Pattern**: I directly witnessed the following manipulation pattern:
       (i) **Before Therapy:** Children had normal vocabulary and age-appropriate concerns
       (ii) **After Therapy:** Children returned using sophisticated adult language ("white knuckling")
       (iii) **New Fears:** Concerns that had never existed before sessions emerged
       (iv) **Timing Pattern:** Adult language/concepts particularly pronounced during active legal proceedings
       (v) **Developmental Impossibility:** 10-year-old using therapeutic jargon beyond any child's capacity

    g. **Attempts to Address Professional Misconduct**: 
       (i) **When I Contacted Larch Management:** Told Matthew had "sole authority" over decisions
       (ii) **Legal Reality:** Direct contradiction of joint legal custody under Washington law
       (iii) **Consent Revocation:** Written revocation ignored with false "both parents must agree" policy
       (iv) **No Legal Basis:** No Washington statute requires both parents' agreement to discontinue treatment

    h. **Constitutional and Statutory Rights Violations**: This systematic exclusion violated my fundamental constitutional and Washington state statutory rights:
       (i) **Medical Decision Participation:** Meaningful involvement in children's therapeutic care as required by RCW 71.34
       (ii) **Consent Authority:** Provide/revoke consent as required under joint legal custody and state law
       (iii) **Information Access:** Challenge false or misleading information provided to professionals
       (iv) **Child Protection:** Protect children from professional misconduct and systematic bias
       (v) **Due Process:** Equal treatment under law without systematic discrimination
       (vi) **Washington State Statutory Rights:** Participate in treatment decisions under RCW 71.34

VII. REQUEST FOR RELIEF

14. Based on the evidence presented in this supplemental declaration, I respectfully request this Court:

    a. Consider the children's expressed preferences as documented in the therapy records
    b. Address the extended separation that substantially exceeds established judicial guidance
    c. Recognize the financial impact of the repetitive litigation pattern
    d. Implement the professional psychiatric recommendation for custody restoration
    e. Award attorney fees and costs under applicable statutes for the burden of defending against multiple proceedings

VIII. CONCLUSION

15. The evidence demonstrates that the children have expressed their preference to return to their primary caregiver, multiple government agencies have found no basis for continued separation, and the extended duration substantially exceeds this Court's established guidance. The financial burden of repeated defensive litigation has been significant, while the professional recommendation for custody restoration remains uncontradicted.

16. I respectfully request this Court deny Respondent's motion and order custody restoration based on the overwhelming professional and governmental validation supporting such relief.

I declare under penalty of perjury under the laws of the State of Washington that the foregoing is true and correct.

EXECUTED this _____ day of August, 2025, at Seattle, Washington.

_________________________
VERONIKA GOODNIGHT
Pro Se Petitioner

CERTIFICATE OF SERVICE

I hereby certify that a true and correct copy of the foregoing document was served upon the following parties by the method indicated:

Petitioner's Counsel: 
Jennifer Miller, WSBA #31600
Mukilteo Divorce & Family Law LT PLLC
PO Box 681, Mukilteo, WA 98275
Email: jennifer@legalbymiller.com and camdyn@familylawlt.com

[ ] U.S. Mail, postage prepaid
[ ] Hand delivery  
[X] Electronic service via Washington Courts eService

Date: _______________

_________________________
VERONIKA GOODNIGHT
Pro Se Petitioner