# TIA Semantic Search Quick Reference
**Legal Operations Cheat Sheet**

## 🚀 **DAILY COMMANDS**

### **Search**
```bash
tia semantic search "your query here"                    # Basic search
tia semantic search "query" --top-k 10                   # More results  
tia semantic search "query" --min-similarity 0.3         # Broader results
```

### **Index New Materials**
```bash
tia semantic index --root ~/Legal --collection legal-materials    # Index all new files
tia semantic info                                                  # Check status
```

## 🎯 **COMMON SEARCHES**

### **Case Strategy**
```bash
tia semantic search "constitutional rights violation"
tia semantic search "parental alienation evidence"  
tia semantic search "judge hawk civil rights strategy"
tia semantic search "emergency motion contempt"
```

### **Evidence & Documentation**
```bash
tia semantic search "therapist documentation child distress"
tia semantic search "smoking gun evidence sanctions"
tia semantic search "2020 case precedent findings"
tia semantic search "attorney argument frameworks"
```

### **Procedures & Templates**
```bash
tia semantic search "king county filing procedures"
tia semantic search "emergency motion template"
tia semantic search "hearing preparation checklist"
tia semantic search "evidence hierarchy organization"
```

## ⚙️ **SYSTEM STATUS**

### **Quick Checks**
```bash
tia semantic info                     # Database stats
tia search sessions "legal" --limit 5 # Recent legal work
```

### **Current Setup**
- **Provider:** OpenAI (text-embedding-3-small, 1536d)
- **Database:** `~/.local/share/tia/semantic/vector_store.db`
- **Documents:** 1,043+ indexed
- **Cost:** ~$0.01 per document

## 🔧 **TROUBLESHOOTING**

### **No Results?**
```bash
tia semantic search "query" --min-similarity 0.3    # Lower threshold
tia semantic info                                    # Check if indexed
```

### **Add New Files**
```bash
tia semantic index --root ~/Legal/new_folder --collection legal-materials
```

### **Quality Check**
```bash
tia semantic search "test query" --verbose          # Debug output
```

---
**📁 Full Guide:** See `TIA_SEMANTIC_SEARCH_GUIDE.md` for complete documentation