# EVIDENCE SUMMARY
**Goodnight v. Ralidak 20-3-03830-3**

## PRIMARY VIOLATIONS

### Court Order Violation - May 1, 2025
**Document:** Therapy session notes, Danielle Smith LMHCA  
**Violation:** Child "called stepmom, 'mom' throughout our session"  
**Court Order:** "The parties are prohibited from encouraging or supporting the use of the terms 'father', 'daddy', 'mother', 'mommy' or any other derivative denoting parenthood to any other person besides Veronika and Mathew"  
**Professional Response:** No intervention documented

### Professional Misconduct Pattern
**Therapist:** Danielle Smith, LMHCA (License MC61294206)  
**Facility:** LARCH Counseling PLLC  
**Misconduct:** 
- Allowed court order violations during session
- Failed to contact legal parent (joint custody)
- Made DCYF reports based on unverified hearsay
- Documented parental alienation without intervention

## INSTITUTIONAL PATTERN

### Multiple Family Impact
**Family 1:** Goodnight - Systematic exclusion of mother from therapy decisions  
**Family 2:** Lauten - "Cut out of daughter's therapy after abusive ex intervened"  
**Common Elements:** Same facility, different therapists, identical exclusion tactics

### Government Investigation
**DCYF Response:** "After reviewing the info you have sent to us, your grievance would best be handled by the Department of Health"  
**Status:** Formally referred to licensing authority  
**Date:** May 27, 2025

## MONIKER CLAUSE ORIGIN

### Father's Day Incident
**Background:** Matthew abandoned children on Father's Day to go camping  
**Children's Response:** Made Father's Day card for present adult  
**Matthew's Reaction:** Demanded court create "moniker clause"  
**Current Violation:** Children now call Monica "mom" - documented in therapy

### Legal Hypocrisy
**Created:** Moniker clause demanded by Matthew due to jealousy  
**Violated:** Same clause now violated by Matthew's household  
**Pattern:** Court orders used as weapons when convenient, ignored when inconvenient

## THERAPY MANIPULATION

### Systematic Exclusion
**Timeline:** 47+ days mother separated from children  
**Professional Participation:** Licensed therapists facilitating separation  
**Court Authority:** Joint legal custody ignored by professionals  
**Impact:** Children expressing "mom was bad and died" in therapy

### Professional Conspiracy
**Participants:** Multiple LARCH Counseling therapists  
**Method:** Accept father's false authority claims without verification  
**Pattern:** Same tactics across multiple families  
**Evidence:** DCYF complaints, therapy notes, government referral

## CONSTITUTIONAL VIOLATIONS

### Fundamental Rights
**Parental Rights:** Systematic denial without due process  
**Equal Protection:** Different treatment based on court manipulation  
**Professional Authority:** Licensed providers violating constitutional rights under color of law

### Civil Rights Framework
**Federal Statute:** 42 U.S.C. § 1983 applicable  
**State Actors:** Licensed professionals acting under state authority  
**Pattern Evidence:** Systematic rights violations affecting multiple families

## SUPPORTING DOCUMENTATION

### Primary Evidence Files
- `Court_Orders_Parental_Terminology.pdf` - Moniker clause prohibition
- `May_1_2025_Therapy_Session_Notes.md` - Documented violations  
- `DCYF_Complaint_20250527.md` - Government investigation initiated
- `LARCH_Pattern_Evidence.md` - Multiple family documentation

### Legal Analysis Files
- `STEPMOM_THERAPY_ETHICAL_VIOLATIONS_ANALYSIS.md` - Professional misconduct analysis
- `FATHERS_DAY_MONIKER_HYPOCRISY_EXPOSED.md` - Court order creation and violation
- `00_LARCH_COUNSELING_CRIMINAL_ENTERPRISE_ANALYSIS.md` - Institutional pattern analysis

### Supporting Evidence
- `Emery_Lauten_Pattern_Evidence.md` - Second family confirmation
- `Professional_License_Verification.md` - Therapist credential confirmation
- `Timeline_Systematic_Violations.pdf` - 47-day exclusion documentation

## LEGAL RELIEF SOUGHT

### Immediate Relief
- Contempt motion for documented court order violations
- Suspension of current therapy arrangements
- Restoration of mother's access to children's healthcare decisions
- Sanctions against violating parties

### Professional Accountability
- Licensing board complaints against involved therapists
- Facility investigation for institutional misconduct
- Protection measures for other affected families

### Long-term Protection
- Custody modification based on systematic violations
- Court-supervised therapy transition
- Professional oversight requirements
- Attorney fee recovery under contempt statute

## EVIDENCE STRENGTH ASSESSMENT

### Primary Evidence: Strong
- Licensed professional documented violations
- Government investigation confirms misconduct pattern
- Court orders clearly establish prohibited conduct
- Multiple families establish institutional pattern

### Professional Standards: Clear Violations
- Failed to verify legal authority before providing services
- Allowed court order violations without intervention
- Made unverified reports to government agencies
- Excluded legal parent from joint custody decisions

### Constitutional Framework: Federal Court Appropriate
- Pattern of rights violations by state actors
- Multiple families affected by systematic misconduct
- Professional conspiracy under color of law
- Civil rights statute enforcement needed

---

**Last Updated:** May 30, 2025  
**Total Documents Analyzed:** 278 legal files  
**Government Investigation:** Active - referred to licensing authority  
**Next Hearing:** June 27, 2025 (4 weeks)