# TAB 1: EMERGENCY MOTION

## SUPERIOR COURT OF WASHINGTON, COUNTY OF KING

**In re the Parenting of:**  
**E.L.R., A.W.R., and R.S.R.,**  
**Minors.**

**No. 20-3-03830-3 SEA**

**EMERGENCY MOTION FOR ENFORCEMENT OF COURT ORDERS**

**Petitioner:**  
**VERONIKA GOODNIGHT,**

**v.**

**Respondent:**  
**MATHEW RALIDAK.**

**Note on Motion Calendar:** [To be filled by court clerk]

---

## TO THE HONORABLE RANIA RAMPERSAD:

Petitioner respectfully requests emergency enforcement of this Court's specific orders, which are being systematically violated in ways that cause immediate and irreparable harm to the minor children.

**RESTRAINT STATEMENT:** Petitioner could pursue federal civil rights litigation, criminal referrals, and professional licensing complaints based on the extensive evidence compiled (see Tabs A-E), but respectfully requests this Court simply enforce its existing orders before escalation becomes necessary.

---

## I. EMERGENCY STANDARDS MET (RCW 26.09.060)

### A. IMMEDIATE AND SUBSTANTIAL RISK

#### 1. Separation Violation - 45+ Days Beyond Court Finding
This Court specifically found in its Final Order dated June 24, 2024: **"separation should not exceed one week."** Children have been separated from mother for **45+ consecutive days** in direct violation of this explicit judicial finding.

**Current Status:** Children last seen by mother on April 10, 2025. Today is May 25, 2025 = 45+ days of ongoing contempt.

#### 2. Court Order Violations - "Monikers" Provision
This Court prohibited stepmother from use of parental titles in its Supplemental Findings. Professional therapy records document child **"called stepmom, 'mom' throughout our session"** on May 1, 2025 (Therapy Session Notes, Page 99).

**Current Status:** Licensed therapist documented violation but failed to intervene, continuing pattern of professional complicity.

#### 3. Joint Decision-Making Authority Violations
This Court ordered joint healthcare decision-making. Father systematically makes false claims of **"sole decision-making"** authority to medical providers, excluding mother from children's healthcare.

**Fresh Evidence:** May 2025 - "Elora anxious at Dr appointment that mat didn't allow me to be in."

### B. INADEQUATE REMEDY AT LAW

Each day of continued violation represents:
- Additional contempt of specific court orders
- Further psychological manipulation of children  
- Ongoing suspension of mother's constitutional rights
- Progressive deterioration of mother-child relationship

Normal litigation timeline would permit **months of ongoing violations** while constitutional rights remain suspended and psychological damage compounds daily.

### C. IRREPARABLE HARM

Professional documentation shows **progressive psychological manipulation:**

**October 2024:** Child "cries when at dad's house" (normal adjustment issues)

**May 2025:** Child creates therapy scenarios where **"mom was bad and died"** (systematic alienation achieved)

This 7-month deterioration was **documented and facilitated** by licensed professionals who had a duty to prevent exactly this outcome.

---

## II. CONSTITUTIONAL VIOLATIONS REQUIRING IMMEDIATE INTERVENTION

### A. Due Process Violations (14th Amendment)
- **Procedural Due Process:** Mother systematically excluded from healthcare decisions despite joint legal authority
- **Substantive Due Process:** Fundamental parenting rights arbitrarily transferred to stepmother with no legal standing

### B. Equal Protection Violations (14th Amendment)  
- **Gender-Based Discrimination:** Different standards applied to mother vs. father in professional treatment
- **Systematic Bias:** Institutional pattern documented across multiple licensed professionals

### C. Parental Rights Doctrine Violations
- **Meyer v. Nebraska (1923):** Right to direct child's upbringing systematically denied
- **Troxel v. Granville (2000):** Presumption of parental fitness illegally overcome without due process

**Note:** Full constitutional analysis available in Tab A. For immediate emergency relief, simple enforcement of existing court orders is sufficient.

---

## III. SPECIFIC RELIEF REQUESTED

### A. IMMEDIATE RETURN OF CHILDREN
**REQUEST:** Children returned to mother's care within 48 hours
**BASIS:** 45+ day separation violates Court's specific "one week" finding  
**TIMELINE:** Emergency implementation required to prevent further daily violations

### B. SUPERVISED FATHER VISITATION
**REQUEST:** All father's visits supervised pending compliance verification
**BASIS:** Documented systematic court order violations and facilitation of psychological manipulation
**DURATION:** Until full compliance with all court orders verified and maintained

### C. STEPMOTHER CONTACT PROHIBITION  
**REQUEST:** Complete cessation of stepmother involvement in children's healthcare, therapy, or decision-making
**BASIS:** Illegal participation in healthcare, "monikers" violations, no legal authority
**SCOPE:** No direct contact, no therapy participation, no medical decisions

### D. CONTEMPT FINDING AND SANCTIONS
**REQUEST:** Father held in contempt for systematic violation of specific court orders
**BASIS:** 45+ day separation, "monikers" violations, false authority claims to medical providers
**SANCTIONS:** Appropriate fines, possible jail time, attorney fees, professional referrals

---

## IV. WHY SIMPLE ENFORCEMENT IS SUFFICIENT

### A. Court Orders Already Address the Issues
Your Honor has already made specific findings about:
- Maximum separation duration (one week)
- Stepmother's prohibited role (no parental titles)  
- Joint decision-making requirements (both parents)

**No new legal determinations required** - only enforcement of existing orders.

### B. Evidence is Overwhelming and Undisputed
- **Professional documentation** from licensed therapists
- **Fresh evidence** from May 2025 showing ongoing violations
- **Timeline documentation** proving 45+ day separation
- **Clear violations** of specific court language

### C. Constitutional Crisis Can Be Prevented
**Rather than federal court intervention** requiring years of litigation, simple state court enforcement can:
- Restore constitutional rights immediately
- Prevent further psychological damage to children
- Avoid institutional reform litigation  
- Maintain state court jurisdiction over family matters

---

## V. CONCLUSION

**Your Honor, this case could generate:**
- Federal civil rights lawsuits under 42 U.S.C. § 1983
- Criminal conspiracy charges under 18 U.S.C. § 241  
- Professional licensing complaints against multiple providers
- RICO enterprise litigation against therapy facility
- Institutional reform consent decrees
- Damages exceeding $5,000,000

**However, Petitioner believes simple enforcement of your existing orders will resolve the immediate crisis and prevent escalation to constitutional litigation.**

**The evidence is overwhelming. The violations are clear. The harm is ongoing. The solution is simple: enforce your orders.**

Respectfully submitted,

**Veronika Goodnight, Pro Se**  
[Address]  
[Phone]  
[Email]

---

**CERTIFICATE OF SERVICE**

I hereby certify that a true and correct copy of the foregoing Emergency Motion was served upon opposing counsel via [method] on [date].

**Veronika Goodnight, Pro Se**