# EVIDENCE SUMMARY
**Professional Misconduct with Government Investigation Support**

---

## GOVERNMENT INVESTIGATION DOCUMENTATION

### DCYF COMPLAINT AND REFERRAL
**Date Filed:** May 27, 2025  
**Investigating Agency:** Washington State Department of Children, Youth & Families  
**Subject Matter:** Professional misconduct by licensed mental health provider  
**Agency Response:** *"After reviewing the info you have sent to us, your grievance would best be handled by the Department of Health"*  
**Current Status:** Formally referred to Washington State Department of Health for licensing investigation  

### LICENSING INVESTIGATION DETAILS
**Regulatory Authority:** Washington State Department of Health  
**Professional License:** Mental Health Counselor Associate #MC61294206  
**Licensed Professional:** Danielle Smith, LMHCA  
**Facility:** LARCH Counseling PLLC  
**Legal Framework:** RCW 18.225.090 (scope of practice violations), WAC 246-809-700 (professional conduct standards)

---

## COURT ORDER VIOLATION DOCUMENTATION

### PRIMARY EVIDENCE - MAY 1, 2025
**Professional Witness:** Danielle Smith, LMHCA (License #MC61294206)  
**Documentation:** Therapy session notes from May 1, 2025  
**Recorded Violation:** *"Client called stepmom, 'mom' throughout our session"*  
**Court Authority:** King County Superior Court Case 20-3-03830-3  
**Violated Provision:** Final Parenting Plan Section 14 - "Monikers for Third Party Adults"  

### SPECIFIC COURT ORDER LANGUAGE
**Exact Text:** *"The parties are prohibited from encouraging or supporting the use of the terms 'father', 'daddy', 'mother', 'mommy' or any other derivative denoting parenthood to any other person besides Veronika and Mathew."*  
**Source Document:** ESIGNED - FINAL PARENTING PLAN - POST MOD - GOODNIGHT AND RALIDAK  
**Legal Effect:** Contempt of court with sanctions and attorney fee recovery available  

---

## PROFESSIONAL MISCONDUCT ANALYSIS

### STANDARD OF CARE VIOLATIONS
**Failed Verification:** No confirmation of legal custody arrangements before providing services  
**Failed Intervention:** Witnessed court order violation without corrective action  
**Failed Reporting:** No documentation of addressing prohibited behavior  
**Failed Compliance:** Proceeded with therapy despite clear legal authority conflicts  

### REGULATORY VIOLATIONS
**WAC 246-809-700:** Professional conduct standards for mental health counselors  
**WAC 246-809-710:** Unprofessional conduct definitions and enforcement  
**RCW 18.225.090:** Mental health counselor scope of practice limitations  
**Professional Duty:** Recognition and respect for legal authority and court directives  

---

## INSTITUTIONAL PATTERN EVIDENCE

### MULTIPLE FAMILY IMPACT
**Documented Cases:** Goodnight family and Lauten family affected by identical tactics  
**Common Elements:** Same facility, different therapists, systematic exclusion of protective parents  
**Facility Pattern:** LARCH Counseling PLLC implementing coordinated exclusion policies  
**Legal Significance:** Institutional misconduct rather than isolated professional error  

### SYSTEMATIC VIOLATIONS
**Coordinated Exclusion:** Multiple licensed professionals using identical tactics  
**False Authority Acceptance:** Pattern of proceeding without legal verification  
**Institutional Support:** Facility policies enabling exclusion of protective parents  
**Professional Conspiracy:** Coordinated misconduct across licensed staff members  

---

## CONSTITUTIONAL IMPLICATIONS

### FEDERAL CIVIL RIGHTS FRAMEWORK
**Legal Authority:** 42 U.S.C. § 1983 - Civil Rights Under Color of Law  
**State Actor Status:** Licensed professionals exercising government authority (West v. Atkins, 487 U.S. 42)  
**Constitutional Rights:** Fourteenth Amendment Due Process and Equal Protection  
**Precedent Support:** Monroe v. Pape (§ 1983 scope), Troxel v. Granville (parental rights protection)  

### DUE PROCESS VIOLATIONS
**Fundamental Right:** Parent-child relationship constitutional protection  
**State Action:** Licensed professionals denying parental rights without due process  
**Procedural Defects:** No verification or hearing before rights denial  
**Substantive Violations:** Arbitrary denial of constitutional parental rights  

---

## EVIDENCE AUTHENTICATION

### PRIMARY SOURCE VERIFICATION
**Therapy Records:** Licensed professional signed and dated session notes  
**Court Documents:** Certified copies available from King County Superior Court Clerk  
**Government Correspondence:** Official agency letterhead with reference numbers  
**Professional Licensing:** Washington State Department of Health database verification  

### CHAIN OF CUSTODY
**Document Security:** Original records maintained in secure client files  
**Court Filing Ready:** Professional formatting for immediate legal proceedings  
**Discovery Preparation:** Complete documentation available for subpoena and production  
**Expert Review:** Records suitable for professional standards expert analysis  

---

## LEGAL IMPLICATIONS

### IMMEDIATE CONTEMPT OPPORTUNITIES
**Clear Standard:** Willful violation of specific court order provisions  
**Professional Witness:** Licensed provider documentation satisfies evidence requirements  
**Available Relief:** Monetary sanctions, compliance orders, attorney fee recovery  
**Emergency Jurisdiction:** Court authority to enforce existing orders immediately  

### PROFESSIONAL ACCOUNTABILITY
**Active Investigation:** Government review of professional misconduct claims  
**Regulatory Authority:** Department of Health enforcement of professional standards  
**Institutional Liability:** Facility responsibility for systematic misconduct patterns  
**Corrective Action:** Professional supervision and compliance monitoring available  

### CONSTITUTIONAL PROTECTION
**Federal Jurisdiction:** Civil rights violations by state actors  
**Injunctive Relief:** Court orders protecting fundamental parental rights  
**Damages Available:** Compensation for constitutional violations and professional misconduct  
**Systemic Reform:** Institutional changes to prevent future rights violations  

---

**Evidence Quality Assessment:** Court-ready documentation with government support  
**Professional Witness:** Licensed provider testimony available  
**Government Validation:** Active investigation corroborates misconduct claims  
**Next Action Required:** Emergency legal consultation and motion preparation