---
title: "Search System Guide"
created: "2025-08-15"
updated: "2025-08-15"
---

# OPENAI SEARCH SYSTEM GUIDE
**Instant Evidence Discovery Instructions**

---

## 🔍 **SEARCH SYSTEM OVERVIEW**

The attorney handoff package includes a complete OpenAI semantic search system with **4,312 embeddings** across **134 legal documents** for instant evidence discovery. This system enables natural language queries to find specific evidence with relevance scoring.

---

## ⚡ **QUICK START COMMANDS**

### **Basic Search Syntax:**
```bash
python3 legal_search.py "your search query here" [number_of_results]
```

### **Essential Search Examples:**

**Children's Emotional Evidence:**
```bash
python3 legal_search.py "child cries emotional distress father" 5
python3 legal_search.py "stepmom called mom parenting plan violation" 3
python3 legal_search.py "children coaching fear mother" 8
```

**Court Violations:**
```bash
python3 legal_search.py "court order violation contempt" 5
python3 legal_search.py "repeated pattern interference" 3
python3 legal_search.py "false contempt accusations" 5
```

**Professional Misconduct:**
```bash
python3 legal_search.py "therapy boundary violations licensing" 8
python3 legal_search.py "unilateral therapist control" 5
python3 legal_search.py "systematic exclusion mother healthcare" 5
```

**Timeline Coordination:**
```bash
python3 legal_search.py "April 4 police report same day" 5
python3 legal_search.py "April 11 protection order emergency" 5
python3 legal_search.py "coordinated agency responses" 8
```

---

## 🎯 **STRATEGIC SEARCH CATEGORIES**

### **MOTION PREPARATION SEARCHES**

**For Contempt Motions:**
```bash
python3 legal_search.py "Matthew interference court orders" 8
python3 legal_search.py "violation screenshots exhibit evidence" 5
python3 legal_search.py "false accusations while violating" 5
```

**For Emergency Child Protection:**
```bash
python3 legal_search.py "children emotional harm separation" 10
python3 legal_search.py "superior parent judicial findings" 5
python3 legal_search.py "therapeutic documentation distress" 8
```

**For Professional Sanctions:**
```bash
python3 legal_search.py "three therapists overreach authority" 8
python3 legal_search.py "licensing violations boundary crossing" 10
python3 legal_search.py "professional misconduct complaints" 5
```

### **DISCOVERY PREPARATION SEARCHES**

**Agency Coordination:**
```bash
python3 legal_search.py "CPS police therapy coordination" 10
python3 legal_search.py "sealed filings prevent defense" 5
python3 legal_search.py "manufactured emergency procedures" 8
```

**Financial Warfare:**
```bash
python3 legal_search.py "resource exhaustion multiple proceedings" 8
python3 legal_search.py "emergency costs frivolous litigation" 5
python3 legal_search.py "attorney fees sanctions awards" 5
```

**Constitutional Issues:**
```bash
python3 legal_search.py "due process emergency orders" 8
python3 legal_search.py "equal protection parental rights" 5
python3 legal_search.py "systematic procedural violations" 8
```

---

## 📊 **SEARCH RESULT INTERPRETATION**

### **Relevance Scoring:**
- **0.7-1.0:** Highly relevant - primary evidence for motions
- **0.5-0.7:** Moderately relevant - supporting evidence
- **0.3-0.5:** Background relevant - context and corroboration
- **0.1-0.3:** Tangentially relevant - general case information

### **Source Prioritization:**
1. **Licensed therapist notes** - Highest credibility for child welfare
2. **Court filing documents** - Official procedural evidence
3. **Police reports** - Official incident documentation
4. **Declaration statements** - Party admissions and claims

---

## 🔍 **ADVANCED SEARCH TECHNIQUES**

### **Combination Searches:**
```bash
# Multiple concept search
python3 legal_search.py "children coaching AND court violations" 10

# Timeline specific
python3 legal_search.py "April 2025 emergency procedures" 8

# Professional specific
python3 legal_search.py "Danielle Smith LMHCA therapeutic notes" 5
```

### **Targeted Discovery:**
```bash
# Communication patterns
python3 legal_search.py "Matthew coordination with agencies" 10

# Emergency justification
python3 legal_search.py "grave danger claims single spanking" 5

# Professional authority
python3 legal_search.py "obtained reports three therapists" 3
```

### **Evidence Verification:**
```bash
# Source verification
python3 legal_search.py "line 49 child cries when at dads" 3

# Citation confirmation
python3 legal_search.py "exhibit D screenshots attachment" 5

# License verification
python3 legal_search.py "MC61294206 Danielle Smith license" 3
```

---

## 📁 **SEARCH SYSTEM ARCHITECTURE**

### **Embedding Database:**
- **File:** `openai_direct_embeddings.json` (198MB)
- **Total Embeddings:** 4,312 across 134 documents
- **Model:** OpenAI text-embedding-3-small
- **Processing:** 150 chunks/second batch processing

### **Document Corpus:**
- **Attorney Handoff:** 29 files with 581 embeddings
- **Evidence Archive:** 105 files with 3,731 embeddings
- **Enhanced Documents:** 136 attorney-ready analyses
- **Processing Provenance:** Complete chain of custody

### **Search Performance:**
- **Response Time:** ~1-2 seconds per query
- **Accuracy:** High precision with semantic understanding
- **Coverage:** Complete case documentation included
- **Relevance:** Cosine similarity scoring with legal context

---

## 🚀 **MOTION DRAFTING WORKFLOW**

### **Step 1: Evidence Discovery**
```bash
# Find all evidence for specific motion type
python3 legal_search.py "contempt court order violations" 15
```

### **Step 2: Source Verification**
```bash
# Verify specific quotes and citations
python3 legal_search.py "repeated pattern interference exhibit D" 5
```

### **Step 3: Supporting Evidence**
```bash
# Find corroborating evidence
python3 legal_search.py "systematic abuse pattern multiple agencies" 10
```

### **Step 4: Expert Witness Preparation**
```bash
# Find professional testimony foundation
python3 legal_search.py "licensed therapist emotional distress documentation" 8
```

---

## 💡 **SEARCH OPTIMIZATION TIPS**

### **Effective Query Construction:**
- **Use specific legal terms** rather than general concepts
- **Include professional titles** (LMHCA, therapist, etc.)
- **Reference specific dates** when known (April 4, April 11)
- **Use quoted phrases** for exact matches

### **Result Analysis:**
- **Read full context** around search results
- **Note source files** for complete document review
- **Verify line numbers** and specific citations
- **Cross-reference** multiple search results

### **Evidence Building:**
- **Start broad** then narrow to specific evidence
- **Combine searches** to build comprehensive evidence packages
- **Verify sources** through multiple query approaches
- **Document findings** with complete citation information

---

## 📞 **TECHNICAL SUPPORT**

### **Search System Location:**
- **Main Script:** `/home/scottsen/src/tia/lib/embeddings/semantic_search.py`
- **Embeddings File:** `./openai_direct_embeddings.json`
- **Evidence Corpus:** `/home/scottsen/src/tia/sessions/20250531_211424/enhanced_documents/`

### **Troubleshooting:**
- **No results:** Try broader search terms or check spelling
- **Too many results:** Add specific terms or use quoted phrases
- **Relevance issues:** Include legal context terms in queries
- **Performance:** Large result sets (50+) may be slower

### **System Requirements:**
- **Python 3.x** with OpenAI and numpy libraries
- **Embeddings file** must be in current directory
- **Source documents** accessible for full text retrieval

**This search system provides instant access to any evidence in the 134-document corpus with legal-grade precision and relevance scoring.**