---
title: "Readme"
created: "2025-08-13"
updated: "2025-08-13"
---

# Kit Spins Email Archive

Comprehensive archive of 92 emails from kit@kitspins.com with full attachment processing and legal organization.

## Directory Structure

```
Kit_Spins_Archive/
├── emails/           # Individual email .md files with frontmatter
├── attachments/      # Original PDF and document attachments  
├── text/            # Extracted text from PDFs and documents
├── images/          # Inline images and extracted graphics
├── content/         # HTML tables, formatted content
├── ocr/             # OCR output for scanned documents
├── indexes/         # Search indexes and cross-references
└── backups/         # Backup copies of originals
```

## Processing Pipeline

1. **Download**: Use `tia-graph-api` to download all emails with attachments
2. **Extract**: Separate attachments, inline images, embedded content
3. **OCR**: Process scanned PDFs with Tesseract
4. **Text**: Extract text from readable PDFs
5. **Metadata**: Generate comprehensive frontmatter
6. **Index**: Create searchable indexes
7. **Cross-ref**: Link to legal cases and TIA tasks

## Frontmatter Schema

Each email gets comprehensive metadata including:
- Legal categorization and relevance scoring
- Attachment processing status
- OCR confidence levels  
- Cross-references to cases and tasks
- Timeline events and people index
- AI analysis and named entity extraction

## Legal Categories

Primary tags:
- `protection_order` - Court protection orders
- `therapy_violations` - Professional misconduct  
- `court_filings` - Legal documents filed with court
- `declarations` - Sworn statements and declarations
- `police_reports` - Law enforcement documents
- `custody_dispute` - Child custody related
- `evidence` - Evidentiary materials
- `appeals` - Appellate court documents

## Search and Discovery

The archive will be fully searchable by:
- Content (full text)
- Metadata (tags, dates, people)
- Semantic similarity (via TIA embeddings)
- Legal relevance scoring
- Cross-references and relationships

Generated: 2025-05-29T02:22:16Z
Total Emails: 92
Status: Setup Complete, Ready for Download