---
title: "PRR 349 Critical Findings Summary - Goodnight v. Ralidak"
case: "Goodnight v. Ralidak"
document_type: "Critical Evidence Summary"
extraction_date: "2025-07-19"
source_files: ["202504-PRR-349_Final Letter_Veronika Goodnight.pdf", "202504-PRR-349_Goodnight_Redacted.pdf"]
case_id: "2682764"
threat_level: "HIGH - Weapon threats documented"
children_at_risk: ["Aidan (8)", "Elora (10)", "Raina (6)"]
current_protection: "Restraining order in effect as of April 2025"
tags: ["critical_evidence", "child_safety", "weapon_threats", "physical_abuse", "court_protection"]
---

# CRITICAL FINDINGS SUMMARY - PRR 349 DCYF Records

## 🚨 IMMEDIATE SAFETY CONCERNS

### WEAPON THREAT ALLEGATIONS (April 24, 2025)
**MOST SERIOUS FINDING**: Children report fear of mother stabbing them with knife

**Critical Details:**
- Aidan (8) asked father: "Is it normal to be afraid that his mother would stab them with a knife?"
- Elora (10) reported mother grabbed knife, "white knuckling" it
- **Children developed safety plan** in case mother stabbed one of them
- No-contact restraining order currently protects children

### CURRENT LEGAL PROTECTION STATUS
- **Active Restraining Order**: 1000-foot protection from mother and Colin Derieg
- **Emergency Custody**: Father has all three children
- **Court Date**: April 25, 2025 (protection order review)
- **Father's Action**: Seeking emergency full custody

## 📋 SUBSTANTIATED EVIDENCE PATTERNS

### 1. ESCALATING PHYSICAL ABUSE
**April 2025 Incidents:**
- Raina (6) "slapped so hard she was thrown into the wall"
- Aidan (8) reports slapping, pushing, intimidation when mother angry
- Mother makes threatening gestures (middle finger, verbal abuse)

**Historical Pattern:**
- Colin Derieg hitting Raina "approximately five times" (February 2025)
- Physical discipline contrary to parents' written agreement

### 2. VERBAL/EMOTIONAL ABUSE
**Children's Direct Reports:**
- Mother cursing: "fuck you," "don't be a fucking bitch"
- Intimidation tactics: getting in children's personal space
- Aidan's statement: "don't tell mom any of this, it makes me sad"

### 3. NEGLECT INDICATORS
**Documented Evidence:**
- Children arrive at father's home "filthy" with "dark circles under eyes"
- Reports of inadequate food, children "begging for food"
- Medical neglect: UTI untreated, hygiene issues
- Restrictive diet causing hunger (only protein shakes, eggs)

### 4. THIRD-PARTY CORROBORATION
**School Staff:**
- Teacher reports of Raina's disclosure about wall incident
- Nurse observations of child distress
- Principal noting multiple disruptions by mother

**Police Documentation:**
- Report C25010391 documenting school confrontation
- Officer Jennifer Kellogg's observations and video review

## 🎵 AUDIO EVIDENCE

### Three Audio Files Provided
**Context**: Likely contain children's disclosures and investigation recordings
**Potential Content**:
1. Children's statements about knife threats
2. Physical abuse disclosures
3. Safety plan discussions

**Legal Significance**: May provide direct evidence of children's statements about threats and abuse

## ⚖️ COMPETING ALLEGATIONS

### Mother's Counter-Claims (April 9, 2025)
- Father making false medical claims (telling doctors she was "deceased")
- Father fabricating gun allegations against Colin
- Pattern of parental alienation and court manipulation

### Father's Claims Pattern
- Documented medical evidence contradicting mother's allergy claims
- Multiple CPS reports with consistent themes
- School and medical provider corroboration

## 📊 CPS SYSTEM INVOLVEMENT

### Case Activity Level: EXTENSIVE
- **Case ID**: 2682764
- **Office**: King East
- **Timeline**: July 2024 - April 2025 (9+ months)
- **Intake Volume**: 15+ documented intakes

### Response Patterns
- **Screen Ins**: Most serious allegations (physical abuse, neglect)
- **Screen Outs**: Duplicate/documented allegations
- **FAR Response**: 72-hour response times for serious concerns

## 🎯 CRITICAL EVIDENCE FOR LEGAL PROCEEDINGS

### 1. Children's Direct Statements
- Weapon threat fears documented by multiple sources
- Physical abuse descriptions with specific details
- Fear-based behavior (safety plans, reluctance to disclose)

### 2. Physical Evidence Indicators
- Medical records of UTI and hygiene issues
- Pediatrician findings contradicting allergy claims
- School nurse observations of hunger/fatigue

### 3. Pattern Documentation
- Escalating severity over 9-month period
- Consistent themes across multiple independent reports
- Third-party professional observations

### 4. Current Protection Measures
- Active restraining order based on court findings
- Emergency custody arrangement
- Scheduled court review process

## ⚠️ RISK ASSESSMENT FACTORS

### High Risk Indicators
- ✅ Weapon threats reported by children
- ✅ Escalating physical violence pattern
- ✅ Children expressing fear of parent
- ✅ Self-protective behavior by children (safety plans)
- ✅ Multiple consistent third-party reports

### Protective Factors
- ✅ Current restraining order in place
- ✅ Children in father's protected custody
- ✅ Court oversight with scheduled review
- ✅ CPS investigation documentation
- ✅ School system awareness and monitoring

## 📋 RECOMMENDATIONS FOR LEGAL STRATEGY

### Immediate Actions
1. **Secure Audio Evidence**: Transcribe and analyze three audio files
2. **Medical Documentation**: Obtain pediatrician's written findings
3. **School Records**: Formal documentation from teachers/staff
4. **Expert Assessment**: Child safety evaluation

### Court Preparation
1. **Timeline Presentation**: Demonstrate escalation pattern
2. **Third-Party Testimony**: School staff, medical providers
3. **Child Voice**: Consider appropriate methods for children's input
4. **Safety Planning**: Ongoing protection measures

### Investigation Priorities
1. **CPS Outcomes**: Determine if allegations were substantiated
2. **Audio Analysis**: Professional transcription and authentication
3. **Medical Records**: Complete health documentation for all children
4. **Mental Health Evaluation**: Professional assessment of family dynamics

## 🔍 NEXT STEPS

1. **Audio File Analysis**: Immediate transcription and legal review
2. **Court Preparation**: Restraining order renewal hearing
3. **Evidence Organization**: Create comprehensive court exhibits
4. **Expert Consultation**: Child trauma and custody evaluation specialists
5. **Safety Monitoring**: Ongoing assessment of children's wellbeing

---

**URGENT NOTE**: The progression from verbal abuse to physical violence to weapon threats represents a classic escalation pattern requiring immediate professional intervention and continued court protection.