---
title: "DCYF PRR 349 Redacted Records Analysis - Goodnight v. Ralidak"
case: "Goodnight v. Ralidak"
document_type: "Public Records Analysis"
document_date: "2025-04-09 to 2025-04-24"
extraction_date: "2025-07-19"
source_file: "202504-PRR-349_Goodnight_Redacted.pdf"
case_id: "2682764"
responding_agency: "Department of Children, Youth, and Families (DCYF)"
children: ["Aidan Goodnight-Ralidak (8)", "Elora Goodnight-Ralidak (10)", "Raina Goodnight-Ralidak (6)"]
parties: 
  - "Veronika Goodnight (43) - Mother"
  - "Mathew Ralidak (38) - Father" 
  - "Colin Derieg (54) - Mother's Partner/Fiance"
  - "Monica Galarneau - Stepmother"
status: "Multiple CPS Intakes - Active Investigation"
tags: ["cps", "child_protection", "domestic_violence", "custody_dispute", "physical_abuse", "neglect"]
---

# DCYF CPS Records Analysis - Goodnight v. Ralidak Case

## Executive Summary

The DCYF records reveal an extensive pattern of Child Protective Services involvement spanning from July 2024 through April 2025, with multiple serious allegations involving physical abuse, neglect, and safety concerns for three children: Aidan (8), Elora (10), and Raina (6) Goodnight-Ralidak.

**Critical Timeline**: The most recent intakes (April 2025) coincide with escalating custody issues and a restraining order being put in place protecting the children from their mother.

## Key Findings

### Most Recent and Serious Concerns (April 2025)

#### 1. Restraining Order in Effect (April 24, 2025)
- **Current Status**: No-contact order protecting children from mother Veronika Goodnight
- **Father's Action**: Mathew Ralidak seeking emergency full custody
- **Court Date**: April 25, 2025 to revisit protection order

#### 2. Knife Threat Allegations (April 24, 2025)
- **Child Disclosure**: Aidan (8) asked father "if it's normal to be afraid that his mother would stab them with a knife"
- **Elora's Account**: Mother grabbed knife, "white knuckling" it
- **Safety Plan**: Children developed their own safety plan "in case the mother stabbed one of the children"
- **Worker**: Paul L. Delacuesta

#### 3. Physical Abuse Disclosures (April 14, 2025)
- **Aidan's Disclosure**: Mother gets physical when angry - pushing, slaps to face, intimidation
- **Verbal Abuse**: Mother cursing at children, middle finger gestures, saying "fuck you" and "don't be a fucking bitch"
- **Child's Fear**: Aidan told referrer "don't tell mom any of this, this has happened and it makes me sad"
- **Worker**: Jennifer L. Willen

### Pattern of Allegations Against Mother

#### Physical Abuse Incidents
1. **April 2025**: Raina (6) slapped "so hard she was thrown into the wall" 
2. **February 2025**: Colin Derieg (mother's partner) spanking Raina multiple times
3. **Ongoing**: Physical discipline contrary to parents' agreement not to use physical punishment

#### Neglect and Food Issues
1. **February 2025**: Children report being hungry, only eating eggs and peanut butter
2. **December 2024**: Restrictive diet with only protein shakes allowed
3. **Pattern**: Children arrive at father's home "filthy," with "dark circles under eyes"
4. **MLM Involvement**: Mother involved with Purium health products company

#### Medical and Educational Interference
1. **False Medical Claims**: Father told medical providers mother was "deceased" or had "drug addiction, alcoholism and mental health issues"
2. **Dietary Restrictions**: Mother claiming false food allergies, contradicted by pediatrician
3. **Counseling Interference**: Father cancelled Elora's counseling for sexual assault by peer

### Counter-Allegations from Mother

#### Against Father (Mathew Ralidak)
1. **April 2025**: Missed mental health therapy appointment
2. **April 2025**: Denied mother's presence at medical visit
3. **April 2025**: Fabricated gun allegation against Colin Derieg at school
4. **Pattern**: Mother alleges father makes false CPS reports and fabricates stories

### School Incident (April 4, 2025)
- **Location**: Carnation Elementary School
- **Police Report**: C25010391 by Officer J. Kellogg
- **Incident**: Confrontation between parents during pickup
- **Father's Claim**: Felt intimidated by Colin Derieg
- **Police Finding**: No crime occurred, no threatening gestures observed

### Sexual Abuse Concerns (Historical)
- **August 2024**: Elora (then 9) disclosed peer sexual contact at Girl Scout camp
- **Perpetrator**: Another child named "River" 
- **Mother's Response**: Arranged counseling at Dawson's Place
- **Father's Response**: Called it "kids fooling around," cancelled appointment
- **Outcome**: Delayed counseling by one month

## Case Patterns and Red Flags

### 1. Escalating Severity
- Progression from verbal abuse to physical threats with weapons
- Increasing frequency of CPS intakes in 2025

### 2. Competing Narratives
- Both parents making serious allegations against each other
- Difficulty determining credibility without investigation outcomes

### 3. Children's Safety Concerns
- Children developing their own safety plans
- Fear expressed by children about mother's anger
- Physical symptoms (dark circles, arriving dirty, hungry)

### 4. System Manipulation Concerns
- Multiple screen-out intakes suggesting possible system abuse
- Both parents accessing CPS system to make reports

## Current Legal Status

### Protection Order Details
- **Type**: Restraining order with 1000-foot distance requirement
- **Protected Parties**: Father Mathew Ralidak and all three children
- **Restrained Parties**: Mother Veronika Goodnight and Colin Derieg
- **Review Date**: April 25, 2025
- **Current Custody**: Father has all three children

### CPS Case Status
- **Case ID**: 2682764
- **Office**: King East Office
- **Assigned Worker**: Gracey Pearson (as of some reports)
- **Case Type**: Multiple FAR (Family Assessment Response) intakes

## Critical Evidence Patterns

### 1. Children's Direct Statements
- Consistent reports of mother's anger and physical responses
- Fear of violence (knife incidents)
- Requests not to tell mother about disclosures

### 2. Physical Evidence
- School nurse observations
- Medical records contradicting mother's allergy claims
- Documentation of children's physical condition

### 3. Third-Party Corroboration
- School staff observations
- Police reports
- Medical provider interactions

## Redaction Patterns

The document contains extensive redactions under **RCW 13.50.100(7)(c)**, which typically protects:
- Identity of mandatory reporters
- Specific details that could identify confidential sources
- Sensitive information about children's statements

## Recommendations for Legal Strategy

### 1. Immediate Safety Assessment
- Current restraining order provides temporary protection
- Need to evaluate ongoing safety with father's custody

### 2. Investigation Outcomes
- Critical to obtain CPS investigation findings
- Determine substantiation status of allegations

### 3. Medical Documentation
- Pediatrician's actual findings re: allergies
- Mental health evaluations for all parties
- Documentation of children's physical condition

### 4. Expert Evaluation
- Child custody evaluator
- Mental health assessment for family dynamics
- Evaluation of parental alienation allegations

## Timeline of Key Events

- **July 2024**: First documented CPS concerns
- **August 2024**: Elora's peer sexual assault incident
- **December 2024**: Food restriction allegations
- **February 2025**: Physical abuse by Colin Derieg reported
- **April 4, 2025**: School confrontation incident
- **April 14, 2025**: Aidan's physical abuse disclosure
- **April 24, 2025**: Knife threat allegations, restraining order
- **April 25, 2025**: Court hearing on protection order

## Audio Files Context

The PRR response included three audio files, which likely contain:
1. Recorded conversations or interviews
2. Children's disclosures
3. Investigation-related recordings

These audio files may provide crucial evidence regarding the children's statements and the circumstances of their disclosures.

---

**Note**: This analysis is based on intake reports and allegations. CPS investigations may have reached different conclusions. The pattern of competing allegations suggests a highly contentious custody situation requiring careful professional evaluation.