---
case_id: goodnight-v-ralidak
case_number: 20-3-03830-3-SEA
court: king-county-superior
court_findings_basis: march-3-2022-orders
court_standard_violation: 10x-one-week-standard
created: '2025-06-13'
cross_references:
- ~/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/02_FILING_READY/EMERGENCY_MOTIONS/ENHANCED_EMERGENCY_MOTION_FINAL.md
- ~/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/02_FILING_READY/EMERGENCY_MOTIONS/DECLARATION_OPTIMIZED_FINAL.md
- ~/Legal/01_ACTIVE_HEARING_AUG_25/EXHIBITS/B_Professional_Misconduct_Documentation.md
- ~/Legal/02_SUPPORTING_MATTERS/DOH_Complaint/
filing_status: ready-to-file
id: proposed-order-optimized-final
jurisdiction: washington-state
legal_basis: court-order-violations
order_type: contempt-and-enforcement
priority: emergency
professional_violations: licensed-therapist-documented
proposing_party: petitioner-veronika-goodnight
related_documents:
- ENHANCED_EMERGENCY_MOTION_FINAL.md
- DECLARATION_OPTIMIZED_FINAL.md
- FILING_PACKAGE_SUMMARY_FINAL.md
relief_requested:
- Contempt finding against respondent
- Immediate separation remedy
- Authority restoration to mother
- Professional accountability measures
- Constitutional protection enforcement
search_keywords:
- proposed order
- emergency relief
- contempt finding
- enforcement
- separation remedy
semantic_concepts:
- contempt proceedings
- professional accountability
separation_violation: 70-plus-days
title: Proposed Emergency Order - Optimized Final Version
type: proposed-court-order
updated: '2025-08-13'
uri: doc://legal/filing-ready/proposed-emergency-order
violating_professional: danielle-smith-lmhca
violation_date: may-1-2025
violation_evidence: client-called-stepmom-mom
---
# PROPOSED EMERGENCY ORDER
**KING COUNTY SUPERIOR COURT, WASHINGTON**

**Case No.:** 20-3-03830-3 SEA  
**Hon. ________________________**

**VERONIKA GOODNIGHT,**  
*Petitioner,*

**v.**

**MATTHEW RALIDAK,**  
*Respondent.*

---

## ORDER ON EMERGENCY MOTION FOR CONTEMPT AND ENFORCEMENT

This matter came before the Court on Petitioner's Emergency Motion for Contempt and Enforcement. The Court has reviewed the motion, declaration, exhibits, and any response filed. Based on the evidence presented:

## FINDINGS

**1. JURISDICTION AND AUTHORITY**
The Court has jurisdiction over the parties and subject matter. This Court's March 3, 2022 findings and orders remain in full force and effect.

**2. SEPARATION VIOLATION ESTABLISHED**
The evidence establishes that children have been separated from mother for 70+ consecutive days (as documented in Petitioner's June 13, 2025 court filing), 10x longer than Court's one-week standard, violating this Court's finding that separation should not exceed one week, particularly for the youngest child's emotional needs.

**3. PROFESSIONAL DOCUMENTATION OF VIOLATIONS**
Licensed therapist Danielle Smith, LMHCA documented terminology violations on May 1, 2025, stating "Client called stepmom, 'mom' throughout our session," directly violating this Court's prohibition order.

**4. HEALTHCARE AUTHORITY VIOLATIONS**
Respondent has systematically excluded Petitioner from healthcare decisions for seven months despite court orders requiring joint decision-making.

**5. EMERGENCY STANDARD SATISFIED**
Ongoing daily violations create immediate and continuing harm requiring swift judicial intervention to restore court order effectiveness.

## ORDERS

### IMMEDIATE COMPLIANCE (Effective Upon Signing)

**IT IS HEREBY ORDERED:**

**1. SEPARATION REMEDY**
a) The 70+ day separation of children from mother is IMMEDIATELY TERMINATED
b) Children shall be returned to mother's care within 48 hours of this order
c) Regular contact schedule per original court orders is IMMEDIATELY RESTORED

**2. TERMINOLOGY COMPLIANCE**
a) All use of parental terms ("mom," "mommy") for stepmother must CEASE IMMEDIATELY
b) Respondent shall immediately notify stepmother and all household members of this prohibition
c) Any licensed professionals working with children shall be notified of terminology requirements

**3. HEALTHCARE AUTHORITY RESTORATION**
a) Petitioner's joint decision-making authority is IMMEDIATELY RESTORED
b) All healthcare providers shall be notified in writing that BOTH parents must be consulted
c) No healthcare decisions may be made excluding either parent without emergency circumstances

**4. PROFESSIONAL NOTIFICATION**
a) All licensed providers currently serving children shall receive written copy of court orders
b) Providers must verify authority before accepting any exclusion of either parent
c) Court orders take precedence over any verbal authority claims

### CONTEMPT FINDING AND SANCTIONS

**5. CONTEMPT DETERMINATION**
Respondent Matthew Ralidak is found to be in CONTEMPT OF COURT for systematic violation of March 3, 2022 orders regarding:
- Separation limitations (68 days vs. one week standard)
- Terminology prohibitions (stepmother as "mom")
- Joint decision-making requirements (healthcare exclusion)

**6. SANCTIONS IMPOSED**
a) Fine of $2,500 payable to Court within 30 days
b) Respondent shall pay Petitioner's reasonable attorney fees for this emergency motion
c) 30 days suspended jail sentence, suspended contingent on future compliance

### PROFESSIONAL ACCOUNTABILITY

**7. LICENSING BOARD REFERRAL**
The Court ORDERS referral of Danielle Smith, LMHCA (#MC61294206) to Washington State Department of Health for:
- Documented enablement of court order violations
- Failure to implement judicial directives
- Professional misconduct investigation

**8. INSTITUTIONAL OVERSIGHT**
a) Larch Counseling PLLC practices regarding court order compliance shall be reviewed
b) All future therapy providers must be pre-approved by Court
c) Therapy session notes must document compliance with court orders

### ONGOING MONITORING AND COMPLIANCE

**9. COMPLIANCE REPORTING**
a) Respondent shall file weekly compliance reports for 60 days
b) Reports must detail adherence to separation, terminology, and authority orders
c) Any violations must be reported immediately to Court and opposing counsel

**10. VERIFICATION REQUIREMENTS**
a) All healthcare providers must verify court orders before making decisions
b) Written confirmation of both parents' consultation required for all non-emergency healthcare
c) Court orders supersede any verbal authority claims or representations

**11. EXPEDITED ENFORCEMENT**
a) Any future violations may be brought before the Court on 24-hour notice
b) Future contempt proceedings may result in immediate incarceration
c) Each violation constitutes separate contempt charge

### RETAINED JURISDICTION

**12. ONGOING AUTHORITY**
The Court retains jurisdiction for:
- Enforcement of this order
- Modification as necessary to protect children's welfare
- Additional sanctions for future violations
- Professional oversight and accountability measures

**13. SHOW CAUSE HEARING**
A show cause hearing is scheduled for _______, 2025 at _____ a.m./p.m. for:
- Compliance review and assessment
- Additional sanctions consideration
- Long-term enforcement planning
- Professional accountability measures

## NOTICE TO ALL PARTIES

**VIOLATION OF THIS ORDER MAY RESULT IN:**
- Immediate arrest and incarceration
- Additional fines and sanctions
- Loss of custody or parenting time
- Professional licensing consequences
- Federal civil rights liability

**THIS ORDER IS EFFECTIVE IMMEDIATELY UPON SIGNING**

All parties and licensed professionals are hereby notified that this Court's orders must be implemented immediately and that continued violations will result in severe sanctions including incarceration.

---

**DATED this _____ day of _______, 2025.**

_________________________________  
Hon. Rania Rampersad  
King County Superior Court Judge

---

**CLERK'S CERTIFICATE**

I hereby certify that this is a true and correct copy of the Emergency Order entered in the above-entitled matter.

_________________________________  
Clerk of the Court

---

**SERVICE CERTIFICATE**

Copies of this Emergency Order have been served upon:

[ ] Petitioner/Attorney  
[ ] Respondent/Attorney  
[ ] Danielle Smith, LMHCA  
[ ] Larch Counseling PLLC  
[ ] Washington State Department of Health  
[ ] Other: ________________________

Date: _____________

_________________________________  
Clerk of the Court