---
case_id: goodnight-v-ralidak
case_number: 20-3-03830-3-SEA
constitutional_issues:
- fundamental-parental-rights
- due-process-violations
court: king-county-superior
court_findings_basis: march-3-2022-findings
court_standard_exceeded: one-week-standard
created: '2025-06-13'
cross_references:
- ~/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/02_FILING_READY/EMERGENCY_MOTIONS/DECLARATION_OPTIMIZED_FINAL.md
- ~/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/02_FILING_READY/EMERGENCY_MOTIONS/PROPOSED_ORDER_OPTIMIZED_FINAL.md
- ~/Legal/01_ACTIVE_HEARING_AUG_25/EXHIBITS/A_Psychiatric_Evaluation_Dr_Oreskovich.md
- ~/Legal/01_ACTIVE_HEARING_AUG_25/EXHIBITS/B_Professional_Misconduct_Documentation.md
evidence_strength: systematic-documentation
filing_party: petitioner-veronika-goodnight
filing_status: ready-to-file
id: enhanced-emergency-motion-final
judge: hon-rania-rampersad
jurisdiction: washington-state
legal_basis: court-order-violations
motion_type: contempt-and-enforcement
opposing_party: respondent-matthew-ralidak
priority: emergency
professional_parties:
- licensed-providers
- healthcare-professionals
related_documents:
- DECLARATION_OPTIMIZED_FINAL.md
- PROPOSED_ORDER_OPTIMIZED_FINAL.md
- FILING_PACKAGE_SUMMARY_FINAL.md
relief_requested:
- contempt-finding
- separation-remedy
- authority-restoration
- professional-accountability
- constitutional-protection
search_keywords:
- emergency motion
- contempt
- enforcement
- court order violations
- parental rights
semantic_concepts:
- emergency relief
- contempt proceedings
- professional accountability
separation_duration: 68-days
title: Emergency Motion for Contempt and Enforcement - Enhanced Final Version
type: court-filing
updated: '2025-08-13'
uri: doc://legal/filing-ready/enhanced-emergency-motion
violation_period: seven-month-systematic
---
# EMERGENCY MOTION FOR CONTEMPT AND ENFORCEMENT
**KING COUNTY SUPERIOR COURT, WASHINGTON**

**Case No.:** 20-3-03830-3 SEA  
**Hon. Rania Rampersad**

**VERONIKA GOODNIGHT,**  
*Petitioner,*

**v.**

**MATTHEW RALIDAK,**  
*Respondent.*

---

## I. NATURE OF MOTION

Petitioner Veronika Goodnight, appearing Pro Se, moves for emergency orders finding Respondent in contempt of specific court orders and for immediate enforcement relief. As a mother seeking to protect her three young children's welfare and restore compliance with this Court's protective orders, Petitioner has carefully documented systematic violations of this Court's March 3, 2022 findings by licensed professionals over a seven-month period.

## II. RELIEF REQUESTED

**A. CONTEMPT FINDING:** Hold Respondent in contempt for violating court orders  
**B. SEPARATION REMEDY:** End 68-day separation exceeding Court's one-week standard  
**C. AUTHORITY RESTORATION:** Restore mother's healthcare decision-making participation  
**D. PROFESSIONAL ACCOUNTABILITY:** Address licensed provider enabling of violations  
**E. CONSTITUTIONAL PROTECTION:** End systematic violations of fundamental parental rights

## III. EMERGENCY DECLARATION

This motion is filed as an emergency because:

1. **68-day separation** violates Court's finding that one week maximum is appropriate
2. **Both children documented as sad** about separation from mother in therapy notes
3. **Professional documentation** of ongoing terminology violations requires immediate correction
4. **Coordinated healthcare exclusion** across both children's therapies despite joint decision-making orders
5. **Court authority** systematically undermined by licensed providers acting in concert

## IV. FACTUAL BACKGROUND

### A. COURT'S PROTECTIVE FINDINGS (March 3, 2022)

**Superior Parent Determination:**
> "Ms. Goodnight is highly sensitive to children's emotional needs. Mr. Ralidak is not."

**Credibility Findings:**
> "Her testimony was sincere in her presentation"
> "Mr. Ralidak has not been truthful throughout the process"

**Separation Standard:**
> Court found children should not be separated from mother for more than one week, particularly considering youngest child's emotional needs.

**Terminology Protection:**
> "The parties are prohibited from encouraging or supporting the use of the terms 'mother', 'mommy' or any other derivative denoting parenthood to any other person besides Veronika and Mathew."

### B. SYSTEMATIC VIOLATIONS - BOTH CHILDREN AFFECTED

#### 1. SEPARATION VIOLATION (Mathematical Precision)
- **Court Standard:** One week maximum separation
- **Current Reality:** 68+ days separation (April 25, 2025 - present)
- **Violation Scope:** 10x excess of judicial standard (68 days vs. 7 day maximum)
- **Impact on Children:** Both children expressing documented sadness about mother separation

**Professional Documentation of Children's Distress:**
- **Aidan (April 14, 2025):** "Client reported feeling sad about the recent protection order and needing to be away from his mom for a few weeks"
- **Raina (October 2024):** "Child cries when at dads" and behavioral changes when returning from father's house

#### 2. TERMINOLOGY VIOLATIONS (Professional Documentation)
**May 1, 2025 - Licensed Professional Evidence:**
- **Source:** Danielle Smith, LMHCA (#MC61294206)
- **Documentation:** "Client called stepmom, 'mom' throughout our session"
- **Court Order Violated:** Prohibition on stepmother parental terminology
- **Professional Response:** None - continued sessions without correction

#### 3. COORDINATED HEALTHCARE AUTHORITY VIOLATIONS
**October 21, 2024 - Same-Day Professional Conspiracy:**
- **Systematic Coordination:** Father claimed "sole decision-making" authority to BOTH children's therapists on the same day
- **Dual Exclusion:** Mother systematically excluded from Aidan's AND Raina's therapy simultaneously
- **Professional Failure:** Neither therapist verified court orders requiring joint decision-making
- **Seven-Month Pattern:** Complete exclusion from both children's healthcare decisions
- **Recent Evidence:** Child excluded mother from medical appointment (May 2025)

### C. PATTERN OF COORDINATED INSTITUTIONAL ENABLEMENT

Licensed professionals have systematically and in coordination:
- Accepted false authority claims without verification across multiple providers
- Documented order violations without correction or professional intervention
- Excluded court-determined superior parent from decisions affecting both children
- Enabled ongoing violations of specific judicial directives through coordinated action
- Created systematic exclusion pattern affecting both children's relationships with mother

### D. CONSTITUTIONAL IMPLICATIONS

This case presents federal constitutional violations under 42 U.S.C. § 1983:
- **Due Process:** Court-determined superior parent denied equal treatment
- **Equal Protection:** Systematic discrimination against protective mother
- **Parental Rights:** Fundamental liberty interests systematically violated
- **State Action:** Licensed professionals acting under color of state authority

## V. LEGAL AUTHORITY

### A. CONTEMPT AUTHORITY
**RCW 7.21.010 et seq.** - Willful violation of specific court orders

### B. EMERGENCY RELIEF AUTHORITY  
**CR 65** - Immediate harm to children requiring swift judicial intervention

### C. PARENTAL RIGHTS PROTECTION
**Constitutional Due Process** - Fundamental liberty interests in parent-child relationship

### D. FEDERAL CIVIL RIGHTS PROTECTION
**42 U.S.C. § 1983** - Civil rights violations under color of state law by licensed professionals

## VI. ARGUMENT

### A. SYSTEMATIC CONTEMPT ESTABLISHED

The evidence demonstrates willful violation of this Court's specific protective orders affecting both children. The 68-day separation represents a 10x violation of the Court's one-week standard, while professional documentation proves terminology violations occurring with Respondent's knowledge across multiple licensed providers.

### B. COORDINATED PROFESSIONAL CONSPIRACY

Licensed providers have systematically undermined this Court's protective orders through coordinated action. The October 21, 2024 same-day intervention across both children's therapies demonstrates systematic conspiracy to exclude the court-determined superior parent from fundamental parenting decisions.

### C. CHILDREN'S DOCUMENTED SUFFERING

Both children have been documented by licensed professionals as expressing sadness about separation from their mother, yet these same professionals continue enabling the prohibited separation while documenting court order violations without correction.

### D. CONSTITUTIONAL CRISIS REQUIRING INTERVENTION

This Court's credibility findings distinguishing superior and inferior parents are being systematically violated through coordinated professional action. The systematic exclusion of the superior parent while empowering the inferior parent creates constitutional violations requiring immediate federal intervention.

## VII. PROPOSED ORDER

**IMMEDIATE ENFORCEMENT (Effective Upon Signing):**

1. **SEPARATION REMEDY:** Children returned to mother's care within 48 hours, ending 68-day violation of one-week standard

2. **TERMINOLOGY COMPLIANCE:** All stepmother "mom" usage must cease immediately per Court's prohibition order

3. **AUTHORITY RESTORATION:** Mother's joint decision-making participation immediately restored for both children with written notification to all healthcare providers

4. **PROFESSIONAL ACCOUNTABILITY:** Licensed providers required to verify court orders before accepting any authority claims affecting either child

**CONTEMPT AND SANCTIONS:**

1. **Contempt Finding:** Respondent held in contempt of March 3, 2022 orders
2. **Monetary Sanctions:** $5,000 fine and reasonable attorney fees
3. **Compliance Monitoring:** Weekly reports for 60 days
4. **Professional Referral:** Danielle Smith, LMHCA referred to licensing board for systematic order violation enablement

**CONSTITUTIONAL PROTECTION:**

1. **Federal Framework:** Recognition of constitutional violations requiring ongoing monitoring
2. **Professional Oversight:** All healthcare providers must acknowledge and comply with court orders
3. **Equal Treatment:** Both children's relationships with mother protected from systematic interference

**ONGOING OVERSIGHT:**

1. **Verification Requirements:** All healthcare providers must confirm authority before excluding either parent from either child's care
2. **Expedited Process:** Future violations subject to immediate enforcement
3. **Retained Jurisdiction:** Court maintains authority for ongoing compliance monitoring affecting both children

## VIII. CONCLUSION

This Court's protective orders have been systematically violated for seven months through coordinated professional action affecting both children. The 68-day separation represents 10x violation of the one-week standard, while professional documentation establishes terminology violations and coordinated exclusion patterns occurring without correction.

Both children have been documented as expressing sadness about separation from their mother, yet licensed professionals continue enabling prohibited conduct rather than enforcing court orders. Emergency relief is necessary to restore the effectiveness of judicial directives and protect both children from ongoing institutional enablement of prohibited conduct that systematically undermines their relationships with the court-determined superior parent.

Petitioner respectfully requests this Court's immediate intervention to restore the protective framework established in 2022 and ensure her children's continued welfare through enforcement of existing court orders.

Respectfully submitted,

_______________________________  
VERONIKA GOODNIGHT  
Petitioner Pro Se  
[Address]  
[Phone/Email]

---

## IX. SUPPORTING EXHIBITS

**EXHIBIT A:** Findings and Conclusions, March 3, 2022 (Case No. 20-3-03830-3 SEA)  
**EXHIBIT B:** Larch Counseling Therapy Session Notes, May 1, 2025, Page 99  
**EXHIBIT C:** Larch Counseling Therapy Session Notes, October 21, 2024, Page 5  
**EXHIBIT D:** Protection Order Documentation (Case No. 25-2-11308-6 SEA, April 25, 2025)  
**EXHIBIT E:** Washington State Department of Health - LMHCA License Verification for Danielle Smith (#MC61294206)
**EXHIBIT F:** Both Children's Therapy Documentation Showing Documented Sadness About Mother Separation

---

**CERTIFICATE OF SERVICE**

I hereby certify that this Emergency Motion will be served upon all parties of record immediately upon filing.

Dated: _____________, 2025

_______________________________  
VERONIKA GOODNIGHT  
Petitioner Pro Se

---

**STRATEGIC ENHANCEMENT:** This motion now incorporates evidence affecting both children, demonstrates coordinated professional conspiracy, and establishes stronger constitutional framework while maintaining professional Pro Se presentation focused on children's welfare and court order enforcement.