---
case_id: goodnight-v-ralidak
case_number: 20-3-03830-3-SEA
children_involved:
- E.R. (born 2019)
- A.R. (born 2021)
- C.R. (born 2023)
court: king-county-superior
court_determinations:
- Mother highly sensitive to children's emotional needs
- Father is not sensitive to emotional needs
- Children should not be separated for more than one week
court_findings_date: '2024-06-25'
court_standard: one-week-maximum
created: '2025-06-13'
cross_references:
- ~/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/02_FILING_READY/EMERGENCY_MOTIONS/ENHANCED_EMERGENCY_MOTION_FINAL.md
- ~/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/02_FILING_READY/EMERGENCY_MOTIONS/PROPOSED_ORDER_OPTIMIZED_FINAL.md
- ~/Legal/01_ACTIVE_HEARING_AUG_25/EXHIBITS/A_Psychiatric_Evaluation_Dr_Oreskovich.md
- ~/Legal/01_ACTIVE_HEARING_AUG_25/COURT_FILINGS/Filing_Instructions.md
declarant: veronika-goodnight
declarant_status: petitioner-mother
declaration_basis: personal-knowledge
evidence_competency: personal-knowledge
filing_status: ready-to-file
id: declaration-optimized-final
jurisdiction: washington-state
legal_basis: systematic-court-order-violations
legal_framework: perjury-penalty-washington
priority: emergency
related_documents:
- ENHANCED_EMERGENCY_MOTION_FINAL.md
- PROPOSED_ORDER_OPTIMIZED_FINAL.md
- FILING_PACKAGE_SUMMARY_FINAL.md
search_keywords:
- declaration
- emergency motion
- separation violation
- court standard
- maternal rights
semantic_concepts:
- emergency relief
separation_violation: 70-plus-days
title: Declaration in Support of Emergency Motion - Optimized Final Version
type: court-declaration
updated: '2025-08-13'
uri: doc://legal/filing-ready/declaration-support
violation_multiplier: 10x-violation
violation_timeline: april-25-2025-to-present
---
# DECLARATION IN SUPPORT OF EMERGENCY MOTION
**KING COUNTY SUPERIOR COURT, WASHINGTON**

**Case No.:** 20-3-03830-3 SEA

**VERONIKA GOODNIGHT,**  
*Petitioner,*

**v.**

**MATTHEW RALIDAK,**  
*Respondent.*

---

## DECLARATION OF VERONIKA GOODNIGHT

I, Veronika Goodnight, declare under penalty of perjury under the laws of the State of Washington that the following is true and correct:

## I. PERSONAL KNOWLEDGE AND STANDING

1. I am the mother of three minor children: E.R. (born 2019), A.R. (born 2021), and C.R. (born 2023). I have personal knowledge of the facts stated herein and am competent to testify to them.

2. This Court entered comprehensive findings and orders on June 25, 2024, determining that I am "highly sensitive to children's emotional needs" while finding that Respondent father "is not" and establishing that children should not be separated from me for more than one week.

## II. SYSTEMATIC VIOLATION OF SEPARATION ORDERS

3. **Court Standard Established:** This Court specifically found that children should not be separated from me for more than one week, particularly considering the youngest child's emotional needs.

4. **Current Violation:** The children have been separated from me for 70+ consecutive days (April 25, 2025 - present), as documented in my June 13, 2025 court filing, representing a 10x violation of this Court's one-week standard.

5. **Legal Documentation:** My June 13, 2025 "Declaration in Response to Respondent's Request for Temporary Orders" explicitly states: "exceeded for over 70 days, in direct violation of court guidance."

6. **Mathematical Precision:** 70+ days ÷ 7 days (Court standard) = 10x violation of specific judicial finding designed to protect children's emotional welfare.

## III. PROFESSIONAL DOCUMENTATION OF TERMINOLOGY VIOLATIONS

6. **Court Order:** This Court prohibited the use of parental terms ("mother," "mommy") for stepmother, recognizing the psychological importance of parental identity protection.

7. **Professional Evidence:** Licensed therapist Danielle Smith, LMHCA (#MC61294206) documented on May 1, 2025: "Client called stepmom, 'mom' throughout our session."

8. **Professional Failure:** Despite documenting this direct violation of Court orders, the licensed professional took no corrective action and continued therapy sessions.

9. **Ongoing Violations:** This represents systematic enabling of Court order violations by state-licensed providers who have a duty to implement judicial directives.

## IV. HEALTHCARE AUTHORITY VIOLATIONS

10. **Joint Decision-Making Order:** This Court established joint decision-making authority for healthcare decisions, requiring both parents' consultation and participation.

11. **False Authority Claims:** Beginning October 21, 2024, Respondent falsely claimed "sole decision-making" authority to licensed therapist without any verification against court orders.

12. **Systematic Exclusion:** For seven months, I have been excluded from my children's healthcare decisions despite court orders requiring my participation.

13. **Recent Evidence:** In May 2025, Respondent excluded me from child's medical appointment, with child reporting anxiety about "mat didn't allow me to be in."

## V. PATTERN OF INSTITUTIONAL BIAS

14. **Superior Parent Exclusion:** Licensed professionals systematically exclude me despite this Court's finding that I am "highly sensitive to children's emotional needs."

15. **Inferior Parent Empowerment:** The same professionals accept authority from Respondent despite this Court's finding that he "has not been truthful throughout the process."

16. **Professional Conspiracy:** This represents systematic institutional bias against this Court's credibility determinations and protective orders.

## VI. IMPACT ON CHILDREN'S WELFARE

17. **Documented Psychological Harm:** During the prohibited extended separation, children have exhibited signs of psychological distress and alienation from me.

18. **Identity Confusion:** Professional enablement of stepmother being called "mom" directly contradicts this Court's protective orders designed to preserve children's parental identity.

19. **Ongoing Trauma:** Each day of continued violations represents additional psychological harm to children who are being systematically separated from the parent this Court found superior.

## VII. EMERGENCY RELIEF NECESSITY

20. **Daily Violations:** The separation violation continues daily, with each day representing additional contempt of this Court's specific protective finding.

21. **Professional Enablement:** Licensed providers continue to enable violations rather than enforce court orders, demonstrating that only immediate judicial intervention can stop institutional bias.

22. **Inadequate Alternative Remedies:** Seven months of violations despite my objections prove that professional self-regulation has failed completely.

23. **Time-Sensitive Evidence:** Professional documentation of violations requires immediate action before evidence is modified or destroyed.

## VIII. RELIEF REQUESTED

24. **Immediate Compliance:** Children should be returned to my care within 48 hours to end the 68-day violation of this Court's one-week standard.

25. **Professional Accountability:** Licensed providers who enabled violations should be held accountable through appropriate licensing board referrals.

26. **Authority Restoration:** My joint decision-making authority should be immediately restored with written notification to all healthcare providers.

27. **Protective Monitoring:** Ongoing court oversight is necessary to prevent future violations by ensuring professional compliance with judicial directives.

## IX. CONCLUSION

This Court's protective orders, specifically designed to safeguard my children's emotional welfare, have been systematically violated for seven months. The evidence is mathematical, documented by professionals, and continuing daily.

Emergency relief is necessary to restore the effectiveness of this Court's protective framework and stop ongoing institutional enablement of prohibited conduct that harms my children's psychological welfare.

I declare under penalty of perjury under the laws of the State of Washington that the foregoing is true and correct.

Executed this _____ day of _______, 2025, at Seattle, Washington.

_______________________________  
VERONIKA GOODNIGHT

---

## X. VERIFICATION

STATE OF WASHINGTON  
COUNTY OF KING

I, Veronika Goodnight, being first duly sworn, depose and say that I have read the foregoing Declaration, that the same is true and correct except as to those matters stated upon information and belief, and as to those matters, I believe them to be true.

_______________________________  
VERONIKA GOODNIGHT

Subscribed and sworn to before me this _____ day of _______, 2025.

_______________________________  
Notary Public in and for the State of Washington  
Residing at: _____________________  
My commission expires: ___________

---

**EXHIBIT ATTACHMENTS:**

**EXHIBIT 1:** Findings and Conclusions, March 3, 2022 (Case No. 20-3-03830-3 SEA)  
**EXHIBIT 2:** Larch Counseling Therapy Session Notes, May 1, 2025, Page 99  
**EXHIBIT 3:** Larch Counseling Therapy Session Notes, October 21, 2024, Page 5  
**EXHIBIT 4:** Protection Order Documentation (Case No. 25-2-11308-6 SEA, April 25, 2025)  
**EXHIBIT 5:** Washington State Department of Health - LMHCA License Verification for Danielle Smith (#MC61294206)