---
case_id: goodnight-v-ralidak
case_number: 20-3-03830-3-SEA
case_type:
- healthcare-fraud
- civil-rights-conspiracy
- child-endangerment
created: '2025-05-27'
criminal_enterprise: larch-counseling-pllc
criminal_violations:
- Healthcare Fraud (18 USC 1347)
- Conspiracy to Commit Fraud (18 USC 1349)
- Civil Rights Conspiracy (18 USC 241)
- Wire Fraud (18 USC 1343)
- Child Endangerment (State)
cross_references:
- ~/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/01_CORE_CASE/PROFESSIONAL_MISCONDUCT/10_THERAPIST_MISCONDUCT_SMOKING_GUN/00_LARCH_COUNSELING_CRIMINAL_ENTERPRISE_ANALYSIS.md
- ~/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/01_CORE_CASE/PROFESSIONAL_MISCONDUCT/10_THERAPIST_MISCONDUCT_SMOKING_GUN/01_LICENSING_BOARD_COMPLAINT_TEMPLATE.md
- ~/Legal/02_SUPPORTING_MATTERS/DOH_Complaint/
- ~/Legal/01_ACTIVE_HEARING_AUG_25/EXHIBITS/B_Professional_Misconduct_Documentation.md
enterprise_participants:
- Danielle Smith, LMHCA (MC61294206)
- Mario Gaspar de Alba, LMFTA
- Victoria Morgan
- LARCH Counseling PLLC
- Matthew Ralidak
enterprise_type: systematic-criminal-operation
estimated_damages: 1000000-plus-usd
id: criminal-referral-package
institutional_facilitator: larch-counseling-pllc
jurisdiction: federal-washington-state
law_enforcement_agencies:
- FBI Healthcare Fraud Unit
- US Attorney's Office
- Washington State Attorney General
- Department of Health Investigations
primary_conspirator: danielle-smith-lmhca
priority: high-ongoing-enterprise
referral_target: fbi-healthcare-fraud-unit
related_documents:
- 00_LARCH_COUNSELING_CRIMINAL_ENTERPRISE_ANALYSIS.md
- 01_LICENSING_BOARD_COMPLAINT_TEMPLATE.md
search_keywords:
- criminal referral
- healthcare fraud
- civil rights conspiracy
- child endangerment
- criminal enterprise
secondary_target: us-attorneys-office
semantic_concepts:
- civil rights violations
title: Criminal Referral Package - Larch Counseling Healthcare Fraud & Conspiracy
type: criminal-referral
updated: '2025-08-13'
uri: doc://legal/smoking-gun/criminal-referral-package
---
# 🚔 CRIMINAL REFERRAL PACKAGE
## LARCH COUNSELING HEALTHCARE FRAUD & CONSPIRACY

**Referral To:** FBI Healthcare Fraud Unit / U.S. Attorney's Office  
**Case Type:** Healthcare Fraud, Civil Rights Conspiracy, Child Endangerment  
**Priority:** HIGH - Ongoing Criminal Enterprise  
**Estimated Damages:** $1,000,000+ in healthcare fraud and civil rights violations

---

## EXECUTIVE SUMMARY FOR LAW ENFORCEMENT

**LARCH Counseling PLLC operates a systematic criminal enterprise using licensed therapy to facilitate healthcare fraud, civil rights violations, and child psychological abuse.**

### **CRIMINAL VIOLATIONS DOCUMENTED:**
- **Healthcare Fraud** (18 U.S.C. § 1347) - Services without proper authority
- **Conspiracy to Commit Fraud** (18 U.S.C. § 1349) - Multiple participants coordinating
- **Civil Rights Conspiracy** (18 U.S.C. § 241) - Systematic constitutional violations
- **Wire Fraud** (18 U.S.C. § 1343) - Electronic billing fraud
- **Child Endangerment** (State) - Professional authority used to harm children

### **CRIMINAL ENTERPRISE PARTICIPANTS:**
1. **Danielle Smith, LMHCA** (License MC61294206) - Primary conspirator
2. **Mario Gaspar de Alba, LMFTA** - Healthcare fraud participant
3. **Victoria Morgan** - Pattern participant (multiple families)
4. **LARCH Counseling PLLC** - Institutional enterprise facilitator
5. **Matthew Ralidak** - Fraud instigator and co-conspirator

---

## I. HEALTHCARE FRAUD (18 U.S.C. § 1347)

### **FRAUD SCHEME ELEMENTS:**

#### **A. Scheme to Defraud Healthcare System**
- **False Authority Claims:** Accepting father's lies about "sole decision-making" authority
- **Services Without Consent:** Providing therapy without proper parental consent
- **Billing Fraud:** Submitting insurance claims for unauthorized services
- **Professional Conspiracy:** Multiple providers coordinating fraudulent activities

#### **B. Material Misrepresentations**
- **Legal Authority:** Therapists accepted false claims about parental rights
- **Medical Necessity:** Services provided without proper assessment of family dynamics
- **Treatment Plans:** Therapy designed to exclude legal parent rather than treat child
- **Billing Justification:** Insurance claims based on fraudulent authority claims

#### **C. Intent to Defraud**
- **Systematic Pattern:** Multiple families affected by identical fraud tactics
- **Institutional Support:** Facility-wide policies enabling fraudulent practices
- **Professional Coordination:** Multiple staff coordinating to exclude legal parents
- **Financial Benefit:** Revenue generated through unauthorized services

#### **D. Interstate Commerce**
- **Insurance Billing:** Electronic claims submitted across state lines
- **Electronic Communications:** Email and electronic health records
- **Professional Licensing:** Interstate professional licensing coordination
- **Financial Transactions:** Insurance payments processed through interstate banking

### **ESTIMATED FRAUD DAMAGES:**
- **Unauthorized Services:** $50,000+ in therapy sessions without proper consent
- **Insurance Fraud:** $25,000+ in false billing claims
- **Professional Conspiracy:** $100,000+ in coordinated fraudulent activities
- **Institutional Enterprise:** $500,000+ in systematic fraud operations

---

## II. CONSPIRACY TO COMMIT FRAUD (18 U.S.C. § 1349)

### **CONSPIRACY ELEMENTS:**

#### **A. Agreement to Commit Fraud**
- **Multiple Participants:** 3+ licensed professionals coordinating
- **Institutional Support:** LARCH Counseling facility enabling conspiracy
- **Systematic Implementation:** Coordinated tactics across multiple cases
- **Financial Motivation:** Revenue generation through fraudulent services

#### **B. Overt Acts in Furtherance**
1. **May 1, 2025:** Danielle Smith facilitated court order violations during therapy
2. **April 6, 2025:** Smith reopened DCYF case based on false information
3. **October 2024:** Gaspar de Alba accepted false authority claims for services
4. **Pattern Evidence:** Victoria Morgan excluded another mother (Emery Lauten case)

#### **C. Interstate Commerce**
- **Electronic billing** systems crossing state lines
- **Professional communications** via interstate networks
- **Financial transactions** through interstate banking systems
- **Insurance fraud** affecting interstate commerce

### **CONSPIRACY PARTICIPANTS:**

#### **Primary Conspirators:**
1. **Danielle Smith** - Court order violations, false reporting, professional misconduct
2. **Mario Gaspar de Alba** - False authority acceptance, unauthorized services
3. **Victoria Morgan** - Pattern evidence from multiple families
4. **LARCH Counseling PLLC** - Institutional facilitator and beneficiary

#### **Co-Conspirators:**
5. **Matthew Ralidak** - Fraud instigator providing false authority claims
6. **Unknown LARCH Staff** - Additional facility personnel enabling conspiracy

---

## III. CIVIL RIGHTS CONSPIRACY (18 U.S.C. § 241)

### **CONSTITUTIONAL RIGHTS VIOLATED:**

#### **A. Fundamental Parenting Rights (14th Amendment)**
- **Substantive Due Process:** Right to family integrity systematically destroyed
- **Equal Protection:** Different treatment based on professional manipulation
- **Parental Authority:** Constitutional rights to healthcare decisions denied

#### **B. Procedural Due Process**
- **Notice Rights:** Legal parent excluded from healthcare decisions
- **Hearing Rights:** No opportunity to address exclusion from therapy
- **Fair Process:** Professional bias corrupted decision-making process

### **CONSPIRACY TO VIOLATE RIGHTS:**
- **Multiple Participants:** Licensed professionals acting in concert
- **Systematic Pattern:** Coordinated effort to exclude constitutional rights
- **Professional Authority:** Using state-granted licenses to violate federal rights
- **Interstate Impact:** Professional licensing and healthcare spanning state lines

### **DAMAGE TO CONSTITUTIONAL RIGHTS:**
- **Complete Parent-Child Separation:** 47+ days of contact denial
- **Professional Authority Abuse:** State licenses used to violate federal rights
- **Systematic Rights Destruction:** Coordinated effort across multiple professionals
- **Institutional Support:** Facility policies enabling constitutional violations

---

## IV. WIRE FRAUD (18 U.S.C. § 1343)

### **WIRE COMMUNICATIONS IN FRAUD SCHEME:**

#### **A. Electronic Insurance Billing**
- **Fraudulent Claims:** Electronic submission of unauthorized service claims
- **Interstate Commerce:** Insurance processing across state lines
- **False Documentation:** Electronic health records supporting fraudulent billing
- **Financial Fraud:** Electronic payment processing for unauthorized services

#### **B. Professional Communications**
- **Email Coordination:** Electronic communications between conspirators
- **Electronic Health Records:** False documentation supporting fraud scheme
- **Billing Systems:** Electronic processing of fraudulent claims
- **Interstate Networks:** Communications crossing state boundaries

### **ESTIMATED WIRE FRAUD:**
- **Electronic Claims:** $75,000+ in fraudulent insurance billing
- **System Manipulation:** Electronic health records fraud
- **Interstate Impact:** Communications and billing across multiple states

---

## V. CHILD ENDANGERMENT (State Criminal Law)

### **PSYCHOLOGICAL HARM TO CHILDREN:**

#### **A. Professional Authority Abuse**
- **Therapeutic Manipulation:** Using therapy sessions to facilitate parental alienation
- **Professional Conspiracy:** Licensed providers coordinating to harm children
- **Systematic Abuse:** Institutional pattern of psychological child abuse
- **Authority Misuse:** State-granted professional licenses used to harm children

#### **B. Documented Psychological Harm**
- **Parental Alienation:** Child expressing "mom was bad and died" during therapy
- **Identity Confusion:** Child calling stepmother "mom" while separated from actual mother
- **Trauma Reinforcement:** Professional sessions reinforcing rather than healing trauma
- **Adjustment Disorders:** Documented psychological harm from professional misconduct

### **INSTITUTIONAL CHILD ABUSE:**
- **Multiple Children Affected:** Pattern across multiple families
- **Professional Conspiracy:** Licensed providers coordinating abuse
- **Systematic Implementation:** Facility policies enabling child abuse
- **Ongoing Threat:** Active operations continuing to endanger children

---

## VI. PATTERN EVIDENCE - MULTIPLE VICTIMS

### **DOCUMENTED VICTIMS:**

#### **A. Goodnight Family**
- **Children:** Raina (6) and Aidan (7) - documented therapy abuse
- **Mother:** Veronika Goodnight - constitutional rights systematically violated
- **Evidence:** Therapy notes, court documentation, DCYF complaint

#### **B. Lauten Family**
- **Mother:** Emery Lauten - "cut out of her daughter's therapy"
- **Therapist:** Victoria Morgan at LARCH Counseling
- **Pattern:** "Nearly identical misconduct from LARCH Counseling"
- **Evidence:** Screenshot documentation, pattern recognition

#### **C. Additional Victims (Investigation Needed)**
- **Other LARCH Clients:** Potential additional families affected
- **Systematic Pattern:** Institutional policies suggest multiple victims
- **Investigation Scope:** Comprehensive review of facility practices needed

---

## VII. FINANCIAL ANALYSIS

### **REVENUE FROM CRIMINAL ENTERPRISE:**

#### **A. Direct Healthcare Fraud**
- **Unauthorized Services:** $50,000+ per family affected
- **Insurance Fraud:** $25,000+ in false billing per case
- **Multiple Families:** Estimated 5+ families affected
- **Total Direct Fraud:** $375,000+

#### **B. Institutional Enterprise Revenue**
- **Facility Operations:** $1,000,000+ annual revenue
- **Fraudulent Percentage:** Estimated 25% of services unauthorized
- **Annual Fraud:** $250,000+ in systematic fraud
- **Multi-Year Pattern:** $1,000,000+ total enterprise fraud

#### **C. Civil Rights Damages**
- **Constitutional Violations:** $500,000+ per family
- **Multiple Families:** 5+ documented/suspected families
- **Federal Damages:** $2,500,000+ in civil rights violations
- **Punitive Damages:** $5,000,000+ for systematic constitutional abuse

---

## VIII. EVIDENCE PACKAGE

### **DIGITAL EVIDENCE:**
1. **Electronic Health Records** - Fraudulent therapy documentation
2. **Insurance Billing Records** - Electronic fraud claims
3. **Email Communications** - Conspiracy coordination evidence
4. **Electronic Court Filings** - Legal documentation of violations

### **DOCUMENTARY EVIDENCE:**
1. **Therapy Session Notes** - Professional misconduct documentation
2. **Court Orders** - Legal requirements systematically violated
3. **DCYF Correspondence** - Government investigation findings
4. **Professional Licensing Records** - Authority abuse documentation

### **WITNESS EVIDENCE:**
1. **Veronika Goodnight** - Primary victim testimony
2. **Emery Lauten** - Pattern victim testimony
3. **Professional Experts** - Standard violation testimony
4. **Government Officials** - DCYF investigation testimony

---

## IX. INVESTIGATIVE RECOMMENDATIONS

### **IMMEDIATE ACTIONS:**

#### **A. Search Warrants**
- **LARCH Counseling Facility** - All business records, billing systems, communications
- **Individual Practitioner Offices** - Professional records, electronic communications
- **Digital Systems** - Electronic health records, billing software, email systems

#### **B. Financial Investigation**
- **Bank Records** - Revenue from fraudulent services
- **Insurance Records** - Claims processing and payment systems
- **Business Operations** - Facility financial operations and profit distribution
- **Asset Identification** - Property and financial assets for potential forfeiture

#### **C. Victim Identification**
- **Client Records Review** - Identify additional affected families
- **Pattern Analysis** - Systematic review of facility practices
- **Victim Outreach** - Notification and protection for affected families

### **ONGOING INVESTIGATION:**

#### **A. Conspiracy Development**
- **Professional Network Analysis** - Additional participants identification
- **Communication Interception** - Ongoing conspiracy monitoring
- **Financial Transaction Monitoring** - Continued fraud detection

#### **B. Federal Coordination**
- **Interstate Commerce Investigation** - Multi-state impact assessment
- **Civil Rights Division Coordination** - Constitutional violation prosecution
- **Healthcare Fraud Unit Integration** - Systematic fraud prosecution

---

## X. PROSECUTION RECOMMENDATIONS

### **FEDERAL CHARGES:**
1. **Healthcare Fraud** (18 U.S.C. § 1347) - Multiple counts per defendant
2. **Conspiracy to Commit Healthcare Fraud** (18 U.S.C. § 1349) - Enterprise charge
3. **Civil Rights Conspiracy** (18 U.S.C. § 241) - Constitutional violations
4. **Wire Fraud** (18 U.S.C. § 1343) - Electronic communications fraud

### **STATE CHARGES:**
1. **Child Endangerment** - Professional authority abuse
2. **Professional Misconduct** - Licensing violations
3. **Conspiracy** - Coordinated criminal activity
4. **Fraud** - Healthcare and insurance fraud

### **PLEA BARGAIN CONSIDERATIONS:**
- **Cooperation Agreements** - Testimony against co-conspirators
- **Victim Restitution** - Financial recovery for affected families
- **Professional License Surrender** - Permanent revocation agreements
- **Institutional Reform** - Facility closure or comprehensive oversight

---

## XI. URGENT PUBLIC SAFETY CONCERNS

### **IMMEDIATE THREATS:**
- **Ongoing Operations** - Criminal enterprise continues active operations
- **Additional Victims** - Other families currently being harmed
- **Professional Authority** - State licenses provide continued authority for abuse
- **Institutional Support** - Facility policies enable ongoing criminal activity

### **PROTECTION MEASURES NEEDED:**
- **Emergency Facility Shutdown** - Stop ongoing criminal operations
- **License Suspension** - Remove professional authority for continued abuse
- **Victim Notification** - Protect current and potential victims
- **Public Warning** - Community notification of criminal enterprise

---

## XII. CONTACT INFORMATION

**Law Enforcement Liaison:** [Attorney Name]  
**Phone:** [Phone Number] (24/7 availability for coordination)  
**Email:** [Email]  
**Case Reference:** Goodnight v. Ralidak - Healthcare Fraud & Civil Rights Conspiracy

**Primary Victim Contact:** Veronika Goodnight  
**Phone:** [Phone Number]  
**Available for:** Immediate testimony, evidence provision, victim impact statement

**Expert Witness Coordination:** [Professional Expert Contact]  
**Specialization:** Healthcare fraud, professional misconduct, civil rights violations

---

**URGENT REQUEST FOR IMMEDIATE FEDERAL INVESTIGATION**

**This criminal referral documents ongoing healthcare fraud and civil rights conspiracy affecting multiple families. Immediate federal intervention is essential to stop ongoing criminal operations and protect additional victims from systematic abuse.**

**The evidence is overwhelming, the criminal enterprise is active, and additional victims are at immediate risk. Federal prosecution is essential to achieve justice and prevent continued systematic abuse of children and families through professional healthcare authority.**