---
case_id: goodnight-v-ralidak
case_number: 20-3-03830-3-SEA
complaint_basis: professional-misconduct
complaint_details:
  attorney_field: '[Attorney Name]'
  complaint_nature: Emergency License Suspension Request
  division: Professional Licensing Division
  filing_agency: Washington State Department of Health
  representing_party: Veronika Goodnight
complaint_type: emergency-license-suspension
created: '2025-05-27'
cross_references:
- ~/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/01_CORE_CASE/PROFESSIONAL_MISCONDUCT/10_THERAPIST_MISCONDUCT_SMOKING_GUN/00_LARCH_COUNSELING_CRIMINAL_ENTERPRISE_ANALYSIS.md
- ~/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/01_CORE_CASE/PROFESSIONAL_MISCONDUCT/10_THERAPIST_MISCONDUCT_SMOKING_GUN/02_CRIMINAL_REFERRAL_PACKAGE.md
- ~/Legal/02_SUPPORTING_MATTERS/DOH_Complaint/
- ~/Legal/01_ACTIVE_HEARING_AUG_25/EXHIBITS/B_Professional_Misconduct_Documentation.md
facility: larch-counseling-pllc
filing_agency: department-of-health
id: licensing-board-complaint-template
jurisdiction: washington-state
legal_violation: court-order-violations
license_number: MC61294206
license_type: licensed-mental-health-counselor-associate
priority: urgent-public-safety-threat
related_documents:
- 00_LARCH_COUNSELING_CRIMINAL_ENTERPRISE_ANALYSIS.md
- 02_CRIMINAL_REFERRAL_PACKAGE.md
search_keywords:
- licensing complaint
- emergency suspension
- professional misconduct
- DOH complaint
- license revocation
semantic_concepts:
- professional accountability
- regulatory enforcement
supervision_status: associate-requires-supervision
target_information:
  license_number: MC61294206
  license_type: LMHCA
  name: Danielle Smith
  practice_location: LARCH Counseling PLLC
  supervision_required: true
target_professional: danielle-smith-lmhca
title: DOH Professional Licensing Complaint Template - Emergency Suspension Request
type: complaint-template
updated: '2025-08-13'
uri: doc://legal/smoking-gun/licensing-complaint-template
---
# 📋 WASHINGTON STATE DEPARTMENT OF HEALTH
## PROFESSIONAL LICENSING COMPLAINT TEMPLATE

**Target:** Danielle Smith, LMHCA (License #MC61294206)  
**Facility:** LARCH Counseling PLLC  
**Complaint Type:** Emergency License Suspension Request  
**Priority:** URGENT - PUBLIC SAFETY THREAT

---

## FORMAL COMPLAINT SUBMISSION

**TO:** Washington State Department of Health  
**Professional Licensing Division**  
**RE:** Emergency License Suspension Request - Professional Misconduct  

**FROM:** [Attorney Name]  
**On Behalf Of:** Veronika Goodnight  
**Case Reference:** Goodnight v. Ralidak (20-3-03830-3 SEA)  
**Date:** [Current Date]

---

## I. LICENSEE INFORMATION

**Name:** Danielle Smith  
**License Type:** Licensed Mental Health Counselor Associate (LMHCA)  
**License Number:** MC61294206  
**Practice Location:** LARCH Counseling PLLC  
**Supervision Status:** Associate (requires supervision)

---

## II. EMERGENCY SUSPENSION REQUEST

**I hereby request immediate emergency suspension of the above licensee's professional license based on clear and present danger to public safety.**

### **GROUNDS FOR EMERGENCY ACTION:**
1. **Systematic court order violations** documented in official therapy records
2. **False mandatory reporting** to child protective services
3. **Facilitating child psychological abuse** through professional therapeutic authority
4. **Professional conspiracy** to exclude legal parent from healthcare decisions
5. **Pattern of misconduct** affecting multiple families

### **PUBLIC SAFETY THREAT:**
- **Active harm to children** through professional misconduct
- **Multiple families affected** by systematic abuse pattern
- **Ongoing operations** continue to endanger additional victims
- **Professional authority misuse** to facilitate parental alienation

---

## III. DETAILED MISCONDUCT ALLEGATIONS

### **A. COURT ORDER VIOLATIONS**

#### **Specific Violation:**
**Date:** May 1, 2025  
**Session:** Individual therapy with minor child  
**Documented Violation:** Licensee allowed and documented child calling stepmother "mom throughout our session"

#### **Court Order Violated:**
**Source:** King County Superior Court Order  
**Provision:** "The parties are prohibited from encouraging or supporting the use of the terms 'father', 'daddy', 'mother', 'mommy' or any other derivative denoting parenthood to any other person besides Veronika and Mathew"

#### **Professional Standard Violated:**
- **WAC 246-809-220** - Professional conduct standards
- **RCW 18.225.090** - Mental health counselor scope of practice
- **Duty to comply** with legal requirements affecting patient care

#### **Evidence:**
- **Therapy session notes** from May 1, 2025
- **Court order** establishing prohibition
- **Pattern documentation** across multiple sessions

### **B. FALSE MANDATORY REPORTING**

#### **Specific Violation:**
**Pattern:** "Multiple reports made to DCYF were based entirely on hearsay from Mathew Ralidak"  
**Professional Failure:** "Ms. Smith did not contact me, nor verify statements, nor operate with any neutrality"  
**Documented Admission:** "She admitted to reopening the case through her email on April 6, 2025, based on secondhand information"

#### **Professional Standards Violated:**
- **RCW 26.44.030** - Mandatory reporting requirements (accuracy and good faith)
- **WAC 246-809-220** - Professional conduct (honesty and integrity)
- **Professional Ethics** - Duty to verify information before reporting

#### **Evidence:**
- **DCYF complaint correspondence** dated May 27, 2025
- **Email admissions** from licensee regarding reporting basis
- **Pattern of unfounded reports** as noted by DCYF investigators

### **C. PARENTAL ALIENATION FACILITATION**

#### **Specific Violation:**
**Date:** May 1, 2025  
**Activity:** Licensee facilitated child creating sand tray scenario where "mom was bad and died"  
**Participants:** Child, stepmother (being called "mom"), licensee  
**Professional Failure:** No intervention to protect child's relationship with legal mother

#### **Professional Standards Violated:**
- **WAC 246-809-220** - Duty to act in client's best interest
- **Professional Ethics** - Avoiding harm to therapeutic relationships
- **Child Welfare Standards** - Protecting parent-child relationships

#### **Evidence:**
- **Therapy session documentation** May 1, 2025
- **Timeline evidence** showing progressive alienation during treatment
- **Professional expert opinions** on therapeutic harm

### **D. INAPPROPRIATE THIRD-PARTY PARTICIPATION**

#### **Specific Violation:**
**Pattern:** Allowing stepmother participation in individual child therapy sessions  
**Legal Issue:** No verification of stepmother's legal authority for participation  
**Professional Failure:** Creating inappropriate loyalty conflicts for child

#### **Professional Standards Violated:**
- **Informed consent requirements** for third-party participation
- **Confidentiality protections** for minor clients
- **Professional boundaries** in therapeutic relationships

#### **Evidence:**
- **Session notes** documenting stepmother participation
- **Legal documentation** showing no authority for stepmother participation
- **Professional standards** for individual child therapy

### **E. SYSTEMATIC EXCLUSION OF LEGAL PARENT**

#### **Specific Violation:**
**Pattern:** Accepting false claims about parental authority from father  
**Professional Failure:** No attempt to contact or include legal mother in treatment  
**Result:** "Complete severance of contact with my daughter for over 47 days"

#### **Professional Standards Violated:**
- **Informed consent** requirements for mental health treatment of minors
- **Joint custody recognition** in healthcare decisions
- **Professional duty** to verify legal authority

#### **Evidence:**
- **Legal documentation** establishing joint decision-making authority
- **Communication records** showing mother's attempts at involvement
- **Professional misconduct** pattern across multiple sessions

---

## IV. INSTITUTIONAL PATTERN EVIDENCE

### **LARCH COUNSELING SYSTEMATIC MISCONDUCT**

#### **Multiple Staff Involvement:**
1. **Danielle Smith, LMHCA** - Individual child therapy violations
2. **Mario Gaspar de Alba, LMFTA** - Accepting false authority claims
3. **Victoria Morgan** - Pattern evidence from other families (Emery Lauten case)

#### **Pattern Recognition:**
- **Multiple families affected** by identical misconduct tactics
- **Institutional support** for excluding protective mothers
- **Coordinated professional conspiracy** across facility staff
- **Systematic violations** of professional standards

#### **Evidence:**
- **Kit Spins correspondence** documenting pattern across families
- **Facility-wide policies** enabling misconduct
- **Multiple professional licenses** requiring investigation

---

## V. HARM TO PUBLIC

### **IMMEDIATE HARM DOCUMENTED:**
1. **Child psychological damage** through facilitated parental alienation
2. **Constitutional rights violations** of legal parents
3. **Professional authority misuse** to facilitate family destruction
4. **Multiple families affected** by systematic misconduct pattern

### **ONGOING THREAT:**
- **Active practice** continues to endanger families
- **Professional license** provides authority for continued abuse
- **Institutional support** enables ongoing misconduct
- **Public trust violation** in mental health system

---

## VI. REQUESTED ACTIONS

### **IMMEDIATE EMERGENCY SUSPENSION:**
1. **Suspend License MC61294206** pending full investigation
2. **Prohibit all therapeutic practice** until resolution
3. **Notify current clients** of suspension and misconduct investigation
4. **Coordinate with other agencies** (DCYF, law enforcement, courts)

### **FULL INVESTIGATION:**
1. **Professional misconduct hearing** with evidence presentation
2. **Institutional investigation** of LARCH Counseling practices
3. **Other license reviews** for facility staff involvement
4. **Public safety measures** to protect additional families

### **DISCIPLINARY ACTIONS:**
1. **License revocation** for systematic professional misconduct
2. **Professional sanctions** preventing future practice
3. **Restitution requirements** for client harm and remedial treatment
4. **Public notification** of professional misconduct findings

---

## VII. SUPPORTING DOCUMENTATION

### **ATTACHED EVIDENCE:**
1. **Therapy session notes** documenting violations (May 1, 2025)
2. **Court orders** establishing violated provisions
3. **DCYF complaint correspondence** with government investigation
4. **Pattern evidence** from multiple affected families
5. **Professional expert opinions** on standard violations
6. **Legal case documentation** showing systematic harm

### **WITNESS AVAILABILITY:**
- **Affected parent** (Veronika Goodnight) - available for testimony
- **Professional experts** - available for standard violation testimony
- **Other affected families** - available for pattern evidence
- **Government investigators** - DCYF personnel familiar with case

---

## VIII. LEGAL REPRESENTATIVE INFORMATION

**Attorney:** [Attorney Name]  
**Firm:** [Law Firm]  
**Address:** [Address]  
**Phone:** [Phone Number]  
**Email:** [Email]  
**Bar Number:** [Washington State Bar Number]

**Authorization:** I am authorized to file this complaint on behalf of the affected party and request emergency action to protect public safety.

---

## IX. VERIFICATION

**I hereby certify under penalty of perjury that the foregoing allegations are true and correct to the best of my knowledge and belief, and that this complaint is filed in good faith for the protection of public safety.**

**Signature:** ________________________  
**Date:** ________________________  
**Attorney for Complainant**

---

## X. EMERGENCY CONTACT INFORMATION

**For immediate emergency actions or questions regarding this complaint:**

**Attorney:** [Phone Number] (available 24/7 for emergency coordination)  
**Complainant:** [Phone Number] (available for immediate testimony)  
**Case Reference:** Goodnight v. Ralidak - URGENT PUBLIC SAFETY THREAT

---

**ATTACHMENT A:** Complete Evidence Package (Therapy Notes, Court Orders, DCYF Correspondence)  
**ATTACHMENT B:** Professional Expert Opinions on Standard Violations  
**ATTACHMENT C:** Pattern Evidence from Multiple Affected Families  
**ATTACHMENT D:** Legal Case Documentation Showing Systematic Harm

**TOTAL PAGES:** [Number of pages in complete submission]

---

**URGENT REQUEST FOR IMMEDIATE ACTION TO PROTECT PUBLIC SAFETY**

**This complaint documents clear and present danger to public welfare through systematic professional misconduct by a licensed mental health provider. Emergency suspension is essential to prevent ongoing harm to children and families.**