---
# STRATEGIC DOCUMENT ENHANCEMENT (flooding-wind-0827)
# Updated: 2025-08-27 with cross-references and strategic context
# MASSIVE EVIDENCE: 181 pages of professional misconduct documentation
# GOVERNMENT VALIDATION: DCYF officially documents "Screen Out" - no findings against mother

title: "DCYF Official Referral to Department of Health - Complete Records"
document_type: "government_professional_misconduct_referral"
strategic_priority: "CRITICAL_SMOKING_GUN"
strategic_rating: 5_out_of_5_stars
page_count: 181
evidence_magnitude: "MASSIVE_GOVERNMENT_VALIDATION"

# Hearing Applications & Strategic Impact
hearing_applications:
  - september_29_contempt: "PRIMARY - Professional misconduct pattern evidence"
  - august_28_emergency: "SUPPORTING - Government validation of concerns"
strategic_significance: "GOVERNMENT_VALIDATES_NO_FINDINGS_AGAINST_MOTHER"
litigation_impact: "DESTROYS_MATT_CPS_MANIPULATION_CLAIMS"

# Document Processing Info
source_file: /home/scottsen/Legal/03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/03_SOURCE_EVIDENCE/EMAIL_EVIDENCE/Legal_Last_30_Days_All_20250826_175258/email_AAMkADhiM2JkZTU0LTVhMDUtNGY0My1iMGJjLTU1YzNhZDI5ZWNmYQBGAAAAAABkxeBJv5LEQ6V7SxBG2amRBwC2X-2LClioSZ3A5qHVuwsgAAAAAAEJAAC2X-2LClioSZ3A5qHVuwsgAAmjT78nAAA=/ATTACHMENT_6_DCYF_Official_Referral_to_DoH.pdf
extraction_method: pdftotext
extraction_date: 2025-08-26T18:01:27.799287
page_count: 181
quality_score: 0.993
file_hash: f3b3c7cf258f6b4a2b6ed35487c620025b83b170a970fd740077f908690fecf0
cache_key: 4de848bf8bb31e4f

# Strategic Context
case_numbers: ["20-3-03830-3-SEA", "25-2-11308-6-SEA"]
government_agency: "DCYF (Department of Children, Youth & Families)"
official_decision: "SCREEN_OUT_NO_FINDINGS_AGAINST_MOTHER"
evidence_quality: "OFFICIAL_GOVERNMENT_DOCUMENTATION"
referral_pattern: "MULTIPLE_FALSE_ALLEGATIONS_SYSTEMATICALLY_DISMISSED"

# Critical Government Findings (Page Evidence)
dcyf_decisions:
  - case_id_2682764: "Screen Out - No specific CA/N allegation or Risk"
  - allegations_status: "Negligent Treatment allegations DISMISSED"
  - government_position: "NO FINDINGS against mother Veronika"
  - pattern_analysis: "Multiple referrals, all closed no adverse findings"

# Cross-References & Relationships  
related_documents:
  constitutional_support:
    - "42_USC_1985_Civil_Rights_Conspiracy_Analysis" # Federal framework
    - "Constitutional_Separation_Analysis" # 20.4x violation
  professional_misconduct:
    - "DOH_Complaints_Multiple" # Department of Health cases
    - "Therapy_Notes_Coordination_Evidence" # Pattern documentation
    - "Professional_License_Verification" # Credential validation
  strategic_integration:
    - "THERAPEUTIC_WEAPONIZATION_EVIDENCE_INDEX.md" # Primary index
    - "LITIGATION_ABUSE_EVIDENCE_INDEX.md" # Pattern documentation
    - "CPS_INVOLVEMENT_ANALYSIS_COMPREHENSIVE.md" # No investigations analysis
  government_validation:
    - "Police_Report_April_4_2025" # Law enforcement support
    - "Dr_Oreskovich_Evaluation" # Professional contradicts false allegations

# Key Strategic Elements
false_allegation_pattern:
  - "Multiple CPS referrals during separation"
  - "ALL referrals closed with no findings"
  - "Government validates mother's fitness"
  - "Pattern of false reporting documented"
government_position:
  - "DCYF finds no credible allegations"
  - "Professional concerns lack substance"
  - "Mother cleared by government investigation"
  - "Pattern suggests coordinated false reporting"

hearing_strategy:
  august_28: "Government validation supports protected party status"
  september_29: "False allegation pattern supports litigation abuse claims"
  
constitutional_significance: "Government validation contradicts conspiracy claims"
pattern_evidence: "181 pages systematically document false allegation manufacturing"

legal_tags: ["dcyf-screen-out", "no-findings-mother", "government-validation", "false-allegations-dismissed", "cps-manipulation-exposed", "181-pages", "smoking-gun-evidence", "goodnight-case", "email-evidence"]
---

DEPARTMENT OF CHILDREN, YOUTH, AND FAMILIES
                                           PRIOR INVOLVEMENT

INTAKE INFORMATION
Intake Name (ID):    Ralidak, Mathew (5688548)
Program:     CPS                                                                 No
                                                                 Provider Related:
Date Received:04/24/2025 2:47 PM                                 Decision: Screen Out
                            04/24/2025
Date of Alleged Maltreatment:                                    Reason:   No specific CA/N allegation or Risk
Worker: DELACUESTA, PAUL L.                                      Response Time:    N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                       SUBJECT                      CA/N                        FINDING
Goodnight-Ralidak, Aidan     Goodnight, Veronika E.       Negligent Treatment or
W. (103285922)               (103285911)                  Maltreatment
Goodnight-Ralidak, Elora     Goodnight, Veronika E.       Negligent Treatment or
L. (103285921)               (103285911)                  Maltreatment
Goodnight-Ralidak, Raina     Goodnight, Veronika E.       Negligent Treatment or
S. (103285923)               (103285911)                  Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
ICW-no
DV-history of DV parents is separated
COVID19-no

Household
Father: Mathew Ralidak - father has a court date on Monday to get emergency full custody of his children
Stepmother: Monica Galarneau
Child: Elora (10)
Child: Aiden (8)
Child: Reyan (6)

Non household
Mother: Veronika Goodnight - there is a no-contact order in place that protects the children from their mother.

The referent (REF) is                          RCW 13.50.100(7)(c)

                       RCW 13.50.100(7)(c)                           . Elora disclosed that 3 weeks ago her
mother slapped her sister Reyan (6) across her face. Elora does not remember if marks were left.

Elora states that the mother also will threaten the children by hitting them and punching them.

The REF was told that the younger child Adien (8) asked his father if it's normal to be afraid that his mother
would stab them with a knife. The father followed up with Elora and Elora told the father that on one occasion
her mother grabbed a knife, and she was squeezing the knife so hard that she was" white knuckling" the knife.

Elora went on to say that she and her siblings had a safety plan in place in case the mother stabbed one of the
children. Unknown when this incident happened. There is a no contact order in place that protects the children
from the mother.

INTAKE INFORMATION
Intake Name (ID):    Ralidak, Mathew (5670778)



SM02 Prior Involvement                                                                               Page 1 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000001
Program:      CPS                                                                  No
                                                                   Provider Related:
Date Received:   04/14/2025 5:02 PM                                Decision: Screen Out
Date of Alleged Maltreatment:  04/14/2025                          Reason:   No specific CA/N allegation or Risk
Worker: Willen, Jennifer L.                                        Response Time:    N/A
Case ID:      2682764
ALLEGATIONS:
VICTIM                        SUBJECT                       CA/N                         FINDING
Goodnight-Ralidak, Aidan      Goodnight, Veronika E.        Negligent Treatment or
W. (103285922)                (103285911)                   Maltreatment
Goodnight-Ralidak, Aidan      Goodnight, Veronika E.        Physical Abuse
W. (103285922)                (103285911)
Describe the nature and extent of the alleged maltreatment or concern:
Referrer is                                   RCW 13.50.100(7)(c)

Family Composition:
Father - Mathew Ralidak, age 38 years.
Child - Elora Goodnight-Ralidak, age 10 years.
Child - Aidan Goodnight-Ralidak, age 8 years.
Child - Raina Goodnight-Ralidak, age 6 years.

Non-Household Member:
Mother - Veronika Goodnight, age 43 years.
Mother's Partner/Fiance - Colin Derieg, age 54 years.

Per Referrer,

Today, on 04/14/2025, Aidan (8) made a disclosure to Ref. Aidan and Ref were talking about conflicted feelings
of missing mom and not being able to see mom for a few weeks. There is a current restraining order preventing
Mother, Veronika Goodnight (43), and Mother's Fiance, Colin Derieg (54), from having any contact or being
within 1000 feet of Father, Mathew Ralidak (38), and the three children, Elora (10), Aidan (8), and Raina (6).
The protection order is in place at this time and will be revisited in court on 04/25/2025. Father currently has all
three children in his care until then.

Aidan mention missing snuggles with Mother, but then mentioned not missing mom's anger. Aidan said when
she is angry, which he reported happens often, she will get physical. Aidan said this includes occasional
pushing, slaps to the face and intimidation (getting in his personal space). Aidan said he has only been slapped
once in the past (it was a while ago) this was because he was "being annoying". Aidan said that Mom slapped
him and then she walked away when he was crying.

Aidan said Mom will curse at him and his sisters. Mother will make a middle finger gesture to him and his
sisters, and she will say "fuck you". Aidan said then later Mother will say "I was just saying it and not to you."
Aidan said Mom will say "don't be a fucking bitch" when there is a lot of crying or upset feelings when she is
angry. Aidan said sometimes she is very snuggly, but when she is angry this is her response.

Aidan did not mention any bruises, injuries or marks when there has been pushing or he has been slapped by
mom. Aidan told Ref, "don't tell mom any of this, this has happened and it makes me sad." Ref reports no
further details or information at this time.

Screening Questions:
Are you aware of any Native American ancestry or tribal affiliation within the family? Ref is unsure.
Are you aware of any DV between any adults in the home? Ref stated nothing physical that they are aware of,
but that Aidan said Mom and Colin "fight so much" and that there is "a lot of yelling".
Are you aware that anyone in the family has been exposed to or has the COVID-19 Virus (Coronavirus)? Ref is


SM02 Prior Involvement                                                                                   Page 2 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000002
unsure.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5674676)
Program:     CPS                                                                     No
                                                                     Provider Related:
Date Received:    04/12/2025 4:53 PM                                 Decision: Screen Out
Date of Alleged Maltreatment:   04/12/2025                           Reason:   No specific CA/N allegation or Risk
Worker: MEKONNEN, MOGES                                              Response Time:    N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                        SUBJECT                         CA/N                        FINDING
Goodnight-Ralidak, Aidan      Ralidak, Mathew W.              Negligent Treatment or
W. (103285922)                (104669770)                     Maltreatment
Goodnight-Ralidak, Elora      Ralidak, Mathew W.              Negligent Treatment or
L. (103285921)                (104669770)                     Maltreatment
Goodnight-Ralidak, Raina      Ralidak, Mathew W.              Negligent Treatment or
S. (103285923)                (104669770)                     Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Household:
Mother Veronika Goodnight
Dr. Colin Derieg / paramour of Veronika
Cassidy Derieg / adult child of Colin
Taylor Derieg / adult child of Colin & currently at college
Child Elora Goodnight-Ralidak (10)
Child Aiden Goodnight-Ralidak (8)
Child Raina Goodnight-Ralidak (6)

Nonhousehold:
Father Mathew "Mat" Ralidak
Step mother Monica Galarneau

Referrer is the mother and her fiance was with her during the report.

There is a shared parenting plan in place. Referrer reported that the children are supposed to be with her today,
but the father, Mat, refused to bring them. Referrer stated that he filed a Restraining Order (RO) against her
and her fiance, Colin Derieg, for an unknown reason.

Referrer said that the father missed a mental health therapy appointment once. He also reportedly denied
referrer's chance to be with her daughter during a medical visit.

Referrer indicated that last Friday, there was a school assembly and the father created a scene saying that
Colin had a gun on him which per the referrer and her fiance is completely false only made up by the father.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5671397)
Program:     CPS                                                                     No
                                                                     Provider Related:
Date Received:  04/09/2025 4:25 PM                                   Decision: Screen Out
Date of Alleged Maltreatment: 04/09/2025                             Reason:   No specific CA/N allegation or Risk
Worker: Carr, Donna C.                                               Response Time:    N/A
Case ID:    2682764


SM02 Prior Involvement                                                                                   Page 3 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000003
ALLEGATIONS:
VICTIM                        SUBJECT                         CA/N                     FINDING
Goodnight-Ralidak, Aidan      Ralidak, Mathew W.              Negligent Treatment or
W. (103285922)                (104669770)                     Maltreatment
Goodnight-Ralidak, Elora      Ralidak, Mathew W.              Negligent Treatment or
L. (103285921)                (104669770)                     Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Caller is Mother Veronika Goodnight / phone 805-895-0509.

Household:
Mother Veronika Goodnight
Dr. Colin Derieg / paramour of Veronika
Cassidy Derieg / adult child of Colin
Taylor Derieg / adult child of Colin & currently at college
Child Elora Goodnight-Ralidak (10)
Child Aiden Goodnight-Ralidak (8)
Child Raina Goodnight-Ralidak (6)

Nonhousehold:
Father Mathew "Mat" Ralidak
Step mother Monica Galarneau

Referrer indicated the family speaks English.
Referrer denied known Native American Ancestry or family known to live on tribal lands.
Referrer noted concern for pas domestic violence (DV) between the mother Veronika Goodnight and father
Mathew Ralidak with Mat as the perpetrator of power and control.
Referrer denied knowledge of recent COVID exposure for participants.
Parent Child Relationship has been entered into the children's person cards in FamLink. [WHALES verified for
child Raina.]

Concern:
The Referrer is concerned for emotional abuse of 10-year-old Elora Goodnight-Ralidak, 8 yo Aiden Goodnight-
Ralidak , and 6 yo Raina Goodnight-Ralidak by their father Mathew "Mat" Ralidak. The Referrer advised the
father has manipulated and directly affected the children's well being through the court system, medical
appointments, and use of CPS intake reports. The father's ongoing efforts have led the Referrer to have
significant concern for parental alienation of the children's mother Veronika Goodnight and the father's
persistent actions having a negative impact on the children's wellbeing.

The Referrer articulated the mother was a victim of power and control by the father during their relationship
which included the father raping the mother in the past. The parents of Elora, Aiden, and Raina have separated
with a Parenting Plan in place through King County courts [Cause # 20-3-03830-3 SEA ]. The Referrer advised
the father does not adhere to the Parenting Plan by not notifying the mother of the children's yearly doctor
appointment and the father has notified the mother of appointments outside of their yearly physicals. The
Referrer recognizes that is a court or civil issues. The Referrer is concerned that the father has made significant
false allegations to medical providers in the past. During the children's past yearly checkup visit with a family
nurse practitioner L. Miller at EvergreenHealth, the father told the provider the mother Veronika was deceased.
The mother Veronika had to prove she had joint custody and was not dead and active in the children's lives.
This week, the father scheduled an appointment for the child Elora without notifying the mother. The mother
arrived at the medical appointment to discover on the medical paperwork the father said the mother was a drug
addict, with alcoholism and mental health issues. Elora is a 10-year-old child who has become aware of things
the father has said and written about the mother. Last week, Elora asked the mother what "mental illness"
meant because the father keeps saying the mother has mental illness.

The Referrer is concerned the father ignores medical recommendations by the children's established provider
Dr. Stacy Bowker. Dr. Bowker recommended Elora not be given food with high fructose. The Referrer advised


SM02 Prior Involvement                                                                                Page 4 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000004
the father continues to feed Elora foods outside of this recommendation. The Referrer advised that Elora has
ongoing stomach issues while at the father's home due to this concern. [CISW located FamLink CPS Screen
Out Intake 5574590 from 12/19/24, which documented the father advised the mother claims children have food
allergies which the father said the pediatrician denies.]

In 2024, the Referrer advised that Elora was molested by a peer. The mother made an appointment at
Dawson's Place for Elora to receive counseling. The father Mathew indicated that child on child sexual touching
was kids fooling around and Elora did not need counseling and cancelled the appointment. The mother had to
remain the appointment which resulted in Elora having to wait another month for treatment and counseling.
Elora is still in counseling related to past child on child sexual activity. The Referrer indicated this was
previously reported and provided no details as to concern. [CISW located FamLink CPS Third Party LE Screen
Out Intake 5494945 from 9/29/24 with concern 9 yrs old child Elora disclosed that a peer got on top of her
during a girl scouts camp. CPS Screen Out Intake 5437643 from 8/4/24, and CPS FAR Intake 5435044 from
07/30/24, with concerns that Elora's peer was trying to kiss Elora. Intake 5435044 documents 9-year-old Elora
continues to disclose that she is being molested by a friend named "River" who is believed to be of the same
age.]

A year and half ago, Aidan was diagnosed with strep throat. The father denied observing any symptoms and
refused to provide Aidan his antibiotics prescribed which delayed Aidan's healing process.

The Referrer indicated the children have withdrawn and present as anxious after visits with their father. The
father has fabricated stories to the courts, medical providers, and the school. about the mother and the mother's
paramour. On Friday [4/4/205], he indicated concern to the school that the way the mother's paramour was
walking and standing at the school appeared he had a gun. The mother is engaged to a Chiropractor Dr. Colin
Derieg. The mother and the fiance Colin went to the school due to children having events. The father was in the
pickup line and took issue when Colin approached the father's vehicle and stood near while the mother was
talking to the father. The Referrer denied Colin had a gun using this as an example of ongoing defamation and
fabrication by the father to coerce and control the mother. [CISW located CPS Screen Out Intake ID: 5664768
from 4/5/2025, which documented concern for an incident at the school in which the father stated he felt
intimidated by Derieg standing outside his car staring at him. Intake reflects all three children were not present
during this incident. Intake documents Carnation Police Department C 25010391 reviewed footage from
incident which "showed Goodnight approaching Ralidak's car. Then it looked like Goodnight had started yelling
at Ralidak. It then showed Derieg standing a few feet away from the vehicle, staring inside. It did not appear
that Derieg or Goodnight made any threatening gestures. Ralidak remained in his car during the entire
incident."]

The Referrer is concerned for a pattern of false reports being made to CPS as to allegations against the
mother. The Referrer noted last week the mother posted a picture on Facebook of an RV she had purchased.
The mother did not move from her current residence or change living situation for the children. The children
reside one week with the mother and one week with the father per the parenting plan. The mother received
concerns from CPS that the mother had moved to the RV and the home was unsafe.

The Referrer has spoken to the former CPS FAR Social Worker Gracey Pearson, Social Worker Supervisor
Jazie Smith, Constituent Relations Pamela Williams and Carnation Police Department as to concerns for the
abuse of the child abuse hotline by the father. The Referrer plans to follow up with the courts to additionally
address concerns.

[At 430 PM, CISW emailed Referrer at kit@kitspins.com the below DV Resources:
Washington State Domestic Violence Hotline - 1-800-562-6025
Washington State Coalition Against Domestic Violence (WSCADV) wscadv.org]

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5664768)
Program:     CPS                                               Provider Related:   No
Date Received:    04/05/2025 11:50 PM                          Decision:   Screen Out
Date of Alleged Maltreatment:    04/04/2025                    Reason:     Allegation documented in previous



SM02 Prior Involvement                                                                                Page 5 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000005
Worker: STRONG, JANICE B.                                        Response Time:    N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                       SUBJECT                      CA/N                       FINDING
Goodnight-Ralidak, Raina     Goodnight, Veronika E.       Physical Abuse
S. (103285923)               (103285911)
Describe the nature and extent of the alleged maltreatment or concern:
Open Case. King East Office

Chronicity indicator

Allegations that six-year-old was injured by her mother were previously reported in screened in intake 5666738
dated 04/04/2025

Household 1:
Mother is Veronika Goodnight
Her boyfriend/partner is Colin Derieg
Ms Goodnight's children:
Elora Goodnight-Ralidak (10)
Aiden Goodnight-Ralidak (8)
Raina Goodnight-Ralidak (6)

Household 2:
Father of the children is Mathew W. Ralidak
His wife is Monica Galarneau

FXED REPORT FROM KING COUNTY SHERIFF/CARNATION POLICE DEPARTMENT
CASE:C25010391
RESPONDING OFFICER/DEPUTY: J KELLOGG

CUT AND PASTED NARRATIVE FROM REPORT C25010391

On April 4, 2025, I was dispatched at 1445 hours for a reported DV threats call at Carnation Elementary School,
4950 Tolt Ave.
RP-1 Matthew Ralidak and S-1 Veronika Goodnight are divorced. Ralidak and Goodnight have three children in
common, V-1 Raina Goodnight-Ralidak (6 yrs old), O-2 Elora Goodnight-Ralidak (8 yrs old), O-3 Aidan
Goodnight-Ralidak (10 yrs old).

O-4 Colin Derieg and Goodnight are currently dating.
O-6 Monica Galarneau and Ralidak are currently married.
O-5 Michelle Frank is the current principal for Carnation Elementary.

Ralidak informed me of the following:
He currently has a tense relationship with Goodnight. They currently share their children 50/50 according to
their parenting plan. Ralidak informed me that there is an open CPS case involving Goodnight, a man she is
living with, and RGR. Ralidak stated that according to RGR, Goodnight was making her kiss this man. Ralidak
did not have any other information about this CPS case.

While waiting, in his car, in line to pick up his children from school. At approximately 1358 hours Goodnight
approached Ralidak's car and started yelling at him. Goodnight was accusing Ralidak of calling CPS on her.
Goodnight continued yelling and asking Ralidak questions about the children and Goodnight's new living
arrangements. At some point Ralidak noticed Derieg standing beside his car staring at him. Goodnight then
went into the school office and back out toward Ralidak's car. During this time Ralidak had called into the
school's office and told the principal, Frank, and another administrator about the odd behavior and scene
Goodnight was making.


SM02 Prior Involvement                                                                              Page 6 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000006
Frank then came outside to speak with Goodnight. At approximately 1412 hours Goodnight and Derieg got into
a maroon Chevy Silverado and left the school parking lot. Ralidak clarified that no threats were ever made by
Goodnight or Derieg. Ralidak stated he felt intimidated by Derieg standing outside his car staring at him. While
sharing the details of this incident Ralidak seemed visibly shaken and needed to take breaks, while talking with
me, to hold back tears. All three children were not present during this incident.

As I was leaving Ralidak showed me a text from Galarneau, who currently had all three children. Galarneau
said that all three children had told her that Goodnight had slapped RGR and slammed her against a wall.
Ralidak thought this might be retaliation because RGR had planned to tell Goodnight she no longer wanted to
live with her. Ralidak did not mention any marks or bruises on RGR when he had seen her at the school pickup.
The text from Galarneau did not describe any injuries on RGR. Ralidak and Galarneau have all three children
over the weekend. Ralidak said he is worried for his children's safety and wasn't sure what to do. I gave Ralidak
the case number and informed him that he should get in touch with a lawyer and ask about getting a protection
order if he is feeling this way.

Frank had informed me of the following:
The office had received a call from Ralidak, so Frank and another administrator had gone outside to see what
was going on. Frank spoke with Goodnight and told her "This isn't the place", in reference to not handling
parenting issues on school grounds. Frank stated this is not the first time that Goodnight has caused a
commotion or interrupted the children's learning process.
Frank then informed me that RGR had told her 1 grade teacher that her mother, Goodnight, had slapped her so
hard she was thrown into the wall. Frank stated the teacher was in the process of reporting this incident to CPS.

I reviewed footage taken by Ralidak and the school security footage. The footage showed Goodnight
approaching Ralidak's car. Then it looked like Goodnight had started yelling at Ralidak. It then showed Derieg
standing a few feet away from the vehicle, staring inside. It did not appear that Derieg or Goodnight made any
threatening gestures. Ralidak remained in his car during the entire incident. There was no audio to the footage.

I sent Ralidak an evidence.com link to upload the footage he has and a screenshot of texts about the slapping
incident. Ralidak is also in the process of obtaining the school's security camera footage.

Body worn camera was activated and footage uploaded to evidence.com.
I determined there was no crime that occurred between Ralidak and Goodnight.

CPS has been forwarded the case.

END OF CUT AND PASTED NARRATIVE FROM REPORT C25010391

Report will be emailed to the local office

DV: Not reported. Conflicts between parents
ICW: None identified in this report or prior reports
COVID: None identified in this report

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5666738)
Program:     CPS                                                                No
                                                                Provider Related:
Date Received:04/04/2025 7:02 PM                                Decision: Screen In
                            04/03/2025
Date of Alleged Maltreatment:                                   Reason:   CPS-FAR
Worker: TRIBBLE, SARAH M.                                       Response Time:    72 Hours
Case ID:    2682764
ALLEGATIONS:
VICTIM                        SUBJECT                    CA/N                        FINDING



SM02 Prior Involvement                                                                               Page 7 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000007
Goodnight-Ralidak, Raina       Goodnight, Veronika E.     Negligent Treatment or
S. (103285923)                 (103285911)                Maltreatment
Goodnight-Ralidak, Raina       Goodnight, Veronika E.     Physical Abuse
S. (103285923)                 (103285911)
Describe the nature and extent of the alleged maltreatment or concern:
*Current Open Case #2682764, Assigned to Gracey Pearson, of the King East Office*

Referrer is              RCW 13.50.100(7)(c)

Household Composition:
Viktoria Goodnight- 43 - Mother
Elora Goodnight-Ralidak - 10 - Other Child
Aiden Goodnight-Ralidak - 8 - Other Child
Raina Goodnight-Ralidak - 6 - Child Victim

Non-Household Composition:
Mathew Ralidak - 38 - Father

Concern:
Referrer reports the parents have split custody and the kids had been with Mom all week, but they are now with
Dad. When Raina came to school today, she was falling asleep in class and complained of a headache and
said Mom slapped her pocket and her cheek and when she slapped her she pushed her into the hall. Ref asked
Raina what she hit her head on and she said the floor. Raina said her Mom checked her head and said there
was no bump and she needed to go to sleep.

Raina said she couldn't go to sleep and this morning, Mom said they didn't have time for breakfast, so she
came without eating. Ref stated she has come without breakfast previously when she is with Mom.

She complained of a headache all day and saw the School Nurse who noted no signs of concussion. Ref did
not observe any marks or bruising.

ICW: Ref stated No
Domestic violence: Ref stated No
Substance abuse: Ref stated No
Mental health: Ref stated No

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5629627)
Program:      CPS                                                                No
                                                                 Provider Related:
Date Received:    02/28/2025 12:00 PM                            Decision: Screen Out
Date of Alleged Maltreatment:    02/28/2025                      Reason:   No specific CA/N allegation or Risk
Worker: BRUNO-ROOT, ANNETTE L.                                   Response Time:    N/A
Case ID:      2682764
ALLEGATIONS:
VICTIM                         SUBJECT                    CA/N                        FINDING
Goodnight-Ralidak, Raina       Goodnight, Veronika E.     Negligent Treatment or
S. (103285923)                 (103285911)                Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Open Case 2682764
Assigne3d Worker: Gracey Pearson

Referrer is               RCW 13.50.100(7)(c)


SM02 Prior Involvement                                                                               Page 8 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000008
Household Members:
Mother: Veronika Goodnight, 43
Mother's Partner: Colin Dearig, 54
Child: Elora Goodnight-Ralidak,9
Child: Aidan Goodnight-Ralidak,, 8
Child: Raina Goodnight-Ralidak, 6

Non-Household members:
Father: Matthew Ralidak, 38

Allegations/Concerns:

Referrer reports they are calling in an informational report. Referrer explains they were contacted by CPS and
asked a series of questions. At the time, the referrer did not have any information. As referrer has proceeded
   RCW 13.50.100(7)(c)         she has obtained information she would like to report. Referrer references intake
5619864 and 5621715 as examples of this practice.

Referrer reported that Raina shared her mother's partner, (Colin) spanks her regularly. Child did not report any
injuries or bruises as a result. Raina "begged" referrer not to tell her mother what she said, because she will
""get in a lot of trouble." Raina also told the referrer she doesn't ever want to leave her dad's house to return to
her mother's.

COVID: referrer had no information regarding exposure or diagnosis of covid-19 In the home.
CSEC: Referrer had no reason to suspect child is a victim of commercial sexual exploitation.
ICW: Referrer had no information suggesting child had Native American Ancestry. The child does not reside on
reservation or tribal lands.
DV: Referrer had no information regarding domestic violence in the home.
LANGUAGE: Child's primary language is English. An Interpreter is not needed.
FamLink: The parent child relationship information has been entered into the child's person card.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5622330)
Program:     CPS                                                  Provider Related: No
Date Received: 02/21/2025 9:13 AM                                 Decision: Screen Out
Date of Alleged Maltreatment:02/14/2025                           Reason:   Allegation documented in previous
Worker: Ramirez, Whitney J.                                       Response Time:     N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                        SUBJECT                      CA/N                         FINDING
Goodnight-Ralidak, Raina      Goodnight, Veronika E.       Negligent Treatment or
S. (103285923)                (103285911)                  Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
** OPEN FAR CASE **

The referent (REF) is                                RCW 13.50.100(7)(c)                                    .

Household Members:
Mother, Veronika Goodnight
Child, Raina Goodnight-Ralidak (6)
Child, Aidan Goodnight-Ralidak (8)
Child, Elora Goodnight-Ralidak (9)




SM02 Prior Involvement                                                                                  Page 9 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000009
Non-Household:
Father, Mathew Ralidak
Mother's Partner, Colin Derieg

The LE report is copied and pasted below:

On 02/14/2025 at approximately 1027 hours, I responded to an abuse call located at 10323 Friar Creek Rd in
                                                     RCW 13.50.10
Monroe WA. The RP, Mathew W. Ralidak (DOB:          /1986) told call takers the previous day, his six-year-old
daughter Raina S. Goodnight-Ralidak (DOB: 06/03/2018) had disclosed RCW 13.50.100(7)(c) that a few weeks prior,
her mother's partner had hit her.

I called Mathew and asked him to tell me what happened. He explained he was separated from his ex,
Veronika
E. goodnight (DOB: 02/15/1982) and that they have three children in common. Mathew said he and Veronika
have a parenting plan and they each have all three kids for a week at a time. He did not know the exact nature
of
                                                                                            RCW 13.50.10
Veronika's current relationship, but he referred to her partner, Colin M. Derieg (DOB:     /1971). The location
given was Colin's home.

Mathew said the previous day,RCW 13.50.100(7)(c) had told him RCW 13.50.100(7)(c) that R.G. disclosed
approximately a few weeks prior, Colin had hit her. RCW 13.50.100(7)(c) utilized puppets to pantomime what R.G.
disclosed to her. Mathew described it to me as Colin told R.G. to shut up and turn around. He then hit R.G. in
the
bottom and the back approximately five times. Mathew described the hit as similar to a spanking. R.G. said that
it
had hurt more when Colin did it because he's stronger. Mathew did not recall having seen any marks or injuries
on R.G. at any point after the kids had stayed with their mother. R.G. did not elaborate on how long the pain
she
experienced had lasted for.

I asked Mathew if R.G. had said or indicated if the incident had occurred randomly or if it was more of a
disciplinary action if R.G. had been misbehaving. He said he did not know. Mathew told me he and Veronika
had
agreed that physical discipline would not be utilized in how they parent the children, but their parenting plan did
not have any language in it regarding discipline.

Mathew said this was the first instance of anything physical occurring that he knew of. He did mention that CPS
cases have been opened in the past against Veronika. He said the kids had told him in the past that Veronika
would be verbally abuse towards them including flipping them off. Mathew said R.G. had told Veronika about
the
incident with Colin. Her response had been apparently to call R.G. a liar and say it never happened.

Mathew mentioned that 02/14 was the exchange day. I asked him if he planned on sending the kids to
Veronika.
He said he was undecided as he did not want her to call about him violating the parenting plan which was
issued
out of a King County Court. He did mention RCW 13.50.100(7)(c) had stated her intent to call Veronika. I asked if either
himself or RCW 13.50.100(7)(c) had contacted CPS. He said no.

Mathew told me the location given was Colin's house and that currently, Veronika lived in Carnation WA. Based
on the information provided by Mathew and his statements of past CPS investigations against Veronika, this
report was forwarded to CPS for review and an intake generated. I am requesting the report be reviewed by
SIU
as well. ///EOR///

ICW - Not mentioned in the LE report.
DV - Not mentioned in the LE report.



SM02 Prior Involvement                                                                                     Page 10 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000010
COVID 19 - Concerns not mentioned in the LE report.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5623944)
Program:     CPS                                                       Provider Related: No
Date Received:    02/18/2025 8:06 AM                                   Decision: Screen Out
Date of Alleged Maltreatment:   02/01/2025                             Reason:   Allegation documented in previous
Worker: DOOTSON, NANCY                                                 Response Time:     N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                       SUBJECT                            CA/N                       FINDING
Goodnight-Ralidak, Raina     Derieg, Colin .                    Physical Abuse
S. (103285923)               (105022503)
Describe the nature and extent of the alleged maltreatment or concern:
ICW-none
DV-none listed in report

HOUSEHOLD COMPOSITION
Mother: Veronika Goodnight
Child: Raina Goodnight-Ralidak (6)
Child: Aidan Goodnight-Ralidak (8)
Child: Elora Goodnight-Ralidak (9)

Non Household:
Father- Mathew Ralidak
---
Open FAR case (2682764), assigned to SW Gracey Pearson.

Snohomish County Sheriff's Office Case Report #2025-20697, received at CPS intake on 2/17/25.
Occurred Date/Time- 02/01/25
Date/Time reported (to police)- 2/14/25

Summary of Report is below:

On 02/14/2025 at approximately 1027 hours, I responded to an abuse call located at 10323 Friar Creek Rd in
                                                 RCW 13.50.10
Monroe WA. The RP, Mathew W. Ralidak (DOB:          /1986) told call takers the previous day, his six-year-old
daughter Raina S. Goodnight-Ralidak (DOB: 06/03/2018) had disclosed RCW 13.50.100(7)(c) that a few weeks prior,
her mother's partner had hit her.

I called Mathew and asked him to tell me what happened. He explained he was separated from his ex,
Veronika
E. goodnight (DOB: 02/15/1982) and that they have three children in common. Mathew said he and Veronika
have a parenting plan and they each have all three kids for a week at a time. He did not know the exact nature
of
                                                                                           RCW 13.50.10
Veronika's current relationship, but he referred to her partner, Colin M. Derieg (DOB:     /1971). The location
given was Colin's home.

Mathew said the previous day, RCW 13.50.100(7)(c) had told him RCW 13.50.100(7)(c) that R.G. disclosed
approximately a few weeks prior, Colin had hit her. RCW 13.50.100(7)(c) utilized puppets to pantomime what R.G.
disclosed to her. Mathew described it to me as Colin told R.G. to shut up and turn around. He then hit R.G. in
the
bottom and the back approximately five times. Mathew described the hit as similar to a spanking. R.G. said that
it had hurt more when Colin did it because he's stronger. Mathew did not recall having seen any marks or


SM02 Prior Involvement                                                                                    Page 11 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000011
injuries on R.G. at any point after the kids had stayed with their mother. R.G. did not elaborate on how long the
pain she experienced had lasted for.

I asked Mathew if R.G. had said or indicated if the incident had occurred randomly or if it was more of a
disciplinary action if R.G. had been misbehaving. He said he did not know. Mathew told me he and Veronika
had
agreed that physical discipline would not be utilized in how they parent the children, but their parenting plan did
not have any language in it regarding discipline.

Mathew said this was the first instance of anything physical occurring that he knew of. He did mention that CPS
cases have been opened in the past against Veronika. He said the kids had told him in the past that Veronika
would be verbally abuse towards them including flipping them off. Mathew said R.G. had told Veronika about
the incident with Colin. Her response had been apparently to call R.G. a liar and say it never happened.
Mathew mentioned that 02/14 was the exchange day. I asked him if he planned on sending the kids to
Veronika.
He said he was undecided as he did not want her to call about him violating the parenting plan which was
issued
out of a King County Court. He did mention RCW 13.50.100(7)(c) had stated her intent to call Veronika. I asked if either
himself or RCW 13.50.100(7)(c) had contacted CPS. He said no.

Mathew told me the location given was Colin's house and that currently, Veronika lived in Carnation WA. Based
on the information provided by Mathew and his statements of past CPS investigations against Veronika, this
report was forwarded to CPS for review and an intake generated. I am requesting the report be reviewed by
SIU
as well.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5621715)
Program:     CPS                                                                    No
                                                                    Provider Related:
Date Received:    02/14/2025 1:45 PM                                Decision: Screen Out
Date of Alleged Maltreatment:   02/14/2025                          Reason:   No specific CA/N allegation or Risk
Worker: CHOW, VINJO                                                 Response Time:    N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                        SUBJECT                        CA/N                          FINDING
Goodnight-Ralidak, Raina      Goodnight, Veronika E.         Negligent Treatment or
S. (103285923)                (103285911)                    Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Open case #2682764 (Goodnight, Veronika), assigned to the King East Office.

HOUSEHOLD COMPOSITION
Mother: Veronika Goodnight
Child: Raina Goodnight-Ralidak (6)
Child: Aidan Goodnight-Ralidak (8)
Child: Elora Goodnight-Ralidak (9)

Referrer:                     RCW 13.50.100(7)(c)                           .

CONCERNS
Referrer met with child/Raina Goodnight-Ralidak (age 6) yesterday and she shared that her mother's boyfriend
Colin (unknown last name) spanked her multiple times as punishment. Raina showed referrer using a puppet
how Colin spanked her; with his hand multiple times on her bottom. No known injuries. Raina said her mother
and her biological father do not spank her, just Colin. Unknown if Collin lives in the home.



SM02 Prior Involvement                                                                                    Page 12 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000012
INTAKE INFORMATION
Intake Name (ID):         Goodnight, Veronika (5619864)
Program:      CPS                                                                 No
                                                                  Provider Related:
Date Received:    02/10/2025 4:16 PM                              Decision: Screen Out
Date of Alleged Maltreatment:   02/10/2025                        Reason:   No specific CA/N allegation or Risk
Worker: Thornhill, Keri L.                                        Response Time:    N/A
Case ID:     2682764
ALLEGATIONS:
VICTIM                            SUBJECT                  CA/N                        FINDING
Goodnight-Ralidak, Aidan          Goodnight, Veronika E.   Negligent Treatment or
W. (103285922)                    (103285911)              Maltreatment
Goodnight-Ralidak, Elora          Goodnight, Veronika E.   Negligent Treatment or
L. (103285921)                    (103285911)              Maltreatment
Goodnight-Ralidak, Raina          Goodnight, Veronika E.   Negligent Treatment or
S. (103285923)                    (103285911)              Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
REF RCW 13.50.100(7)(c)

Household:
Mother: Veronika Goodnight
Child: Elora Goodnight-Ralidak - 9y/o
Child: Aidan Goodnight-Ralidak - 8y/o
Child: Raina Goodnight-Ralidak - 6y/o

Non-household members
Father: Matthew Ralidak

There is an open CPS case regarding the same allegations. There are no new allegations.

REF reports she spoke to a SW on Thursday but spoke to the father on Friday and has additional information to
report. The father told REF that the children do not get enough food at their mother's house and they have to
beg for food. The father said the mother does not help the 6 year old to wipe and she was recently treated for a
UTI.

DV, substance abuse, and mental health were not reported.
Covid 19: No
ICW: No
School: Not reported.

INTAKE INFORMATION
Intake Name (ID):         Goodnight, Veronika (5619402)
Program:      CPS                                                                 No
                                                                  Provider Related:
Date Received:  02/06/2025 11:58 AM                               Decision: Screen In
Date of Alleged Maltreatment:  02/06/2025                         Reason:   CPS-FAR
Worker: Kausal, Alan G.                                           Response Time:    72 Hours
Case ID:     2682764
ALLEGATIONS:
VICTIM                            SUBJECT                  CA/N                        FINDING




SM02 Prior Involvement                                                                               Page 13 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000013
Goodnight-Ralidak, Aidan     Goodnight, Veronika E.        Negligent Treatment or
W. (103285922)               (103285911)                   Maltreatment
Goodnight-Ralidak, Elora     Goodnight, Veronika E.        Negligent Treatment or
L. (103285921)               (103285911)                   Maltreatment
Goodnight-Ralidak, Raina     Goodnight, Veronika E.        Negligent Treatment or
S. (103285923)               (103285911)                   Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Household Composition
Mother: Veronika Goodnight
Child: Elora Goodnight-Ralidak - 9y/o
Child: Aidan Goodnight-Ralidak - 8y/o
Child: Raina Goodnight-Ralidak - 6y/o

Non-household members
Father: Matthew Ralidak
Step-mother: Monica Galarneau

Per intake of 1/6/25 Caller reports the father told them that the mother moved in with a boyfriend. The boyfriend
has adult children/young adults. One of the young adults, who is 20, threatened to throw Raina off the home's
balcony, sometime during Winter Break. Ref, today, did not provide the name of mother's BF or his children.


                         RCW 13.50.100(7)(c)                            . Ref said parents have 50/50
custody. The children spend a week with each parent. The change takes place on Fridays. The children also
have a Wednesday evening visit with the parent in whose home they are not residing, in a given week.

Ref is calling to report that the children are not being fed adequately when they are in their mother's home.
According to Elora, the oldest, who was in ref's home last night, they have missed a lot of meals this week and
all they have had to eat is eggs and peanut butter, with Elora being the one that cooks the eggs for herself and
her siblings. Ref said that when the children come into her home they are always very hungry and are allowed
to eat as much as they want, but usually after a meal or 2, they have diarrhea, for about a day, which indicates
to ref that their bodies are adjusting to a higher level of food intake. The children also arrive at the home of ref
and father in poor condition, described by ref as "filthy." They are usually wearing visibly soiled clothing, with
the girls wearing "crusty" underwear. They all have "dark circles" under their eyes, which clear up after a few
days in father's home.
    RCW 13.50.10
Per      mother has said that she does not have the money to get enough groceries, but she always
manages to have champagne for herself.

There are certain foods in the home that the children are forbidden to touch because they belong to mother's
BF.
Ref said the children get breakfast and lunch at school.

Mother tried to get the school to discontinue providing meals to the children, contending that they have
significant food allergies, but father blocked this by providing the school with documentation from the children's
doctor, saying that the children have no such allergies. The children arrived at school on Monday, too late for
breakfast and then school was cancelled the rest of the week due to snow.

Ref said that mother is involved with a MLM company known as Purium, which sells various health foods,
detox/cleansing products and supplements. Some of what the children eat at mother's home are products from
this company, but not clear to ref what Purium products the children have consumed or how often.

Ref had no information about DV
Case still open from intake of7/30/24, but appears to be pending closure.




SM02 Prior Involvement                                                                                 Page 14 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000014
INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5581786)
Program:     CPS                                                                 No
                                                                 Provider Related:
Date Received:    01/06/2025 7:14 PM                             Decision: Screen Out
Date of Alleged Maltreatment:   12/26/2024                       Reason:   No specific CA/N allegation or Risk
Worker: Jackson, Sherry R.                                       Response Time:    N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                       SUBJECT                      CA/N                        FINDING
Goodnight-Ralidak, Raina     Goodnight, Veronika E.       Negligent Treatment or
S. (103285923)               (103285911)                  Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Mandatory Referrer reports 6 year old Raina attends Carnation Elementary and lives with her mother, Veronika
Goodnight. Famlink shows siblings as 9 year old Elora and 8 year old Aidan. Father is Matthew, he and the
mother are separated.

Referrer reports the parents had a contentious/high conflict divorce.

Caller reports the father told them that the mother moved in with a boyfriend. The boyfriend has adult
children/young adults. One of the young adults, who is 20, threatened to throw Raina off the home's balcony,
sometime during Winter Break.

Caller had no further information.

Open case: no
ICW: no
siblings: yes
domestic violence: unk
substance abuse: no
mental health: yes
csec: no
covid 19: no
weapons: unk
animals: unk

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5575864)
Program:     CPS                                                 Provider Related: No
Date Received:12/22/2024 7:50 PM                                 Decision: Screen Out
                            12/22/2024
Date of Alleged Maltreatment:                                    Reason:   Allegation documented in previous
Worker: Mosesso, Whitney E.                                      Response Time:     N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                       SUBJECT                      CA/N                        FINDING
Goodnight-Ralidak, Aidan     Goodnight, Veronika E.       Negligent Treatment or
W. (103285922)               (103285911)                  Maltreatment
Goodnight-Ralidak, Elora     Goodnight, Veronika E.       Negligent Treatment or
L. (103285921)               (103285911)                  Maltreatment




SM02 Prior Involvement                                                                              Page 15 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000015
Goodnight-Ralidak, Raina      Goodnight, Veronika E.        Negligent Treatment or
S. (103285923)                (103285911)                   Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Native American ancestry: No
D/V history: No
Substance Abuse history: No
Mental Health history: No
COVID exposure/symptoms: No

Household Composition
Mother: Veronika Goodnight
Child: Elora Goodnight-Ralidak - 9y/o
Child: Aidan Goodnight-Ralidak - 8y/o
Child: Raina Goodnight-Ralidak - 6y/o

Non-household members
Father: Matthew Ralidak
Step-mother: Monica Galarneau

Ref reports that the parents are separated and have "50/50/ custody." The children visit the parents for 1 week
at a time, alternating weekly and also having a visit on Wednesday with the parent they are not with that week.

Ref is       RCW 13.50.100(7)(c)           Ref reports that the father of Elora has expressed concerns about the
mother and that she is restricting the children's calories in ways that are harming their health. Ref reports that
the children all report being hungry at their mother's and that they can only drink protein shakes. Ref reports
that the father has stated that mother has some app where she checks ingredients and food and doesn't let the
children eat anything with any food that is concerning in the app.

Elora reports that they eat really healthy at her mom's house, she reports having cereal, eggs and protein
shakes and couldn't think of other foods. Elora says she feels hungry at her mother's a lot.

Ref reports that the children do not appear under weight but they just started to do this shake restriction
recently. Ref reports that she did talk to the mother about this app and that restricting the children's calories is
harmful. She states that the mother overwhelmingly agreed however she may still be doing so.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5574590)
Program:     CPS                                                                   No
                                                                   Provider Related:
Date Received: 12/19/2024 4:31 PM                                  Decision: Screen Out
Date of Alleged Maltreatment:12/19/2024                            Reason:   No specific CA/N allegation or Risk
Worker: RUIZ, ANIBAL C.                                            Response Time:    N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                        SUBJECT                       CA/N                         FINDING
Goodnight-Ralidak, Aidan      Goodnight, Veronika E.        Negligent Treatment or
W. (103285922)                (103285911)                   Maltreatment
Goodnight-Ralidak, Elora      Goodnight, Veronika E.        Negligent Treatment or
L. (103285921)                (103285911)                   Maltreatment
Goodnight-Ralidak, Raina      Goodnight, Veronika E.        Negligent Treatment or
S. (103285923)                (103285911)                   Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:



SM02 Prior Involvement                                                                                  Page 16 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000016
Ref is           RCW 13.50.100(7)(c)

Native American ancestry: No
D/V history: No
Substance Abuse history: No
Mental Health history: No
COVID exposure/symptoms: No

Household Composition
Mother: Veronika Goodnight
Child: Elora Goodnight-Ralidak - 9y/o
Child: Aidan Goodnight-Ralidak - 8y/o
Child: Raina Goodnight-Ralidak - 6y/o

Non-household members
Father: Matthew Ralidak
Step-mother: Monica Galarneau

Ref reports that the parents are separated and have "50/50/ custody" The children visit the parents for 1 week
at a time, alternating weekly and also having a visit on Wednesday with the parent they are not with that week.

Recently the school called home to inform the parents that Elora was telling some "big stories". During the
conversation with the father he requested to speak with the school about another matter. When they met the
father stated that he took the children to a pediatrician and the doctor reported that the children do not have any
allergies, contrary to what the mother is reporting.

Ref stated that the mother has requested a special non-dairy, gluten-free, diet for the children and has provided
a note from her naturopath/physician. The school has been honoring the mother's request, but also notes that
the children do not like their diet and are sometimes requesting snacks from the school nurse.

The father reported to the school that on 12/18/24, he picked the kids up for his weeklong visit. On the ride
home, Elora told them that they didn't really eat much, that their mother told them that there is a lot of bad food
out there and they only ate boiled eggs. She stated that Aidan doesn't eat eggs so he had some edamame. She
stated that she only knows how to cook scrambled eggs and she is worried that Aidan won't eat because he
doesn't like eggs.

The father is requesting that the parenting plan be changed and is working to get a note from the children's
pediatrician regarding their alleged allergies and any dietary restrictions. The father is also reportedly pursuing
a change in who the primary custodian is.

CISW asked if the children appeared unhealthy or had their medical needs go unmet. Ref stated that they
looked healthy and that she was not aware of any ongoing medical needs.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5494945)
Program:     CPS                                                  Provider Related:No
Date Received:    09/29/2024 11:35 PM                             Decision: Screen Out
Date of Alleged Maltreatment:    08/30/2024                       Reason:   Third Party-Referred to Law
Worker: WU, MICHELLE J.                                           Response Time:    N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                       SUBJECT                       CA/N                         FINDING
Goodnight-Ralidak, Elora     Goodnight, Veronika E.        Negligent Treatment or
L. (103285921)               (103285911)                   Maltreatment



SM02 Prior Involvement                                                                                 Page 17 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000017
Describe the nature and extent of the alleged maltreatment or concern:
Referrer (Ref) is                 RCW 13.50.100(7)(c)

Note: per Ref, the family does not have known exposure to COVID-19

household members per Ref:
mother- Veronika Goodnight
mother's partner- Collin (last name unknown to Ref)
child- Elora Ralidak (age 9)
child- Aidan Ralidak (age 8)
child- Raina Ralidak (age 6)

non-household members:
father- Matthew Ralidak
stepmother- Monica (last name unknown to Ref)
FamLink hx. lists Monica's last name as Galarneau.


Ref reported that the child, Elora Ralidak (age 9), lives with her mother and her 2 siblings, Aidan Ralidak (age
8) and Raina Ralidak (age 6). Ref stated that the children's father is Matthew Ralidak, and father lives with the
children's stepmother, Monica (last name unknown to Ref).

Ref stated that on 9/24/2024, mother reported that Elora was sexually assaulted by a peer, Addie (last name
unknown to Ref), at a girl scouts camp, end of August of 2024. It was reported that Addie asked Elora to play a
game, to pretend to have sex, and that Addie got on top of Elora (with clothing on).

Ref stated that Ref spoke with Elora, and Elora denied any touching by Addie.

Ref reported that Elora and Addie attend same elementary school together (Ref does not know the name of the
school).

Ref stated that mother is going to have Elora take a break from girl scouts activities.


Ref denied DV between mother and mother's partner, and Ref reported history of DV between parents.

no indication of ICW per Ref and FamLink.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5437643)
Program:     CPS                                                                  No
                                                                  Provider Related:
Date Received: 08/04/2024 8:40 PM                                 Decision: Screen Out
Date of Alleged Maltreatment:08/04/2024                           Reason:   No specific CA/N allegation or Risk
Worker: Whitham, Robert                                           Response Time:    N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                       SUBJECT                       CA/N                           FINDING
Goodnight-Ralidak, Elora     Goodnight, Veronika E.        Negligent Treatment or
L. (103285921)               (103285911)                   Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Current Open Case.

The referrer is                             RCW 13.50.100(7)(c)


SM02 Prior Involvement                                                                               Page 18 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000018
Household Composition:
Mother - Veronika Goodnight
Child - Elora Ralidak (9)
Child - Aidan Ralidak (7)
Child - Raina Ralidak (6)

Non-household Composition:
Father - Matthew Ralidak

Others Involved:
Other Child: River Muggli (10)


Concerns:
The referrer contacted Central Intake to express ongoing concerns that the mother is not ensuring the safety of
9 year-old Elora Ralidak from a peer who has been sexually abusive toward her.
                                                               RCW 13.50.100
In May, 2024, the referrer first learned that Elora's peer, River , attempted to kiss Elora. The referrer
recommended to mother that Elora and River have no contact with each other.

On 07/30/24, the referrer again made this recommendation to the mother after Elora disclosed that she still
sees River and that he is still attempting to kiss her.

During a session with the father on 08/02/24, the father reported that on 07/31/24, Elora told him that River had
been sending "mean text messages" to her (no date(s) of the text messages was provided and there was no
specific information regarding the content of the messages). The father reported that Elora uses a cell phone
while at her mother's house and that the mother allows her to use the cell phone without supervision.

Toward the end of 08/02/24 session, the father reported that in December, 2023, Elora and her siblings were in
a car with their mother. Elora and her sister were arguing, so the mother pulled the car over and "smacked"
Elora across the face. The father reported that Elora did not go to his house until a couple of days after the
incident, so he was unsure if there were any injuries. The referrer was asked if Elora reported sustaining
injuries, and the referrer stated there were no injuries reported. Elora told her father that the family returned
home after the mother slapped her. The mother went into bathroom, got into the bathtub and refused to come
out until Elora wrote her a note apologizing for being a bad person.


No known Native American Ancestry.
No reported COVID-19 Exposure or Symptoms.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5438709)
Program:     CPS                                                 Provider Related: No
Date Received:    08/02/2024 10:50 PM                            Decision: Screen Out
Date of Alleged Maltreatment:    07/30/2024                      Reason:   Allegation documented in previous
Worker: MONEY, TAMMY A.                                          Response Time:     N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                       SUBJECT                      CA/N                        FINDING
Goodnight-Ralidak, Elora     Goodnight, Veronika E.       Negligent Treatment or
L. (103285921)               (103285911)                  Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:



SM02 Prior Involvement                                                                              Page 19 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000019
EMAILED REPORT FROM THE KING COUNTY SHERIFF'S OFFICE

OPEN CASE

HOUSEHOLD MEMBERS:
Mother - Veronika Goodnight
Child - Elora Ralidak age 9
Child - Aidan Ralidak age 7
Child - Raina Ralidak age 5

OTHER BIO PARENT
Father - Matthew Ralidak

CONCERNS:

At 1556 hours on 8/1/2024, I was dispatched to a sex offense detail with a listed address of 33219 NE 66TH
ST. The following information was displayed on CAD:

" 21-REQUEST RP NOT AT LOC...3RD PERSON REFERRAL FOR SEX ABUSE OF 9YO CHILD, CHILD
DISCLOSED WHILE BEING
MEDICALLY EVALUATED...UNK WHERE ABUSE OCC'D...THEIR REPORT IS BASED ON CHILD'S HOME
ADDR...*RP REFUSED
TO PROVIDE THE NAME OF THE CHILD OR THE SUSPECT, WANTS TO TALK TO PATROL OR FAX
THEIR INTAKE TO PATROL...
**UNK IF CHILD IN IMMINENT DANGER "

I then contacted RP Virginia Gleason, the Child Advocacy Program Manager of Compass Health, over the
phone using my department issued cellphone. Compass Health wanted to contact law enforcement to fax over
or email a document from a recent "Special Occurrence" from a mental health appointment. A Special
Occurrence refers to a patient disclosing sexual or physical assault to a healthcare professional. The patient
from this incident is Elora L. Goodnight - DOB 3/21/2015. Elora lives at 33219 NE 66TH ST. Gleason could not
firsthand report the incident to me; however, she sent the document to my work email. The document is
summarized as follows:

Elora received a therapy session affiliated with Compass Health on 7/30/2024. While Elora was talking with a
mental health professional, she explained an incident which happened approximately two weeks prior to the
appointment. Elora explained how River RCW 13.50.100 family friend who is the same age, was kissed by River at
River's house. Elora indicated that River and she have kissed multiple times previously, where no other reports
of inappropriate touching have been reported by Elora. In this specific incident, Elora was being kissed by River
when she told River to stop. River stopped kissing Elora after this incident occurred.

In the Compass Health document, it also discusses how Elora's father reported to health personnel about River
kissing Elora "with tongue on multiple occasions" in May of 2024. A therapist recommended that River and
Elora should take a break from seeing each other. Elora's mother, Veronika E Goodnight - DOB 2/15/1982, is
listed in the document as the best contact for Elora. A therapist also contacted Veronika about the
recommendation, where she agreed and understood such input.

As Veronika is listed as the best contact for Elora, I attempted to contact her over the phone two times in
attempt to get more information. I was unable to come into contact with Veronika after these attempts.

Due to the above listed information, no crime has taken place. This police report is to be forwarded to CPS, no
charges are to be filed at this time.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5435044)
Program:     CPS                                               Provider Related:   No



SM02 Prior Involvement                                                                               Page 20 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000020
Date Received:07/30/2024 10:15 PM                                   Decision: Screen In
Date of Alleged Maltreatment:07/30/2024                             Reason:   CPS-FAR
Worker: Thompson, Diane                                             Response Time:    72 Hours
Case ID:              2682764
ALLEGATIONS:
VICTIM                              SUBJECT                  CA/N                        FINDING
Goodnight-Ralidak, Elora            Goodnight, Veronika E.   Negligent Treatment or
L. (103285921)                      (103285911)              Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Household:
Mother - Veronika
Child - Elora Ralidak age 9
Child - Aidan Ralidak age 7
Child - Raina Ralidak age 5

Non-household Members:
Father - Matthew Ralidak
Anjali D'souza is calling from Compass Health
RCW 13.50.100(7)(c)
          reporting concerns of parent Anjali going against clinical recommendation for the healthy welfare of 9
yr Elora.
                                                         RCW 13.50.100
Two weeks ago Elora had indicated that a 9 yr girl River               had kissed her. Therapist has requested that
Elora not be around this child River,
Parent Veronica agreed but did not follow through.

Today Elora indicated that she meet up with 9 yr River because her Mom Veronica and River's Mom Diana are
friends.
Elora stated that River has touched Elora multiple time in the past and this time Elora had told River to stop
kissing and touching her, but River did not. River was putting her tongue in Ellora's mouth, while at River's
house
Veronica indicated that she doubted that this happened.

Veronica was spoken with       RCW 13.50.100(7)(c)        today and again explained about the safety of her
daughter around this child. Veronica indicated that she would not have them in contact with each other.
RCW 13.50.100(7)(c)
           concerned about Veronica understanding of the risk to her child and concerned about Veronica
following through with protection of Elora.

INTAKE INFORMATION
Intake Name (ID):           Goodnight, Veronika (5368536)
Program:              CPS                                                           No
                                                                    Provider Related:
             05/23/2024 11:26 AM
Date Received:                                                      Decision: Screen Out
                            05/21/2024
Date of Alleged Maltreatment:                                       Reason:   No specific CA/N allegation or Risk
Worker: HOOPER, ALICIA M.                                           Response Time:    N/A
Case ID:              2682764
ALLEGATIONS:
VICTIM                              SUBJECT                  CA/N                        FINDING
Goodnight-Ralidak, Elora            Goodnight, Veronika E.   Negligent Treatment or
L. (103285921)                      (103285911)              Maltreatment




SM02 Prior Involvement                                                                                 Page 21 of 26
      Goodnight, Veronika
      202504-PRR-349
      DCYF - 000021
Goodnight-Ralidak, Elora      Ralidak, Mathew W.          Negligent Treatment or
L. (103285921)                (104669770)                 Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
                     RCW 13.50.100(7)(c)

Household:
Mother - Veronika
Child - Elora Ralidak age 9
Child - Aidan Ralidak age 7
Child - Raina Ralidak age 5

Non-household Members:
Father - Matthew Ralidak

ICW - None known per REF
DV - Mother and father are divorced, but mother disclosed historical sexual and physical violence
Covid19 - None known per REF

REF has only met with Elora once                            RCW 13.50.100(7)(c)                              REF
was sent an email from the mother including screen shots of texts from Elora's father. Some of the things in the
texts and disclosures were different than information in Elora's intake. One disclosure was that Elora asked a
family friend named Sage to lay on her inappropriately during a play date. The father also reported that Elora
had been kissing her peer and friend River with tongue. Father referenced a camping trip that he and his wife
and the kids went on two years ago. Elora allegedly kissed another girl at their camp site. Father said Elora is
now telling the truth about the camping. Previously she said it was the other girl trying to kiss her. The way the
father prefaced the information was that Elora had shared all the information with him.

When the mother dropped Elora off at session and REF did a check in with the mother, the mother said she
does not believe the disclosure about Sage. She does not think it happened because she said she was at the
referenced playdate in her home and Sage's parents were there supervising the children. Mother also
expressed doubts about the disclosures with River and the camping trip. She feels things are not lining up with
the timing and she is skeptical as to why the father is sending the information now. Elora has not reported any
of this to the mother except the camping trip incident which she told the mother the other girl kissed her.

In the texts the father and stepmother's responses seemed validating to Elora.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5348466)
Program:     CPS                                                 Provider Related: No
             05/03/2024 2:15 PM
Date Received:                                                   Decision: Screen Out
                           05/03/2024
Date of Alleged Maltreatment:                                    Reason:   Allegation documented in previous
Worker: HOOPER, ALICIA M.                                        Response Time:     N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                        SUBJECT                     CA/N                        FINDING
Goodnight-Ralidak, Elora      Goodnight, Veronika E.      Negligent Treatment or
L. (103285921)                (103285911)                 Maltreatment
Goodnight-Ralidak, Elora      Ralidak, Mathew W.          Negligent Treatment or
L. (103285921)                (104669770)                 Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Referrer REF is                    RCW 13.50.100(7)(c)



SM02 Prior Involvement                                                                               Page 22 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000022
HOUSEHOLD
Mother - Veronika Goodnight
Child - Elora Ralidak age 9
Child - Aidan Ralidak age 7
Child - Raina Ralidak age 5

Non-household Members:
Father - Matthew Ralidak

The children are with the father Thursday through Sunday

DV - History between the parents, no current DV
ICW - None known per REF
Covid19 - None known per REF

The concerns are third party related to a peer named Makayla RCW 13.50.100 is a peer. REF spoke to Elora and she
said that during a playdate, Makayla would tell her parents that they were going to draw. Makayla would then
go check to see if the cost was clear. Makayla would make Elora get on her bed. Makayla would lay on top of
Elora and kiss her. She would pull her pants and underwear down and sometimes take her underwear off of
her. REF has no other details at this time. Elora's mother mentioned Makayla has an older sibling who
inappropriately touched someone else as well.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5337530)
Program:     CPS                                                 Provider Related: No
Date Received:  04/17/2024 10:08 AM                              Decision: Screen Out
Date of Alleged Maltreatment:  03/24/2024                        Reason:   Allegation documented in previous
Worker: Aust, Sean R.                                            Response Time:     N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                       SUBJECT                      CA/N                        FINDING
Goodnight-Ralidak, Elora     Ralidak, Mathew W.           Negligent Treatment or
L. (103285921)               (104669770)                  Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
REF                 RCW 13.50.100(7)(c)

HOUSEHOLD
Mother - Veronika Goodnight
Child - Elora Ralidak [9]
Child - Aidan Ralidak [7]
Child - Raina Ralidak [5]

Non-household Members:
Father - Matthew Ralidak

Concerns Reported Today: In a phone conversation with Kim Kiefer, Clinical Program Assistant with the Child
Advocacy Program, the mother said Elora was touched inappropriately by a neighbor girl at her dad's house,
and the alleged offender is Makayla RCW 13.50.100 who is 10 years old. The mother told Kim his happened on more
than one time. The mother also said Elora came to her and said she (alleged offender) tried to kiss her,
remover her clothing, and touch her private parts.
Has this been previously reported? Yes. King County Sheriff Department.
(Case number) No: C24010592.




SM02 Prior Involvement                                                                               Page 23 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000023
Note: We do not have further details than what is presented in the above at this time.

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5321629)
Program:     CPS                                                   Provider Related: No
Date Received:    03/29/2024 3:50 PM                               Decision: Screen Out
Date of Alleged Maltreatment:   03/24/2024                         Reason:   Allegation documented in previous
Worker: Kausal, Alan G.                                            Response Time:     N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                        SUBJECT                       CA/N                           FINDING
Goodnight-Ralidak, Elora      Ralidak, Mathew W.            Negligent Treatment or
L. (103285921)                (104669770)                   Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
HOUSEHOLD
Mother - Veronika Goodnight
Child - Elora Ralidak [9]
Child - Aidan Ralidak [7]
Child - Raina Ralidak [5]

Non HH, Mathew Ralidak, father, lives with his wife or GF Monica Galarneau

Ref is         RCW 13.50.100(7)(c)            calling about Elora. Ref got an email today from the mother saying
that Elora was "molested" by a 10 girl who is a neighbor of her father. Mother said she has notified "the
authorities." No information provided as to the name of this girl and what is meant by "molested."

Ref said the children have regular visits with their father, but there is a custody battle going on in family court,
due to father wanting full custody.

Ref had no information about DV
No open case
No ICW

INTAKE INFORMATION
Intake Name (ID):    Goodnight, Veronika (5321486)
Program:     CPS                                                   Provider Related:No
Date Received:    03/28/2024 4:21 PM                               Decision: Screen Out
Date of Alleged Maltreatment:   03/28/2024                         Reason:   Third Party-Referred to Law
Worker: Robins, Aaron G.                                           Response Time:    N/A
Case ID:    2682764
ALLEGATIONS:
VICTIM                        SUBJECT                       CA/N                           FINDING
Goodnight-Ralidak, Elora      Goodnight, Veronika E.        Negligent Treatment or
L. (103285921)                (103285911)                   Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
Referrer:                          RCW 13.50.100(7)(c)                                 .

Household Members: Veronika Goodnight (Mother), Elora Ralidak (9), Aiden Ralidak (7), and Raina Ralidak
(5).


SM02 Prior Involvement                                                                                   Page 24 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000024
Non-household Members: Matthew Ralidak (Father).

*Due to CISW shift time constraints, CISW did not verity the children's parentage.

NARRATIVE
________________________________________________________________________________________
_______________

On 03/24/2024 at 1407 hours I was dispatched to a child molestation type of call at 10445 302ND WAY NE,
Carnation WA, 98014. I arrived on scene at 1456 hours and met with the RP Veronika E. Goodnight (DOB
02/15/1982) who informed me that her daughter, Elora L. Goodnight (9-years-old) had been molested by
another juvenile female. Veronika states that on Monday 3/25/2024 Elora had come to her and said a friend
from church, MakaylaRCW 13.50.100 (9-years-old) had inappropriately touched Elora at Makayla's house after
church on Sunday 03/24/2024.                          RCW 13.50.100
                                                                                        RCW 13.50.10
Veronika says that Elora came home from her father's house, Mathew W. Ralidak (DOB              /1986), whom
she was staying with that weekend. Elora told Veronika that while she was at Makayla's house that Makaya had
pulled her pants and underwear down, and that as Elora tried to pull them up, that Makayla had held her wrists
and prevented her from doing so and Makayla began to giggle. Veronika said that she asked Elora if Elora had
enjoyed it and Elora said no and that she froze because she was uncomfortable. Elora also told Veronika that
this was not the only thing that had happened on Sunday. Elora said that she had to sit with her legs tucked up
to her chest so that Makayla would not be able to touch her vagina. Veronika asked again if Elora liked being
touched and Elora said no. Elora then told Veronika that Makayla had Elora touch Makayla's vagina, Elora not
knowing what to do then touched Makayla. Elora told Veronika that she did not like that either.

Veronika asked Elora how it all started, and Elora told her that Makayla lied to her father, Douglas R. Woodle
      RCW 13.50.10
(DOB         /1962), that they were going to draw. Elora said they then played "barbies" which was when the
unwanted touching began. According to Veronika, Elora says that Makayla plays this game with another friend
named Ona (we could not get more information than a first name), and it is often explained as drawing and then
turns to playing "barbies".

Veronika explained this was not the first time Elora had said something happened with Makayla. Elora told her
mother that while at Mathew's house, Makayla had tried to kiss Elora. Veronika asked if Elora had enjoyed that,
and Elora said no.
Veronika is concerned because she does not believe that Makayla, as a 10-year-old should know these things
and is concerned for the safety of not only her child but Makayla as well. There is concern for what is going on
at Makayla's house. Veronika and Mathew have a plan in place to keep Elora away from Makayla and not let
them be alone together. They both go to the same church, Stillwater church, and Mathew told Veronika that
they will be having Elora with them at service from now on. Mathew has been in contact with Makayla's parents
regarding the situations.

After talking with Detective Pearlstein this should be screened by an SAU Sergeant.

                                              RCW 13.50.100
                                .

Case should be forwarded to SAU for review.

I have nothing further to add to this.
________________________________________________________________________________________
_______________
End of Narrative.

                                           RCW 13.50.100




SM02 Prior Involvement                                                                                 Page 25 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000025
* See companion intake no. 5321512 regarding Ona.

INTAKE INFORMATION
Intake Name (ID):        Goodnight, Veronika (4230045)
Program:       CPS                                                                   No
                                                                     Provider Related:
Date Received:    10/09/2019 4:19 PM                                 Decision: Screen Out
Date of Alleged Maltreatment:   09/25/2019                           Reason:   No specific CA/N allegation or Risk
Worker: SCREWS, SYDNEY L.                                            Response Time:    N/A
Case ID:      2682764
ALLEGATIONS:
VICTIM                               SUBJECT                  CA/N                        FINDING
Goodnight-Ralidak, Aidan             Goodnight, Veronika E.   Negligent Treatment or
W. (103285922)                       (103285911)              Maltreatment
Goodnight-Ralidak, Elora             Goodnight, Veronika E.   Negligent Treatment or
L. (103285921)                       (103285911)              Maltreatment
Goodnight-Ralidak, Raina             Goodnight, Veronika E.   Negligent Treatment or
S. (103285923)                       (103285911)              Maltreatment
Describe the nature and extent of the alleged maltreatment or concern:
No open case
Referrer reports no known Native American ancestry for this family

Household composition:
Veronika Goodnight - mother
Matthew Ralidak - father
Elora Ralidak - 4 years old
Aidan Ralidak - 3 years old
Raina Ralidak - 16 months old

Address: 26710 NE Park Street, Duvall, WA 98019
Veronika's phone number: 805-895-0509

----------------------------------------

Referrer is                                          RCW 13.50.100(7)(c)


Referrer completed an intake for services for Veronika a couple of weeks ago. At that intake, she reported she
was clean from alcohol for the past month but previously she was drinking 1-3 bottles of champagne each
night. Veronika said this would happen after the kids went to bed. Referrer asked Veronika if she was "alert"
enough to care for the kids if they had woken up and Veronika said she was. Referrer said she delayed in
reporting this because she had to consult with her supervisor first.




SM02 Prior Involvement                                                                                  Page 26 of 26
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000026
                             DEPARTMENT OF CHILDREN, YOUTH, AND FAMILIES (DCYF)
                                         FAR ASSESSMENT RESPONSE (FAR)
                                       FAR FAMILY ASSESSMENT & CASE PLAN
CASE & PARTICIPANT INFORMATION

Case Name (ID):                                                                            Approval Date:
Goodnight, Veronika (2682764)                                                              09/24/2024
Parent/Caregiver(ID):                                                   DOB:               Intake ID:
Galarneau, Monica (104669771)                                           RCW 13.50.10
                                                                                   /1985   5435044
Goodnight, Veronika, E. (103285911)                                     02/15/1982
Ralidak, Matthew (103285924)                                            RCW 13.50.10
                                                                                   /1986
Child(ren):                                                             DOB:
Goodnight-Ralidak, Aidan, W. (103285922)                                08/16/2016
Goodnight-Ralidak, Elora, L. (103285921)                                03/21/2015
Goodnight-Ralidak, Raina, S. (103285923)                                06/03/2018


Social Service Specialist:                         Email:                                  Phone:
Dhillon, Amandeep (104106842)                      amandeep.dhillon@dcyf.wa.gov            (206) 445-4184

INITIAL ENGAGEMENT QUESTIONS
Did you discuss the FAR Intervention with the family and provide written information?                   Yes

Did the family agree to participate in the FAR Intervention?                                            Yes

Explain:
SW Dhillon went over FAR process with both parents from different households and they both agreed to
participate. Custody of children are split 50/50 with both sides.


CURRENT NEEDS AND CHALLENGES

Describe the Nature and Extent of the Situation that brought the family to the Department’s attention.
Household:
Mother - Veronika
Child - Elora Ralidak age 9
Child - Aidan Ralidak age 7
Child - Raina Ralidak age 5

Non-household Members:
Father - Matthew Ralidak
                      RCW 13.50.100(7)(c)
RCW 13.50.100(7)(c)
          reporting concerns of parent Anjali going against clinical recommendation for the healthy welfare of 9
yr Elora.
                                                         RCW 13.50.100
Two weeks ago Elora had indicated that a 9 yr girl River               had kissed her. Therapist has requested that
Elora not be around this child River,
Parent Veronica agreed but did not follow through.



FAR Family Assessment                             Case Name (Case ID)                                     Page 1 of 10
DCYF 10-474 (02/2019) INT/EXT                 Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000027
Today Elora indicated that she meet up with 9 yr River because her Mom Veronica and River's Mom Diana are
friends.
Elora stated that River has touched Elora multiple time in the past and this time Elora had told River to stop
kissing and touching her, but River did not. River was putting her tongue in Ellora's mouth, while at River's
house
Veronica indicated that she doubted that this happened.

Veronica was spoken with during counseling appointment today and again explained about the safety of her
daughter around this child. Veronica indicated that she would not have them in contact with each other.

Therapist concerned about Veronica understanding of the risk to her child and concerned about Veronica
following through with protection of Elora.

Sequence of Events: Describe the surrounding circumstances that led to the family assessment.
PER CHILD ELORA: Elora stated it happened in the past before and stated River had pecked her quick and it
wasn't a big kiss. Elora stated she felt uncomfortable and stated she told her mom right away and situation was
cared for. Elora has stated no concerns since then.

Matthew stated he is not aware of what has happened but stated an incident of the friend and Elora had
happened in the past. Monica stated she has only heard from Matt and heard from Elora that she has told them
she has never touched anyone like this. Matt stated they have talked to Elora about touching and what is
appropriate and what is not. Monica stated there was an incident in the past where on social media Veronica
had posted about it. Matt stated King County sheriffs office was involved but stated all visits between Elora and
her friends are limited and safe.

Veronika stated Elora is in therapy now and stated she told Anjali on Tuesday that she has to call CPS for a
report. Veronika stated a similar situation like this happened to Elora in 2019 where it was Dawson's place and
stated the person is at still church. Veronika stated her father Matt still takes her to the same church. Veronika
stated Diana was previous case worker.

Diana stated her friendship ended with Veronika. Diana stated her daughter River asked Elora to be her
girlfriend and stated they were together but then broke up. Diana stated both girls had kissed couple of times
but stated their friendship is over and everything has been taken care of. Diana stated

FAMILY DEVELOPMENTAL STAGES AND TASKS

Family Developmental Stages:
School Age Children

Describe the family’s composition and cultural factors.
Household:
Mother - Veronika
Child - Elora Ralidak age 9
Child - Aidan Ralidak age 7
Child - Raina Ralidak age 5

Non-household Members:
Father - Matthew Ralidak
            RCW 13.50.100(7)(c)

Describe the everyday life task(s) that contribute to the situation.




FAR Family Assessment                             Case Name (Case ID)                                 Page 2 of 10
DCYF 10-474 (02/2019) INT/EXT                 Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000028
                                                           RCW 13.50.100
Two weeks ago Elora had indicated that a 9 yr girl River                   had kissed her. Therapist has requested that
Elora not be around this child River,
Parent Veronica agreed but did not follow through.

Today Elora indicated that she meet up with 9 yr River because her Mom Veronica and River's Mom Diana are
friends.
Elora stated that River has touched Elora multiple time in the past and this time Elora had told River to stop
kissing and touching her, but River did not. River was putting her tongue in Ellora's mouth, while at River's
house
Veronica indicated that she doubted that this happened.

Veronica was spoken with during counseling appointment today and again explained about the safety of her
daughter around this child. Veronica indicated that she would not have them in contact with each other.
Describe what the family has done to keep the child(ren) safe and healthy in the past and the resources
used.

All children are enrolled in school, Elora is in counseling and is getting her treatment. Both households have
enough food, toys and all living necessities.

Parenting Practices

Describe how each parent disciplines the child(ren).


All children stated the rules at mom and dad's are to be respectful, not yell at mom or dad, be positive and keep
rooms clean. Elora stated she gets sent to room as punishment. Aidan stated his mom will grab his ear from
side and sent to room. Raina stated nobody hits them but they go to their rooms for punishment. Elora stated
that mom yells at them and makes them go to the room.

Matt stated the kids cannot say curse words, no hitting, or biting anyone, and respecting all younger and elders.
Matt stated he takes away the kids privileges or mostly send them to their rooms for timeout and stated he will
always talk to them. Matt stated Monica does the same discipline methods.

 Veronika stated Elora is emotional, personal, smart, kind, empathetic and doing very food in school. Veronika
stated Aidan loves hockey, sweet boy and does not act out. Veronika stated Raina is her DNA twin, wild,
emotional, and causes more drama and is very insane. Veronika stated the kids go to a natural homeopathic
Dr. Bowker in Natural Snohomish.

Diana stated Veronika revokes privileges and stated there is no physical disciplining involved.

Robert stated no physical discipline, and stated the parents send the kids to their rooms and corrects them if
they are wrong.

What are the overall parenting practices used by the parent?


VERONIKA: Elora stated she loves her mom because she gets to play with her but stated she dislikes her stern
voice. Aidan stated he loves mom because she hugs him but stated he dislikes her being stern. Raina stated
she loves snuggling with mom and stated she loves helping her.
COLIN: Elora stated what she likes about Colin is that he is nice, Aidan stated he plays catch and Raina stated
he helps adjust her neck. All children stated no dislikes for Colin.
MATT: Elora stated she likes her dad because he is loosening up, lets her do makeup, and is redoing her room.
Aidan stated he likes to go to the creek with dad, catch fish, trout, and dislikes dad because he has to clean his
room. Raina stated she loves to feed the cats with dad, and hug him.
MONIKA: Elora stated Monika takes her for shopping, plays with her, reads to her but dislikes being put in a
room. Aidan stated Monica plays catch with him, cooks for him, and stated he dislikes when she yells. Raina


FAR Family Assessment                            Case Name (Case ID)                                          Page 3 of 10
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000029
stated Monika helps us with the problem that they get and reads to her.

PARENTING STYLE/EXPECTATIONS: Matthew stated he loves to guide his children through situations, let
them grow, be involved in their school activities. Monica stated what she loves about parenting is letting the
kids be their own individuals, sing to them, having inside jokes with them, and taking them to church. Monica
stated they have 50/50 custody. Monica stated she will not be having her own kids because Matt's kids are the
main priority right now. Matthew stated what he finds frustrating about parenting is the needs and managing
their emotional needs. Matt stated it is hard every week and stated the separate lives is hard with
communication. Monica stated the change is hard and going back between every week.

Veronika stated she has known and take care of the 2 kids for a lot. Veronika stated she has shielded her kids
from the outside world. Veronika stated she never lies to the kids and stated she finds nothing frustrating right
now. Veronika stated she is making her kids be good human beings for when they grow up.

Diana stated she has no comments on Veronika's parenting but stated she will say that Veronika is very
authoritarian, and could slow things down to go with the flow.

Robert stated Monika is a good mom, patient lady, always fair to all sides, listens to the children's development,
works with young people and has no tempers. Robert stated Matthew is a good dad, calls to attention, and
loves these kids a lot and would do anything for them. Matthew is a very patient dad as well.
Family Support

Describe the family’s support system.


Veronika expressed interest in FFT. FA Matthew stated no needs from the department and stated they have a
plan set in place for the kids and stated they have enough support around.


INDIVIDUAL ADULT PATTERNS OF BEHAVIOR

Parent/Caregiver:       Galarneau, Monica (104669771)
How does the parent manage his/her own life on a daily basis? How does the parent function on a daily
basis?
"Parent Functioning:
                                RCW 13.50.100


                             Travel as needed for Events/Projects.
What do you do to make yourself happy?
I like to listen to music, podcast, or sit outside and bird watch. I enjoy funny movies and TV shows as well.
How do you manage stress?
I pause my situation, whatever moment it may be, and breath, pray, talk to my therapist, but always look to
deescalate whatever may be bothering me.
What does an argument between adults look like?
It would look like two low speaking reasonable people being able to calmly be able to walk away from a
conversation or be able to navigate talking to one another in a peaceful and respectful manner.

What social/community support do you have? If there was a problem, who would you go to for help?
We have a very strong church community. We have friends surrounding the greater Seattle area from our work
and personal relationships. Family from CA and the East Coast that communicate regularly and visit annually or
more. Social interactions in the community however have been tarnished with the hateful and disgusting things
Veronika has said about my wife and I in the community. It has been hard to trust others locally sounds of out
church and close friends because of the negativity.

Do you need any help/services with parenting?


FAR Family Assessment                            Case Name (Case ID)                                  Page 4 of 10
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000030
My wife and I do not need any help or services with parenting.

Discipline:
What are the rules in your home?

What is discipline like? What happens if someone breaks the rules?

Is discipline effective? Why do you use those consequences/methods?

How often does discipline happen?

Reasons department got involved:
Do you know why the department received a concern about safety of children in your home? Please explain
and describe your point of view on what may have led to department's involvement?




Below are some questions we have to ask each family: Please explain if you answered yes to any of the
questions

Do you have a Mental health diagnosis? If so, what is it?
No.

Do you have any childhood abuse history?


Were you part of any Military service?
No.

Are you Religious?
Yes, Christian.

Do you have Criminal history? Conviction history?
No.

Do you use Drugs?
No.

Have you ever been in an intimate relationship where you didn't feel safe, or a relationship with a violent or
aggressive component?


Do you drink? If not, what is the frequency, duration, quantity? Where are the drink(s) located in your home?
Are they accessible to the children?

Any other concerns you like to share that are not covered?

INDIVIDUAL ADULT PATTERNS OF BEHAVIOR

Parent/Caregiver:       Goodnight, Veronika, E. (103285911)
How does the parent manage his/her own life on a daily basis? How does the parent function on a daily
basis?
PARENT FUNCTION/SDM: Veronika stated she is a retired performer and stated she used to perform on silk
clinics and loves to go on long walks, and bath. Veronika stated she does deep breathing exercises.
Crim: no.
Religious: no.

FAR Family Assessment                            Case Name (Case ID)                                  Page 5 of 10
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000031
Substance use: no.
MH: stated no.
DV: states yes with Matt.
SUPPORTS: Veronika stated she has her fianc and Diana.
NEXT-STEPS/SERVICES: Veronika stated she would be interested in FFT.

INDIVIDUAL ADULT PATTERNS OF BEHAVIOR

Parent/Caregiver:       Ralidak, Matthew (103285924)
How does the parent manage his/her own life on a daily basis? How does the parent function on a daily
basis?
"Parent Functioning:
Are you working right now? Where do you work? Other sources of income?
Full Time Employment. Company name, Freeman.
What is your schedule?
Work from home/Remote. Travel as needed for Events/Projects.
What do you do to make yourself happy?
I like to listen to music, podcast, or sit outside and bird watch. I enjoy funny movies and TV shows as well.
How do you manage stress?
I pause my situation, whatever moment it may be, and breath, pray, talk to my therapist, but always look to
deescalate whatever may be bothering me.
What does an argument between adults look like?
It would look like two low speaking reasonable people being able to calmly be able to walk away from a
conversation or be able to navigate talking to one another in a peaceful and respectful manner.

What social/community support do you have? If there was a problem, who would you go to for help?
We have a very strong church community. We have friends surrounding the greater Seattle area from our work
and personal relationships. Family from CA and the East Coast that communicate regularly and visit annually or
more. Social interactions in the community however have been tarnished with the hateful and disgusting things
Veronika has said about my wife and I in the community. It has been hard to trust others locally sounds of out
church and close friends because of the negativity.

Do you need any help/services with parenting?
My wife and I do not need any help or services with parenting.

Discipline:
What are the rules in your home?

What is discipline like? What happens if someone breaks the rules?

Is discipline effective? Why do you use those consequences/methods?

How often does discipline happen?

Reasons department got involved:
Do you know why the department received a concern about safety of children in your home? Please explain
and describe your point of view on what may have led to department's involvement?




Below are some questions we have to ask each family: Please explain if you answered yes to any of the
questions

Do you have a Mental health diagnosis? If so, what is it?
No.



FAR Family Assessment                            Case Name (Case ID)                                 Page 6 of 10
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000032
Do you have any childhood abuse history?


Were you part of any Military service?
No.

Are you Religious?
Yes, Christian.

Do you have Criminal history? Conviction history?
No.

Do you use Drugs?
No.

Have you ever been in an intimate relationship where you didn't feel safe, or a relationship with a violent or
aggressive component?


Do you drink? If not, what is the frequency, duration, quantity? Where are the drink(s) located in your home?
Are they accessible to the children?

Any other concerns you like to share that are not covered?


CHILD FUNCTIONING AND DEVELOPMENT

Child:     Goodnight-Ralidak, Aidan, W. (103285922)
Describe how the child functions on a daily basis. Describe the child’s general
behavior, temperament and physical capacity.
ELORA: Elora stated she loves to watch youtube such as Ben, like school because of reading and stated she is
in 4th grade. Elora stated she loves recess and doing math.
Aidan: Aidan stated he is 8 years old, loves playing with Godzilla toys, good at math, writing and reading and
stated he loves to play baseball and hockey.
RAINA: Raina stated she is 6 years old, loves to play with her toys and stated she loves her doll. During IFF,
Raina was very active and playing in her room.

CHILD FUNCTIONING:
ELORA: 4th grade, behind in reading, writing, math and stated has a tutor for math next week. Elora is highly
emotional, has struggles with friendship, Elora likes chapter book, and stated she loves to be recognized and is
very codependent. Elora has turned 9, and very spiritual but also is ambitiousand loves to do pranks.
AIDAN: loves sports, Godzilla, caring soul, emotional bear and is very involved in church. Aidan helps other at
baseball and is involved in hockey right now. Aidan Is a comedy sketch then loves to laugh and make voices.
Aidan is daddy's boy and it takes him time to express himself. Aidan is about to enter third grade, and loves to
read, write and do math. Aidan lashes out in anger, but he loves to go to the creek and fish for stuff.
RAINA: 6 year old, has the biggest personality, hilarious with her jokes and is beyond wise for her age. Know
what she can do and where she has to say the right stuff. Raina loves to sing, act, and play just dance. Raina
loves to be happy with friends, and has tons of confidence. Raina is doing good in school but she is disruptive
and likes to throw things. Monica stated the school emails weekly for Raina.

Child:     Goodnight-Ralidak, Elora, L. (103285921)
Describe how the child functions on a daily basis. Describe the child’s general
behavior, temperament and physical capacity.
ELORA: Elora stated she loves to watch youtube such as Ben, like school because of reading and stated she is
in 4th grade. Elora stated she loves recess and doing math.



FAR Family Assessment                            Case Name (Case ID)                                  Page 7 of 10
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000033
Aidan: Aidan stated he is 8 years old, loves playing with Godzilla toys, good at math, writing and reading and
stated he loves to play baseball and hockey.
RAINA: Raina stated she is 6 years old, loves to play with her toys and stated she loves her doll. During IFF,
Raina was very active and playing in her room.

CHILD FUNCTIONING:
ELORA: 4th grade, behind in reading, writing, math and stated has a tutor for math next week. Elora is highly
emotional, has struggles with friendship, Elora likes chapter book, and stated she loves to be recognized and is
very codependent. Elora has turned 9, and very spiritual but also is ambitiousand loves to do pranks.
AIDAN: loves sports, Godzilla, caring soul, emotional bear and is very involved in church. Aidan helps other at
baseball and is involved in hockey right now. Aidan Is a comedy sketch then loves to laugh and make voices.
Aidan is daddy's boy and it takes him time to express himself. Aidan is about to enter third grade, and loves to
read, write and do math. Aidan lashes out in anger, but he loves to go to the creek and fish for stuff.
RAINA: 6 year old, has the biggest personality, hilarious with her jokes and is beyond wise for her age. Know
what she can do and where she has to say the right stuff. Raina loves to sing, act, and play just dance. Raina
loves to be happy with friends, and has tons of confidence. Raina is doing good in school but she is disruptive
and likes to throw things. Monica stated the school emails weekly for Raina.

Child:     Goodnight-Ralidak, Raina, S. (103285923)
Describe how the child functions on a daily basis. Describe the child’s general
behavior, temperament and physical capacity.
ELORA: Elora stated she loves to watch youtube such as Ben, like school because of reading and stated she is
in 4th grade. Elora stated she loves recess and doing math.
Aidan: Aidan stated he is 8 years old, loves playing with Godzilla toys, good at math, writing and reading and
stated he loves to play baseball and hockey.
RAINA: Raina stated she is 6 years old, loves to play with her toys and stated she loves her doll. During IFF,
Raina was very active and playing in her room.

CHILD FUNCTIONING:
ELORA: 4th grade, behind in reading, writing, math and stated has a tutor for math next week. Elora is highly
emotional, has struggles with friendship, Elora likes chapter book, and stated she loves to be recognized and is
very codependent. Elora has turned 9, and very spiritual but also is ambitiousand loves to do pranks.
AIDAN: loves sports, Godzilla, caring soul, emotional bear and is very involved in church. Aidan helps other at
baseball and is involved in hockey right now. Aidan Is a comedy sketch then loves to laugh and make voices.
Aidan is daddy's boy and it takes him time to express himself. Aidan is about to enter third grade, and loves to
read, write and do math. Aidan lashes out in anger, but he loves to go to the creek and fish for stuff.
RAINA: 6 year old, has the biggest personality, hilarious with her jokes and is beyond wise for her age. Know
what she can do and where she has to say the right stuff. Raina loves to sing, act, and play just dance. Raina
loves to be happy with friends, and has tons of confidence. Raina is doing good in school but she is disruptive
and likes to throw things. Monica stated the school emails weekly for Raina.

ASSESSMENT RECOMMENDATIONS
Assessment Summary:



INITIAL CONCERN: Therapist reporting concerns of parent Anjali going against clinical recommendation for the
healthy welfare of 9 yr Elora.
Two weeks ago Elora had indicated that a 9 yr girl River Muggli had kissed her. Therapist has requested that
Elora not be around this child River,

IFF/CHILD(REN) INTERVIEW REGARDING ALLEGATIONS:
Elora stated it happened in the past before and stated River had pecked her quick and it wasn't a big kiss. Elora
stated she felt uncomfortable and stated she told her mom right away and situation was cared for. Elora has
stated no concerns since then.


FAR Family Assessment                           Case Name (Case ID)                                 Page 8 of 10
DCYF 10-474 (02/2019) INT/EXT               Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000034
PARENT INTERVIEW REGARDING ALLEGATIONS:
Matthew stated he is not aware of what has happened but stated an incident of the friend and Elora had
happened in the past. Monica stated she has only heard from Matt and heard from Elora that she has told them
she has never touched anyone like this. Matt stated they have talked to Elora about touching and what is
appropriate and what is not. Monica stated there was an incident in the past where on social media Veronica
had posted about it. Matt stated King County sheriffs office was involved but stated all visits between Elora and
her friends are limited and safe.

Veronika stated Elora is in therapy now and stated she told Anjali on Tuesday that she has to call CPS for a
report. Veronika stated a similar situation like this happened to Elora in 2019 where it was Dawson's place and
stated the person is at still church. Veronika stated her father Matt still takes her to the same church. Veronika
stated Diana was previous case worker.

COLLATERALS:
SW Dhillon spoke to step grandfather Robert who stated the kids are very safe with both parents
SW Dhillon spoke to Veronika's friend Diana who stated no safety concerns but stated Veronika could slow
things down in order to parent.
SW DHillon reviewed new parenting plan and protection order which stated dad has final decision making for
medical and school and custody is now 50/50.
SW Dhillon reviewed medical record from Compass Health which shows that Elora is going to counseling and
all her medical needs are being met.

SAFETY THREAT(S): Safety threat #17 was determined inactive.

SDM: moderate level.

SERVICES: SW Dhillon emailed Veronika FFT information but never got a response back.

Assessment Recommendation:                                               Recommendation Reason:
Case is Closing                                                          No known needs or safety threats

Explain:


No ongoing safety threats within household. Parents are protective and no sexual assault has occurred. Case is
now being closed.

Present Danger Date:            Present Danger:
07/31/2024                      No Present Danger

Safety Assessment Date:         Safety Decision:                Final Safety Plan:
09/22/2024                      Safe                            No Safety Plan Required



SDM Date: 09/22/2024            SDM Score:     Moderate




FAR Family Assessment                             Case Name (Case ID)                                 Page 9 of 10
DCYF 10-474 (02/2019) INT/EXT                 Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000035
INDIVIDUAL OBJECTIVES ACHIEVED/HISTORICALGalarneau, Monica (104669771)
Start Date:                     Target End Date:
Objective:
null

INDIVIDUAL OBJECTIVES ACHIEVED/HISTORICALGoodnight, Veronika, E. (103285911)
Start Date:                     Target End Date:
Objective:
null

INDIVIDUAL OBJECTIVES ACHIEVED/HISTORICALRalidak, Matthew (103285924)
Start Date:                     Target End Date:
Objective:
null




FAR Family Assessment                      Case Name (Case ID)                 Page 10 of 10
DCYF 10-474 (02/2019) INT/EXT          Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000036
                                                      Investigative Assessment
                                                           CPS Risk Only
                                                       Assessment ID: 73841010
                                                 Completion Date: 11/25/2024 10:47 AM

 Case:      Muggli, Diana R (3511494)
Worker:     CLARK, SEAN D.
Office:     King East DCFS                                                Provider Type:
PARTICIPANTS
                 AP=Alleged Perpetrator; CL=Client; CO=Collateral; CS=Courtesy Supervisor; HM=Household Member; IC=Identified Child; IN=Intake
Roles:           Name; NM=Non-Household Member; PR=Parent/Parental Role; ST=Staff; SB=Subject; V=Victim; WT=Witness



RCW 13.50.100(7)(c)                                                                                        Roles:     RF




 Name: Goodnight, Veronika E.                              Gender:       Female                            Roles:     CO
 Ethnicity: Not Hispanic/Latino                            Date of Birth:    02/15/1982
 Race: White/Caucasian                                     Primary Language:     English

 Name: Goodnight-Ralidak, Elora L.                         Gender:       Female                            Roles:     CO
 Ethnicity: Not Hispanic/Latino                            Date of Birth:    03/21/2015
 Race: White/Caucasian                                     Primary Language:     English

 Name: Muggli, Diana R. (104806895)                        Gender:       Female                            Roles:     HM, IN, PR
                                                                                  RCW 13.50.10
 Ethnicity:                                                Date of Birth:                   /1987
 Race:                                                     Primary Language:               English
          RCW 13.50.100
 Name:                    River Q. (104806896)             Gender:       Female                            Roles:     HM, IC
                                                                                  RCW 13.50.10
 Ethnicity:                                                Date of Birth:                   /2014
 Race:                                                     Primary Language:               English
          RCW 13.50.100
 Name:                    Mirko B. (104807914)             Gender:       Male                              Roles:     HM, PR
                                                                                  RCW 13.50.10
 Ethnicity:                                                Date of Birth:                   /1982
 Race:                                                     Primary Language:               English
          RCW 13.50.100
 Name:         Finn S. (104808903)                         Gender:       Male                              Roles:     HM, IC
                                                                                  RCW 13.50.10
 Ethnicity: Unable to determine                            Date of Birth:                   /2017
 Race:                                                     Primary Language:               English




SM06 investigative Assessment                           Case (ID): Muggli, Diana R (3511494)                                        Page 1 of 7
          Goodnight, Veronika
          202504-PRR-349
          DCYF - 000037
GATHERING QUESTIONS
Describe the nature and extent of maltreatment.
Department received report that it was reported that River (10) molested a child outside the home. There is currently
another child living in the home with River.
Sequence of Events: What surrounding circumstances accompany the maltreatment?
River: When asked what she thought SW was there to talk to her about, River stated that she believed Elora told someone
that River had tried to kiss her. When asked to talk more about that, River could not recall very much information about it,
including when it occurred, but stated that she was pretty sure it was a joke. When asked about body rules, River defined
them as "not touching people without permission, not inappropriately touching others, and keeping appropriate personal
space between others. River did not disclose that she had ever been inappropriately touched by someone else. River
defined safe as being at home with her family near her or feeling protected, and stated that she felt safe at her home and
with her parents.

Finn: When asked to define what the world safe meant, he indicated it meant to feel protected, an that he felt safe at home
and with his parents. When asked to define body rules, Finn stated that it was important to be respectful of people space,
and that its ok to ask if someone before you give them a hug if they're angry or sad. Finn did not disclose that he had ever
been inappropriately touched by someone else.

FA: SW spoke with Mirko, who indicated he had been informed of the report by Veronika Goodnight on 07/29/24, and that
he had briefly spoken to River about it. He stated that River informed him that it was meant to be a joke, and she couldn't
remember when it happened. Mirko was surprised by the report, as he stated that River is not a very touchy person. SW
explained to Mirko the importance of supervision when the girls are playing together, and he informed SW that he has
spoken with Veronika about taking a break from play days with the girls for a while. Mirko stated that they had been very
open with educating River on sexual touch, and that she has no access to inappropriate content or porn.

MO: SW spoke with Diana over the phone, after not making contact with her at her home. Diana indicated that she was
surprised by CPS involvement, as she believed that Elona Ralidak had made up reported of unwanted touch and kissing in
the past. SW explained the process of the investigation and Diana was cooperative with SW and agreed to meet to
complete interviews on 8/1/24.




RCW 13.50.100



SM06 investigative Assessment                  Case (ID): Muggli, Diana R (3511494)                             Page 2 of 7
          Goodnight, Veronika
          202504-PRR-349
          DCYF - 000038
RCW 13.50.100
                                                                                     so
                                                                                     e
                                                                                     e




                                                                                     if




                                                                                     y


                                                                                     d




SM06 investigative Assessment   Case (ID): Muggli, Diana R (3511494)   Page 3 of 7
          Goodnight, Veronika
          202504-PRR-349
          DCYF - 000039
RCW 13.50.100




SM06 investigative Assessment   Case (ID): Muggli, Diana R (3511494)   Page 4 of 7
          Goodnight, Veronika
          202504-PRR-349
          DCYF - 000040
RCW 13.50.100

INVESTIGATIVE DETAILS
Narrative describing facts obtained from Investigation and sources used to verify.
INITIAL CONCERN: 7/31/2024: Allegation that River (10) molested a child outside the home. There is currently another
child living in the home with River.

IFF/CHILD(REN) INTERVIEW REGARDING ALLEGATIONS:
River: When asked what she thought SW was there to talk to her about, River stated that she believed Elora told someone
that River had tried to kiss her. When asked to talk more about that, River could not recall very much information about it,
including when it occurred, but stated that she was pretty sure it was a joke. When asked about body rules, River defined
them as "not touching people without permission, not inappropriately touching others, and keeping appropriate personal
space between others. River did not disclose that she had ever been inappropriately touched by someone else. River
defined safe as being at home with her family near her or feeling protected, and stated that she felt safe at her home and
with her parents.

Finn: When asked to define what the world safe meant, he indicated it meant to feel protected, an that he felt safe at home
and with his parents. When asked to define body rules, Finn stated that it was important to be respectful of people space,
and that its ok to ask if someone before you give them a hug if they're angry or sad. Finn did not disclose that he had ever
been inappropriately touched by someone else.

PARENT INTERVIEW REGARDING ALLEGATIONS:
SW spoke with Mirko, who indicated he had been informed of the report by Veronika Goodnight on 07/29/24, and that he
had briefly spoken to River about it. He stated that River informed him that it was meant to be a joke, and she couldn't
remember when it happened. Mirko was surprised by the report, as he stated that River is not a very touchy person. SW
explained to Mirko the importance of supervision when the girls are playing together, and he informed SW that he has
spoken with Veronika about taking a break from play days with the girls for a while. Mirko stated that they had been very
open with educating River on sexual touch, and that she has no access to inappropriate content or porn.

SW spoke with Diana over the phone, after not making contact with her at her home. Diana indicated that she was
surprised by CPS involvement, as she believed that Elona Ralidak had made up reported of unwanted touch and kissing in
the past. SW explained the process of the investigation and Diana was cooperative with SW and agreed to meet to
complete interviews on 8/1/24.

COLLATERALS:

School reports not having any concerns until this incident. Counselor reports that children come in well dressed. Both
collaterals report that both parents have individual therapy. River also attends individual therapy. It appears that the divorce
affected both parents. They have no concerns about their parenting practices.

SAFETY: The assessment is being submitted for closure due to there being no immediate safety threats and no present

SM06 investigative Assessment                   Case (ID): Muggli, Diana R (3511494)                               Page 5 of 7
          Goodnight, Veronika
          202504-PRR-349
          DCYF - 000041
danger at this time.

SAFETY THREAT(S): Safety threat [#10] was determined [ inactive]. Both parents appear protective and talked to children
about appropriate touching.

SDM:Mod

SERVICES:N/A parents are doing individual counseling and River is also attending individual counseling.

FILE UPLOADS:
IIR

Domestic Violence: None
Period of Purple Crying: N/A
Safe Sleep: N/A
ICWA: N/A
CA-N/Interviewing Children/Use of Force: Yes
Consent Form: N/A

CONTACTS
                                                                                                  Date/Time    Date/Time
Activity                            Participant                       Location                    Occurred     Created
Contact - Collateral                Muggli, Diana R.            Parental Home                     11/14/2024   11/20/2024
                                    (104806895)                                                   01:00 AM     04:44 PM
Contact - Collateral                Muggli, Mirko B.            By Phone                          11/22/2024   11/22/2024
                                    (104807914)                                                   11:30 AM     12:33 PM
Child - Initial Face to Face with   Muggli, River Q.            Parental Home                     07/31/2024   07/31/2024
Child                               (104806896)                                                   10:00 AM     02:08 PM
Contact - Education                 Muggli, River Q.            School                            10/31/2024   11/21/2024
                                    (104806896)                                                   11:45 AM     04:53 PM
Health and Safety Monitoring        Muggli, River Q.            School                            10/31/2024   11/12/2024
Visit (CA Social Worker)            (104806896)                                                   11:45 AM     03:30 PM
Health and Safety Monitoring        Muggli, Finn S. (104808903) School                            10/31/2024   11/12/2024
Visit (CA Social Worker)                                                                          11:45 AM     03:30 PM
Child - Initial Face to Face with   Muggli, Finn S. (104808903) Parental Home                     07/31/2024   07/31/2024
Child                                                                                             10:00 AM     02:08 PM
Parent/Guardian Contact             Muggli, Diana R.            By Phone                          07/31/2024   07/31/2024
                                    (104806895)                                                   10:00 AM     02:08 PM
Parent/Guardian Contact             Muggli, Mirko B.            Parental Home                     07/31/2024   07/31/2024
                                    (104807914)                                                   10:00 AM     02:08 PM
Parent/Guardian Contact             Muggli, Mirko B.            By Phone                          11/05/2024   11/05/2024
                                    (104807914)                                                   12:00 PM     02:02 PM
Parent/Guardian Contact             Muggli, Finn S. (104808903) Parental Home                     10/31/2024   11/12/2024
                                                                                                  11:45 AM     03:30 PM
Parent/Guardian Contact             Muggli, Diana R.                  By Phone                    11/07/2024   11/20/2024
                                    (104806895)                                                   11:30 AM     04:29 PM
RECORDS REVIEWED
Type of Record                      Date Reviewed                     Comment
Referral History                    11/22/2024                        Reviewed Families CPS history.
SAFETY ASSESSMENT
Assessment Date                     Safety Decision                   Final Safety Plan
11/22/2024                          Safe                              No Safety Plan Required
PRESENT DANGER
Date Assessed                       Present Danger ID                 Present Danger
11/22/2024                          466022                            No Present Danger




SM06 investigative Assessment                     Case (ID): Muggli, Diana R (3511494)                          Page 6 of 7
           Goodnight, Veronika
           202504-PRR-349
           DCYF - 000042
GENERAL DETAILS
Living Arrangement of the Child(ren)
Two parent household

Family Characteristics/Conditions                                              Developmental Stages
None Observed                                                                  School Age Children


DISPOSITION
Disposition:       Case Closed                                                 SDM Risk Score: Moderate
Explain:
Children did not disclose any concerns. Child reported that it was meant as a joke. Child understands appropriate
touching. Children in the home denied being touched inappropriately. Parents went over appropriate/ inappropriate
touching with their children.
SERVICES
Is the family being referred to ongoing services that require                  Program Type:
                                                                  No
DCYF to monitor?
Reasons services are not being provided to the family by DCYF:
Investigation only: no services needed




SM06 investigative Assessment                 Case (ID): Muggli, Diana R (3511494)                           Page 7 of 7
           Goodnight, Veronika
           202504-PRR-349
           DCYF - 000043
                        DEPARTMENT OF CHILDREN, YOUTH, AND FAMILIES (DCYF)
                                   FAR ASSESSMENT RESPONSE (FAR)
                                 FAR FAMILY ASSESSMENT & CASE PLAN
CASE & PARTICIPANT INFORMATION

Case Name (ID):                                                                               Approval Date:
Goodnight, Veronika (2682764)                                                                 04/08/2025
Parent/Caregiver(ID):                                                  DOB:                   Intake ID:
Galarneau, Monica (104669771)                                          RCW 13.50.100
                                                                                       1985   5619402; 5666738
Goodnight, Veronika, E. (103285911)                                    02/15/1982
Ralidak, Mathew, W. (104669770)                                        RCW 13.50.10
                                                                                  /1986
Child(ren):                                                            DOB:
Goodnight-Ralidak, Aidan, W. (103285922)                               08/16/2016
Goodnight-Ralidak, Elora, L. (103285921)                               03/21/2015
Goodnight-Ralidak, Raina, S. (103285923)                               06/03/2018


Social Service Specialist:                        Email:                                      Phone:
Pearson, Gracey (101599922)                       gracey.pearson@dcyf.wa.gov                  (425) 515-5925

INITIAL ENGAGEMENT QUESTIONS
Did you discuss the FAR Intervention with the family and provide written information?                  Yes

Did the family agree to participate in the FAR Intervention?                                           Yes

Explain:
SW Pearson provided both FO and MO the FAR paperwork and both parties agreed to participate.


CURRENT NEEDS AND CHALLENGES

Describe the Nature and Extent of the Situation that brought the family to the Department’s attention.
Referrer reports the parents have split custody and the kids had been with Mom all week, but they are now with
Dad. When Raina came to school today, she was falling asleep in class and complained of a headache and
said Mom slapped her pocket and her cheek and when she slapped her she pushed her into the hall. Ref asked
Raina what she hit her head on and she said the floor. Raina said her Mom checked her head and said there
was no bump and she needed to go to sleep.

Concern:
Referrer reports the parents have split custody and the kids had been with Mom all week, but they are now with
Dad. When Raina came to school today, she was falling asleep in class and complained of a headache and
said Mom slapped her pocket and her cheek and when she slapped her she pushed her into the hall. Ref asked
Raina what she hit her head on and she said the floor. Raina said her Mom checked her head and said there
was no bump and she needed to go to sleep.

Raina said she couldn't go to sleep and this morning, Mom said they didn't have time for breakfast, so she
came without eating. Ref stated she has come without breakfast previously when she is with Mom.

She complained of a headache all day and saw the School Nurse who noted no signs of concussion. Ref did


FAR Family Assessment                            Case Name (Case ID)                                      Page 1 of 12
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000044
not observe any marks or bruising.

*******************************************************************************************************************
REPORT FROM SCHOOL:

CUT AND PASTED NARRATIVE FROM REPORT C25010391

On April 4, 2025, I was dispatched at 1445 hours for a reported DV threats call at Carnation Elementary School,
4950 Tolt Ave.
RP-1 Matthew Ralidak and S-1 Veronika Goodnight are divorced. Ralidak and Goodnight have three children in
common, V-1 Raina Goodnight-Ralidak (6 yrs old), O-2 Elora Goodnight-Ralidak (8 yrs old), O-3 Aidan
Goodnight-Ralidak (10 yrs old).

O-4 Colin Derieg and Goodnight are currently dating.
O-6 Monica Galarneau and Ralidak are currently married.
O-5 Michelle Frank is the current principal for Carnation Elementary.

Ralidak informed me of the following:
He currently has a tense relationship with Goodnight. They currently share their children 50/50 according to
their parenting plan. Ralidak informed me that there is an open CPS case involving Goodnight, a man she is
living with, and RGR. Ralidak stated that according to RGR, Goodnight was making her kiss this man. Ralidak
did not have any other information about this CPS case.

While waiting, in his car, in line to pick up his children from school. At approximately 1358 hours Goodnight
approached Ralidak's car and started yelling at him. Goodnight was accusing Ralidak of calling CPS on her.
Goodnight continued yelling and asking Ralidak questions about the children and Goodnight's new living
arrangements. At some point Ralidak noticed Derieg standing beside his car staring at him. Goodnight then
went into the school office and back out toward Ralidak's car. During this time Ralidak had called into the
school's office and told the principal, Frank, and another administrator about the odd behavior and scene
Goodnight was making.

Frank then came outside to speak with Goodnight. At approximately 1412 hours Goodnight and Derieg got into
a maroon Chevy Silverado and left the school parking lot. Ralidak clarified that no threats were ever made by
Goodnight or Derieg. Ralidak stated he felt intimidated by Derieg standing outside his car staring at him. While
sharing the details of this incident Ralidak seemed visibly shaken and needed to take breaks, while talking with
me, to hold back tears. All three children were not present during this incident.

As I was leaving Ralidak showed me a text from Galarneau, who currently had all three children. Galarneau
said that all three children had told her that Goodnight had slapped RGR and slammed her against a wall.
Ralidak thought this might be retaliation because RGR had planned to tell Goodnight she no longer wanted to
live with her. Ralidak did not mention any marks or bruises on RGR when he had seen her at the school pickup.
The text from Galarneau did not describe any injuries on RGR. Ralidak and Galarneau have all three children
over the weekend. Ralidak said he is worried for his children's safety and wasn't sure what to do. I gave Ralidak
the case number and informed him that he should get in touch with a lawyer and ask about getting a protection
order if he is feeling this way.

Frank had informed me of the following:
The office had received a call from Ralidak, so Frank and another administrator had gone outside to see what
was going on. Frank spoke with Goodnight and told her "This isn't the place", in reference to not handling
parenting issues on school grounds. Frank stated this is not the first time that Goodnight has caused a
commotion or interrupted the children's learning process.
Frank then informed me that RGR had told her 1 grade teacher that her mother, Goodnight, had slapped her so
hard she was thrown into the wall. Frank stated RCW 13.50.100(7)(c) was in the process of reporting this incident to CPS.

I reviewed footage taken by Ralidak and the school security footage. The footage showed Goodnight
approaching Ralidak's car. Then it looked like Goodnight had started yelling at Ralidak. It then showed Derieg
standing a few feet away from the vehicle, staring inside. It did not appear that Derieg or Goodnight made any


FAR Family Assessment                                 Case Name (Case ID)                                        Page 2 of 12
DCYF 10-474 (02/2019) INT/EXT                     Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000045
threatening gestures. Ralidak remained in his car during the entire incident. There was no audio to the footage.

I sent Ralidak an evidence.com link to upload the footage he has and a screenshot of texts about the slapping
incident. Ralidak is also in the process of obtaining the school's security camera footage.

Sequence of Events: Describe the surrounding circumstances that led to the family assessment.
PER MO: MO reported that she does feed her children (showed SW during home walk through food, and
doctor's notes to confirm this) and that her children eat 'healthy foods' and that she provides enough food for
them along with following doctor's orders (uploaded on famlink). MO reported that all children are up to date on
PCP and have been seen at the doctor as they all eat certain foods while they spend time with MO. MO
reported that she does not know what they eat when they are with their father (every other week) but that she
denies restricting the children's food intake.


SW Pearson contacted MO via phone per additional concerns regarding the children reporting to be
unconformable with new living situation in a trailer and that their 'grandpa' is making Raina uncomfortable/trying
to kiss her on the mouth. SW Pearson explained to MO that these were the concerns along with the unsteady
living environment for the children as SW Pearson was told by MO that when MO has the children, they are
staying at Collin's home in which SW did a HWT along with interview with no safety concerns. MO reported that
she was upset that these allegations were being called in and reported that she was at the school, saying
goodbye to her children.MO reported that her bestfriend and another close family friend are where MO is
planning on staying with eventually as the commute to the children's school from Collin's home in Monroe is
difficult. SW observed that MO was speaking to Collin in the background and SW observed that MO was
becoming upset as she reported to have seen FO in the parking line. MO reported to Collin that she may go
over there to insist that FO stops calling reports in. SW asked MO who she was speaking to, MO confirmed that
it was Collin, and MO reported that she was extremely upset. MO then reported that she knows that FO called
in a report and SW Pearson explained that the reporter will remain confidential but if MO is able to provide
name/address of where she is living, SW can complete safety assessment to address the concerns. MO
reported that she will do this. Then the phone call ended.

PER FO: FO reported that MO does not feed the children and has them on strict diets despite FO taking them
to the doctor reporting that there is not a need for a specific diet.

SW Pearson spoke to FO on the phone regarding new concerns about MO having the children stay in a trailer
with an unknown person and FO provided their names as 'Jim Solberg and Nathan 'Kanis' Solberg. FO reported
that Raina specifically has voiced that these men have tried to kiss her on the mouth and make Raina
uncomfortable. FO did not have more information regarding the whereabouts of the Trailer and reported that
MO's previous partner, Collin have broken up therefore leading FO to not know where the children are located
when the children are in MO's care.

PER COLLIN: Collin reported that the children are on 'special diets' per doctor's orders but that Collin does not
have any concerns regarding what the children are eating. Collin reported that MO has these doctor's orders for
the children to eat certain foods and then the children go to their FO's home where there are 'no regulations
and that Collin reports that there might be a hard time transitioning from households.

PER MONICA: Monica reported that all children have reported that when 'mommy gets out of control' the
children must calm there mom down and that they are worried about what will happen when mom gets mad.
Monica reported that all children have reported that they get spanked, cursed at, and smacked across the face.
Monica reported that Raina therapists have disclosed that MO's now ex-fianc had 'laid hands on the children's.
Monica reported that the children have reported that mom and Collin are no longer together. Monica reported
that FO had tried to get full custody of the children but that the judge reported that MO is a 'beautiful young
woman' which led to 50-50 custody. Monica reported that she is extremely frustrated with the system because
FO needs to have at least 50-50 custody and that as of now, Monica and FO are working to document
everything to get full-custody of the children.
UNMET NEEDS: Monica reported that the children do not have consistent housing due to MO posting this on
social media, and that food has been taken away from the children as punishment. Monica reported that MO



FAR Family Assessment                            Case Name (Case ID)                                 Page 3 of 12
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000046
needs MH care/support. Monica reported that MO is not working at this time.

PER CHILDREN:
RAINA (6): Raina reported that she gets fed more at her dad's than with her mom.
AIDEN (8): Aiden reported that he feels safe with MO but that he doesn't get as much food with MO as he does
with dad because MO says that some foods are not good for him.
ELORA (10): Sometimes Elora reported that she has to cook her own food when she's at her moms, Elora
reported that sometimes that she has enough food but sometimes he doesn't.




PER CHILDREN FOR MOST RECENT INTAKE:
 Aiden reported that MO did hurt Raina (6) but that he didn't want to talk about it. Aiden reported that SW should
as Raina.

Elora reported that MO wants to move into an RV and that it is too small. Elora reported that the other adult
around but not in the RV with the family is 'Uncle Canny' who is MO's best friend. Elora reported that the RV is
on a farm.


SW observed that Raina was not willing to speak with SW as Raina was hiding under her bed and behind
Monica and/or FO when SW asked her to speak with her. Raina reported that she only would speak to SW if
FO could come with her. SW observed that FO was willing to be with Raina while speaking with SW. SW, FO
and Raina went into Raina's room and FO sat on the bed with Raina. SW attempted to ask Raina questions, but
she did not want to speak with SW. SW was able to do a body check to see that Raina was free of
marks/bruising. Raina did show SW a mark on her chest that was the size of a pencil mark and reported that
MO scratched me. Raina was hiding under the covers thus not allowing a full interview to be completed.


CONVERSATION WITH FO/Monica PER RECENT INTAKE:



SW spoke to FO outside the home. FO reported that he was upset post Friday (documented in famlink) as MO
and Dr. Collin harassed him at school. FO showed SW Pearson the video of Collin making a gun symbol at FO
at the school and FO reported to have his legal rep on the phone when SW Pearson arrived as FO is working to
document all of this. FO reported that he understands that SW Pearson is separate from family court. FO
reported thanked SW Pearson for being receptive and reported that he will keep SW updated. SW Pearson
reported that she spoke to her SUP and that SW Pearson will keep FO updated once the case is closed so he
can have further documentation of this period per multiple intakes. Monica then came out of the home as SW
was leaving to report to SW that Raina is having a tantrum now and that she is reporting that she is scared
because MO told all of the children not to speak to CPS. FO thanked SW Pearson again and SW left the home.

FAMILY DEVELOPMENTAL STAGES AND TASKS

Family Developmental Stages:
School Age Children

Military Family:
No longer active military

Describe the family’s composition and cultural factors.

ICWA: denied.



FAR Family Assessment                            Case Name (Case ID)                                 Page 4 of 12
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000047
MO and FO have 50/50 custody of their 3 children.
Elora Goodnight-Ralidak - 10
Aiden Goodnight-Ralidak - 8
Raina Goodnight-Ralidak - 6

MO and Collin are living together.
FO and Monica are married/parenting together.

Describe the everyday life task(s) that contribute to the situation.
Referrer reports the parents have split custody and the kids had been with Mom all week, but they are now with
Dad. When Raina came to school today, she was falling asleep in class and complained of a headache and
said Mom slapped her pocket and her cheek and when she slapped her she pushed her into the hall. Ref asked
Raina what she hit her head on and she said the floor. Raina said her Mom checked her head and said there
was no bump and she needed to go to sleep.
Describe what the family has done to keep the child(ren) safe and healthy in the past and the resources
used.

PER both MO AND FO: Both parents have the children attend school regularly and are up to date on PCP.

Parenting Practices

Describe how each parent disciplines the child(ren).


PER MO: MO reported that the children and herself implement the '5 to 1' ratio meaning that 1 wrongdoing
means you have to do 5 good things. MO reported that MO and her children work together to understand that
they do not have control over the outside world but that they do have control over their own actions. MO
reported that she does EFT tapping with the children to regulate their emotions. MO reported that she believes
her discipline is impactful. MO reported that she denies any physical form of discipline.

PER FO:
SW Pearson spoke to FO on the phone regarding new concerns about MO having the children stay in a trailer
with an unknown person and FO provided their names as 'Jim Solberg and Nathan 'Kanis' Solberg. FO reported
that Raina specifically has voiced that these men have tried to kiss her on the mouth and make Raina
uncomfortable. FO did not have more information regarding the whereabouts of the Trailer and reported that
MO's previous partner, Collin have broken up therefore leading FO to not know where the children are located
when the children are in MO's care.

SW spoke to FO outside the home. FO reported that he was upset post Friday (documented in famlink) as MO
and Dr. Collin harassed him at school. FO showed SW Pearson the video of Collin making a gun symbol at FO
at the school and FO reported to have his legal rep on the phone when SW Pearson arrived as FO is working to
document all of this. FO reported that he understands that SW Pearson is separate from family court. FO
reported thanked SW Pearson for being receptive and reported that he will keep SW updated. SW Pearson
reported that she spoke to her SUP and that SW Pearson will keep FO updated once the case is closed so he
can have further documentation of this period per multiple intakes. Monica then came out of the home as SW
was leaving to report to SW that Raina is having a tantrum now and that she is reporting that she is scared
because MO told all of the children not to speak to CPS. FO thanked SW Pearson again and SW left the home.


PER MONICA: Monica reported that when the children are with FO and Monica, the children can eat whatever
they want, and that they can eat when they are hungry. Monica reported that in working with the children's
therapist, FO and Monica have been working with the children to eat some junk food as they are allowed to be
children. Monica reported that MO has had children on certain diets and sometimes not. Monica reported that
she is confused about why/what the diets are for the children when they are with MO. Monica reported that
there have been arguments with the school due to diagnosis's ODD leading to dietary restrictions. Monica
reported that MO is 'Yucka' app that shows if the 'food is good or bad'. Monica reported that MO will take food


FAR Family Assessment                             Case Name (Case ID)                               Page 5 of 12
DCYF 10-474 (02/2019) INT/EXT                 Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000048
away as punishment.
PER COLLIN: Collin reported that MO will put the children in time outs, Collin denies any form of physical
discipline, and that the children are expected to do their homework and to eat healthy if they are going to have
any sweets, they need to finish their food first.

PER CHILDREN:

ELORA: FO: Elora reported that when she is with her dad, she has to be respectful and if she says a bad word
she might be sent to her room but that doesn't happen often.
MO: Elora reported that MO wants Elora and her siblings to comfort MO when she is upset, be respectful and
that MO slaps/spanks the kids when they don't follow the rules. Elora reported that she doesn't like when MO
slaps/spanks her, but that Raina (6) usually gets slaps the most.

RAINA: SW observed that Raina was not willing to speak with SW as Raina was hiding under her bed and
behind Monica and/or FO when SW asked her to speak with her. Raina reported that she only would speak to
SW if FO could come with her. SW observed that FO was willing to be with Raina while speaking with SW. SW,
FO and Raina went into Raina's room and FO sat on the bed with Raina. SW attempted to ask Raina questions,
but she did not want to speak with SW. SW was able to do a body check to see that Raina was free of
marks/bruising. Raina did show SW a mark on her chest that was the size of a pencil mark and reported that
MO scratched me. Raina was hiding under the covers thus not allowing a full interview to be completed.

AIDEN: FO: Aiden reported that at dad's house he has a certain bedtime routine and that he needs to be
respectful. Aiden reported that if he doesn't follow the rules at dad's home, he goes to his room but that this
does not happen often.
MO: Aiden reported that MO expects him and his sisters to be respectful and to not fight. Aiden reported that
MO does slap his sister's more than him and that MO spanks them on the butt when they do not follow the
rules. Aiden showed SW Pearson and open hand to give a visual for SW Pearson when MO disciplines him and
Aiden's sisters.

What are the overall parenting practices used by the parent?


PER MO:
PER FO:



PER MONICA: Monica reported that Matthew is good at communicating and that it has improved over the
years. Monica reported that Matthew is a fun and loving dad. Monica reported that Matthew is good at talking to
the children and their emotions. Monica reported that Matthew struggles with ADD and has reading issues so
Matthew interprets questions which may lead to Matthew misunderstanding situations. Monica reported that
Matthew had been working to become more patient with both Monica, herself along with the children.


PER COLLIN: MO: Collin reported that MO is a very loving mom, supportive, and kind. Collin reported that MO
is a very kind mom that supports her children and implements positive partnering.

FO: Collin reported that he has not had any interactions with FO and 'cannot speak to his parenting'.

PER CHILDREN:

ELORA: FO: Elora reported that she likes spending time with her dad and that he is nice/fun to be around.
MO: Elora reported that MO is okay but that she does hit her and her siblings sometimes. Elora reported that
she doesn't want to be with MO in the RV. Elora reported that she doesn't understand why MO wants to move
into the RV because it's small.




FAR Family Assessment                            Case Name (Case ID)                                 Page 6 of 12
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000049
RAINA:

SW observed that Raina was not willing to speak with SW as Raina was hiding under her bed and behind
Monica and/or FO when SW asked her to speak with her. Raina reported that she only would speak to SW if
FO could come with her. SW observed that FO was willing to be with Raina while speaking with SW. SW, FO
and Raina went into Raina's room and FO sat on the bed with Raina. SW attempted to ask Raina questions, but
she did not want to speak with SW. SW was able to do a body check to see that Raina was free of
marks/bruising. Raina did show SW a mark on her chest that was the size of a pencil mark and reported that
MO scratched me. Raina was hiding under the covers thus not allowing a full interview to be completed.
AIDEN: FO: Aiden reported that at his dad's house he gets to eat when he wants, plays a lot and that he loves
to spend time with his dad.
MO: Aiden reported that he likes his mom but that she can be scary sometimes. Aiden reported that he is
expected to be nice to his mom even when he didn't do anything wrong.

Family Support

Describe the family’s support system.


MO reported to have a support system via community, family members/freidsn and her boyfriend Dr. Collin.

FO reported that his support is the school and his wife Monica.


INDIVIDUAL ADULT PATTERNS OF BEHAVIOR

Parent/Caregiver:       Galarneau, Monica (104669771)
How does the parent manage his/her own life on a daily basis? How does the parent function on a daily
basis?
PER MO: MO reported that Monica is Fo's new wife and did not speak to her parenting practices.


PER FO: FO reported that Monica is a form of support for him and the children as they are married.

PER COLLIN: n/a.

PER MONICA: Monica reported that she helps Matthew with taking the children to school and does her best to
support each child for their own needs during this difficult time with FO/MO custody battle.

INDIVIDUAL ADULT PATTERNS OF BEHAVIOR

Parent/Caregiver:       Goodnight, Veronika, E. (103285911)
How does the parent manage his/her own life on a daily basis? How does the parent function on a daily
basis?
PER MO:

PER MO: Monica reported that she does not communicate with Veronika and does not contact Monica. Monica
reported that she had met Veronika a couple of times prior to Matthew and Monica started dating. Monica
reported that Veronika accused Monica of having an affair with Matthew even though Monica and Matthew
were not dating prior to Veronika and Matthew separating. Monica reported that Veronika had reached out to
her during 2020 as Veronika reported that Matthew was abusing Veronika, and that Veronika had a plan to flee
from Matthew. Monica reported that this was her first interaction with Veronika.
Monica reported that she observed that MO yells a lot with the children and that Monica observed that MO did
not take very well of the children. Monica reported that she observed MO yelling at the children at events, over
facetime while at Matthew's house, and that the children have disclosed that MO gets upset when Monica is
around the children.


FAR Family Assessment                            Case Name (Case ID)                                 Page 7 of 12
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000050
PER CHILDREN:
MO: Aiden reported that he likes his mom but that she can be scary sometimes. Aiden reported that he is
expected to be nice to his mom even when he didn't do anything wrong.

MO: Elora reported that MO is okay but that she does hit her and her siblings sometimes. Elora reported that
she doesn't want to be with MO in the RV. Elora reported that she doesn't understand why MO wants to move
into the RV because it's small.

INDIVIDUAL ADULT PATTERNS OF BEHAVIOR

Parent/Caregiver:       Ralidak, Mathew, W. (104669770)
How does the parent manage his/her own life on a daily basis? How does the parent function on a daily
basis?
PER MO:
MO reported that FO and herself separated due to 'violent behaviors and that FO can be 'a little rough'. MO
reported that she had to flee their relationship due to DV, but that MO reported that FO does love his children.
MO reported that FO has 'narcissistic tendencies'. MO reported that MO does not talk bad to the children about
their father. MO reported that she refers to the therapist when the children come to MO in regards to their
father. MO reported that the last CPS call was when the children were in his care, and that they go to an unsafe
church (per previous intake). MO reported that the children will report that FO will only send the children to their
room but that MO does not want to interfere with FO's parenting practices.

PER FO: FO: Aiden reported that at his dad's house he gets to eat when he wants, plays a lot and that he loves
to spend time with his dad.

PER COLLIN: Collin reported that he has not had any interactions with FO and 'cannot speak to his parenting'.



PER MONICA: PER FO: Monica reported that Matthew is good at communicating and that it has improved over
the years. Monica reported that Matthew is a fun and loving dad. Monica reported that Matthew is good at
talking to the children and their emotions. Monica reported that Matthew struggles with ADD and has reading
issues so Matthew interprets questions which may lead to Matthew misunderstanding situations. Monica
reported that Matthew had been working to become more patient with both Monica, herself along with the
children.
PER CHILDREN:


FO: Elora reported that she likes spending time with her dad and that he is nice/fun to be around.

CHILD FUNCTIONING AND DEVELOPMENT

Child:     Goodnight-Ralidak, Aidan, W. (103285922)
Describe how the child functions on a daily basis. Describe the child’s general
behavior, temperament and physical capacity.
PER FO: FO reported that Aiden is a good kid and that he loves to spend time with him.


AIDEN (8): MO reported that Aiden is very smart, can be lazy with homework, put through special testing at the
school' and that Aiden 'learns a different way (could be ADHD) but that Aiden is in the process of getting
evaluated for ADHD. MO reported that Aiden is a mommy's boy, and plays sports such as hockey and baseball.


Aidan (8): Collin reported that Aidan is a good kid and that he does not have any concerns for him.


FAR Family Assessment                             Case Name (Case ID)                                  Page 8 of 12
DCYF 10-474 (02/2019) INT/EXT                 Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000051
Raina (6): Collin reported that Raina is a sweet kid but that she may benefit from speech therapy.


Aiden (8): Monica reported that Aiden is quiet at first, loves to observe, and once you find what he is interested
in, he can talk about it forever such as science and dinosaurs. Monica reported that Aiden loves space and
animals. Monica reported that Aiden goes back and forth between being vegetarian because he loves animals,
and that Aiden feels empathetic to other people. Monica reported that Aiden is very sweet and takes really good
care of his sisters. Monica reported that Aiden may have support with the school with reading, but that Aiden is
currently doing testing.

Child:     Goodnight-Ralidak, Elora, L. (103285921)
Describe how the child functions on a daily basis. Describe the child’s general
behavior, temperament and physical capacity.
PER FO: FO reported that Elora is good at taking care of her younger siblings, very active, and is silly.

ELORA (9): MO reported that Elora is going to turn 10 next month, and that she is 'sensitive in the best way
possible', smart, and has in tutoring, and now is doing well in school, and loves fashion. MO reported that FO
had concerns for Elora with ADHD but that she got evaluated but she does not have ADHD. MO reported that
Elora is on a specific diet per doctors' recommendations and is currently in therapy.


Elora (9): Collin reported that Elora is a good kid, and sweet. Collin reported that he doesn't have any concerns
about any of the children developmentally. Collin reported that they all act like siblings



Elora (9): Monica reported that Elora is a big ball of personality and has a lot of emotions in a wise way, is
poetic, and that Elora feels big. Monica reported that Elora loves to play softball and try new things. Monica
reported that Elora is creative, smart, and loves to be funny/make people laugh. Monica reported that Elora is
very loving, and it is Monica and Elora spend a lot of time together. Monica reported that Elora has a lot of
friends and that she does well in school.

Child:     Goodnight-Ralidak, Raina, S. (103285923)
Describe how the child functions on a daily basis. Describe the child’s general
behavior, temperament and physical capacity.
PER FO: FO reported that Raina is his little girl and that he loves her very much. FO reported that Raina is
quiet at first but once she gets to know you, she has a lot of energy.

RAINA (6): MO reported that Raina is her twin and has ODD. MO reported that Raina has had trouble with
Raina in regards to teachers and can be defiant. MO reported that Raina is 'always sad on transition day (one
week w/ mom and one week with dad), and that Raina has a hard time with transitions. MO reported that Raina
has a history of reporting to the school that she is hungry, and that MO has talked to the school about these
issues, and conversating with the school regarding this. MO reported that Raina is in therapy and is a
sweetheart.


Collin reported that Raina is a sweet kid but that she may benefit from speech therapy.



Raina (6): Monica reported that the 'house sass' and that Raina is witty and always has been. Monica reported
that Raina is charming, observant, and funny. Monica reported that Raina is a force of nature. Monica reported
that Raina is set to be CEO at some point in time. Monica reported that Raina loves people, and that Raina
takes younger children under her wing, and is interested in learning/having fun conversations. Monica reported


FAR Family Assessment                            Case Name (Case ID)                                  Page 9 of 12
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000052
that Raina has been working with the school due to behavioral issues.


ASSESSMENT RECOMMENDATIONS
Assessment Summary:



INTITAL CONCERN: First intake was regarding food restrictions via mom. Second intake was regarding MO
spanking Raina and that MO was living in an RV with concerns of inconsistent housing. Referrer reports the
parents have split custody and the kids had been with Mom all week, but they are now with Dad. When Raina
came to school today, she was falling asleep in class and complained of a headache and said Mom slapped
her pocket and her cheek and when she slapped her she pushed her into the hall. Ref asked Raina what she
hit her head on and she said the floor. Raina said her Mom checked her head and said there was no bump and
she needed to go to sleep. Concern: Referrer reports the parents have split custody and the kids had been with
Mom all week, but they are now with Dad. When Raina came to school today, she was falling asleep in class
and complained of a headache and said Mom slapped her pocket and her cheek and when she slapped her
she pushed her into the hall. Ref asked Raina what she hit her head on and she said the floor. Raina said her
Mom checked her head and said there was no bump and she needed to go to sleep. Raina said she couldn't go
to sleep and this morning, Mom said they didn't have time for breakfast, so she came without eating. Ref stated
she has come without breakfast previously when she is with Mom. She complained of a headache all day and
saw the School Nurse who noted no signs of concussion. Ref did not observe any marks or bruising.


PARENTS: PER MO: MO reported that the children and herself implement the '5 to 1' ratio meaning that 1
wrongdoing means you have to do 5 good things. MO reported that MO and her children work together to
understand that they do not have control over the outside world but that they do have control over their own
actions. MO reported that she does EFT tapping with the children to regulate their emotions. MO reported that
she believes her discipline is impactful. MO reported that she denies any physical form of discipline.

PER FO: SW Pearson spoke to FO on the phone regarding new concerns about MO having the children stay in
a trailer with an unknown person and FO provided their names as 'Jim Solberg and Nathan 'Kanis' Solberg. FO
reported that Raina specifically has voiced that these men have tried to kiss her on the mouth and make Raina
uncomfortable. FO did not have more information regarding the whereabouts of the Trailer and reported that
MO's previous partner, Collin have broken up therefore leading FO to not know where the children are located
when the children are in MO's care. SW spoke to FO outside the home. FO reported that he was upset post
Friday (documented in famlink) as MO and Dr. Collin harassed him at school. FO showed SW Pearson the
video of Collin making a gun symbol at FO at the school and FO reported to have his legal rep on the phone
when SW Pearson arrived as FO is working to document all of this. FO reported that he understands that SW
Pearson is separate from family court. FO reported thanked SW Pearson for being receptive and reported that
he will keep SW updated. SW Pearson reported that she spoke to her SUP and that SW Pearson will keep FO
updated once the case is closed so he can have further documentation of this period per multiple intakes.
Monica then came out of the home as SW was leaving to report to SW that Raina is having a tantrum now and
that she is reporting that she is scared because MO told all of the children not to speak to CPS. FO thanked
SW Pearson again and SW left the home.


 PER MONICA: Monica reported that when the children are with FO and Monica, the children can eat whatever
they want, and that they can eat when they are hungry. Monica reported that in working with the children's
therapist, FO and Monica have been working with the children to eat some junk food as they are allowed to be
children. Monica reported that MO has had children on certain diets and sometimes not. Monica reported that
she is confused about why/what the diets are for the children when they are with MO. Monica reported that
there have been arguments with the school due to diagnosis's ODD leading to dietary restrictions. Monica
reported that MO is 'Yucka' app that shows if the 'food is good or bad'. Monica reported that MO will take food
away as punishment.




FAR Family Assessment                           Case Name (Case ID)                               Page 10 of 12
DCYF 10-474 (02/2019) INT/EXT               Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000053
PER COLLIN: Collin reported that MO will put the children in time outs, Collin denies any form of physical
discipline, and that the children are expected to do their homework and to eat healthy if they are going to have
any sweets, they need to finish their food first.

PER CHILDREN: Elora reported that when she is with her dad, she has to be respectful and if she says a bad
word she might be sent to her room but that doesn't happen often. MO: Elora reported that MO wants Elora and
her siblings to comfort MO when she is upset, be respectful and that MO slaps/spanks the kids when they don't
follow the rules. Elora reported that she doesn't like when MO slaps/spanks her, but that Raina (6) usually gets
slaps the most.
RAINA: SW observed that Raina was not willing to speak with SW as Raina was hiding under her bed and
behind Monica and/or FO when SW asked her to speak with her. Raina reported that she only would speak to
SW if FO could come with her. SW observed that FO was willing to be with Raina while speaking with SW. SW,
FO and Raina went into Raina's room and FO sat on the bed with Raina. SW attempted to ask Raina questions,
but she did not want to speak with SW. SW was able to do a body check to see that Raina was free of
marks/bruising. Raina did show SW a mark on her chest that was the size of a pencil mark and reported that
MO scratched me. Raina was hiding under the covers thus not allowing a full interview to be completed.

 AIDEN:Aiden reported that at dad's house he has a certain bedtime routine and that he needs to be respectful.
Aiden reported that if he doesn't follow the rules at dad's home, he goes to his room but that this does not
happen often. MO: Aiden reported that MO expects him and his sisters to be respectful and to not fight. Aiden
reported that MO does slap his sister's more than him and that MO spanks them on the butt when they do not
follow the rules. Aiden showed SW Pearson and open hand to give a visual for SW Pearson when MO
disciplines him and Aiden's sisters.

COLLAT:REPORT FROM SCHOOL: CUT AND PASTED NARRATIVE FROM REPORT C25010391 On April
4, 2025, I was dispatched at 1445 hours for a reported DV threats call at Carnation Elementary School, 4950
Tolt Ave. RP-1 Matthew Ralidak and S-1 Veronika Goodnight are divorced. Ralidak and Goodnight have three
children in common, V-1 Raina Goodnight-Ralidak (6 yrs old), O-2 Elora Goodnight-Ralidak (8 yrs old), O-3
Aidan Goodnight-Ralidak (10 yrs old). O-4 Colin Derieg and Goodnight are currently dating. O-6 Monica
Galarneau and Ralidak are currently married. O-5 Michelle Frank is the current principal for Carnation
Elementary. Ralidak informed me of the following: He currently has a tense relationship with Goodnight. They
currently share their children 50/50 according to their parenting plan. Ralidak informed me that there is an open
CPS case involving Goodnight, a man she is living with, and RGR. Ralidak stated that according to RGR,
Goodnight was making her kiss this man. Ralidak did not have any other information about this CPS case.
While waiting, in his car, in line to pick up his children from school. At approximately 1358 hours Goodnight
approached Ralidak's car and started yelling at him. Goodnight was accusing Ralidak of calling CPS on her.
Goodnight continued yelling and asking Ralidak questions about the children and Goodnight's new living
arrangements. At some point Ralidak noticed Derieg standing beside his car staring at him. Goodnight then
went into the school office and back out toward Ralidak's car. During this time Ralidak had called into the
school's office and told the principal, Frank, and another administrator about the odd behavior and scene
Goodnight was making. Frank then came outside to speak with Goodnight. At approximately 1412 hours
Goodnight and Derieg got into a maroon Chevy Silverado and left the school parking lot. Ralidak clarified that
no threats were ever made by Goodnight or Derieg. Ralidak stated he felt intimidated by Derieg standing
outside his car staring at him. While sharing the details of this incident Ralidak seemed visibly shaken and
needed to take breaks, while talking with me, to hold back tears. All three children were not present during this
incident. As I was leaving Ralidak showed me a text from Galarneau, who currently had all three children.
Galarneau said that all three children had told her that Goodnight had slapped RGR and slammed her against a
wall. Ralidak thought this might be retaliation because RGR had planned to tell Goodnight she no longer
wanted to live with her. Ralidak did not mention any marks or bruises on RGR when he had seen her at the
school pickup. The text from Galarneau did not describe any injuries on RGR. Ralidak and Galarneau have all
three children over the weekend. Ralidak said he is worried about his children's safety and wasn't sure what to
do. I gave Ralidak the case number and informed him that he should get in touch with a lawyer and ask about
getting a protection order if he is feeling this way. Frank had informed me of the following: The office had
received a call from Ralidak, so Frank and another administrator had gone outside to see what was going on.
Frank spoke Goodnight and told her "This isn't the place", in reference to not handling parenting issues on
school grounds. Frank stated this is not the first time that Goodnight has caused a commotion or interrupted the
children's learning process.


FAR Family Assessment                            Case Name (Case ID)                                Page 11 of 12
DCYF 10-474 (02/2019) INT/EXT                Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000054
SDM: Mod (MO) and Low for FO/Monica
SAFETY: SW Pearson assessed safety threat 10 and determined it to be inactive.
SERVICES: N/A
FILE UPLOADS: IIR/COLLATS WITH MEDICAL(EMAILS).

Assessment Recommendation:                                               Recommendation Reason:
Case is Closing                                                          FAR successfully completed

Explain:


SW Pearson completed FAR process with both MO and FO and determined no active safety threat at this time.
MO reported that she feeds the children (SW reviewed medical records) and both FO/MO are able to meet
children's basic needs.

Safety Assessment Date:         Safety Decision:                Final Safety Plan:
04/08/2025                      Safe                            No Safety Plan Required
02/10/2025                      Safe                            No Safety Plan Required



SDM Date: 04/07/2025            SDM Score:     Moderate




INDIVIDUAL OBJECTIVES ACHIEVED/HISTORICALGalarneau, Monica (104669771)
Start Date:                            Target End Date:
Objective:
null

INDIVIDUAL OBJECTIVES ACHIEVED/HISTORICALGoodnight, Veronika, E. (103285911)
Start Date:                            Target End Date:
Objective:
null

INDIVIDUAL OBJECTIVES ACHIEVED/HISTORICALRalidak, Mathew, W. (104669770)
Start Date:                            Target End Date:
Objective:
null




FAR Family Assessment                             Case Name (Case ID)                                 Page 12 of 12
DCYF 10-474 (02/2019) INT/EXT                 Goodnight, Veronika (2682764)
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000055
                                         CASE NOTES

 Case Name:                   Case ID:        Case Note ID:                     Note Finalized
Goodnight, Veronika        2682764            52884556
Case Note Category: FAR                       Case Note Type: Assessment
Date Occurred: 07/31/2024                     Time Occurred: 10:45 AM
Date Entered: 08/07/2024 04:12 PM             Note Entered by: Dhillon, Amandeep
Related Participants and Collaterals:         Related Intakes:
Veronika E. Goodnight                         07/30/2024 10:15 PM 5435044
Elora L. Goodnight-Ralidak                    08/04/2024 8:40 PM 5437643
Aidan W. Goodnight-Ralidak                    08/02/2024 10:50 PM 5438709
Raina S. Goodnight-Ralidak
Mathew W. Ralidak
Monica Galarneau

                                           ACTIVITIES
Activity: Parent/Guardian Contact Participant: Mathew W. Ralidak           Location: Parental
Home Time: 10:45 AM             TCM: No
Activity: Parent/Guardian Contact Participant: Veronika E. Goodnight Location: Parental
Home Time: 10:45 AM             TCM: No
Activity: Parent/Guardian Contact Participant: Monica Galarneau            Location: Parental
Home Time: 10:45 AM             TCM: No
Activity: Child - Initial Face-to-Face with child   Participant: Raina S. Goodnight-Ralidak
       Location: Parental Home         Time: 10:45 AM       TCM: No
Activity: Child - Initial Face-to-Face with child   Participant: Elora L. Goodnight-Ralidak
       Location: Parental Home         Time: 10:45 AM       TCM: No
Activity: Child - Initial Face-to-Face with child   Participant: Aidan W. Goodnight-Ralidak
       Location: Parental Home         Time: 10:45 AM       TCM: No
                                           CONTACTS

                                           NARRATIVE
Case Note 1 of 1        Entered By : Amandeep Dhillon          Date Entered : 08/07/2024 Time
Entered : 04:12 PM
ALL EVENTS OCCURRED ON 7/31/2024 IN THE TIMES AND LOCATIONS LISTED
BELOW:
10:45AM- SW Dhillon went to mom's house in Carnation to do IFF. SW knocked on door
however, nobody was there. SW Dhillon called and left Veronika a vm for callback. Veronika
called SW back and stated she is at the dentist and stated SW can come around 1pm to see the
kids and speak with her.
11:00AM- SW Dhillon went to dad's home as second IFF attempt to see the kids. SW met with
FA Matt and Monica. SW emailed interview questions to both parents and stated they will
answer them then.
1:37PM- IFF WITH ELORA, AIDAN, RAINA: MOM'S HOME IN CARNATION:
SW Dhillon went over three ground rules and all children promised to tell the truth.
CHILD FUNCTIONING:
ELORA: Elora stated she loves to watch youtube such as Ben, like school because of reading
and stated she is in 4th grade. Elora stated she loves recess and doing math.


                                          Page 1 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000056
Aidan: Aidan stated he is 8 years old, loves playing with Godzilla toys, good at math, writing
and reading and stated he loves to play baseball and hockey.
RAINA: Raina stated she is 6 years old, loves to play with her toys and stated she loves her doll.
During IFF, Raina was very active and playing in her room.
ABOUT HOME: All children stated at dad's house it's him and Monika. All children stated at
moms house its her and step dad Colin.
ABOUT PARENTS:
VERONIKA: Elora stated she loves her mom because she gets to play with her but stated she
dislikes her stern voice. Aidan stated he loves mom because she hugs him but stated he dislikes
her being stern. Raina stated she loves snuggling with mom and stated she loves helping her.
COLIN: Elora stated what she likes about Colin is that he is nice, Aidan stated he plays catch
and Raina stated he helps adjust her neck. All children stated no dislikes for Colin.
MATT: Elora stated she likes her dad because he is loosening up, lets her do makeup, and is
redoing her room. Aidan stated he likes to go to the creek with dad, catch fish, trout, and dislikes
dad because he has to clean his room. Raina stated she loves to feed the cats with dad, and hug
him.
MONIKA: Elora stated Monika takes her for shopping, plays with her, reads to her but dislikes
being put in a room. Aidan stated Monica plays catch with him, cooks for him, and stated he
dislikes when she yells. Raina stated Monika helps us with the problem that they get and reads to
her.
RULES/DISICPLINE: All children stated the rules at mom and dad's are to be respectful, not
yell at mom or dad, be positive and keep rooms clean. Elora stated she gets sent to room as
punishment. Aidan stated his mom will grab his ear from side and sent to room. Raina stated
nobody hits them but they go to their rooms for punishment. Elora stated that mom yells at them
and makes them go to the room.
SAFETY/CLOSURE: Elora stated safe means being with your mom and dad and knowing if
something were to happen they would be there for you. Aidan and Raina stated they did not
know how to describe being safe. All children reported they felt safe at home with both parents
within both households and stated they would tell their parent if they felt unsafe within the
household.




 Case Name:                   Case ID:         Case Note ID:                       Note Finalized
Goodnight, Veronika        2682764              53055689
Case Note Category: FAR                        Case Note Type: Assessment
Date Occurred: 07/31/2024                      Time Occurred: 01:00 PM
Date Entered: 09/22/2024 06:36 PM              Note Entered by: Dhillon, Amandeep
Related Participants and Collaterals:          Related Intakes:
Veronika E. Goodnight                          07/30/2024 10:15 PM 5435044
Mathew W. Ralidak                              08/04/2024 8:40 PM 5437643
Monica Galarneau                               08/02/2024 10:50 PM 5438709

                                      ACTIVITIES
Activity: Parent/Guardian Contact Participant: Mathew W. Ralidak             Location: Parental
Home Time: 01:00 PM         TCM: No


                                            Page 2 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000057
Activity: Parent/Guardian Contact Participant: Veronika E. Goodnight Location: Parental
Home Time: 01:00 PM         TCM: No
Activity: Parent/Guardian Contact Participant: Monica Galarneau      Location: Parental
Home Time: 01:00 PM         TCM: No
                                      CONTACTS

                                       NARRATIVE
Case Note 1 of 1       Entered By : Amandeep Dhillon
                                          Date Entered : 09/22/2024                         Time
Entered : 06:36 PM
ALL EVENTS AND INTERVIEWS OCCURRED ON 7.31.2024:

PARENTAL INTERVIEW: Matthew and Monica: 1:00pm- PARENTAL HOM E (MATT'S
HOME)

ALLEGRCW 13.50.100 Matthew stated he is not aware of what has happened but stated an incident of
the friend and Elora had happened in the past. Monica stated she has only heard from Matt and
heard from Elora that she has told them she has never touched anyone like this. Matt stated they
have talked to Elora about touching and what is appropriate and what is not. Monica stated there
was an incident in the past where on social media Veronica had posted about it. Matt stated King
County sheriffs office was involved but stated all visits between Elora and her friends are limited
and safe.

ICWA: both parents denied.

ABOUT HOME: Matthew stated he lives at home with his life Monica. Matthew stated he has
been split from Veronica for a while and stated there was a lot of DV between both.

PARENTING STYLE/EXPECTATIONS: Matthew stated he loves to guide his children through
situations, let them grow, be involved in their school activities. Monica stated what she loves
about parenting is letting the kids be their own individuals, sing to them, having inside jokes with
them, and taking them to church. Monica stated they have 50/50 custody. Monica stated she will
not be having her own kids because Matt's kids are the main priority right now. Matthew stated
what he finds frustrating about parenting is the needs and managing their emotional needs. Matt
stated it is hard every week and stated the separate lives is hard with communication. Monica
stated the change is hard and going back between every week.

RULES/DISICIPLINE: Matt stated the kids cannot say curse words, no hitting, or biting anyone,
and respecting all younger and elders. Matt stated he takes away the kids privileges or mostly
send them to their rooms for timeout and stated he will always talk to them. Matt stated Monica
does the same discipline methods.

CHILD FUNCTIONING:
ELORA: 4th grade, behind in reading, writing, math and stated has a tutor for math next week.
Elora is highly emotional, has struggles with friendship, Elora likes chapter book, and stated she
loves to be recognized and is very codependent. Elora has turned 9, and very spiritual but also is
ambitiousand loves to do pranks.
AIDAN: loves sports, Godzilla, caring soul, emotional bear and is very involved in church.
Aidan helps other at baseball and is involved in hockey right now. Aidan Is a comedy sketch

                                            Page 3 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000058
then loves to laugh and make voices. Aidan is daddy's boy and it takes him time to express
himself. Aidan is about to enter third grade, and loves to read, write and do math. Aidan lashes
out in anger, but he loves to go to the creek and fish for stuff.
RAINA: 6 year old, has the biggest personality, hilarious with her jokes and is beyond wise for
her age. Know what she can do and where she has to say the right stuff. Raina loves to sing, act,
and play just dance. Raina loves to be happy with friends, and has tons of confidence. Raina is
doing good in school but she is disruptive and likes to throw things. Monica stated the school
emails weekly for Raina.

SW Dhillon had to email the rest of the interview questions.

SW emailed parent interview questions to:
        RCW 13.50.100


HOME WALKTHROUGH: All three children have their own bedrooms, the kids' room were a
mess as both Monica and Matt had stated that they are remodeling the kids. Both parents showed
SW the safe in the room where their concealed gun was kept. The home was in clean condition
when SW arrived. The living room had toys in it, and both parents had state they were sick but
negative from Covid and are working on cleaning the home. The kitchen had plenty of food in it.
No safety threat or present danger within household.
______________________________________________________________________________
________________

PARENT INTERVIEW: VERONIKA GOODNIGHT 1:00PM (PARENTAL HOMEMOMS)

ALLEGATIONS: Veronika stated Elora is in therapy now and stated she told Anjali on Tuesday
that she has to call CPS for a report. Veronika stated a similar situation like this happened to
Elora in 2019 where it was Dawson's place and stated the person is at still church. Veronika
stated her father Matt still takes her to the same church. Veronika stated Diana was previous case
worker.

Veronika stated Anjali had shared that Raina told her that River had kissed her for the second
time. Veronika stated Elora had shared that she went to Diana's and Erlora had told her that
Diana made her uncomfortable. Veronika stated that she told Diana to not do it again. Veronika
stated 2-3 weeks ago River tried to do that and Veronika stated she has addressed the situation
and stated Elora froze because boundaries were crossed. Veronika stated she is now allowing
River to see Elora at the time and any type of visitation will be supervised. Veronika stated Elora
has past trauma from being in this similar situation. Veronika stated this was a peck on the lip
and stated situation has been handled.

FAMILY: Veronika stated she has 50/50 custody of the three children along with Matt. Veronika
stated Matt has molested her and in the first trial he was dismissed. Veronika stated she has
worked very hard to get this home for the kids and started crying. Veronika stated she is engaged
to Dr. Colin Monroe and stated she has been with him for 5 years. Veronika stated Matt had
cheated on her with his mistress Monika and is with him now.

PARENT STYLE/EXPECTATIONS: Veronika stated she has known and take care of the 2 kids


                                            Page 4 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000059
for a lot. Veronika stated she has shielded her kids from the outside world. Veronika stated she
never lies to the kids and stated she finds nothing frustrating right now. Veronika stated she is
making her kids be good human beings for when they grow up.

RULES/DISICPLINE: Veronika stated the kids have to wake up, eat healthy, shoes on and off.
Veronika stated she takes the kids electronics away, and stated she has spanked them once in the
past but does not use physical. Veronika stated she has used the ear method on Aidan and stated
it works well.

CHILD FUNCTION: Veronika stated Elora is emotional, personal, smart, kind, empathetic and
doing very food in school. Veronika stated Aidan loves hockey, sweet boy and does not act out.
Veronika stated Raina is her DNA twin, wild, emotional, and causes more drama and is very
insane. Veronika stated the kids go to a natural homeopathic Dr. Bowker in Natural Snohomish.

PARENT FUNCTION/SDM: Veronika stated she is a retired performer and stated she used to
perform on silk clinics and loves to go on long walks, and bath. Veronika stated she does deep
breathing exercises.
Crim: no.
Religious: no.
Substance use: no.
MH: stated no.
DV: states yes with Matt.
SUPPORTS: Veronika stated she has her fianc and Diana.
NEXT-STEPS/SERVICES: Veronika stated she would be interested in FFT.

COLLATERALS: Veronika stated she will text SW.

HOME WALKTHROUGH: SW Dhillon completed it. Both girls share a bedroom, there was lots
of clothes and bunk bed. Aidan has his own room, and MO stated no weapons within household.
The living room was in good condition, there was plenty of food in the kitchen and no safety
threats. Overall there are three bedrooms within the household.




 Case Name:                   Case ID:          Case Note ID:                      Note Finalized
Goodnight, Veronika        2682764              53055693
Case Note Category: FAR                         Case Note Type: Assessment
Date Occurred: 08/05/2024                       Time Occurred: 11:27 AM
Date Entered: 09/22/2024 06:51 PM               Note Entered by: Dhillon, Amandeep
Related Participants and Collaterals:           Related Intakes:
Mathew W. Ralidak                           07/30/2024 10:15 PM 5435044
                                            08/04/2024 8:40 PM 5437643
                                            08/02/2024 10:50 PM 5438709
                                      ACTIVITIES
Activity: Parent/Guardian Contact Participant: Mathew W. Ralidak    Location: Email
       Time: 11:27 AM       TCM: No
                                      CONTACTS


                                            Page 5 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000060
                                         NARRATIVE
Case Note 1 of 1         Entered By : Amandeep Dhillon         Date Entered : 09/22/2024   Time
Entered : 06:51 PM
"Hi Ms. Dhillon,

Thank you again for speaking with my wife and I last week and taking my daughter's/kid's
situation seriously. Attached are the Parent Interview questions filled out along with a few other
documents.
        Elora told my wife and I that River sent her mean and nasty text messages on the car ride
from the dentist to their house on the day you were here. This is very concerning to me that
Elora's mother knew all of this was all occurring.
        Recently I was provided a screenshot of a social media post from Veronika dated July
28th where she speaks about being evicted. I have serious concerns about the children's housing.
        I've included my talking parents message to Veronika in May regarding my concerns.
Elora's therapist also has this message.
        The Summer schedule calendar, a message to Veronika confirming dates in February,
along with the Talking Parents messages and her approach to the situation. Since, she has walked
this back and messed up the summer schedule taking my time away with the kids from 7/26-8/2,
so far. Along with this, I have a King County Sheriff's Record Number for when I called the
Sheriff regarding Veronika threatening to use the authorities on me and come to my house when
she did not agree with the summer schedule as planned. That # is K24170376.
        The original Parenting Plan and Findings along with the New Parenting Plan and
Findings.
        An inappropriate message Veronika sent me from the children's phone. Violating the
parenting plan and endangering their mental health.
        Veronika has a Harassment case we also found out about through the community, case
23CIV04677

Please let me know if you have any questions or need to follow up on anything!

Thank you!
Mathew Ralidak
856-332-7796
"




 Case Name:                   Case ID:         Case Note ID:                      Note Finalized
Goodnight, Veronika        2682764             53055692
Case Note Category: FAR                        Case Note Type: Assessment
Date Occurred: 08/05/2024                      Time Occurred: 07:00 PM
Date Entered: 09/22/2024 06:43 PM              Note Entered by: Dhillon, Amandeep
Related Participants and Collaterals:          Related Intakes:
Mathew W. Ralidak                              07/30/2024 10:15 PM 5435044
Monica Galarneau                               08/04/2024 8:40 PM 5437643
                                               08/02/2024 10:50 PM 5438709

                                           Page 6 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000061
                                      ACTIVITIES
Activity: Parent/Guardian Contact Participant: Mathew W. Ralidak         Location: Email
       Time: 07:00 PM       TCM: No
Activity: Parent/Guardian Contact Participant: Monica Galarneau          Location: Email
       Time: 07:00 PM       TCM: No
                                      CONTACTS

                                             NARRATIVE
Case Note 1 of 1         Entered By : Amandeep Dhillon          Date Entered : 09/22/2024 Time
Entered : 06:43 PM
MATTHEW AND MONICA EMAILED REST OF PARENT INTERVIEW TO SW
"Parent Functioning:
Are you working right now? Where do you work? Other sources of income?
Full Time Employment. Company name, Freeman.
What is your schedule?
Work from home/Remote. Travel as needed for Events/Projects.
What do you do to make yourself happy?
I like to listen to music, podcast, or sit outside and bird watch. I enjoy funny movies and TV
shows as well.
How do you manage stress?
I pause my situation, whatever moment it may be, and breath, pray, talk to my therapist, but
always look to deescalate whatever may be bothering me.
What does an argument between adults look like?
It would look like two low speaking reasonable people being able to calmly be able to walk away
from a conversation or be able to navigate talking to one another in a peaceful and respectful
manner.

What social/community support do you have? If there was a problem, who would you go to for
help?
We have a very strong church community. We have friends surrounding the greater Seattle area
from our work and personal relationships. Family from CA and the East Coast that communicate
regularly and visit annually or more. Social interactions in the community however have been
tarnished with the hateful and disgusting things Veronika has said about my wife and I in the
community. It has been hard to trust others locally sounds of out church and close friends
because of the negativity.

Do you need any help/services with parenting?
My wife and I do not need any help or services with parenting.

Discipline:
What are the rules in your home?

What is discipline like? What happens if someone breaks the rules?

Is discipline effective? Why do you use those consequences/methods?

How often does discipline happen?


                                          Page 7 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000062
Reasons department got involved:
Do you know why the department received a concern about safety of children in your home?
Please explain and describe your point of view on what may have led to department's
involvement?



Below are some questions we have to ask each family: Please explain if you answered yes to any
of the questions

Do you have a Mental health diagnosis? If so, what is it?
No.

Do you have any childhood abuse history?


Were you part of any Military service?
No.

Are you Religious?
Yes, Christian.

Do you have Criminal history? Conviction history?
No.

Do you use Drugs?
No.

Have you ever been in an intimate relationship where you didn't feel safe, or a relationship with a
violent or aggressive component?


Do you drink? If not, what is the frequency, duration, quantity? Where are the drink(s) located in
your home? Are they accessible to the children?

Any other concerns you like to share that are not covered?


Services:
Do you currently have or need any services? Services can range from parenting skills,
counselling/ therapy/manage stress/substance use/ child development training, anything you
believe that will be helpful for you family. Please describe?

"




    Case Name:             Case ID:             Case Note ID:                     Note Finalized



                                            Page 8 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000063
Goodnight, Veronika        2682764           52940533
Case Note Category: CPS                      Case Note Type: Supervision
Date Occurred: 08/22/2024                    Time Occurred: 09:28 AM
Date Entered: 08/22/2024 09:30 AM            Note Entered by: Smith, Jazie, B.
Related Participants and Collaterals:        Related Intakes:
Makayla N. Woodle
Veronika E. Goodnight
Elora L. Goodnight-Ralidak
Aidan W. Goodnight-Ralidak
Raina S. Goodnight-Ralidak
Mathew W. Ralidak
Monica Galarneau
River Q. Muggli

                                        ACTIVITIES
Activity: Monthly Supervisor Review        Participant: Makayla N. Woodle       Location:
Children's Administration Office    Time: 09:28 AM         TCM: No
Activity: Monthly Supervisor Review        Participant: Veronika E. Goodnight Location:
Children's Administration Office    Time: 09:28 AM         TCM: No
Activity: Monthly Supervisor Review        Participant: Elora L. Goodnight-Ralidak
       Location: Children's Administration Office Time: 09:28 AM        TCM: No
Activity: Monthly Supervisor Review        Participant: Aidan W. Goodnight-Ralidak
       Location: Children's Administration Office Time: 09:28 AM        TCM: No
Activity: Monthly Supervisor Review        Participant: Raina S. Goodnight-Ralidak
       Location: Children's Administration Office Time: 09:28 AM        TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 09:28 AM         TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 09:28 AM         TCM: No
Activity: Monthly Supervisor Review        Participant: Monica Galarneau        Location:
Children's Administration Office    Time: 09:28 AM         TCM: No
Activity: Monthly Supervisor Review        Participant: River Q. Muggli Location: Children's
Administration Office        Time: 09:28 AM        TCM: No
                                         CONTACTS

                                        NARRATIVE
Case Note 1 of 1      Entered By : Jazie B. Smith Date Entered : 08/22/2024      Time Entered :
09:30 AM
Household:
Mother - Veronika
Child - Elora Ralidak age 9
Child - Aidan Ralidak age 7
Child - Raina Ralidak age 5

Non-household Members:
Father - Matthew Ralidak
                RCW 13.50.100(7)(c)


                                         Page 9 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000064
Therapist reporting concerns of parent Anjali going against clinical recommendation for the
healthy welfare of 9 yr Elora.
Two weeks ago Elora had indicated that a 9 yr girl River Muggli had kissed her. Therapist has
requested that Elora not be around this child River,
Parent Veronica agreed but did not follow through.

Today Elora indicated that she meet up with 9 yr River because her Mom Veronica and River's
Mom Diana are friends.
Elora stated that River has touched Elora multiple time in the past and this time Elora had told
River to stop kissing and touching her, but River did not. River was putting her tongue in Ellora's
mouth, while at River's house
Veronica indicated that she doubted that this happened.

Veronica was spoken with during counseling appointment today and again explained about the
safety of her daughter around this child. Veronica indicated that she would not have them in
contact with each other.

Therapist concerned about Veronica understanding of the risk to her child and concerned about
Veronica following through with protection of Elora.

IFF: 07/31/2024 at the mother's home

Elora reported there was a few times this happened. Parents addressed the situation and since
then, the kids cannot see each other.

TO DO:
Send FFT to the mother
Send LE referral
Call PCP
Call collaterals
Safety assessment




 Case Name:                   Case ID:         Case Note ID:                       Note Finalized
Goodnight, Veronika        2682764              53055700
Case Note Category: FAR                        Case Note Type: Assessment
Date Occurred: 09/12/2024                      Time Occurred: 03:25 PM
Date Entered: 09/22/2024 08:11 PM              Note Entered by: Dhillon, Amandeep
Related Participants and Collaterals:          Related Intakes:
Veronika E. Goodnight                          07/30/2024 10:15 PM 5435044
Mathew W. Ralidak                              08/04/2024 8:40 PM 5437643
Monica Galarneau                               08/02/2024 10:50 PM 5438709

                                           ACTIVITIES
Activity: Contact - Collateral Participant: Mathew W. Ralidak       Location: By Phone      Time:


                                           Page 10 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000065
03:25 PM       TCM: No
Activity: Contact - Collateral Participant: Veronika E. Goodnight Location: By Phone      Time:
03:25 PM       TCM: No
Activity: Contact - Collateral Participant: Monica Galarneau      Location: By Phone      Time:
03:25 PM       TCM: No
                                           CONTACTS

                                      NARRATIVE
Case Note 1 of 1      Entered By : Amandeep Dhillon
                                       Date Entered : 09/22/2024                          Time
Entered : 08:11 PM
DATE AND TIME: 9/12/2024 3:25PM
COLLATERAL CONTACT: ROBERT GALARNEAU RCW 13.50.100

HOME/FAMILY INFORMATION: Robert stated he is the father to Monika. Robert stated it is
matthew, Monika and then three kids who have them throughout the custody thing. Robert stated
he sees the family twice a year or talks to them on phone as needed.


PARENTING INFORMATION: Robert stated Monika is a good mom, patient lady, always fair
to all sides, listens to the children's development, works with young people and has no tempers.
Robert stated Matthew is a good dad, calls to attention, and loves these kids a lot and would do
anything for them. Matthew is a very patient dad as well.

CHILD INFORMATION: Robert stated all kids are well and stated they are involve din sports
and are doing good in education. Robert stated the kids are well fed and they are always in good
shape when he sees them.

RULES/DISCIPLINE: Robert stated no physical discipline, and stated the parents send the kids
to their rooms and corrects them if they are wrong.

SUPPORTS: Robert stated no supports for the family.


SDM
MENTAL HEALTH: Robert stated no and stated both parents are stable.
SUBSTANCE USE: Robert stated both drink socially.
CRIMINAL HISTORY: Robert stated no.
DOMESTIC VIOLENCE: Robert stated no.

ALLEGATIONS: Robert stated she has concerns for bio mom but stated nothing else.
CHILD SAFETY CONCERNS: Robert stated no concerns.

DATE AND TIME: 9/12/2024 3:45PM
COLLATERAL CONTACT: DIANA MUGGLI RCW 13.50.100 (friend)

HOME/FAMILY INFORMATION: Diana stated she was friends with Veronika for the past 7
years but stated there was a nasty situation between the daughters which ended this friendship.
Diana stated she used to see the family very often but stated has not seen them now.


                                           Page 11 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000066
PARENTING INFORMATION: Diana stated she has no comments on Veronika's parenting but
stated she will say that Veronika is very authoritarian, and could slow things down to go with the
flow.

CHILD INFORMATION: Diana stated the kids are little behind on behavior and stated most of
the kids like to do what they can do. Diana stated the kids are well fed and whenever she has
seen them, they have never been malnourished.

RULES/DISCIPLINE: Diana stated Veronika revokes privileges and stated there is no physical
disciplining involved.

SUPPORTS: Diana stated the family needs extra counseling.


SDM
MENTAL HEALTH: Diana stated Veronika shows signs of borderline personality disorder, and
PMBD.
SUBSTANCE USE: Diana stated Veronika drinks occasionally.
CRIMINAL HISTORY: Diana stated no.
DOMESTIC VIOLENCE: Diana stated no.

ALLEGATIONS: Diana stated her friendship ended with Veronika. Diana stated her daughter
River asked Elora to be her girlfriend and stated they were together but then broke up. Diana
stated both girls had kissed couple of times but stated their friendship is over and everything has
been taken care of. Diana stated
CHILD SAFETY CONCERNS: Diana stated no.




 Case Name:                   Case ID:          Case Note ID:                       Note Finalized
Goodnight, Veronika        2682764               53040101
Case Note Category: CPS                         Case Note Type: Supervision
Date Occurred: 09/18/2024                       Time Occurred: 09:08 AM
Date Entered: 09/18/2024 09:09 AM               Note Entered by: Smith, Jazie, B.
Related Participants and Collaterals:           Related Intakes:
Makayla N. Woodle
Veronika E. Goodnight
Elora L. Goodnight-Ralidak
Aidan W. Goodnight-Ralidak
Raina S. Goodnight-Ralidak
Mathew W. Ralidak
Monica Galarneau
River Q. Muggli

                                          ACTIVITIES
Activity: Monthly Supervisor Review         Participant: Makayla N. Woodle           Location:


                                            Page 12 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000067
Children's Administration Office    Time: 09:08 AM         TCM: No
Activity: Monthly Supervisor Review        Participant: Veronika E. Goodnight Location:
Children's Administration Office    Time: 09:08 AM         TCM: No
Activity: Monthly Supervisor Review        Participant: Elora L. Goodnight-Ralidak
       Location: Children's Administration Office Time: 09:08 AM        TCM: No
Activity: Monthly Supervisor Review        Participant: Aidan W. Goodnight-Ralidak
       Location: Children's Administration Office Time: 09:08 AM        TCM: No
Activity: Monthly Supervisor Review        Participant: Raina S. Goodnight-Ralidak
       Location: Children's Administration Office Time: 09:08 AM        TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 09:08 AM         TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 09:08 AM         TCM: No
Activity: Monthly Supervisor Review        Participant: Monica Galarneau        Location:
Children's Administration Office    Time: 09:08 AM         TCM: No
Activity: Monthly Supervisor Review        Participant: River Q. Muggli Location: Children's
Administration Office        Time: 09:08 AM        TCM: No
                                         CONTACTS

                                        NARRATIVE
Case Note 1 of 1      Entered By : Jazie B. Smith Date Entered : 09/18/2024            Time Entered :
09:09 AM
Household:
Mother - Veronika
Child - Elora Ralidak age 9
Child - Aidan Ralidak age 7
Child - Raina Ralidak age 5

Non-household Members:
Father - Matthew Ralidak
                      RCW 13.50.100(7)(c)

          reporting concerns of parent
RCW 13.50.100(7)(c)
                                               going against clinical recommendation for the
                                            RCW 13.50.100(7)



healthy welfare of 9 yr Elora.
Two weeks ago Elora had indicated that a 9 yr girl River RCW 13.50.100 had kissed her. Therapist has
requested that Elora not be around this child River,
Parent Veronica agreed but did not follow through.

Today Elora indicated that she meet up with 9 yr River because her Mom Veronica and River's
Mom Diana are friends.
Elora stated that River has touched Elora multiple time in the past and this time Elora had told
River to stop kissing and touching her, but River did not. River was putting her tongue in Ellora's
mouth, while at River's house
Veronica indicated that she doubted that this happened.

Veronica was spoken with during counseling appointment today and again explained about the
safety of her daughter around this child. Veronica indicated that she would not have them in


                                                     Page 13 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000068
contact with each other.

Therapist concerned about Veronica understanding of the risk to her child and concerned about
Veronica following through with protection of Elora.

IFF: 07/31/2024 at the mother's home

Elora reported there was a few times this happened. Parents addressed the situation and since
then, the kids cannot see each other.

TO DO:
Send FFT to the mother
Send LE referral
Call PCP
Call collaterals
Safety assessment

UPDATE 09/18/2024:

SW sent FFT information.

TO DO:
Send LE referrals
Case notes and assessment




 Case Name:                   Case ID:         Case Note ID:                       Note Finalized
Goodnight, Veronika        2682764             53064717
Case Note Category: CPS                        Case Note Type: Supervision
Date Occurred: 09/24/2024                      Time Occurred: 02:32 PM
Date Entered: 09/24/2024 02:32 PM              Note Entered by: Smith, Jazie, B.
Related Participants and Collaterals:          Related Intakes:
Makayla N. Woodle
Veronika E. Goodnight
Elora L. Goodnight-Ralidak
Aidan W. Goodnight-Ralidak
Raina S. Goodnight-Ralidak
Mathew W. Ralidak
Monica Galarneau
River Q. Muggli

                                      ACTIVITIES
Activity: Monthly Supervisor Review       Participant: Makayla N. Woodle     Location:
Children's Administration Office   Time: 02:32 PM        TCM: No
Activity: Monthly Supervisor Review       Participant: Veronika E. Goodnight Location:
Children's Administration Office   Time: 02:32 PM        TCM: No


                                          Page 14 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000069
Activity: Monthly Supervisor Review        Participant: Elora L. Goodnight-Ralidak
       Location: Children's Administration Office Time: 02:32 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Aidan W. Goodnight-Ralidak
       Location: Children's Administration Office Time: 02:32 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Raina S. Goodnight-Ralidak
       Location: Children's Administration Office Time: 02:32 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 02:32 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 02:32 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Monica Galarneau        Location:
Children's Administration Office    Time: 02:32 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: River Q. Muggli Location: Children's
Administration Office        Time: 02:32 PM        TCM: No
                                         CONTACTS

                                             NARRATIVE
Case Note 1 of 1           Entered By : Jazie B. Smith Date Entered : 09/24/2024         Time Entered :
02:32 PM
----------------------------------------------CLOSING NOTE-------------------------------------------------
INTAKE#: 5435044

INTAKE DATE: 07/30/2024

          reporting concerns of parent
RCW 13.50.100(7)(c)
                                               going against clinical recommendation for the
                                              RCW 13.50.100(7



healthy welfare of 9 yr Elora.
Two weeks ago Elora had indicated that a 9 yr girl River Muggli had kissed her. Therapist has
requested that Elora not be around this child River,
Parent Veronica agreed but did not follow through.

Today Elora indicated that she meet up with 9 yr River because her Mom Veronica and River's
Mom Diana are friends.
Elora stated that River has touched Elora multiple time in the past and this time Elora had told
River to stop kissing and touching her, but River did not. River was putting her tongue in Ellora's
mouth, while at River's house
Veronica indicated that she doubted that this happened.

Veronica was spoken with during counseling appointment today and again explained about the
safety of her daughter around this child. Veronica indicated that she would not have them in
contact with each other.

Therapist concerned about Veronica understanding of the risk to her child and concerned about
Veronica following through with protection of Elora.

-----------------------------------------------------

IFF Completed: 07/31/2024
Elora stated it happened in the past before and stated River had pecked her quick and it wasn't a

                                                       Page 15 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000070
big kiss. Elora stated she felt uncomfortable and stated she told her mom right away and situation
was cared for. Elora has stated no concerns since then.


DISCLOSURES:
N/A
**************************************************************************

Parent interview:
Matthew stated he is not aware of what has happened but stated an incident of the friend and
Elora had happened in the past. Monica stated she has only heard from Matt and heard from
Elora that she has told them she has never touched anyone like this. Matt stated they have talked
to Elora about touching and what is appropriate and what is not. Monica stated there was an
incident in the past where on social media Veronica had posted about it. Matt stated King County
sheriffs office was involved but stated all visits between Elora and her friends are limited and
safe.

Veronika stated Elora is in therapy now and stated she told Anjali on Tuesday that she has to call
CPS for a report. Veronika stated a similar situation like this happened to Elora in 2019 where it
was Dawson's place and stated the person is at still church. Veronika stated her father Matt still
takes her to the same church. Veronika stated Diana was previous case worker.

--------------------------------------------------------------------

Collaterals:
SW Dhillon spoke to step grandfather Robert who stated the kids are very safe with both parents
SW Dhillon spoke to Veronika's friend Diana who stated no safety concerns but stated Veronika
could slow things down in order to parent.
SW DHillon reviewed new parenting plan and protection order which stated dad has final
decision making for medical and school and custody is now 50/50.
SW Dhillon reviewed medical record from Compass Health which shows that Elora is going to
counseling and all her medical needs are being met.

DCYF HISTORY:
DV - Mother and father are divorced, but mother disclosed historical sexual and physical
violence

5/3/24 - No report of a new incident or supplemental information that minimally meets the WAC
for CA/N.

4/17/24 - Allegations documented in intake #'s 5321629 and 5321486.

3/29/24 - Allegations previously documented in intake#5321486.

3/28/24 Screen Out to Law Enforcement - Staffed with CI Supervisor Susan Rolls.
Inappropriate touching between unrelated children. Refer to law enforcement. This is a
companion intake. See intake no. 5321486, dated 03/28/2024.



                                                   Page 16 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000071
10/09/2019; Screen Out; Mother disclosed that she is no longer drinking alcohol however, she
was previously drinking 1 - 3 bottles of champagne per night. Mother reported that this occurred
after the children were in bed and she does not feel that she was impaired to the point of not
being able to care for the children.
-----------------------------------------------------------------------------

Native: Family reported no native American ancestry.

Present danger: None

Indian Identity Request uploaded: No, asked SW to do so.

Domestic violence: No domestic violence reported.

Safety: Safety threat [10] was determined inactive.

HOME WALKTHROUGH: SW Dhillon completed it. Both girls share a bedroom, there was lots
of clothes and bunk bed. Aidan has his own room, and MO stated no weapons within household.
The living room was in good condition, there was plenty of food in the kitchen and no safety
threats. Overall there are three bedrooms within the household.

Safe sleep/PURPLE: N/A due to child's age.

SDM: MODERATE

Services: SW Dhillon emailed Veronika FFT information but never got a response back.

Disposition: No ongoing safety threats within household. Parents are protective and no sexual
assault has occurred. Case is now being closed.

Closing letter recommendations: SW will send FAR letter.

HSV: N/A




 Case Name:                   Case ID:          Case Note ID:                      Note Finalized
Goodnight, Veronika        2682764               53589093
Case Note Category: FAR                         Case Note Type: Assessment
Date Occurred: 02/07/2025                       Time Occurred: 11:00 AM
Date Entered: 02/07/2025 01:17 PM               Note Entered by: Pearson, Gracey
Related Participants and Collaterals:           Related Intakes:
Veronika E. Goodnight                           02/06/2025 11:58 AM 5619402
Elora L. Goodnight-Ralidak
Aidan W. Goodnight-Ralidak
Raina S. Goodnight-Ralidak

                                         ACTIVITIES


                                           Page 17 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000072
Activity: Parent/Guardian Contact Participant: Veronika E. Goodnight Location: By Phone
       Time: 11:00 AM           TCM: No
Activity: Contact Education Participant: Veronika E. Goodnight Location: School        Time:
11:00 AM       TCM: No
Activity: Child - Initial Face-to-Face with child Participant: Raina S. Goodnight-Ralidak
       Location: School         Time: 11:00 AM    TCM: No
Activity: Child - Initial Face-to-Face with child Participant: Aidan W. Goodnight-Ralidak
       Location: School         Time: 11:00 AM    TCM: No
Activity: Child - Initial Face-to-Face with child Participant: Elora L. Goodnight-Ralidak
       Location: School         Time: 11:00 AM    TCM: No
                                           CONTACTS

                                          NARRATIVE
Case Note 1 of 2       Entered By : Gracey Pearson            Date Entered : 02/07/2025 Time
Entered : 01:17 PM
Principal: 2/7/25
One week on with mom and one with dad:
Raina comes down to the nurses;
Raina do a speech;
Custody battle:
FO: Matthew: 'tries to be neutral up until this year (January 2024).
MO: Vernokia voulneters at school, loves her children, 'something off'- Had a head injury.
Concerns about dressing her inappropriately.

STEP MOM: Monica Galarmeanu:


DATE & TIME: 2/7/25 11:20AM
LOCATION: Carnation Elementary School
ATTENDANCE: Raina Goodnight-Raldak

SW OBSERVATIONS

GROUND RULES: SW Pearson went over the ground rules and Raina agreed to tell the truth.

CHILD FUNCTIONING:
Ranina reported that she is 6 and going 7 in 3 weeks. Ranina reported that she likes to play dolls
with her.
Ranina reports to love to hangout with her siblings.
Ranina reported that playing

HOUSEHOLD:
Ranina reported that she Collin's (step-dad)
Brother, mother
Share a room with Aiden,

MOM: Ranina reported that likes to go horse back riding or bowling, half a day with mom,
Ranina reported that on Wednesday's mom does not cook, FO reported to. A candy,


                                           Page 18 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000073
DAD: Ranina reported that


PARENTING PRACTICES

DISCIPLINE:
Raina: resonpible, kind, do not push anyone,
Brother broke the rules; brother punching,
No throwing rules,
Spanking on the butt by mom, one spanking
Brother broke and did not get a spanking,


SDM/ PARENT FUNCTION

SAFETY:
MOM: yes.
DAD: kind of because of he lives in the woods

ALLEGATIONS

ANYTHING ELSE
CHILD INTERVIEW NOTE TEMPLATE

DATE & TIME: 2/7/25 at 11:30AM
LOCATION: Carnation Elementary School
ATTENDANCE: Aidan (8) Goodnight-Radidak

SW OBSERVATIONS:

GROUND RULES: SW Pearson went over the ground rules and Aiden(8) agreed to tell the truth.
CHILD FUNCTIONING: Aiden reported that he likes to collect cards and Godzilla, and play
games on his phone. Aiden reported that he likes art.

HOUSEHOLD:
Aiden reported that he lives with mom and dad. Aiden reported that he has realy



PARENTING PRACTICES:
MO: likes to snuggle with mom, play games with MO after dinner, and that for dinner
Aiden reported that his mom gets really mad and when this happens she goes down to her room
for an hour and goes to her room for the whole day. Aiden reported that his siblings don't really
like them because his siblings because he through a snow man.
MO reported that,
FO:

DISCIPLINE:


                                           Page 19 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000074
Adien reported that MO says that because his the only boy, 'he needs to protect everyone'.
Aiden reported that MO gets mad 'for no reason'. Aiden reported that MO picked him up by the
ear and hurt,
Aiden reported that MO buys pizza, mac n cheese,

FO: Aiden reported that his dad sends the kids to their rooms even if he doesn't get into trouble.
Aiden reported that he wishes that his dad was more fair and would stop arguing.

SDM/ PARENT FUNCTION

SAFETY:
MO: yes
FO: kind of because of the trampoline he says no,

ALLEGATIONS

ANYTHING ELSE
CHILD INTERVIEW NOTE TEMPLATE

DATE & TIME: 2/7/25
LOCATION: Carnation Elementary school
ATTENDANCE: Elora (9) Goodnight-Radidak

SW OBSERVATIONS

GROUND RULES: SW Pearson went over the ground rules and Elora agreed to tell the truth.

CHILD FUNCTIONING: likes to watch tv, do her nails, likes to color,

Two younger sister and younger, Aiden.
Likes to play in the snow, plays,

HOUSEHOLD:
Parents are divorcesed.
MO: can talk to her about, play together, and that she is very fun to be around. Doesn't like when
she gets mad uses a 'stern voice' and getting,

FO: can help her with stuff and lets her go to birther pay parties. Can use a stern voice.



PARENTING PRACTICES

DISCIPLINE:
MO: don't speak when MO is speaking, be respectful, clean up. If you don't follow the rules they
get sent to the room, ster

FO: reported that the same rules, don't talk when dad is talking, be respectful,



                                            Page 20 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000075
SDM/ PARENT FUNCTION

SAFETY: Safe means
MO: yes.
FO: yes.

ALLEGATIONS:
Sometimes Elora reported that she has to cook her own food when shes at her moms, Elora
reported that sometimes that she has enough food but sometimes he doesn't.

ANYTHING ELSE
Case Note 2 of 2 Correction:            Entered By : Gracey Pearson            Date Entered :
04/07/2025 Time Entered : 02:20 PM
CONVERSATION WITH Principal: 2/7/25
Principal reported that the children do one week on with mom and one with dad:
Principal reported that there is an obvious custody battle between MO and FO.
Principal reported that FO, Matthew: 'tries to be neutral up until this year (January 2024).
Principal reported that MO, Vernokia does help out at school, loves her children, but that there is
'something off' an that MO had a previous head injury.
Principal reported that there is a step mom, Monica that helps take care of the children when they
are with FO.


******************************************************************************
*
DATE & TIME: 2/7/25 11:20AM
LOCATION: Carnation Elementary School
ATTENDANCE: Raina Goodnight-Raldak

SW OBSERVATIONS: Raina was quiet when speaking with SW but was able to answer some
of SWs questions.

GROUND RULES: SW Pearson went over the ground rules and Raina agreed to tell the truth.

CHILD FUNCTIONING:
Ranina reported that she is 6 and going 7 in 3 weeks. Ranina reported that she likes to play dolls
with her mom.
Ranina reports to love to hangout with her siblings.
Ranina reported that playing outside.

HOUSEHOLD:
Ranina reported that she Collin's (step-dad) is nice, lives with her mom and dad on and off.
Raina reported that she has siblings and that she is the youngest.

MOM: Ranina reported that likes to go horse back riding or bowling with mom.
Ranina reported that on Wednesday's mom doesn't feed her a lot.

DAD: Ranina reported that she gets enough food with dad.


                                           Page 21 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000076
PARENTING PRACTICES: SW asked Raina about her parents and Raina reported that she likes
both of them most of the time.

DISCIPLINE:
Raina reported that at mom's home she needs to be resonpible, kind, do not push anyone and at
FO's home she is expected to be kind. Raina reported that MO will sometimes spank her but FO
does not.

SDM/ PARENT FUNCTION

SAFETY:
MOM: Raina reported that she feels safe with her mom.
DAD: Raina reported that she feels safe with her dad.

ALLEGATIONS: Raina reported that she gets fed more at her dad's than with her mom.

ANYTHING ELSE: n/a.
******************************************************************************
***************

DATE & TIME: 2/7/25 at 11:30AM
LOCATION: Carnation Elementary School
ATTENDANCE: Aidan (8) Goodnight-Radidak

SW OBSERVATIONS: SW observed that Aidan was willing to speak with SW.

GROUND RULES: SW Pearson went over the ground rules and Aiden(8) agreed to tell the truth.
CHILD FUNCTIONING: Aiden reported that he likes to collect cards and Godzilla, and play
games on his phone. Aiden reported that he likes art.

HOUSEHOLD:
Aiden reported that he lives with mom and dad. Aiden reported that he has his own room at his
dad's and that his mom lives with her boyfriend Collin.

PARENTING PRACTICES:
MO: Aiden reported that he likes to snuggle with mom, play games with MO after dinner, and
that for dinner
Aiden reported that his mom gets really mad and when this happens she goes down to her room
for an hour and goes to her room for the whole day. Aiden reported that he does not always get
along with his siblings but that that is normal.

FO: Aiden reported that FO is nice and plays games with him.

DISCIPLINE:
Adien reported that MO says that because his the only boy, 'he needs to protect everyone'.
Aiden reported that MO gets mad 'for no reason'. Aiden reported that MO picked him up by the
ear and hurt,



                                          Page 22 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000077
FO: Aiden reported that his dad sends the kids to their rooms even if he doesn't get into trouble.
Aiden reported that he wishes that his dad was more fair and would stop arguing with MO.
Aiden reported that FO does not get mad but sometimes takes his screen time away.

SDM/ PARENT FUNCTION

SAFETY:
MO: Aiden reported that he feels safe with MO.
FO: Aiden reported to feel safe with FO.

ALLEGATIONS: Aiden reported that he feels safe with MO but that he doesn't get as much food
with MO as he does with dad because MO says that some foods are not good for him.

ANYTHING ELSE: SW observed that Aiden is free of marks/bruising at this time.
******************************************************************************
*************************************************

DATE & TIME: 2/7/25
LOCATION: Carnation Elementary school
ATTENDANCE: Elora (9) Goodnight-Radidak

SW OBSERVATIONS: SW observed that Elora was quiet at first but then was more open with
SW as the interview went on.

GROUND RULES: SW Pearson went over the ground rules and Elora agreed to tell the truth.

CHILD FUNCTIONING: Elora reported that she likes to watch tv, do her nails, likes to color,
and be outside.

HOUSEHOLD:
Elora reported that her parents are divorced.

MO: can talk to her about, play together, and that she is very fun to be around. Doesn't like when
she gets mad uses a 'stern voice' and getting.

PARENTING PRACTICES
FO: Elora reported that FO can help her with stuff and lets her go to birther pay parties. Can use
a stern voice.
MO: Elora reported that MO does yell a lot but denied physical discipline. Elora reported that
MO doesn't feed her or her siblings certain foods because MO says they are bad for them.

DISCIPLINE:
MO: Elora reported that at her mom's house the rules are to not speak when MO is speaking, be
respectful, clean up after yourself and to be nice and if you don't follow the rules they get sent to
the room.

FO: Elora reported that the same rules at Moms are at Dads. Elora reported that she does not get
in trouble often.



                                            Page 23 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000078
SDM/ PARENT FUNCTION

SAFETY: Elora reported that safe means to be protected.
Elora reported that she feels safe with her mom and dad.

ALLEGATIONS:
Sometimes Elora reported that she has to cook her own food when she's at her moms, Elora
reported that sometimes that she has enough food but sometimes he doesn't.

ANYTHING ELSE: n/a.




 Case Name:                   Case ID:         Case Note ID:                      Note Finalized
Goodnight, Veronika        2682764              53589230
Case Note Category: FAR                        Case Note Type: Assessment
Date Occurred: 02/07/2025                      Time Occurred: 02:45 PM
Date Entered: 02/07/2025 02:49 PM              Note Entered by: Pearson, Gracey
Related Participants and Collaterals:          Related Intakes:
Monica Galarneau                               02/06/2025 11:58 AM 5619402

                                       ACTIVITIES
Activity: Contact - Health Contact Participant: Monica Galarneau            Location: Email
       Time: 02:45 PM        TCM: No
                                       CONTACTS

                                          NARRATIVE
Case Note 1 of 2         Entered By : Gracey Pearson           Date Entered : 02/07/2025   Time
Entered : 02:49 PM
MEDICAL COLLATERAL EMAIL:
2/7/25 at 2:45PM

SW Pearson received the following email from the children's doctor confirming and offering
additional information to ensure that all three children are receiving adequate medical care/food
intake while with MO. SW Pearson also uploaded needed medical records and reviewed them
which indicated that all children are being fed/adequately taken care of per intake concerns
regarding food intake.



The email is listed below:


Ms. Pearson,

Veronika Goodnight reached out to me after receiving a call from you regarding a report made
concerning her children's diet and nutrition. Please feel free to reach out to me if you have any
concerns or if you would like me to send any medical records for your investigation. I have been


                                           Page 24 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000079
seeing this family for several years, so I know the children well.       RCW 13.50.100


Sincerely,

Stacy Bowker, ND

110 Cedar Ave., Ste 101
Snohomish, WA 98290

Office phone: (360) 282-4014
Office fax: (360) 282-4017
Case Note 2 of 2 Correction:      Entered By : Gracey Pearson              Date Entered :
04/07/2025 Time Entered : 02:20 PM
This is from Veronika not Monica.




 Case Name:                   Case ID:           Case Note ID:                      Note Finalized
Goodnight, Veronika        2682764                53594271
Case Note Category: FAR                          Case Note Type: Assessment
Date Occurred: 02/10/2025                        Time Occurred: 10:00 AM
Date Entered: 02/10/2025 12:20 PM                Note Entered by: Pearson, Gracey
Related Participants and Collaterals:            Related Intakes:
Veronika E. Goodnight                            02/06/2025 11:58 AM 5619402

                                      ACTIVITIES
Activity: Parent/Guardian Contact Participant: Veronika E. Goodnight Location: By Phone
       Time: 04:00 PM       TCM: No
Activity: Parent/Guardian Contact Participant: Veronika E. Goodnight Location: Parental
Home Time: 10:00 AM         TCM: No
                                      CONTACTS

                                    NARRATIVE
Case Note 1 of 1   Entered By : Gracey Pearson               Date Entered : 02/10/2025      Time
Entered : 12:20 PM
2/10/25 at 10AM
HOME WALK THROUGH
ATTENDANCE: SW PEARSON and MO (Veronika)

SW Pearson arrived at the home and MO greeted SW allowing her into the home. MO reported
that she was in the process of moving into her Fiance's home within the next month and reported
that the home is messy due to this. SW reported that she understood. SW was shown around the
home and observed that this was a three bedroom home in which Elora and Raina share their a
bedroom with a bunk bed and Aidan has his own room on the opposite side on the hall way. MO
denied any fire arms or weapons, SW observed that there are clear exit and entry was both at the
front of the home and through the sliding door in the kitchen. SW observed that the home has


                                            Page 25 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000080
adequate food in the fridge and pantry. SW observed that the home was at a normal temperature
and did not observe any present danger nor immediate safety concerns at this time

******************************************************************************
************************************
DATE AND TIME: 2.10.25 at 4PM
NAME: Veronika Goodnight (MO)
LOCATION: 805 895 0509
ATTENDANCE: SW Pearson and MO

WAC&RCW/BROCHURE/NON-DISCRIMINATION NOTICE: SW Pearson provided all
paperwork during home walk through, and MO agreed to participate in FAR procedure.

ICWA: denied. IIR forms in famlink.

HOUSEHOLD: MO reported that she lives with her children and that Dr. Collins, her finance is
in the home a lot. MO reported that Collin's 24 year old daughter is currently living at the home.

CHILD FUNCTIONING:
AIDEN (8): MO reported that Aiden is very smart, can be lazy with homework, put through
special testing at the school' and that Aiden 'learns a different way (could be ADHD) but that
Aiden is in the process of getting evaluated for ADHD. MO reported that Aiden is a mommy's
boy, and plays sports such as hockey and baseball.

ELORA (9): MO reported that Elora is going to turn 10 next month, and that she is 'sensitive in
the best way possible', smart, and has in tutoring, and now is doing well in school, and loves
fashion. MO reported that FO had concerns for Elora with ADHD but that she got evaluated but
she does not have ADHD. MO reported that Elora is on a specific diet per doctors'
recommendations and is currently in therapy.

RAINA (6): MO reported that Raina is her twin and has ODD. MO reported that Raina has had
trouble with Raina in regards to teachers and can be defiant. MO reported that Raina is 'always
sad on transition day (one week w/ mom and one week with dad), and that Raina has a hard time
with transitions. MO reported that Raina has a history of reporting to the school that she is
hungry, and that MO has talked to the school about these issues, and conversating with the
school regarding this. MO reported that Raina is in therapy and is a sweetheart.

PARENTING PRACTICES
PER MO: MO reported that she has been working on 'not swearing as she an Italian new yorker'.
MO reported that she does a good job of loving her children and that she believes herself to be a
good mom. MO reported that she does everything to support her children and to make sure they
are all safe, and happy.

PER FO: MO reported that FO and herself separated due to 'violent behaviors and that FO can be
'a little rough'. MO reported that she had to flee their relationship due to DV, but that MO
reported that FO does love his children. MO reported that FO has 'narcissistic tendencies'. MO
reported that MO does not talk bad to the children about their father. MO reported that she refers
to the therapist when the children come to MO in regards to their father. MO reported that the


                                           Page 26 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000081
last CPS call was when the children were in his care, and that they go to an unsafe church (per
previous intake). MO reported that the children will report that FO will only send the children to
their room but that MO does not want to interfere with FO's parenting practices.

DISCIPLINE:
MO reported that the children and herself implement the '5 to 1' ratio meaning that 1 wrongdoing
means you have to do 5 good things. MO reported that MO and her children work together to
understand that they do not have control over the outside world but that they do have control
over their own actions. MO reported that she does EFT tapping with the children to regulate their
emotions. MO reported that she believes her discipline is impactful. MO reported that she denies
any physical form of discipline.

SUPPORT SYSTEM:
MO reported that her friends are a form of support for her along with Dr. Collin. MO provided
Dr. Collin as a collateral.

SDM/ PARENT FUNCTIONING

WORK: MO reported that she works at IGA (1 or 2 days a week). MO reported that during this
moving process, she is currently in a transitional process. MO reported that she asked her boss to
be taken off the schedule for now and that she will start working when she gets back'. MO
reported that she makes money teaching at Collin's practice on Thursday's.

SUBSTANCE USE: denied.

MENTAL HEALTH: MO reported that her children and herself are all in therapy.

PHYSICAL HEALH: MO reported that she has a brain injury but that it does not get in the way
of her parenting.

CRIMINAL HISTORY: n/a.

CA/N HISTORY: MO reported that 'there should have been' but that she has a memory disorder
due to trauma.

DOMESTIC VIOLENCE: MO reported that with her previous partner she experienced DV. MO
reported that now the children's father and herself are 'at peace' but that it took a long time to get
to this point. SW offered resources MO reported she has support.

MILITARY: n/a.
ALLEGATIONS: MO reported that she does feed her children (showed SW during home walk
through food, and doctor's notes to confirm this) and that her children eat 'healthy foods' and that
she provides enough food for them along with following doctor's orders (uploaded on famlink).
MO reported that all children are up to date on PCP and have been seen at the doctor as they all
eat certain foods while they spend time with MO. MO reported that she does not know what they
eat when they are with their father (every other week) but that she denies restricting the
children's food intake.



                                             Page 27 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000082
ADDITIONAL INFORMATION: MO reported that within the next month, the children and
herself will be moving in with her Fianc. MO reported that she is concerned that FO may have a
hand gun in his home. SW Pearson reported that she will follow up with FO.

UNMET NEEDS: denied. MO reported that her family has food stamps. MO reported that she
wants her current home without her current landlord to where she is moving with Collin. MO
reported the she and her family has EBT.

COLLATERAL CONTACT INFO: Dr. Collin (Fianc): RCW 13.50.100




 Case Name:                   Case ID:          Case Note ID:                      Note Finalized
Goodnight, Veronika        2682764               53596357
Case Note Category: FAR                         Case Note Type: Assessment
Date Occurred: 02/11/2025                       Time Occurred: 10:00 AM
Date Entered: 02/11/2025 10:21 AM               Note Entered by: Pearson, Gracey
Related Participants and Collaterals:           Related Intakes:
Veronika E. Goodnight                           02/10/2025 4:16 PM 5619864

                                           ACTIVITIES
Activity: Contact - Collateral Participant: Veronika E. Goodnight Location: By Phone        Time:
10:00 AM       TCM: No
                                           CONTACTS

                                          NARRATIVE
Case Note 1 of 1         Entered By : Gracey Pearson            Date Entered : 02/11/2025   Time
Entered : 10:21 AM
COLLATERAL FOR MO:

DATE AND TIME: 2.11.25 at 10AM
NAME: Collin Derieg (Veronika's Partner)
LOCATION: RCW 13.50.100
ATTENDANCE: SW Pearson and Collin

HOUSEHOLD: Collin reported that he was Veronika's doctor for 5 years and became romantic
within the last 2 years. Collin reported that he sees the children every other week (when MO has
them in their care). Collin reported that Veronika and the children come over to his home in
Monroe.


CHILD FUNCTIONING:
Elora (9): Collin reported that Elora is a good kid, and sweet. Collin reported that he doesn't have
any concerns about any of the children developmentally. Collin reported that they all act like
siblings

Aidan (8): Collin reported that Aidan is a good kid and that he does not have any concerns for


                                            Page 28 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000083
him.

Raina (6): Collin reported that Raina is a sweet kid but that she may benefit from speech therapy.

PARENTING PRACTICES:
MO: Collin reported that MO is a very loving mom, supportive, and kind. Collin reported that
MO is a very kind mom that supports her children and implements positive partnering.

FO: Collin reported that he has not had any interactions with FO and 'cannot speak to his
parenting'.

DISCIPLINE:
Collin reported that MO will put the children in time outs, Collin denies any form of physical
discipline, and that the children are expected to do their homework and to eat healthy if they are
going to have any sweets, they need to finish their food first.

ALLEGATIONS: Collin reported that the children are on 'special diets' per doctor's orders but
that Collin does not have any concerns regarding what the children are eating. Collin reported
that MO has these doctor's orders for the children to eat certain foods and then the children go to
their FO's home where there are 'no regulations and that Collin reports that there might be a hard
time transitioning from households.

SUPPORT SYSTEM: Collin reported that he tries to be a support for MO and MO has another
friend that support her. Collin reported that MO is Mormon and utilizes it as a form of support.

SDM/ PARENT FUNCTIONING
WORK SCHDULE: MO reported that she has a following online as a financial support.

MILITARY: denied.

MENTAL HEALTH: denied.

SUBSTANCE USE: denied.

CRIMINAL HISTORY: denied.

DOMESTIC VIOLENCE: Collin reported that Veronika has been in a DV relationship with FO.




 Case Name:                   Case ID:          Case Note ID:                       Note Finalized
Goodnight, Veronika        2682764              53640813
Case Note Category: CPS                         Case Note Type: Supervision
Date Occurred: 02/24/2025                       Time Occurred: 01:24 PM
Date Entered: 02/24/2025 01:27 PM               Note Entered by: Smith, Jazie, B.
Related Participants and Collaterals:           Related Intakes:
Makayla N. Woodle
Veronika E. Goodnight


                                           Page 29 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000084
Elora L. Goodnight-Ralidak
Aidan W. Goodnight-Ralidak
Raina S. Goodnight-Ralidak
Mathew W. Ralidak
Monica Galarneau
River Q. Muggli
Addie Unknown
Colin Derieg

                                        ACTIVITIES
Activity: Monthly Supervisor Review        Participant: Makayla N. Woodle       Location:
Children's Administration Office    Time: 01:24 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Veronika E. Goodnight Location:
Children's Administration Office    Time: 01:24 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Elora L. Goodnight-Ralidak
       Location: Children's Administration Office Time: 01:24 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Aidan W. Goodnight-Ralidak
       Location: Children's Administration Office Time: 01:24 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Raina S. Goodnight-Ralidak
       Location: Children's Administration Office Time: 01:24 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 01:24 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 01:24 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Monica Galarneau        Location:
Children's Administration Office    Time: 01:24 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: River Q. Muggli Location: Children's
Administration Office        Time: 01:24 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Addie Unknown Location: Children's
Administration Office        Time: 01:24 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Colin Derieg    Location: Children's
Administration Office        Time: 01:24 PM        TCM: No
                                         CONTACTS

                                         NARRATIVE
Case Note 1 of 1       Entered By : Jazie B. Smith Date Entered : 02/24/2025        Time Entered :
01:27 PM
CONCERNS: Parents have 50/50 custody. Children complain that they are not fed enough when
they spend their week with mother and that they are hungry. Per oldest girl, Elora, all they have
had to eat this week is eggs and peanut butter, prepared by Elora. They normally get meals at
school, but no school past few days because of snow. Also, the children show up at father's home
in poor condition, wearing dirty clothes, with dark circles under their eyes, which clear up after a
few days in father's home.

IFF: SW completed at the school with all 3 of the children. Elora told SW that she doesn't get
enough food at her mothers house.



                                            Page 30 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000085
SW completed mothers interview. The mother sent photos of her home with all of the food and
the medical records because she has Elora on a special diet and the father doesn't follow this.

The father said the mother is a horrible mother and has MH concerns.

They are going through a difficult separation.

Safety Assessment due 3/8
Safety threat being explored: #10

TO DO:
Walkthrough of the fathers home




 Case Name:                   Case ID:           Case Note ID:                      Note Finalized
Goodnight, Veronika        2682764               53707128
Case Note Category: FAR                          Case Note Type: Assessment
Date Occurred: 02/27/2025                        Time Occurred: 12:00 PM
Date Entered: 03/11/2025 12:47 PM                Note Entered by: Pearson, Gracey
Related Participants and Collaterals:            Related Intakes:
Mathew W. Ralidak                           02/10/2025 4:16 PM 5619864
                                            02/14/2025 1:45 PM 5621715
                                            02/21/2025 9:13 AM 5622330
                                            02/18/2025 8:06 AM 5623944
                                            02/28/2025 12:00 PM 5629627
                                      ACTIVITIES
Activity: Parent/Guardian Contact Participant: Mathew W. Ralidak    Location: By Phone
       Time: 12:00 PM       TCM: No
                                      CONTACTS

                                          NARRATIVE
Case Note 1 of 1         Entered By : Gracey Pearson             Date Entered : 03/11/2025   Time
Entered : 12:47 PM
PARENT CONTACT
Matthew (FO)
2/27/25 at 12PM

SW Pearson spoke to FO on the phone regarding the current FAR intake. SW Pearson explained
that she needed to schedule a time with FO to conduct an official interview along with a home
walk through. FO reported that FO and Monica were going to be gone/out of town for the
following week. SW Pearson reported that she understood and would have another SW conduct
HWT then SW Pearson will schedule official interview with FO along with his wife, Monica at a
later date. FO reported that he is willing to work with SW and that he looks forward to speaking
with SW as FO and his ex, Veronika have different parenting styles/views on food intake which
pertains to the FAR intake. SW reported that she understands and will reach out to FO and
Monica when the come back in to town. FO thanked SW and the phone call ended.


                                           Page 31 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000086
 Case Name:                   Case ID:          Case Note ID:                       Note Finalized
Goodnight, Veronika        2682764               53664066
Case Note Category: FAR                         Case Note Type: Assessment
Date Occurred: 02/28/2025                       Time Occurred: 10:00 AM
Date Entered: 02/28/2025 02:28 PM               Note Entered by: Fullah, Abba, H.
Related Participants and Collaterals:           Related Intakes:
Mathew W. Ralidak                               02/28/2025 12:00 PM 5629627

                                      ACTIVITIES
Activity: Parent/Guardian Contact Participant: Mathew W. Ralidak             Location: Parental
Home Time: 10:00 AM         TCM: No
                                      CONTACTS

                                         NARRATIVE
Case Note 1 of 1         Entered By : Abba H. Fullah Date Entered : 02/28/2025       Time Entered :
02:28 PM
Home Walkthrough: Mathew Ralidak Residential Home.


SW OBSERVATION:

SW arrived at the non-household of Mathew Ralidak (father) in the city of Duval, and he was
seen standing outside his garage entrance waiting for SW as this meeting was scheduled. We
both greeted each other and SW introduced himself and I also outline my purpose of being there.
The home is a two-level building with an open plan space of the home, whereas you can see the
living room, dinning and kitchen. However, the family seems to be doing renovation as there
were lot of boxes and building materials in the open as a handyman worker was also seen
working. The renovation does not seen to be a hazard towards the children movement inside the
home.

SW observed the children each have their own room, the two younger girls have bunkbeds in
their rooms and the oldest child have his own room the basement floor. All the children rooms
appeared be untidy, however, there was no present danger observed or concerns to report. The
home sufficient food in the refrigerator and also in the food pantry. Both toilets in the home are
flushable and there is running warm water in the home. The kitchen area is decent and SW did
not observed any sharps utensils or cleaning chemicals in the open.




 Case Name:                   Case ID:          Case Note ID:                       Note Finalized
Goodnight, Veronika       2682764                53697933
Case Note Category: FAR                         Case Note Type: Assessment
Date Occurred: 03/07/2025                       Time Occurred: 02:40 PM



                                            Page 32 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000087
Date Entered: 03/07/2025 03:20 PM              Note Entered by: Pearson, Gracey
Related Participants and Collaterals:          Related Intakes:
Veronika E. Goodnight                           01/06/2025 7:14 PM 5581786
                                                02/06/2025 11:58 AM 5619402
                                                02/10/2025 4:16 PM 5619864
                                                02/14/2025 1:45 PM 5621715
                                                02/21/2025 9:13 AM 5622330
                                                02/18/2025 8:06 AM 5623944
                                                02/28/2025 12:00 PM 5629627
                                           ACTIVITIES
Activity: Contact - Collateral Participant: Veronika E. Goodnight Location: Email          Time:
02:40 PM       TCM: No
Activity: Contact - Collateral Participant: Veronika E. Goodnight Location: By Phone       Time:
02:40 PM       TCM: No
                                           CONTACTS

                                        NARRATIVE
Case Note 1 of 1       Entered By : Gracey Pearson        Date Entered : 03/07/2025 Time
Entered : 03:20 PM
COLLATERAL:
3/7/25 2:40PM
SW Pearson received and phone call and follow up email (listed below) from Raina's therapist.
Hi Gracey,

Thank you again for taking my call. I saw Raina on Monday 3/3/2025 where she shared new
information with me.

Raina entered my office telling me "I am a bad kid, all I do is lie. I am bad" She shared that mom
yells at her all the time, tells her she is lying, and spanks her. When asked how often she gets
spanked, Raina replied with " a lot." Raina also said that at her dads house she is never spanked.

Raina has also asked me questions "why she has to leave dads house", and made statements that
"mom doesn't play with her".

It should be noted that I have not spoken to mom about the use of corporal punishment with
Raina. After my interactions with both Raina and mom I have increased concerns of how that
information will be used. For that reason I have not talked to the mom about any new
information that has been shared with me.

Thanks for your time! Let me know if you have any other questions.

Danielle




 Case Name:                 Case ID:           Case Note ID:                      Note Finalized
Goodnight, Veronika          2682764            53813258


                                           Page 33 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000088
Case Note Category: FAR                         Case Note Type: Assessment
Date Occurred: 03/11/2025                       Time Occurred: 01:00 PM
Date Entered: 04/07/2025 02:34 PM               Note Entered by: Pearson, Gracey
Related Participants and Collaterals:           Related Intakes:
Monica Galarneau                            02/06/2025 11:58 AM 5619402
                                            02/10/2025 4:16 PM 5619864
                                            02/14/2025 1:45 PM 5621715
                                            02/21/2025 9:13 AM 5622330
                                            02/18/2025 8:06 AM 5623944
                                            02/28/2025 12:00 PM 5629627
                                      ACTIVITIES
Activity: Parent/Guardian Contact Participant: Monica Galarneau     Location: By Phone
       Time: 01:00 PM       TCM: No
                                      CONTACTS

                                        NARRATIVE
Case Note 1 of 1       Entered By : Gracey Pearson       Date Entered : 04/07/2025 Time
Entered : 02:34 PM
DATE AND TIME: 3/11/25 at 1PM
NAME: Monica
LOCATION: 206 406 7920
ATTENDANCE: SW Pearson and Monica (Matthew's wife)
HOUSEHOLD: Monica reported that she had been with Matthew for 5 years. Monica reported
that she and Matthew have the children one week on and one week off.

CHILD FUNCTIONING:
Aiden (8): Monica reported that Aiden is quiet at first, loves to observe, and once you find what
he is interested in, he can talk about it forever such as science and dinosaurs. Monica reported
that Aiden loves space and animals. Monica reported that Aiden goes back and forth between
being vegetarian because he loves animals, and that Aiden feels empathetic to other people.
Monica reported that Aiden is very sweet and takes really good care of his sisters. Monica
reported that Aiden may have support with the school with reading, but that Aiden is currently
doing testing.


Elora (9): Monica reported that Elora is a big ball of personality and has a lot of emotions in a
wise way, is poetic, and that Elora feels big. Monica reported that Elora loves to play softball and
try new things. Monica reported that Elora is creative, smart, and loves to be funny/make people
laugh. Monica reported that Elora is very loving, and it is Monica and Elora spend a lot of time
together. Monica reported that Elora has a lot of friends and that she does well in school.


Raina (6): Monica reported that the 'house sass' and that Raina is witty and always has been.
Monica reported that Raina is charming, observant, and funny. Monica reported that Raina is a
force of nature. Monica reported that Raina is set to be CEO at some point in time. Monica
reported that Raina loves people, and that Raina takes younger children under her wing, and is
interested in learning/having fun conversations. Monica reported that Raina has been working


                                            Page 34 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000089
with the school due to behavioral issues.

PARENTING PRACTICES:
PER FO: Monica reported that Matthew is good at communicating and that it has improved over
the years. Monica reported that Matthew is a fun and loving dad. Monica reported that Matthew
is good at talking to the children and their emotions. Monica reported that Matthew struggles
with ADD and has reading issues so Matthew interprets questions which may lead to Matthew
misunderstanding situations. Monica reported that Matthew had been working to become more
patient with both Monica, herself along with the children.


PER MO: Monica reported that she does not communicate with Veronika and does not contact
Monica. Monica reported that she had met Veronika a couple of times prior to Matthew and
Monica started dating. Monica reported that Veronika accused Monica of having an affair with
Matthew even though Monica and Matthew were not dating prior to Veronika and Matthew
separating. Monica reported that Veronika had reached out to her during 2020 as Veronika
reported that Matthew was abusing Veronika, and that Veronika had a plan to flee from
Matthew. Monica reported that this was her first interaction with Veronika.
Monica reported that she observed that MO yells a lot with the children and that Monica
observed that MO did not take very well of the children. Monica reported that she observed MO
yelling at the children at events, over facetime while at Matthew's house, and that the children
have disclosed that MO gets upset when Monica is around the children.

DISCIPLINE:
Monica reported that when the children are with FO and Monica, the children can eat whatever
they want, and that they can eat when they are hungry. Monica reported that in working with the
children's therapist, FO and Monica have been working with the children to eat some junk food
as they are allowed to be children. Monica reported that MO has had children on certain diets
and sometimes not. Monica reported that she is confused about why/what the diets are for the
children when they are with MO. Monica reported that there have been arguments with the
school due to diagnosis's ODD leading to dietary restrictions. Monica reported that MO is
'Yucka' app that shows if the 'food is good or bad'. Monica reported that MO will take food away
as punishment.

Monica reported that when the children with FO and herself, the rules revolve around safety,
asking for permission and that there is more structure than rules such as bedtimes, dinner times,
and brushing their teeth.

SUPPORT SYSTEM:
Monica reported that church is a form of support along with Matthew and friends in their area.
Monica reported that she works in the theater community in Seattle and work friends.

SDM/ PARENT FUNCTIONING

WORK:
Monica reported that she works 9-5 from home in the event industry.
Monica reported that Matthew works for the same company as Monica as more of the
coordinator.


                                            Page 35 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000090
SUBSTANCE USE: denied.

MENTAL HEALTH: Monica reported that at one point there was a diagnosis for MO for BPD.
Monica reported that FO is working on his MH but not been diagnosed

PHYSICAL HEALH: Monica reported that the children's PCP have reported that the children do
not have any dietary restrictions.

CRIMINAL HISTORY: denied for FO

CA/N HISTORY: denied.

DOMESTIC VIOLENCE: Monica reported that both parents have reported to feel unsafe with
one another, but that Veronika has been 'untrue'. Monica reported that she has seen a video of
Veronika in 2019 of verbally abusing FO.

MILITARY: n/a.

ALLEGATIONS: Monica reported that all children have reported that when 'mommy gets out of
control' the children must calm there mom down and that they are worried about what will
happen when mom gets mad. Monica reported that all children have reported that they get
spanked, cursed at, and smacked across the face. Monica reported that Raina therapists have
disclosed that MO's now ex-fianc had 'laid hands on the children's. Monica reported that the
children have reported that mom and Collin are no longer together. Monica reported that FO had
tried to get full custody of the children but that the judge reported that MO is a 'beautiful young
woman' which led to 50-50 custody. Monica reported that she is extremely frustrated with the
system because FO needs to have at least 50-50 custody and that as of now, Monica and FO are
working to document everything to get full-custody of the children.
UNMET NEEDS: Monica reported that the children do not have consistent housing due to MO
posting this on social media, and that food has been taken away from the children as punishment.
Monica reported that MO needs MH care/support. Monica reported that MO is not working at
this time.
ADDITIONAL INFOMRATION: Monica reported that FO is working to get full custody and
will be requesting records post CPS process.




 Case Name:                   Case ID:           Case Note ID:                      Note Finalized
Goodnight, Veronika        2682764               53782600
Case Note Category: FAR                          Case Note Type: Assessment
Date Occurred: 03/31/2025                        Time Occurred: 12:00 PM
Date Entered: 03/31/2025 12:18 PM                Note Entered by: Pearson, Gracey
Related Participants and Collaterals:            Related Intakes:
Veronika E. Goodnight                            02/06/2025 11:58 AM 5619402
Raina S. Goodnight-Ralidak                       02/10/2025 4:16 PM 5619864
                                                 02/14/2025 1:45 PM 5621715


                                           Page 36 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000091
                                                 02/21/2025 9:13 AM 5622330
                                                 02/18/2025 8:06 AM 5623944
                                                 02/28/2025 12:00 PM 5629627
                                           ACTIVITIES
Activity: Contact - Collateral Participant: Raina S. Goodnight-Ralidak   Location: Email
       Time: 12:00 PM          TCM: No
Activity: Contact - Collateral Participant: Veronika E. Goodnight Location: Email     Time:
12:00 PM       TCM: No
                                           CONTACTS

                                         NARRATIVE
Case Note 1 of 1        Entered By : Gracey Pearson             Date Entered : 03/31/2025       Time
Entered : 12:18 PM
3/31/25 at 12PM

SW Pearson received the following email from Raina's therapist regarding additional concerns
for this family.

Awesome thank you. Raina asked last week to speak with me, (it was our off week from
therapy), her dad made an appointment for Thursday 3/27. Ten minutes before our session her
father called my line, and said Raina was freaking out because her mom's car was parked out
front (I can't confirm this, as I don't know what the mom drives) but Raina was able to describe
the car out front perfectly. I had to go outside to Raina's car, to provide reassurance that her mom
was not in our building and that she would not be allowed in our building. I even went as far as
saying I would lock the main lobby office door, so that no one else could enter our building (I
was the only therapist left for the night). With my reassurance, Raina did enter our building as
long as I locked the door. Throughout our session if she heard a noise she would ask me to go
make sure mom hadn't come in, which I did.

She then shared with me that mom knew a man she called "grandpa" but isn't her actual grandpa
was buying them a RV to live on his land. She shared that the man always wants hugs from her
but she doesn't want to give him hugs, because he's creepy and gross. She also shared that he has
tried to kiss her on the lips but she told him she doesn't like that or not but he still tries. She told
me she doesn't want to live next to this man in the RV.

She also asked repeatedly for me to not tell mom about this. That I could only speak about it with
dad and stepmom because she doesn't want mom to get mad. This concerns me as a professional
but also makes it difficult because I don't want to ask mom about my concerns, in fear that the
blame will be put on Raina.

Thank you again for your time. Let me know if you have any questions or if I should relay this
information somewhere else.

******************************************************************************
***************************************
Parent Contact: Matthew Ralidak
12:18PM


                                              Page 37 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000092
SW Pearson called FO to address the email along with following up with FO as he texted SW
regarding additional concerns for the children while in MO's care.

SW Pearson left VM for FO and FO responded via text that SW and FO can speak 4/1/25 at
8:30AM via phone.




 Case Name:                   Case ID:        Case Note ID:                       Note Finalized
Goodnight, Veronika        2682764             53787600
Case Note Category: FAR                       Case Note Type: Assessment
Date Occurred: 04/01/2025                     Time Occurred: 08:30 AM
Date Entered: 04/01/2025 09:28 AM             Note Entered by: Pearson, Gracey
Related Participants and Collaterals:         Related Intakes:
Mathew W. Ralidak                             02/28/2025 12:00 PM 5629627

                                      ACTIVITIES
Activity: Parent/Guardian Contact Participant: Mathew W. Ralidak           Location: By Phone
       Time: 08:30 AM       TCM: No
                                      CONTACTS

                                          NARRATIVE
Case Note 1 of 1         Entered By : Gracey Pearson          Date Entered : 04/01/2025    Time
Entered : 09:28 AM
4/1/25 at 8:30AM

SW Pearson spoke to FO on the phone regarding new concerns about MO having the children
stay in a trailer with an unknown person and FO provided their names as 'Jim Solberg and
Nathan 'Kanis' Solberg. FO reported that Raina specifically has voiced that these men have tried
to kiss her on the mouth and make Raina uncomfortable. FO did not have more information
regarding the whereabouts of the Trailer and reported that MO's previous partner, Collin have
broken up therefore leading FO to not know where the children are located when the children are
in MO's care.




 Case Name:                   Case ID:        Case Note ID:                       Note Finalized
Goodnight, Veronika        2682764             53789875
Case Note Category: CPS                       Case Note Type: Supervision
Date Occurred: 04/01/2025                     Time Occurred: 02:46 PM
Date Entered: 04/01/2025 02:51 PM             Note Entered by: Smith, Jazie, B.
Related Participants and Collaterals:         Related Intakes:
Makayla N. Woodle
Veronika E. Goodnight
Elora L. Goodnight-Ralidak
Aidan W. Goodnight-Ralidak


                                          Page 38 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000093
Raina S. Goodnight-Ralidak
Mathew W. Ralidak
Monica Galarneau
River Q. Muggli
Addie Unknown
Colin Derieg

                                        ACTIVITIES
Activity: Monthly Supervisor Review        Participant: Makayla N. Woodle       Location:
Children's Administration Office    Time: 02:46 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Veronika E. Goodnight Location:
Children's Administration Office    Time: 02:46 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Elora L. Goodnight-Ralidak
       Location: Children's Administration Office Time: 02:46 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Aidan W. Goodnight-Ralidak
       Location: Children's Administration Office Time: 02:46 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Raina S. Goodnight-Ralidak
       Location: Children's Administration Office Time: 02:46 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 02:46 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 02:46 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Monica Galarneau        Location:
Children's Administration Office    Time: 02:46 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: River Q. Muggli Location: Children's
Administration Office        Time: 02:46 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Addie Unknown Location: Children's
Administration Office        Time: 02:46 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Colin Derieg    Location: Children's
Administration Office        Time: 02:46 PM        TCM: No
                                         CONTACTS

                                         NARRATIVE
Case Note 1 of 1       Entered By : Jazie B. Smith Date Entered : 04/01/2025        Time Entered :
02:51 PM
CONCERNS: Parents have 50/50 custody. Children complain that they are not fed enough when
they spend their week with mother and that they are hungry. Per oldest girl, Elora, all they have
had to eat this week is eggs and peanut butter, prepared by Elora. They normally get meals at
school, but no school past few days because of snow. Also, the children show up at father's home
in poor condition, wearing dirty clothes, with dark circles under their eyes, which clear up after a
few days in father's home.

IFF: SW completed at the school with all 3 of the children. Elora told SW that she doesn't get
enough food at her mothers house.

SW completed mothers interview. The mother sent photos of her home with all of the food and
the medical records because she has Elora on a special diet and the father doesn't follow this.


                                            Page 39 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000094
The father said the mother is a horrible mother and has MH concerns.

They are going through a difficult separation.

Safety Assessment due 3/8
Safety threat being explored: #10

TO DO:
Walkthrough of the fathers home

UPDATE 04/01/2025:

SW Fullah assisted with home walkthrough.

SW got an update from therapist that the Raina is being kissed by a grandfather who lives in
some trailer. Information is unknown as to the grandfather or the trailer location.

TO DO:
Call mother and ask about this grandfather




 Case Name:                   Case ID:           Case Note ID:                      Note Finalized
Goodnight, Veronika        2682764                53809839
Case Note Category: FAR                          Case Note Type: Assessment
Date Occurred: 04/04/2025                        Time Occurred: 02:00 PM
Date Entered: 04/04/2025 02:33 PM                Note Entered by: Pearson, Gracey
Related Participants and Collaterals:            Related Intakes:
Veronika E. Goodnight                            02/28/2025 12:00 PM 5629627
Mathew W. Ralidak

                                      ACTIVITIES
Activity: Parent/Guardian Contact Participant: Mathew W. Ralidak     Location: By Phone
       Time: 02:00 PM       TCM: No
Activity: Parent/Guardian Contact Participant: Veronika E. Goodnight Location: By Phone
       Time: 02:20 PM       TCM: No
                                      CONTACTS

                                          NARRATIVE
Case Note 1 of 1         Entered By : Gracey Pearson             Date Entered : 04/04/2025   Time
Entered : 02:33 PM
4/4/25 2PM
PARENT CONTACT:

SW Pearson contacted MO via phone per additional concerns regarding the children reporting to
be unconformable with new living situation in a trailer and that their 'grandpa' is making Raina
uncomfortable/trying to kiss her on the mouth. SW Pearson explained to MO that these were the

                                             Page 40 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000095
concerns along with the unsteady living environment for the children as SW Pearson was told by
MO that when MO has the children, they are staying at Collin's home in which SW did a HWT
along with interview with no safety concerns. MO reported that she was upset that these
allegations were being called in and reported that she was at the school, saying goodbye to her
children.MO reported that her bestfriend and another close family friend are where MO is
planning on staying with eventually as the commute to the children's school from Collin's home
in Monroe is difficult. SW observed that MO was speaking to Collin in the background and SW
observed that MO was becoming upset as she reported to have seen FO in the parking line. MO
reported to Collin that she may go over there to insist that FO stops calling reports in. SW asked
MO who she was speaking to, MO confirmed that it was Collin, and MO reported that she was
extremely upset. MO then reported that she knows that FO called in a report and SW Pearson
explained that the reporter will remain confidential but if MO is able to provide name/address of
where she is living, SW can complete safety assessment to address the concerns. MO reported
that she will do this. Then the phone call ended.

SW Pearson then received multiple texts from MO reporting that it is her right to know who
called in the report. MO texted SW Pearson videos/pictures of the trailer (screenshots in
Famlink).



PARENT CONTACT:

SW Pearson received a call from FO, Matthew, and he reported that MO/ Collin came up to his
car 'berating him' and yelling. FO reported that he got some of it on video and that he did not
know who else to call so he called SW Pearson. SW Pearson reported that she understands why
FO called and validated his concerns. SW Pearson reported that she will be documenting this
along with FO reporting that he will get a report from the school. SW asked FO to send SW the
report, if he is willing, so that can be documented as well. FO agreed to do so. FO reported that
he was caught off guard and felt that Collin was out of line by intimating him at school. FO
reported that he wants SW to document this and SW Pearson reported that she is required to by
policy. FO thanked SW Pearson and SW Pearson told FO to keep her updated if anything
changes/comes up over the weekend.




 Case Name:                   Case ID:         Case Note ID:                        Note Finalized
Goodnight, Veronika        2682764              53810972
Case Note Category: FAR                        Case Note Type: Assessment
Date Occurred: 04/06/2025                      Time Occurred: 12:40 PM
Date Entered: 04/06/2025 05:20 PM              Note Entered by: Matheny, Kari, A.
Related Participants and Collaterals:          Related Intakes:
Veronika E. Goodnight                          04/04/2025 7:02 PM 5666738
Raina S. Goodnight-Ralidak
Mathew W. Ralidak



                                           Page 41 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000096
                                          ACTIVITIES
Activity: Parent/Guardian Contact Participant: Veronika E. Goodnight Location: By Phone
       Time: 01:38 PM         TCM: No
Activity: Child - Attempted Initial Face-to-Face   Participant: Raina S. Goodnight-Ralidak
       Location: Parental Home        Time: 12:40 PM       TCM: No
                                           CONTACTS

                                        NARRATIVE
Case Note 1 of 1     Entered By : Kari A. Matheny           Date Entered : 04/06/2025 Time
Entered : 05:20 PM
SW went to the address that was on the intake, in carnation, and no one appeared to be home.

138 pm SW was able to make contact with the mother by phone. She informed the SW that she
no longer lives at that address due to mold. She has moved to 10323 Fryer Creek Rd. Monroe
WA. Mother stated that Raina is not with her this weekend but with her father.

SW thanked her for the information and told her a SW will be following up with her.




 Case Name:                   Case ID:          Case Note ID:                      Note Finalized
Goodnight, Veronika        2682764               53813148
Case Note Category: FAR                         Case Note Type: Assessment
Date Occurred: 04/07/2025                       Time Occurred: 12:00 AM
Date Entered: 04/07/2025 01:26 PM               Note Entered by: Pearson, Gracey
Related Participants and Collaterals:           Related Intakes:
Elora L. Goodnight-Ralidak                        02/06/2025 11:58 AM 5619402
Aidan W. Goodnight-Ralidak                        02/10/2025 4:16 PM 5619864
Raina S. Goodnight-Ralidak                        02/14/2025 1:45 PM 5621715
Mathew W. Ralidak                                 02/21/2025 9:13 AM 5622330
Monica Galarneau                                  02/18/2025 8:06 AM 5623944
                                                  02/28/2025 12:00 PM 5629627
                                                  04/05/2025 11:50 PM 5664768
                                                  04/04/2025 7:02 PM 5666738
                                           ACTIVITIES
Activity: Parent/Guardian Contact Participant: Monica Galarneau              Location: Parental
Home Time: 10:40 AM             TCM: No
Activity: Parent/Guardian Contact Participant: Mathew W. Ralidak             Location: Parental
Home Time: 10:40 AM             TCM: No
Activity: Child - Initial Face-to-Face with child     Participant: Raina S. Goodnight-Ralidak
       Location: Parental Home         Time: 10:30 AM         TCM: No
Activity: Child - Initial Face-to-Face with child     Participant: Elora L. Goodnight-Ralidak
       Location: Parental Home         Time: 10:20 AM         TCM: No
Activity: Child - Initial Face-to-Face with child     Participant: Aidan W. Goodnight-Ralidak
       Location: Parental Home         Time: 10:00 AM         TCM: No
                                           CONTACTS


                                           Page 42 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000097
                                       NARRATIVE
Case Note 1 of 1      Entered By : Gracey Pearson           Date Entered : 04/07/2025     Time
Entered : 01:26 PM
IFF Aiden (8): 10AM 4/7/25
LOCATION: FO's Home in Duvall
ATTENDANCE: SW Pearson and Aiden (8).

SW OBSERVATIONS: SW Pearson observed that Aiden was willing to speak with SW as he
remembered SW from previous intake. Aiden was able to answer SW's questions and allow SW
to do a body check.

GROUND RULES: SW Pearson went over the ground rules and Aiden agreed to tell the truth.
RECORDING (IF APPLICABLE): n/a.

CHILD FUNCTIONING: Aiden reported that he was eating breakfast and that he is staying with
his FO, Siblings, and Monica for spring break. Aiden reported that he likes to play with his bugs
as pets and that he likes spending time with his sisters.

HOUSEHOLD:
Aiden reported that he lives with his mom and Dr. Collin half the time and that the other half
lives with his FO. Aiden reported that his mom is moving them into an RV and that Aiden thinks
the RV is cool but too small. Aiden reported that he has his own room at his dad's house.

PARENTING PRACTICES:
FO: Aiden reported that at his dad's house he gets to eat when he wants, plays a lot and that he
loves to spend time with his dad.
MO: Aiden reported that he likes his mom but that she can be scary sometimes. Aiden reported
that he is expected to be nice to his mom even when he didn't do anything wrong.

DISCIPLINE:
FO: Aiden reported that at dad's house he has a certain bedtime routine and that he needs to be
respectful. Aiden reported that if he doesn't follow the rules at dad's home, he goes to his room
but that this does not happen often.
MO: Aiden reported that MO expects him and his sisters to be respectful and to not fight. Aiden
reported that MO does slap his sister's more than him and that MO spanks them on the butt when
they do not follow the rules. Aiden showed SW Pearson and open hand to give a visual for SW
Pearson when MO disciplines him and Aiden's sisters.

SDM/ PARENT FUNCTION

SAFETY: Aiden reported that safety is hard to explain but agreed with SW Pearson when she
explained that safety is when you do not have to worry about bad things happening to you. Aiden
reported that he does feel safe with his mom but only sometimes because she hits him and his
sisters. Aiden reported that he feels safe with Collin and that he feels safe with both FO and
Monica.

ALLEGATIONS: Aiden reported that MO did hurt Raina (6) but that he didn't want to talk about


                                           Page 43 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000098
it. Aiden reported that SW should as Raina.

ADDITIONAL: SW Pearson did a body check and Aiden was free from marks and bruising at
this time.
******************************************************************************
**********************************************************

IFF WITH ELORA (10)
DATE & TIME: 10:20AM 4/7/25
LOCATION: FO's home in Duvall
ATTENDANCE: SW Pearson and Elora (10):

SW OBSERVATIONS: SW Pearson observed that Elora was willing to speak with SW and that
Elora was eager to see SW Pearson as she remembered her from the last time, they saw each
other. Elora was able to answer SWs questions.

GROUND RULES: SW Pearson went over ground rules and Elora agreed to tell the truth.
RECORDING (IF APPLICABLE): n/a.

CHILD FUNCTIONING: Elora reported that she and her siblings are on spring break and that
they will be staying with their FO. Elora reported that she is excited to spend time with her father
and that they are all going to a hotel in Everett because they have a pool.

HOUSEHOLD:
Elora reported that she lives with her FO half of the time and her MO the other time. Elora
reported that her mom wants to move them all into an RV but was previously living with MO
and Dr. Collin. Elora reported that the RV is super small and that she doesn't want to live with
her mom in the RV but that she was fine with living at Dr. Collin's house.

PARENTING PRACTICES:
FO: Elora reported that she likes spending time with her dad and that he is nice/fun to be around.
MO: Elora reported that MO is okay but that she does hit her and her siblings sometimes. Elora
reported that she doesn't want to be with MO in the RV. Elora reported that she doesn't
understand why MO wants to move into the RV because it's small.


DISCIPLINE:
FO: Elora reported that when she is with her dad, she has to be respectful and if she says a bad
word she might be sent to her room but that doesn't happen often.
MO: Elora reported that MO wants Elora and her siblings to comfort MO when she is upset, be
respectful and that MO slaps/spanks the kids when they don't follow the rules. Elora reported
that she doesn't like when MO slaps/spanks her, but that Raina (6) usually gets slaps the most.

SDM/ PARENT FUNCTION

SAFETY: Elora reported that safe means to not be worried about bad things happening to her.
Elora reported that she feels safe with FO/Monica but safe with her MO sometimes. Elora
reported that MO gets really upset. SW asked Elora to speak to a time that MO got upset and


                                            Page 44 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000099
Elora reported that SW should talk to Raina.

ALLEGATIONS: Elora reported that MO wants to move into an RV and that it is too small.
Elora reported that the other adult around but not in the RV with the family is 'Uncle Canny' who
is MO's best friend. Elora reported that the RV is on a farm.

ANYTHING ELSE: SW Pearson did a body check and Elora is free from marks/bruising at this
time.
******************************************************************************
***************************************************
IFF with Raina (6)
DATE & TIME: 4/7/25 10:30AM
LOCATION: FO's home in Duvall
ATTENDANCE: SW Pearson, FO, and Raina (6)

SW OBSERVATIONS: SW observed that Raina was not willing to speak with SW as Raina was
hiding under her bed and behind Monica and/or FO when SW asked her to speak with her. Raina
reported that she only would speak to SW if FO could come with her. SW observed that FO was
willing to be with Raina while speaking with SW. SW, FO and Raina went into Raina's room and
FO sat on the bed with Raina. SW attempted to ask Raina questions, but she did not want to
speak with SW. SW was able to do a body check to see that Raina was free of marks/bruising.
Raina did show SW a mark on her chest that was the size of a pencil mark and reported that MO
scratched me. Raina was hiding under the covers thus not allowing a full interview to be
completed.
**********************************************************
CONVERSATION WITH FO/ Monica
4/7/25 10:40AM

SW spoke to FO outside the home. FO reported that he was upset post Friday (documented in
famlink) as MO and Dr. Collin harassed him at school. FO showed SW Pearson the video of
Collin making a gun symbol at FO at the school and FO reported to have his legal rep on the
phone when SW Pearson arrived as FO is working to document all of this. FO reported that he
understands that SW Pearson is separate from family court. FO reported thanked SW Pearson for
being receptive and reported that he will keep SW updated. SW Pearson reported that she spoke
to her SUP and that SW Pearson will keep FO updated once the case is closed so he can have
further documentation of this period per multiple intakes. Monica then came out of the home as
SW was leaving to report to SW that Raina is having a tantrum now and that she is reporting that
she is scared because MO told all of the children not to speak to CPS. FO thanked SW Pearson
again and SW left the home.




 Case Name:                Case ID:            Case Note ID:                       Note Finalized
Goodnight, Veronika        2682764             53817496
Case Note Category: CPS                        Case Note Type: Supervision
Date Occurred: 04/08/2025                      Time Occurred: 12:00 PM
Date Entered: 04/08/2025 12:00 PM              Note Entered by: Smith, Jazie, B.


                                          Page 45 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000100
Related Participants and Collaterals:              Related Intakes:
Makayla N. Woodle
Veronika E. Goodnight
Elora L. Goodnight-Ralidak
Aidan W. Goodnight-Ralidak
Raina S. Goodnight-Ralidak
Mathew W. Ralidak
Monica Galarneau
River Q. Muggli
Addie Unknown
Colin Derieg

                                        ACTIVITIES
Activity: Monthly Supervisor Review        Participant: Makayla N. Woodle       Location:
Children's Administration Office    Time: 12:00 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Veronika E. Goodnight Location:
Children's Administration Office    Time: 12:00 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Elora L. Goodnight-Ralidak
       Location: Children's Administration Office Time: 12:00 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Aidan W. Goodnight-Ralidak
       Location: Children's Administration Office Time: 12:00 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Raina S. Goodnight-Ralidak
       Location: Children's Administration Office Time: 12:00 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 12:00 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Mathew W. Ralidak       Location:
Children's Administration Office    Time: 12:00 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: Monica Galarneau        Location:
Children's Administration Office    Time: 12:00 PM         TCM: No
Activity: Monthly Supervisor Review        Participant: River Q. Muggli Location: Children's
Administration Office        Time: 12:00 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Addie Unknown Location: Children's
Administration Office        Time: 12:00 PM        TCM: No
Activity: Monthly Supervisor Review        Participant: Colin Derieg    Location: Children's
Administration Office        Time: 12:00 PM        TCM: No
                                         CONTACTS

                                           NARRATIVE
Case Note 1 of 1         Entered By : Jazie B. Smith Date Entered : 04/08/2025           Time Entered :
12:00 PM
----------------------------------------------CLOSING NOTE-------------------------------------------------
INTAKE #5619402

02/06/2025

Ref lives with father and describes herself as the stepmother to the children. Ref said parents
have 50/50 custody. The children spend a week with each parent. The change takes place on


                                               Page 46 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000101
Fridays. The children also have a Wednesday evening visit with the parent in whose home they
are not residing, in a given week.

Ref is calling to report that the children are not being fed adequately when they are in their
mother's home. According to Elora, the oldest, who was in ref's home last night, they have
missed a lot of meals this week and all they have had to eat is eggs and peanut butter, with Elora
being the one that cooks the eggs for herself and her siblings. Ref said that when the children
come into her home they are always very hungry and are allowed to eat as much as they want,
but usually after a meal or 2, they have diarrhea, for about a day, which indicates to ref that their
bodies are adjusting to a higher level of food intake. The children also arrive at the home of ref
and father in poor condition, described by ref as "filthy." They are usually wearing visibly soiled
clothing, with the girls wearing "crusty" underwear. They all have "dark circles" under their
eyes, which clear up after a few days in father's home.

Per Elora, mother has said that she does not have the money to get enough groceries, but she
always manages to have champagne for herself.

 There are certain foods in the home that the children are forbidden to touch because they belong
to mother's BF.
Ref said the children get breakfast and lunch at school.

Mother tried to get the school to discontinue providing meals to the children, contending that
they have significant food allergies, but father blocked this by providing the school with
documentation from the children's doctor, saying that the children have no such allergies. The
children arrived at school on Monday, too late for breakfast and then school was cancelled the
rest of the week due to snow.

Ref said that mother is involved with a MLM company known as Purium, which sells various
health foods, detox/cleansing products and supplements. Some of what the children eat at
mother's home are products from this company, but not clear to ref what Purium products the
children have consumed or how often.

SECOND INTAKE 5666738

Referrer reports the parents have split custody and the kids had been with Mom all week, but
they are now with Dad. When Raina came to school today, she was falling asleep in class and
complained of a headache and said Mom slapped her pocket and her cheek and when she slapped
her she pushed her into the hall. Ref asked Raina what she hit her head on and she said the floor.
Raina said her Mom checked her head and said there was no bump and she needed to go to sleep.

Raina said she couldn't go to sleep and this morning, Mom said they didn't have time for
breakfast, so she came without eating. Ref stated she has come without breakfast previously
when she is with Mom.

She complained of a headache all day and saw the School Nurse who noted no signs of
concussion. Ref did not observe any marks or bruising.
**************************************************
IFF COMPLETED: 02/27/2025


                                            Page 47 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000102
Aiden reported that MO did hurt Raina (6) but that he didn't want to talk about it. Aiden reported
that SW should as Raina.
Elora reported that MO wants to move into an RV and that it is too small. Elora reported that the
other adult around but not in the RV with the family is 'Uncle Canny' who is MO's best friend.
Elora reported that the RV is on a farm.

***************************************************
PARENT INTERVIEW:
PER MO: MO reported that the children and herself implement the '5 to 1' ratio meaning that 1
wrongdoing means you have to do 5 good things. MO reported that MO and her children work
together to understand that they do not have control over the outside world but that they do have
control over their own actions. MO reported that she does EFT tapping with the children to
regulate their emotions. MO reported that she believes her discipline is impactful. MO reported
that she denies any physical form of discipline.

PER FO: SW Pearson spoke to FO on the phone regarding new concerns about MO having the
children stay in a trailer with an unknown person and FO provided their names as 'Jim Solberg
and Nathan 'Kanis' Solberg. FO reported that Raina specifically has voiced that these men have
tried to kiss her on the mouth and make Raina uncomfortable. FO did not have more information
regarding the whereabouts of the Trailer and reported that MO's previous partner, Collin have
broken up therefore leading FO to not know where the children are located when the children are
in MO's care. SW spoke to FO outside the home. FO reported that he was upset post Friday
(documented in famlink) as MO and Dr. Collin harassed him at school. FO showed SW Pearson
the video of Collin making a gun symbol at FO at the school and FO reported to have his legal
rep on the phone when SW Pearson arrived as FO is working to document all of this. FO
reported that he understands that SW Pearson is separate from family court. FO reported thanked
SW Pearson for being receptive and reported that he will keep SW updated. SW Pearson
reported that she spoke to her SUP and that SW Pearson will keep FO updated once the case is
closed so he can have further documentation of this period per multiple intakes. Monica then
came out of the home as SW was leaving to report to SW that Raina is having a tantrum now and
that she is reporting that she is scared because MO told all of the children not to speak to CPS.
FO thanked SW Pearson again and SW left the home.


PER MONICA: Monica reported that when the children are with FO and Monica, the children
can eat whatever they want, and that they can eat when they are hungry. Monica reported that in
working with the children's therapist, FO and Monica have been working with the children to eat
some junk food as they are allowed to be children. Monica reported that MO has had children on
certain diets and sometimes not. Monica reported that she is confused about why/what the diets
are for the children when they are with MO. Monica reported that there have been arguments
with the school due to diagnosis's ODD leading to dietary restrictions. Monica reported that MO
is 'Yucka' app that shows if the 'food is good or bad'. Monica reported that MO will take food
away as punishment.

PER COLLIN: Collin reported that MO will put the children in time outs, Collin denies any form
of physical discipline, and that the children are expected to do their homework and to eat healthy


                                           Page 48 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000103
if they are going to have any sweets, they need to finish their food first.

--------------------------------------------------------------------
COLLATERALS:
REPORT FROM SCHOOL: CUT AND PASTED NARRATIVE FROM REPORT C25010391
On April 4, 2025, I was dispatched at 1445 hours for a reported DV threats call at Carnation
Elementary School, 4950 Tolt Ave. RP-1 Matthew Ralidak and S-1 Veronika Goodnight are
divorced. Ralidak and Goodnight have three children in common, V-1 Raina Goodnight-Ralidak
(6 yrs old), O-2 Elora Goodnight-Ralidak (8 yrs old), O-3 Aidan Goodnight-Ralidak (10 yrs old).
O-4 Colin Derieg and Goodnight are currently dating. O-6 Monica Galarneau and Ralidak are
currently married. O-5 Michelle Frank is the current principal for Carnation Elementary. Ralidak
informed me of the following: He currently has a tense relationship with Goodnight. They
currently share their children 50/50 according to their parenting plan. Ralidak informed me that
there is an open CPS case involving Goodnight, a man she is living with, and RGR. Ralidak
stated that according to RGR, Goodnight was making her kiss this man. Ralidak did not have any
other information about this CPS case. While waiting, in his car, in line to pick up his children
from school. At approximately 1358 hours Goodnight approached Ralidak's car and started
yelling at him. Goodnight was accusing Ralidak of calling CPS on her. Goodnight continued
yelling and asking Ralidak questions about the children and Goodnight's new living
arrangements. At some point Ralidak noticed Derieg standing beside his car staring at him.
Goodnight then went into the school office and back out toward Ralidak's car. During this time
Ralidak had called into the school's office and told the principal, Frank, and another
administrator about the odd behavior and scene Goodnight was making. Frank then came outside
to speak with Goodnight. At approximately 1412 hours Goodnight and Derieg got into a maroon
Chevy Silverado and left the school parking lot. Ralidak clarified that no threats were ever made
by Goodnight or Derieg. Ralidak stated he felt intimidated by Derieg standing outside his car
staring at him. While sharing the details of this incident Ralidak seemed visibly shaken and
needed to take breaks, while talking with me, to hold back tears. All three children were not
present during this incident. As I was leaving Ralidak showed me a text from Galarneau, who
currently had all three children. Galarneau said that all three children had told her that Goodnight
had slapped RGR and slammed her against a wall. Ralidak thought this might be retaliation
because RGR had planned to tell Goodnight she no longer wanted to live with her. Ralidak did
not mention any marks or bruises on RGR when he had seen her at the school pickup. The text
from Galarneau did not describe any injuries on RGR. Ralidak and Galarneau have all three
children over the weekend. Ralidak said he is worried about his children's safety and wasn't sure
what to do. I gave Ralidak the case number and informed him that he should get in touch with a
lawyer and ask about getting a protection order if he is feeling this way. Frank had informed me
of the following: The office had received a call from Ralidak, so Frank and another administrator
had gone outside to see what was going on. Frank spoke Goodnight and told her "This isn't the
place", in reference to not handling parenting issues on school grounds. Frank stated this is not
the first time that Goodnight has caused a commotion or interrupted the children's learning
process.



DCYF HISTORY:
12 additional intakes in 2024 - 1 intake in 2019


                                             Page 49 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000104
CPS Intake History for 2025:
2/28/25 12:00 PM 5629627 Veronika E. Goodnight CPS Screen Out
Report that 6 yo child was spanked by mother's boyfriend who lives in the home; no report of
more than transient pain
2/21/25 9:13 AM 5622330 Veronika E. Goodnight CPS Screen Out
The exact LE report was also previously sent by LE and documented in intake 5623944, and the
same allegations were
also previously reported by the child's therapist, see intake ID 5621715. Additionally, LE report
indicates the mother's
partner resides in a separate home and it's unknown if he's acting in loco parentis.
2/18/25 8:06 AM 5623944 Veronika E. Goodnight CPS Screen Out
Allegation regarding mother's boyfriend spanking 6yo has been previously reported under intake
#5621715.
2/14/25 1:45 PM 5621715 Veronika E. Goodnight CPS Screen Out
Open case. 6-year-old Raina reported her mother's boyfriend spanked her as punishment. No
injuries reported.
2/10/25 4:16 PM 5619864 Veronika E. Goodnight CPS Screen Out
Concern regarding children not being fed enough reported in intake #5619402. New allegation
that mother does not help 6 yo wipe and child was recently treated for a UTI.
2/6/25 11:58 AM 5619402 Veronika Goodnight CPS Screen In
Parents have 50/50 custody. Children complain that they are not fed enough when they spend
their week with mother and that they are hungry. Per oldest girl, Elora, all they have had to eat
this week is eggs and peanut butter, prepared by Elora. They normally get meals at school, but no
school past few days because of snow. Also, the children show up at father's home in poor
condition, wearing dirty clothes, with dark circles under their eyes, which clear up after a few
days in father's home.
-----------------------------------------------------------------------------

Native: Family reported no native American ancestry.

Present danger: N/A

Indian Identity Request uploaded: Uploaded

Domestic violence: N/A

INITIAL WALKTHROUGH: SW Pearson arrived at the home and MO greeted SW allowing
her into the home. MO reported that she was in the process of moving into her Fiance's home
within the next month and reported that the home is messy due to this. SW reported that she
understood. SW was shown around the home and observed that this was a three bedroom home
in which Elora and Raina share their a bedroom with a bunk bed and Aidan has his own room on
the opposite side on the hall way. MO denied any fire arms or weapons, SW observed that there
are clear exit and entry was both at the front of the home and through the sliding door in the
kitchen. SW observed that the home has adequate food in the fridge and pantry. SW observed
that the home was at a normal temperature and did not observe any present danger nor immediate
safety concerns at this time



                                          Page 50 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000105
SAFETY THREAT(S): Safety threat [#10] was determined [inactive].

PPC/Safe Sleep: N/A

SDM: MODERATE

UNMET NEEDS: N/A

Disposition: SW Pearson completed FAR process with both MO and FO and determined no
active safety threat at this time. MO reported that she feeds the children (SW reviewed medical
records) and both FO/MO are able to meet children's basic needs.

Closing letter recommendations: SW will send FAR letters.

HSV: N/A




                                          Page 51 of 51
Goodnight, Veronika
202504-PRR-349
DCYF - 000106
                                   DEPARTMENT OF CHILDREN,YOUTH AND FAMILIES (DCYF)
                                         Present Danger Assessment

                                                                                      Date Assessed:           07/31/2024

                                                                                      Case Name:               Goodnight, Veronika


CHILDREN ASSESSED
 NAME                                                                                   GENDER                    DOB
 GOODNIGHT-RALIDAK, AIDAN W. (103285922)                                                MALE                      08/16/2016
 GOODNIGHT-RALIDAK, ELORA L. (103285921)                                                FEMALE                    03/21/2015
 GOODNIGHT-RALIDAK, RAINA S. (103285923)                                                FEMALE                    06/03/2018


PRESENT DANGER THREATS

      No Present Danger Found


 Maltreatment

      Maltreating Now                        Premeditated                                        Unexplained injuries
      Injuries to face/head                  Several victims                                     Bizarre cruelty
      Serious bodily injury                  Life-threatening living arrangement                 Sexual abuse and alleged subject
                                                                                                 has access to child victim(s)

 Child

      Child unsupervised now and             Child needs medical attention                       Parent/Caregiver viewpoint of child is
      unable to care for self                Child extremely fearful                             bizarre


 Parent/Caregiver

      Parents are unable to perform          Parent behavior is out of control now               Domestic Violence present with child
      parental responsibilities now                                                              maltreatment

      Parents described as dangerous         Parent intoxicated or under                         Parent/caregiver will flee with child
                                             significant influence of drugs



PROTECTIVE ACTIONS

      Law Enforcement protective             Child placed with unlicensed                        Safety plan developed with
      custody of child                       caregiver (Purpose Code X check                     protective caregiver
                                             completed on all adults)
                                                                                             Established on:
      Hospital hold of child                 Child placed with licensed caregiver
                                                                                                 Other:

 Explain:


 Approved by:                                                     Date Approved:




PRESENT DANGER                                    CASE (ID): Goodnight, Veronika (2682764)                             Page 1 of 1
DCYF 27-090 (10/2018) INT/EXT


             Goodnight, Veronika
             202504-PRR-349
             DCYF - 000107
                                   DEPARTMENT OF CHILDREN, YOUTH, AND FAMILIES
                                            Structured Decision Making
                                                 Risk Assessment


 Case:       Goodnight, Veronika                                                Final Risk Level: Moderate

 Worker:     Dhillon, Amandeep                 Assessment ID: 2205651 Completed Date: 09/22/2024
             (104106842)

 GENERAL DETAILS
 Household Caregiver(s)

 Primary: Goodnight, Veronika E (103285911)                Secondary: Ralidak, Matthew (103285924)

 Date of Birth:       02/15/1982                           Date of Birth: 06/12/1986

 Associated Intake(s)

 Intake: Goodnight (5435044)               Date Received:          07/30/2024       Response Time: 72 Hours

 Reason for Assessment:



 RISK ASSESSMENT
 1. Current Intake/Investigation CA/N type:                                               Neglect Score: 1
       X   Neglect                     Abuse                       Not Applicable         Abuse Score: 0

 2. Prior Number of CPS Intakes assigned:                                                 Neglect Score: 2

           None                                                                           Abuse Score: 0

           One for Abuse                            X   One or two for Neglect

           Two or more for Abuse                        Three or more for Neglect

 3. Household has previously had a child abuse or neglect investigation                   Neglect Score:1
 that resulted in a case being open for services (voluntary or court
 ordered):                                                                                Abuse Score: 1
         No                                       X  Yes

 4. Four or more children are involved in the current child abuse/neglect                 Neglect Score: 0
 incident:
                                                                                          Abuse Score:
       X   No                                           Yes

 5. Prior injury to a child resulting from CA/N:                                          Neglect Score:

           No                                       X   Yes                               Abuse Score: 1


 STRUCTURED DECISION MAKING                              Case (ID):                                 Page 1 of 4
 RISK ASSESSMENT                                Goodnight, Veronika (2682764)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000108
 6. The youngest child in the household is under age two years.                             Neglect Score: 0
       X   No                                               Yes                             Abuse Score:

 7. Characteristics of children in the household:                                           Neglect Score: 0
           Medically fragile or failure to thrive           Developmental disability        Abuse Score: 0

           Positive toxicology screen at Birth              Delinquency history

           Physical disability                              Mental health/ Behavioral
       X   None of the Above

 8. Number of adults in household at time of the most recent alleged                        Neglect Score:
 incident:
                                                                                            Abuse Score:
           None                      One                          Two
       X   Three                     Four or more

 9. Primary caregiver’s assessment of incident:                                             Neglect Score:

           Justifies Maltreatment of child                  Blames child                    Abuse Score: 0
       X   None of the Above


 10. Primary caregiver provides physical care consistent with child needs:                  Neglect Score: 0

           No                                           X   Yes                             Abuse Score:

 11. Caregiver characteristics:                                                             Neglect Score:

                                                                                            Abuse Score: 0

      Primary Caregiver

           Provides insufficient emotional/psychological support             Lacks parenting skills

           Employs excessive/inappropriate discipline                        Apathetic or hopeless

           Domineering parent                                                Involved in harmful relationships
       X   None of the Above

      Secondary Caregiver

           Provides insufficient emotional/psychological support             Lacks parenting skills

           Employs excessive/inappropriate discipline                        Apathetic or hopeless

           Domineering parent                                                Involved in harmful relationships
       X   None of the Above




 STRUCTURED DECISION MAKING                                  Case (ID):                                Page 2 of 4
 RISK ASSESSMENT                                    Goodnight, Veronika (2682764)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000109
 12. Caregiver has a past or current mental health problem:                               Neglect Score: 0
                                                                                          Abuse Score:

      Primary Caregiver
       X   No          During the last 12 months                           Prior to the last 12 months

      Secondary Caregiver
       X   No          During the last 12 months                           Prior to the last 12 months

 13. Caregiver has historic or current alcohol or drug problem:                           Neglect Score: 0
                                                                                          Abuse Score: 0

      Primary Caregiver
       X   No                                                              Drugs- During the last 12 months

           Alcohol- During the last 12 months                              Drugs- Prior to the last 12 months

           Alcohol- Prior to the last 12 months

      Secondary Caregiver
       X   No                                                              Drugs- During the last 12 months

           Alcohol- During the last 12 months                              Drugs- Prior to the last 12 months

           Alcohol- Prior to the last 12 months

 14. Caregiver has a history of abuse or neglect as a child:                              Neglect Score:

                                                                                          Abuse Score: 0

      Primary Caregiver
       X   No                                            Yes

      Secondary Caregiver
       X   No                                            Yes

 15. Two or more incidents of domestic violence in the household:                         Neglect Score:
       X   No         During the last 12 months         Prior to the last 12 months       Abuse Score: 0

 16. Housing:                                                                             Neglect Score: 0

           Current housing is physically unsafe                                           Abuse Score:

           Homeless or about to be evicted when investigation began
       X   None of the above




 STRUCTURED DECISION MAKING                                Case (ID):                                    Page 3 of 4
 RISK ASSESSMENT                                  Goodnight, Veronika (2682764)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000110
 17. Caregiver has a criminal arrest or conviction history:                              Neglect Score:
                                                                                         Abuse Score:

      Primary Caregiver
       X   No known history

           Arrest history- During the last 12 months              Conviction history- During the last 12 months

           Arrest history- Prior to the last 12 months            Conviction history- Prior to the last 12

      Secondary Caregiver
       X   No known history

           Arrest history- During the last 12 months              Conviction history- During the last 12 months

           Arrest history- Prior to the last 12 months            Conviction history- Prior to the last 12

 18. Attachment and nurturing issues:                                                    Neglect Score:

      Primary Caregiver                                                                  Abuse Score:

           Caregiver rejection of a child                         Caregiver lack of involvement in parenting
       X   None of the above

      Secondary Caregiver

           Caregiver rejection of a child                         Caregiver lack of involvement in parenting
       X   None of the above


 RISK SUMMARY                                               FINAL RISK LEVEL:        Moderate

  Total Risk            Neglect         4

                        Abuse          2                  Calculated Risk           Moderate

  Risk Assessment


  Should the Scored Risk Level be            No
  overridden to a higher
  Comments




 STRUCTURED DECISION MAKING                                Case (ID):                                Page 4 of 4
 RISK ASSESSMENT                                  Goodnight, Veronika (2682764)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000111
                                         DEPARTMENT OF CHILDREN, YOUTH, AND FAMILIES
                                                  Structured Decision Making
                                                       Risk Assessment


 Case:       Muggli, Diana (3511494)                                                  Final Risk Level: Moderate

 Worker:     Gaona, Miryam (103680879)                  Assessment ID: 2251691 Completed Date: 11/25/2024


 GENERAL DETAILS
 Household Caregiver(s)

 Primary: Muggli, Diana R (104806895)                              Secondary: Muggli, Mirko B (104807914)
                      RCW 13.50.10                                                   RCW 13.50.10
 Date of Birth:                  /1987                             Date of Birth:               /1982

 Associated Intake(s)

 Intake: Muggli (5436913)                          Date Received:          07/31/2024               Response Time: 24 Hours

 Reason for Assessment:



 RISK ASSESSMENT
 1. Current Intake/Investigation CA/N type:                                                             Neglect Score: 0

           Neglect                          X   Abuse                      Not Applicable               Abuse Score: 1

 2. Prior Number of CPS Intakes assigned:                                                               Neglect Score: 0
       X   None                                                                                         Abuse Score: 0

           One for Abuse                                       One or two for Neglect

           Two or more for Abuse                               Three or more for Neglect

 3. Household has previously had a child abuse or neglect investigation                                  Neglect Score:0
 that resulted in a case being open for services (voluntary or court
 ordered):                                                                                              Abuse Score: 0
       X No                                          Yes

 4. Four or more children are involved in the current child abuse/neglect                               Neglect Score: 0
 incident:
                                                                                                        Abuse Score:
       X   No                                                  Yes

 5. Prior injury to a child resulting from CA/N:                                                        Neglect Score:
       X   No                                                  Yes                                      Abuse Score: 0


 STRUCTURED DECISION MAKING                                       Case (ID):                                       Page 1 of 4
 RISK ASSESSMENT                                           Muggli, Diana (3511494)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000112
 6. The youngest child in the household is under age two years.                         Neglect Score: 0
       X   No                                           Yes                             Abuse Score:




RCW 13.50.100
 8. Number of adults in household at time of the most recent alleged                    Neglect Score:
 incident:
                                                                                        Abuse Score:
           None                     One                   X   Two

           Three                    Four or more

 9. Primary caregiver’s assessment of incident:                                         Neglect Score:

           Justifies Maltreatment of child              Blames child                    Abuse Score: 0
       X   None of the Above


 10. Primary caregiver provides physical care consistent with child needs:              Neglect Score: 0

           No                                       X   Yes                             Abuse Score:

 11. Caregiver characteristics:                                                         Neglect Score:

                                                                                        Abuse Score: 0

      Primary Caregiver

           Provides insufficient emotional/psychological support         Lacks parenting skills

           Employs excessive/inappropriate discipline                    Apathetic or hopeless

           Domineering parent                                            Involved in harmful relationships
       X   None of the Above

      Secondary Caregiver

           Provides insufficient emotional/psychological support         Lacks parenting skills

           Employs excessive/inappropriate discipline                    Apathetic or hopeless

           Domineering parent                                            Involved in harmful relationships
       X   None of the Above




 STRUCTURED DECISION MAKING                               Case (ID):                               Page 2 of 4
 RISK ASSESSMENT                                   Muggli, Diana (3511494)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000113
 12. Caregiver has a past or current mental health problem:                             Neglect Score: 0
                                                                                        Abuse Score:

      Primary Caregiver
       X   No          During the last 12 months                         Prior to the last 12 months

      Secondary Caregiver
       X   No          During the last 12 months                         Prior to the last 12 months

 13. Caregiver has historic or current alcohol or drug problem:                         Neglect Score: 0
                                                                                        Abuse Score: 0

      Primary Caregiver
       X   No                                                            Drugs- During the last 12 months

           Alcohol- During the last 12 months                            Drugs- Prior to the last 12 months

           Alcohol- Prior to the last 12 months

      Secondary Caregiver
       X   No                                                            Drugs- During the last 12 months

           Alcohol- During the last 12 months                            Drugs- Prior to the last 12 months

           Alcohol- Prior to the last 12 months

 14. Caregiver has a history of abuse or neglect as a child:                            Neglect Score:

                                                                                        Abuse Score: 0

      Primary Caregiver
       X   No                                          Yes

      Secondary Caregiver
       X   No                                          Yes

 15. Two or more incidents of domestic violence in the household:                       Neglect Score:
       X   No         During the last 12 months       Prior to the last 12 months       Abuse Score: 0

 16. Housing:                                                                           Neglect Score: 0

           Current housing is physically unsafe                                         Abuse Score:

           Homeless or about to be evicted when investigation began
       X   None of the above




 STRUCTURED DECISION MAKING                               Case (ID):                                   Page 3 of 4
 RISK ASSESSMENT                                   Muggli, Diana (3511494)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000114
 17. Caregiver has a criminal arrest or conviction history:                            Neglect Score:
                                                                                       Abuse Score:

      Primary Caregiver
       X   No known history

           Arrest history- During the last 12 months            Conviction history- During the last 12 months

           Arrest history- Prior to the last 12 months          Conviction history- Prior to the last 12

      Secondary Caregiver
       X   No known history

           Arrest history- During the last 12 months            Conviction history- During the last 12 months

           Arrest history- Prior to the last 12 months          Conviction history- Prior to the last 12

 18. Attachment and nurturing issues:                                                  Neglect Score:

      Primary Caregiver                                                                Abuse Score:

           Caregiver rejection of a child                       Caregiver lack of involvement in parenting
       X   None of the above

      Secondary Caregiver

           Caregiver rejection of a child                       Caregiver lack of involvement in parenting
       X   None of the above


 RISK SUMMARY                                             FINAL RISK LEVEL:        Moderate

  Total Risk            Neglect         0

                        Abuse          2                 Calculated Risk          Moderate

  Risk Assessment


  Should the Scored Risk Level be            No
  overridden to a higher
  Comments




 STRUCTURED DECISION MAKING                               Case (ID):                               Page 4 of 4
 RISK ASSESSMENT                                   Muggli, Diana (3511494)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000115
                                   DEPARTMENT OF CHILDREN, YOUTH, AND FAMILIES
                                            Structured Decision Making
                                                 Risk Assessment


 Case:       Goodnight, Veronika                                                  Final Risk Level: Moderate

 Worker:     Pearson, Gracey (101599922) Assessment ID: 2350664 Completed Date: 04/07/2025


 GENERAL DETAILS
 Household Caregiver(s)

 Primary: Goodnight, Veronika E (103285911)                  Secondary:

 Date of Birth:       02/15/1982                             Date of Birth:

 Associated Intake(s)

 Intake: Goodnight (5619402)                 Date Received:          02/06/2025       Response Time: 72 Hours
 Intake: Goodnight (5666738)                 Date Received:          04/04/2025       Response Time: 72 Hours
 Reason for Assessment:



 RISK ASSESSMENT
 1. Current Intake/Investigation CA/N type:                                                 Neglect Score: 1
       X   Neglect                    X   Abuse                      Not Applicable         Abuse Score: 1

 2. Prior Number of CPS Intakes assigned:                                                   Neglect Score: 2

           None                                                                             Abuse Score: 0

           One for Abuse                              X   One or two for Neglect

           Two or more for Abuse                          Three or more for Neglect

 3. Household has previously had a child abuse or neglect investigation                     Neglect Score:0
 that resulted in a case being open for services (voluntary or court
 ordered):                                                                                  Abuse Score: 0
       X No                                          Yes

 4. Four or more children are involved in the current child abuse/neglect                   Neglect Score: 0
 incident:
                                                                                            Abuse Score:
       X   No                                             Yes

 5. Prior injury to a child resulting from CA/N:                                            Neglect Score:
       X   No                                             Yes                               Abuse Score: 0


 STRUCTURED DECISION MAKING                                Case (ID):                                 Page 1 of 4
 RISK ASSESSMENT                                  Goodnight, Veronika (2682764)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000116
 6. The youngest child in the household is under age two years.                             Neglect Score: 0
       X   No                                               Yes                             Abuse Score:

 7. Characteristics of children in the household:                                           Neglect Score: 0
           Medically fragile or failure to thrive           Developmental disability        Abuse Score: 0

           Positive toxicology screen at Birth              Delinquency history

           Physical disability                              Mental health/ Behavioral
       X   None of the Above

 8. Number of adults in household at time of the most recent alleged                        Neglect Score:
 incident:
                                                                                            Abuse Score:
           None                      One                          Two
       X   Three                     Four or more

 9. Primary caregiver’s assessment of incident:                                             Neglect Score:

           Justifies Maltreatment of child                  Blames child                    Abuse Score: 0
       X   None of the Above


 10. Primary caregiver provides physical care consistent with child needs:                  Neglect Score: 0

           No                                           X   Yes                             Abuse Score:

 11. Caregiver characteristics:                                                             Neglect Score:

                                                                                            Abuse Score: 0

      Primary Caregiver

           Provides insufficient emotional/psychological support             Lacks parenting skills

           Employs excessive/inappropriate discipline                        Apathetic or hopeless

           Domineering parent                                                Involved in harmful relationships
       X   None of the Above

 12. Caregiver has a past or current mental health problem:                                 Neglect Score: 0

                                                                                            Abuse Score:

      Primary Caregiver
       X   No           During the last 12 months                            Prior to the last 12 months




 STRUCTURED DECISION MAKING                                  Case (ID):                                    Page 2 of 4
 RISK ASSESSMENT                                    Goodnight, Veronika (2682764)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000117
 13. Caregiver has historic or current alcohol or drug problem:                           Neglect Score: 0
                                                                                          Abuse Score: 0

      Primary Caregiver
       X   No                                                              Drugs- During the last 12 months

           Alcohol- During the last 12 months                              Drugs- Prior to the last 12 months

           Alcohol- Prior to the last 12 months

 14. Caregiver has a history of abuse or neglect as a child:                              Neglect Score:
                                                                                          Abuse Score: 0

      Primary Caregiver
       X   No                                            Yes

 15. Two or more incidents of domestic violence in the household:                         Neglect Score:
       X   No         During the last 12 months          Prior to the last 12 months      Abuse Score: 0

 16. Housing:                                                                             Neglect Score: 0

           Current housing is physically unsafe                                           Abuse Score:

           Homeless or about to be evicted when investigation began
       X   None of the above

 17. Caregiver has a criminal arrest or conviction history:                               Neglect Score:

                                                                                          Abuse Score:

      Primary Caregiver
       X   No known history

           Arrest history- During the last 12 months              Conviction history- During the last 12 months

           Arrest history- Prior to the last 12 months            Conviction history- Prior to the last 12

 18. Attachment and nurturing issues:                                                     Neglect Score:

      Primary Caregiver                                                                   Abuse Score:

           Caregiver rejection of a child                         Caregiver lack of involvement in parenting
       X   None of the above




 STRUCTURED DECISION MAKING                                Case (ID):                                Page 3 of 4
 RISK ASSESSMENT                                  Goodnight, Veronika (2682764)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000118
 RISK SUMMARY                                          FINAL RISK LEVEL:     Moderate

  Total Risk          Neglect       3

                      Abuse     1                    Calculated Risk         Moderate

  Risk Assessment


  Should the Scored Risk Level be       No
  overridden to a higher
  Comments




 STRUCTURED DECISION MAKING                           Case (ID):                        Page 4 of 4
 RISK ASSESSMENT                             Goodnight, Veronika (2682764)
 DCYF 16-208 (01/2019) INT




Goodnight, Veronika
202504-PRR-349
DCYF - 000119
                         DEPARTMENT OF CHILDREN, YOUTH, AND FAMILIES (DCYF)

                                       Safety Assessment/Safety Plan
 CASE & SAFETY PLAN PARTICIPANTS
 Case Name (ID):                                         Intake ID:                Safety Decision:
 Goodnight, Veronika (2682764)                           5435044                   Safe

 Participants (ID):                                      DOB:                      Safety Plan Decision:
 Galarneau, Monica (104669771)                           03/26/1985                No Safety Plan Required
 Goodnight, Veronika E. (103285911)                      02/15/1982
                                                                                   Date of Assessment:
 Goodnight-Ralidak, Aidan W. (103285922)                 08/16/2016
                                                                                   09/22/2024
 Goodnight-Ralidak, Elora L. (103285921)                 03/21/2015
 Goodnight-Ralidak, Raina S. (103285923)                 06/03/2018
                                                         RCW 13.50.10
                                                                                   Assessment Type:
 Ralidak, Mathew W. (104669770)                               /1986                FAR
 Social Service Specialist:                              Phone Number:
 Smith, Jazie B(103169328)                               (425) 365-6016


 SAFETY THREATS
 1. The family/facility situation results in no adults in the home/facility performing parenting/childcare       No
    duties and responsibilities that assure the child's safety.

 2. The family/facility situation is that the living arrangement(s) seriously endanger the child's physical      No
    health.

 3. Caregiver(s) are acting (behaving) violently or dangerously and the behaviors impact child safety.           No


 4. There has been an incident of domestic violence that impacts child safety.                                   No




Safety Assessment/Safety Plan                        Case Name (ID):                               Page 1 of 4
DCYF 15-258 (06/2021) INT/EXT                  Goodnight, Veronika (2682764)

   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000120
 5. Caregiver(s) will not or cannot control their behavior and their behavior impacts child safety.                  No


 6. Caregiver(s) perceive the child in extremely negative terms.                                                     No

 7. Caregiver(s) do not have or do not use resources necessary to meet the child's immediate basic                   No
    needs, which present an immediate threat of serious harm to a child.

 8. Caregiver's attitudes, emotions or behaviors threaten severe harm to a child, or caregiver(s) fear               No
    they will maltreat the child and are requesting placement.

 9. Caregiver(s) intend(ed) to seriously hurt the child.                                                             No

 10. Caregiver(s) lack the parenting knowledge, skills, or motivation necessary to assure a child's                  No
     safety.

 11. Caregiver(s) overtly rejects DCYF intervention, refuses access to a child, or there is some                     No
     indication that the caregiver(s) will flee.

 12. Caregiver(s) are not meeting, cannot meet or will not meet the child's exceptional physical,                    No
     emotional, medical, or behavioral needs.

 13. Caregiver(s) cannot or will not explain child's injuries or maltreating condition(s) or explanation is          No
     not consistent with the facts.

 14. A child has serious physical injuries or serious physical conditional resulting from maltreatment.              No


 15. A child demonstrates serious emotional symptoms, self-destructive behavior and/or lack of                       No
     behavioral control that results in provoking dangerous reactions in caregivers.

 16. A child is extremely fearful of the home/facility situation or people within the home/facility.                 No

 17. Child sexual abuse is suspected, has occurred, or circumstances suggest sexual abuse is likely to               No
     occur.

      Safety Threat #17 was explored. However, it did not meet the threshold criteria. SW observed that
      safety threshold criteria did not meet the 5 thresholds. There were no severe consequences for the
      child. There is no immediate or present danger that is likely to occur. 1.Veronika and Matthew
      agreed to speak with CPS and engaged well throughout the FAR process and has provided all
      documents, medical information to SW. 2.MH therapist Anjali called in that Elora expressed her
      friend kisses her and resulted in concerns of sexual abuse among two kiddos. 3.Youthis not
      vulnerable to safety threat #17 because she is not seeing that friend River anyore. Both parents
      are protective. 4.Safety threat is not out of control because there is not active safety threat as all
      kids stated they feel safe within both households. 5.SW Dhillon completed the FAR
      ASSESSMENT and did not find any reasons to believe there was present danger or active safety
      threats in the household.




Safety Assessment/Safety Plan                         Case Name (ID):                                  Page 2 of 4
DCYF 15-258 (06/2021) INT/EXT                   Goodnight, Veronika (2682764)

   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000121
 SAFETY PLAN ANALYSIS
 •   There is a parent/caregiver or adult in the home/facility.
 •   The home/facility is calm enough to allow safety providers to function in the home/facility.

 •       The adults in the home/facility agree to cooperate with and allow an In-Home Safety
         Plan.
 •       Sufficient, appropriate, reliable resources are available and willing to provide safety
         services/tasks.




Safety Assessment/Safety Plan                          Case Name (ID):                             Page 3 of 4
DCYF 15-258 (06/2021) INT/EXT                    Goodnight, Veronika (2682764)

     Goodnight, Veronika
     202504-PRR-349
     DCYF - 000122
                                  Safety Assessment and Safety Plan
 IDENTIFIED SAFETY THREATS
    No Safety Threats Indicated




 COMMENTS
 Document Family Time Supervision Level Evidence for each parent.



 Document pertinent Safety related information regarding: Condition for Return Home, Trial Return Home,
 Reunification with a non-custodial parent, etc.



 Reporting Concerns: In case of Emergency or immediate safety threats, call 911.
 For questions or concerns regarding the Safety Plan, participant should contact the DCYF Worker at the
 telephone number at the top of this plan or Central Intake at 1-866-363-4276 evenings or on weekends
 and holidays.


 Failure to comply with this agreement may result in the filing of a dependency petition and recommendation
 that the child or children be placed out of the home.
 SIGNATURES
 Parent Signature:                               Date:    Parent Signature:                          Date:


 Parent Signature:                           Date:        Other Signature:                            Date:


 Other Signature:                            Date:        Worker Signature:                           Date:




Safety Assessment/Safety Plan                      Case Name (ID):                            Page 4 of 4
DCYF 15-258 (06/2021) INT/EXT                Goodnight, Veronika (2682764)

   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000123
                         DEPARTMENT OF CHILDREN, YOUTH, AND FAMILIES (DCYF)

                                       Safety Assessment/Safety Plan
 CASE & SAFETY PLAN PARTICIPANTS
 Case Name (ID):                                         Intake ID:                Safety Decision:
 Goodnight, Veronika (2682764)                           5619402                   Safe

 Participants (ID):                                      DOB:                      Safety Plan Decision:
 Goodnight, Veronika E. (103285911)                      02/15/1982                No Safety Plan Required
 Goodnight-Ralidak, Aidan W. (103285922)                 08/16/2016
                                                                                   Date of Assessment:
 Goodnight-Ralidak, Elora L. (103285921)                 03/21/2015
                                                                                   02/10/2025
 Goodnight-Ralidak, Raina S. (103285923)                 06/03/2018
                                                         RCW 13.50.100
 Ralidak, Matthew (103285924)                                  1986                Assessment Type:
 Social Service Specialist:                              Phone Number:             FAR
 Smith, Jazie B(103169328)                               (425) 365-6016


 SAFETY THREATS
 1. The family/facility situation results in no adults in the home/facility performing parenting/childcare       No
    duties and responsibilities that assure the child's safety.

 2. The family/facility situation is that the living arrangement(s) seriously endanger the child's physical      No
    health.

 3. Caregiver(s) are acting (behaving) violently or dangerously and the behaviors impact child safety.           No


 4. There has been an incident of domestic violence that impacts child safety.                                   No

 5. Caregiver(s) will not or cannot control their behavior and their behavior impacts child safety.              No




Safety Assessment/Safety Plan                        Case Name (ID):                               Page 1 of 4
DCYF 15-258 (06/2021) INT/EXT                  Goodnight, Veronika (2682764)

   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000124
 6. Caregiver(s) perceive the child in extremely negative terms.                                                     No

 7. Caregiver(s) do not have or do not use resources necessary to meet the child's immediate basic                   No
    needs, which present an immediate threat of serious harm to a child.

 8. Caregiver's attitudes, emotions or behaviors threaten severe harm to a child, or caregiver(s) fear               No
    they will maltreat the child and are requesting placement.

 9. Caregiver(s) intend(ed) to seriously hurt the child.                                                             No

 10. Caregiver(s) lack the parenting knowledge, skills, or motivation necessary to assure a child's                  No
     safety.

      Per intake, SW Pearson assessed safety threat number 10 as there were concerns regarding the
      children not being fed enough at MO's home. 1) How the safety threat has had or will have severe
      impact(s) on the child. During IFFs, SW observed no severe safety impacts to the children
      physically however, Elora, Aidan and Raina all reported that they have to eat different foods when
      at mom's home and at father's home. SW Pearson spoke to MO and conducted HWT that
      indicated that the children are being fed along with doctor's notes indicating that MO provides
      certain dietary related foods for Elora specifically. SW Pearson spoke with FO and FO reported
      that he feeds the children when they are with him but that FO has heard from the children that they
      are hungry while with MO. 2) How the safety threat is immediate or will occur in the near future.
      SW determined that due to the parents having 50/50 custody and both parents having various
      views regarding foods; the children are being fed which eliminates the safety threat to be
      immediate/occur in the near future. 3) The vulnerability of the child in relation to the safety threat.
      Elora (9), Aidan (8), and Raina (6) are all vulnerable to the safety threat as they rely one their
      CGs/supports to provide food for them to meet their basic needs. 4) Why there is no responsible
      parent/caregiver or adult in the home/facility that can prevent the threat. SW determined FO and
      MO to be responsible CGs as MO provided doctor's note regarding why she gives the children
      certain foods and FO has been able to feed the children without complaints to meet their basic
      needs. 5) The specific behaviors, conditions, etc., that are observed that make the threat clearly
      understood and observable. The conditions/behaviors were observed by both parents and SW
      Pearson along with the school/medical collaterals. SW Pearson determined safety threat 10 to be
      inactive as it does not meet the threshold criteria.

 11. Caregiver(s) overtly rejects DCYF intervention, refuses access to a child, or there is some                     No
     indication that the caregiver(s) will flee.

 12. Caregiver(s) are not meeting, cannot meet or will not meet the child's exceptional physical,                    No
     emotional, medical, or behavioral needs.

 13. Caregiver(s) cannot or will not explain child's injuries or maltreating condition(s) or explanation is          No
     not consistent with the facts.

 14. A child has serious physical injuries or serious physical conditional resulting from maltreatment.              No


 15. A child demonstrates serious emotional symptoms, self-destructive behavior and/or lack of                       No
     behavioral control that results in provoking dangerous reactions in caregivers.

 16. A child is extremely fearful of the home/facility situation or people within the home/facility.                 No

 17. Child sexual abuse is suspected, has occurred, or circumstances suggest sexual abuse is likely to               No
     occur.




Safety Assessment/Safety Plan                         Case Name (ID):                                  Page 2 of 4
DCYF 15-258 (06/2021) INT/EXT                   Goodnight, Veronika (2682764)

   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000125
 SAFETY PLAN ANALYSIS
 •   There is a parent/caregiver or adult in the home/facility.
 •   The home/facility is calm enough to allow safety providers to function in the home/facility.

 •       The adults in the home/facility agree to cooperate with and allow an In-Home Safety
         Plan.
 •       Sufficient, appropriate, reliable resources are available and willing to provide safety
         services/tasks.




Safety Assessment/Safety Plan                          Case Name (ID):                             Page 3 of 4
DCYF 15-258 (06/2021) INT/EXT                    Goodnight, Veronika (2682764)

     Goodnight, Veronika
     202504-PRR-349
     DCYF - 000126
                                  Safety Assessment and Safety Plan
 IDENTIFIED SAFETY THREATS
    No Safety Threats Indicated




 COMMENTS
 Document Family Time Supervision Level Evidence for each parent.



 Document pertinent Safety related information regarding: Condition for Return Home, Trial Return Home,
 Reunification with a non-custodial parent, etc.



 Reporting Concerns: In case of Emergency or immediate safety threats, call 911.
 For questions or concerns regarding the Safety Plan, participant should contact the DCYF Worker at the
 telephone number at the top of this plan or Central Intake at 1-866-363-4276 evenings or on weekends
 and holidays.


 Failure to comply with this agreement may result in the filing of a dependency petition and recommendation
 that the child or children be placed out of the home.
 SIGNATURES
 Parent Signature:                               Date:    Parent Signature:                          Date:


 Parent Signature:                           Date:        Other Signature:                            Date:


 Other Signature:                            Date:        Worker Signature:                           Date:




Safety Assessment/Safety Plan                      Case Name (ID):                            Page 4 of 4
DCYF 15-258 (06/2021) INT/EXT                Goodnight, Veronika (2682764)

   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000127
                         DEPARTMENT OF CHILDREN, YOUTH, AND FAMILIES (DCYF)

                                       Safety Assessment/Safety Plan
 CASE & SAFETY PLAN PARTICIPANTS
 Case Name (ID):                                         Intake ID:                Safety Decision:
 Goodnight, Veronika (2682764)                           5619402                   Safe
                                                         5666738
                                                                                   Safety Plan Decision:
 Participants (ID):                                      DOB:                      No Safety Plan Required
                                                         RCW 13.50.10
 Galarneau, Monica (104669771)                                /1985
 Goodnight, Veronika E. (103285911)                      02/15/1982                Date of Assessment:
 Goodnight-Ralidak, Aidan W. (103285922)                 08/16/2016                04/08/2025
 Goodnight-Ralidak, Elora L. (103285921)                 03/21/2015
 Goodnight-Ralidak, Raina S. (103285923)                 06/03/2018                Assessment Type:
                                                         RCW 13.50.10              FAR
 Ralidak, Matthew (103285924)                                 /1986

 Social Service Specialist:                              Phone Number:
 Smith, Jazie B(103169328)                               (425) 365-6016


 SAFETY THREATS
 1. The family/facility situation results in no adults in the home/facility performing parenting/childcare       No
    duties and responsibilities that assure the child's safety.

 2. The family/facility situation is that the living arrangement(s) seriously endanger the child's physical      No
    health.

 3. Caregiver(s) are acting (behaving) violently or dangerously and the behaviors impact child safety.           No


 4. There has been an incident of domestic violence that impacts child safety.                                   No




Safety Assessment/Safety Plan                        Case Name (ID):                               Page 1 of 4
DCYF 15-258 (06/2021) INT/EXT                  Goodnight, Veronika (2682764)

   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000128
 5. Caregiver(s) will not or cannot control their behavior and their behavior impacts child safety.                  No


 6. Caregiver(s) perceive the child in extremely negative terms.                                                     No

 7. Caregiver(s) do not have or do not use resources necessary to meet the child's immediate basic                   No
    needs, which present an immediate threat of serious harm to a child.

 8. Caregiver's attitudes, emotions or behaviors threaten severe harm to a child, or caregiver(s) fear               No
    they will maltreat the child and are requesting placement.

 9. Caregiver(s) intend(ed) to seriously hurt the child.                                                             No

 10. Caregiver(s) lack the parenting knowledge, skills, or motivation necessary to assure a child's                  No
     safety.

      Per intake, SW Pearson assessed safety threat number 10 as there were concerns regarding the
      children not being fed enough at MO's home. 1) How the safety threat has had or will have severe
      impact(s) on the child. During IFFs, SW observed no severe safety impacts to the children
      physically however, Elora, Aidan and Raina all reported that they have to eat different foods when
      at mom's home and at father's home. SW Pearson spoke to MO and conducted HWT that
      indicated that the children are being fed along with doctor's notes indicating that MO provides
      certain dietary related foods for Elora specifically. SW Pearson spoke with FO and FO reported
      that he feeds the children when they are with him but that FO has heard from the children that they
      are hungry while with MO. 2) How the safety threat is immediate or will occur in the near future.
      SW determined that due to the parents having 50/50 custody and both parents having various
      views regarding foods; the children are being fed which eliminates the safety threat to be
      immediate/occur in the near future. 3) The vulnerability of the child in relation to the safety threat.
      Elora (9), Aidan (8), and Raina (6) are all vulnerable to the safety threat as they rely one their
      CGs/supports to provide food for them to meet their basic needs. 4) Why there is no responsible
      parent/caregiver or adult in the home/facility that can prevent the threat. SW determined FO and
      MO to be responsible CGs as MO provided doctor's note regarding why she gives the children
      certain foods and FO has been able to feed the children without complaints to meet their basic
      needs. 5) The specific behaviors, conditions, etc., that are observed that make the threat clearly
      understood and observable. The conditions/behaviors were observed by both parents and SW
      Pearson along with the school/medical collaterals. SW Pearson determined safety threat 10 to be
      inactive as it does not meet the threshold criteria.

 11. Caregiver(s) overtly rejects DCYF intervention, refuses access to a child, or there is some                     No
     indication that the caregiver(s) will flee.

 12. Caregiver(s) are not meeting, cannot meet or will not meet the child's exceptional physical,                    No
     emotional, medical, or behavioral needs.

 13. Caregiver(s) cannot or will not explain child's injuries or maltreating condition(s) or explanation is          No
     not consistent with the facts.

 14. A child has serious physical injuries or serious physical conditional resulting from maltreatment.              No


 15. A child demonstrates serious emotional symptoms, self-destructive behavior and/or lack of                       No
     behavioral control that results in provoking dangerous reactions in caregivers.

 16. A child is extremely fearful of the home/facility situation or people within the home/facility.                 No

 17. Child sexual abuse is suspected, has occurred, or circumstances suggest sexual abuse is likely to               No
     occur.


Safety Assessment/Safety Plan                         Case Name (ID):                                  Page 2 of 4
DCYF 15-258 (06/2021) INT/EXT                   Goodnight, Veronika (2682764)

   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000129
 SAFETY PLAN ANALYSIS
 •   There is a parent/caregiver or adult in the home/facility.
 •   The home/facility is calm enough to allow safety providers to function in the home/facility.

 •       The adults in the home/facility agree to cooperate with and allow an In-Home Safety
         Plan.
 •       Sufficient, appropriate, reliable resources are available and willing to provide safety
         services/tasks.




Safety Assessment/Safety Plan                          Case Name (ID):                             Page 3 of 4
DCYF 15-258 (06/2021) INT/EXT                    Goodnight, Veronika (2682764)

     Goodnight, Veronika
     202504-PRR-349
     DCYF - 000130
                                  Safety Assessment and Safety Plan
 IDENTIFIED SAFETY THREATS
    No Safety Threats Indicated




 COMMENTS
 Document Family Time Supervision Level Evidence for each parent.



 Document pertinent Safety related information regarding: Condition for Return Home, Trial Return Home,
 Reunification with a non-custodial parent, etc.



 Reporting Concerns: In case of Emergency or immediate safety threats, call 911.
 For questions or concerns regarding the Safety Plan, participant should contact the DCYF Worker at the
 telephone number at the top of this plan or Central Intake at 1-866-363-4276 evenings or on weekends
 and holidays.


 Failure to comply with this agreement may result in the filing of a dependency petition and recommendation
 that the child or children be placed out of the home.
 SIGNATURES
 Parent Signature:                               Date:    Parent Signature:                          Date:


 Parent Signature:                           Date:        Other Signature:                            Date:


 Other Signature:                            Date:        Worker Signature:                           Date:




Safety Assessment/Safety Plan                      Case Name (ID):                            Page 4 of 4
DCYF 15-258 (06/2021) INT/EXT                Goodnight, Veronika (2682764)

   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000131
Goodnight, Veronika
202504-PRR-349
DCYF - 000133
Goodnight, Veronika
202504-PRR-349
DCYF - 000134
Goodnight, Veronika
202504-PRR-349
DCYF - 000135
Goodnight, Veronika
202504-PRR-349
DCYF - 000136
Goodnight, Veronika
202504-PRR-349
DCYF - 000137
Goodnight, Veronika
202504-PRR-349
DCYF - 000138
Goodnight, Veronika
202504-PRR-349
DCYF - 000139
                        Superior Court of Washington, County of King
 In re Parenting and Support of:
 E.L.R., A.W.R., and R.S.R.,
    Minors.                                           No. 20-3-03830-3 SEA

                                                      Final Parenting Plan
 Petitioner:                                          (PPP / PPT / PP)
      VERONIKA GOODNIGHT,
                                                      Clerk’s action required: 1

 And Respondent:
      MATHEW RALIDAK.


                                      Final Parenting Plan
1.       This parenting plan is a:
           Court Order signed by a judge. This is a final order entered after a motion to modify
            the prior final parenting plan. This order replaces all previous parenting plans,
            including the prior plan entered on 03/07/2022.
2.       Children – This parenting plan is for the following children:

                           Child’s name                Age
                1. Elora L. Ralidak                      9
                3. Aidan W. Ralidak                      7
                5. Raina S. Ralidak                      5

3.       Reasons for putting limitations on a parent (under RCW 26.09.191)
         a. Abandonment, neglect, child abuse, domestic violence, assault, or sex
            offense. (If a parent has any of these problems, the court must limit that parent’s
              contact with the children and that parent’s right to make decisions for the children,
              and may not require dispute resolution other than court.)
                  [X] Neither parent has any of these problems. (Skip to 3.b.)


 RCW 26.09.016, .181, .187, .194              Parenting Plan
 Mandatory Form (07/2022)                       p. 1 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000140
         b. Other problems that may harm the children’s best interests. (If a parent has any of
            these problems, the court may limit that parent’s contact with the children and that
              parent’s right to make decisions for the children.)
                  Neither parent has these problems.
4.       Limitations on a parent
         The Court essentially maintains a modified form of the substances provisions from the
            original parenting plan. The Court does not find it necessary to maintain the mental
            health related provisions, as they were originally intended for 24 months only.
         The modified language is as follows: Neither party may consume marijuana products
            during their residential time with the children, and must refrain from being under the
            influence of alcohol, marijuana, or any other controlled substance or non-prescribed
            medication while in the presence of the children.
5.         Decision-making
           When the children are with you, you are responsible for them. You can make day-to-
           day decisions for the children when they are with you, including decisions about safety
           and emergency healthcare. Major decisions must be made as follows:
           a. Who can make major decisions about the children?

                 Type of Major Decision                     Joint                       Limited
                                                    (parents make these    (only the parent named below has
                                                     decisions together)   authority to make these decisions)
              School / Educational                [X] – as detailed below [ ] (Name):
              Healthcare (not emergency)          [X] – as detailed below [ ] (Name):
              Name Changes for the children                                [X] Veronika Goodnight, as
                                                                           detailed below
              Other: Childcare                              [X]            [ ] (Name):
              Other: Extracurricular activities             [X]            [ ] (Name):
              Other: Driving/insurance                      [X]            [ ] (Name):
              Other: cell phones / phone plan               [X]            [ ] (Name):
              Other: Marriage before 18                     [X]            [ ] (Name):
              Other: tattoos/piercings                      [X]            [ ] (Name):
              *As detailed below, Mr. Ralidak will have the right to take the children to a
              pediatrician of his choice if he deems it necessary without Mother’s permission but
              will notify Mother when he does so.
         b. Reasons for limits on major decision-making, if any:
              The Court incorporates the findings and conclusions detailed in the “Order of the
                 Court: Supplemental Findings and Conclusions” entered separately today.
              In summary, the Court finds the parties have had considerable disputes regarding
                  school attendance and the children’s healthcare that have resulted in detrimental
                  outcomes for the children and now require detailed provisions in this parenting
                  plan. The parties also require clarity on whether/how they may proceed with


 RCW 26.09.016, .181, .187, .194                   Parenting Plan
 Mandatory Form (07/2022)                            p. 2 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000141
                  contemplated name changes for the children. See detailed provisions listed
                  below.




6.       Dispute Resolution

        Important! After this parenting plan is signed by a judge or commissioner, if you and the other parent
        disagree about shared decisions or what parts of this plan mean, the court may require you to use a dispute
        resolution provider before going back to court. The court may only require a dispute resolution provider if
        there are no limitations in 3.a. above. If a dispute resolution provider is checked below, the parents may,
        and sometimes must, use this provider before filing a Petition to Change a Parenting Plan or a Motion for
        Contempt for not following the plan. Check your county’s Local Court Rules.

         a. The parents will go to:
                  The dispute resolution provider below (before they may go to court):
                  Any mediator or dispute resolution provider agreed upon by the parties, including
                       but not limited to: Dispute Resolution Center of King County.
                  If a dispute resolution provider is not named above or if the named provider is no
                  longer available, the parents may agree on a provider in writing or ask the court
                  to name one.
                  Important! Unless there is an emergency, the parents must participate in the
                  dispute resolution process listed above in good faith, before going to court for
                  disagreements about joint decisions or what parts of this plan mean. This section
                  does not apply to disagreements about money or support.
         b. If mediation, arbitration, or counseling is required, one parent must notify the other
            parent by via the parenting app, Talking Parents.
              The parents will pay for the mediation, arbitration, or counseling services as follows:
              based on each parents’ Proportional Share of Income (percentage) from line 6 of the
              Child Support Worksheet.
              What to expect in the dispute resolution process:
                Preference shall be given to carrying out the parenting plan.
                If you reach an agreement, it must be put into writing, signed, and both parents
                 must get a copy.
                If the court finds that you have used or frustrated the dispute resolution process
                 without a good reason, the court can order you to pay financial sanctions
                 (penalties) including the other parent’s legal fees.
                You may go back to court if the dispute resolution process doesn’t solve the
                 disagreement or if you disagree with the arbitrator’s decision.
7.       Custodian
         The custodian is (name): Veronika Goodnight solely for the purpose of all state and
         federal statutes which require a designation or determination of custody. Even though
         one parent is called the custodian, this does not change the parenting rights and
         responsibilities described in this plan.


 RCW 26.09.016, .181, .187, .194                   Parenting Plan
 Mandatory Form (07/2022)                            p. 3 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000142
            (Washington law generally refers to parenting time and decision-making, rather than custody. However,
            some state and federal laws require that one person be named the custodian. The custodian is the person
            with whom the children are scheduled to reside a majority of their time.)

 Parenting Time Schedule (Residential Provisions)
            Complete the parenting time schedule in sections 8 – 11.
   8.       School Schedule
            a. Children under school-age
                     Does not apply. All children are school-age.

            b. School-age children
                 This schedule will apply immediately.
                 -   The children shall alternate weeks with each parent following a one-week-
                     on/one-week-off schedule.
                        o Exchanges shall occur on Fridays at release from school, or 3pm on days
                             when the children are not in school (such as holiday, snow day, home
                             sick, or for any other reason … etc.).
                        o Pick up and drop off will be at school.
                 -   Except that to accommodate the children’s emotional, academic, and physical
                     health-related needs, each parent will have a mid-week visit, to occur on
                     Wednesday from end of school day or 3pm when school is not in session, until
                     7pm.
                        o The parents may, by mutual agreement, change the mid-week visit to an
                             alternate day.
                        o Provided that if one parent does not agree in writing, the mid-week visit
                             must occur as stated above.
                 -   Any deviation from this schedule must be agreed upon by both parents in writing.


   9.       Summer Schedule
                 The Summer Schedule is the same as the School Schedule except that each parent
                 shall be entitled to two weeks of uninterrupted vacation time with the children each
                 summer. The parents shall confirm their vacation schedules in writing by the end of
                 April each year. (Skip to 10.) In the event of a conflict in vacations schedules, the
                 Mother’s vacation schedule will have priority in the odd years, and the Father’s in the
                 even years. If the parent with the priority does not submit their vacation schedule by
                 April 30, will still be able to exercise their two weeks of uninterrupted time, but will
                 lose their priority in the event of a scheduling conflict.
                 The parties are encouraged to work together and confirm dates earlier than the
                 schedule requires, particularly if the children intend to participate in summer camps,
                 as doing so is in the best interests of the children.
   10.      Holiday Schedule (includes school breaks and special occasions)
                 The children are scheduled to spend holidays, school breaks, and special occasions
                 as follows:
                 Note any differences for children who have not yet started school.

    RCW 26.09.016, .181, .187, .194                  Parenting Plan
    Mandatory Form (07/2022)                           p. 4 of 14
    FL All Family 140
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000143
               Martin Luther King Jr. Day –
                      With the parent who has the children for the attached weekend.
               Presidents' Day –
                      With the parent who has the children for the attached weekend.
               Mid-winter Break –
                      Other plan: Whomever has the child on the attached weekend if it is not a full
                      week. If the school district has a full week for mid-Winter Break it shall begin
                      at end of the last day of school until the day before school resumes at 5:00
                      pm. Father will have even years and Mother will have odd years.
               Spring Break –
                      Other plan: Spring break is defined as the days out of school for the break
                      beginning at 8:00 a.m. on the first day of the break (defined as the day after
                      school lets out) and ending on the last day of the break (defined as the day
                      before school begins) at 5:00 p.m. plus that parent's normal weekend
                      residential schedule. Father will have spring break in odd years and will have
                      spring break in even years.
               Mother's Day – Begins and ends (day/time): 9:00 a.m. to 6:00 p.m.
                      Every year with Veronika Goodnight
               Memorial Day –
                      With the parent who has the children for the attached weekend.
               Father’s Day – 9:00 a.m. to 6:00 p.m.
                      Every year with Mathew Ralidak
               Fourth of July – Begins and ends (day/time): 10:00 a.m. on 7/4 to 12:00 p.m. on
                7/5
                     Odd years with Mathew Ralidak. Even years with the other parent.
               Labor Day –
                      With the parent who has the children for the attached weekend and defined
                      as from pick-up from school for the normal residential time and ending at
                      return to school after the holiday weekend.
               Thanksgiving Day / Break –
                      Other plan: Begins after school on the Wednesday before Thanksgiving and
                      ends 5:00 p.m. Sunday after Thanksgiving. Mother will have the odd years
                      and Father will have the even years.
               Winter Break –
                      Other plan: Each parent will have the children for 50% of the Winter Break.
                      -In odd years, Mathew Ralidak shall have the first half of winter break and
                      Veronika Goodnight shall have the second half of winter break.
                      -In even years, Veronika Goodnight shall have the first half of winter break
                      and Mathew Ralidak shall have the second half.
                      -The first half of winter break shall be defined as from release from school
                      until 10:00 a.m. on December 26. The second half of winter break shall be

 RCW 26.09.016, .181, .187, .194              Parenting Plan
 Mandatory Form (07/2022)                       p. 5 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000144
                       defined as from 10:00 a.m. on December 26 until 5:00 pm on the day before
                       school resumes.
               Christmas Eve / Day –
                       Follow the Winter Break schedule above.
               New Year's Eve / Day –
                (odd/even is based on New Year’s Eve)
                       Follow the Winter Break schedule above.
                 All three-day weekends not listed elsewhere
                 (Federal holidays, school in-service days, etc.)
                      The children shall spend any unspecified holiday or non-school day with the
                      parent who has them for the attached weekend.

             Important! Families in Washington observe a broad range of religions and traditions. Your Parenting
             Plan can provide for how children will spend time on other significant days. (Examples: Eid, Passover,
             Easter, Chinese New Year, birthdays, etc.) Add lines as needed.

                      Other occasion important to the family:
               The parties are to follow the ordinary schedule on their children’s and the parents’
                  birthdays. The Court is intentionally omitting all special provisions regarding
                  residential time for birthdays for the following reasons.
               The Court observes that in the past, Ms. Goodnight has pulled the children out of
                  school in order to celebrate her birthday and/or the child’s birthday. This is not in
                  the best interest of the children as it has contributed to an excessive amount of
                  school absences that have hindered at least one child’s academic progress. The
                  Court finds that the prior order set special residential provisions for birthdays,
                  and so created an expectation that these dates were to be treated as holidays.
                  The Court now removes these provisions and clarifies that the children should
                  not be pulled out of school for birthday celebrations. The parties are welcome to
                  celebrate birthdays at school (if that is permitted in the classroom) or outside
                  school hours.
11.      Conflicts in Scheduling
         The Holiday Schedule must be observed over all other schedules. If there are conflicts
         within the Holiday Schedule (check all that apply):
              Named holidays shall be followed before school breaks.
12.      Transportation Arrangements
         The children will be exchanged for parenting time (picked up and dropped off) at their
         school.
         Who is responsible for arranging transportation?
           In general, the dropping off parent – The parent whose parenting time is ending
                must arrange to have the children dropped off at school (or if school is not in
                session, then at the other parent’s home).
           *Exception: However, if a parent’s residential time begins from the children’s release
                from school, then the picking up parent must arrange to pick up the children from
                school.
 RCW 26.09.016, .181, .187, .194                   Parenting Plan
 Mandatory Form (07/2022)                            p. 6 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000145
13.      Moving with the Chil/dren (Relocation)
         Anyone with majority or substantially equal residential time (at least 45 percent) who
         wants to move with the children must notify every other person who has court-ordered
         time with the children.

         Move to a different school district
         If the move is to a different school district, the relocating person must complete the form
         Notice of Intent to Move with Children (FL Relocate 701) and deliver it at least 60 days
         before the intended move.
         Exceptions:
              If the relocating person could not reasonably have known enough information to
               complete the form in time to give 60 days’ notice, they must give notice within 5
               days after learning the information.
              If the relocating person is relocating to a domestic violence shelter or moving to
               avoid a clear, immediate, and unreasonable risk to health or safety, notice may be
               delayed 21 days.
              If information is protected under a court order or the address confidentiality
               program, it may be withheld from the notice.
              A relocating person who believes that giving notice would put themself or a child at
               unreasonable risk of harm, may ask the court for permission to leave things out of
               the notice or to be allowed to move without giving notice. Use form Motion to Limit
               Notice of Intent to Move with Children (Ex Parte) (FL Relocate 702).
         The Notice of Intent to Move with Children can be delivered by having someone
         personally serve the other party or by any form of mail that requires a return receipt.
         If the relocating person wants to change the Parenting Plan because of the move, they
         must deliver a proposed Parenting Plan together with the Notice.
         Move within the same school district
         If the move is within the same school district, the relocating person still has to let the
         other parent know. However, the notice does not have to be served personally or by mail
         with a return receipt. Notice to the other party can be made in any reasonable way. No
         specific form is required.
         Warning! If you do not notify…
         A relocating person who does not give the required notice may be found in contempt of
         court. If that happens, the court can impose sanctions. Sanctions can include requiring
         the relocating person to bring the children back if the move has already happened, and
         ordering the relocating person to pay the other side’s costs and lawyer’s fees.
         Right to object
         A person who has court-ordered time with the children can object to a move to a
         different school district and/or to the relocating person’s proposed Parenting Plan. If the
         move is within the same school district, the other party doesn’t have the right to object to
         the move, but they may ask to change the Parenting Plan if there are adequate reasons
         under the modification law (RCW 26.09.260).


 RCW 26.09.016, .181, .187, .194             Parenting Plan
 Mandatory Form (07/2022)                      p. 7 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000146
         An objection is made by filing the Objection about Moving with Children and Petition
         about Changing a Parenting/Custody Order (Relocation) (form FL Relocate 721). File
         your Objection with the court and serve a copy on the relocating person and anyone else
         who has court-ordered time with the children. Service of the Objection must be by
         personal service or by mailing a copy to each person by any form of mail that requires a
         return receipt. The Objection must be filed and served no later than 30 days after the
         Notice of Intent to Move with Children was received.
         Right to move
         During the 30 days after the Notice was served, the relocating person may not move to a
         different school district with the children unless they have a court order allowing the
         move.
         After the 30 days, if no Objection is filed, the relocating person may move with the
         children without getting a court order allowing the move.
         After the 30 days, if an Objection has been filed, the relocating person may move with
         the children pending the final hearing on the Objection unless:
              The other party gets a court order saying the children cannot move, or
              The other party has scheduled a hearing to take place no more than 15 days after
               the date the Objection was served on the relocating person. (However, the
               relocating person may ask the court for an order allowing the move even though a
               hearing is pending if the relocating person believes that they or a child is at
               unreasonable risk of harm.)
         The court may make a different decision about the move at a final hearing on the
         Objection.
         Parenting Plan after move
         If the relocating person served a proposed Parenting Plan with the Notice, and if no
         Objection is filed within 30 days after the Notice was served (or if the parties agree):
              Both parties may follow that proposed plan without being held in contempt of the
               Parenting Plan that was in place before the move. However, the proposed plan
               cannot be enforced by contempt unless it has been approved by a court.
              Either party may ask the court to approve the proposed plan. Use form Ex Parte
               Motion for Final Order Changing Parenting Plan – No Objection to Moving with
               Children (FL Relocate 706).
         Forms
         You can find forms about moving with children at:
              The Washington State Courts’ website: www.courts.wa.gov/forms,
              Washington LawHelp: www.washingtonlawhelp.org, or
              The Superior Court Clerk’s office or county law library (for a fee).
          (This is a summary of the law. The complete law is in RCW 26.09.430 through 26.09.480.)
14.      Other
         Co-Parenting App. Both parents will utilize a co-parenting app, currently Talking Parents,
         for all communication regarding the children. Each parent will cover their own costs for

 RCW 26.09.016, .181, .187, .194             Parenting Plan
 Mandatory Form (07/2022)                      p. 8 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000147
         the app. The parents may choose to change the co-parenting app, upon agreement of
         the parties in writing. If they cannot agree, then they will continue use of Talking Parents.
              -   Parents must use TalkingParents or another mutually agreed upon parenting app
                  for all communications regarding the children (medical, school related,
                  scheduling …etc.), unless truly urgent.
         Decision-Making Protocol Via App.

              -   If a parent has a question for another parent, they must first read all pending
                  messages in the app before sending an urgent query via text message.
                       o Parents must refrain from involving the other parents’ partner in any
                          communications, absent an emergency situation (such as potential
                          imminent hospitalization of the child).
              -   Both parents are responsible for checking the communication app at least once
                  every 48 hours, and for remaining current on all communications.
              -   Parents must abide by the following protocol with respect to any decision that is
                  joint decision-making:
                       o A parent who proposes a course of action must communicate the
                          proposed decision via the App.
                       o A parent has 48 hours to agree, object, or request additional information.
                               If the parent has access to the additional information, they must
                                  respond within 24 hours to either (a) provide the information, if
                                  they have it, (b) provide the contact information of the party who
                                  does have the information, if it is known, or (c) explain that they do
                                  not have the information and do not know who has the
                                  information.
                               The other parent then has 24 hours to respond with an
                                  agreement, objection, or alternative proposal.
                       o If one party fails to respond within 48 hours, the other parent may
                          proceed with their proposed course of action.
                       o While one party is waiting for another party’s response, they may book an
                          appointment or take action to secure a child’s place, but may not commit
                          to any course of action or obligate the other parent regarding their time or
                          financial responsibilities.
                       o **However, where the protocol stated above is inconsistent with the
                          specific healthcare provisions detailed below, the specific healthcare
                          provisions control.
         Decision-Making Healthcare Provisions.
              -   Mr. Ralidak may select a medical doctor / pediatrician for the children to see for
                  annual exams, and pursue any course of action recommended by the
                  pediatrician.
                      o Mr. Ralidak may raise any general concerns he has about the children’s
                          mental or physical health at these appointments.
                      o If Ms. Goodnight wishes to attend these appointments, she may do so,
                          and Mr. Ralidak must coordinate with her schedule to enable her to do so
                          (provided that she must make herself reasonably available so as not to
                          delay the appointment more than 2 weeks).
                      o Mr. Ralidak may pursue and schedule any evaluations which the
                          pediatrician recommends at these appointments. (For example, if after


 RCW 26.09.016, .181, .187, .194               Parenting Plan
 Mandatory Form (07/2022)                        p. 9 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000148
                          Mr. Ralidak raises his concerns, the pediatrician recommends evaluations
                          for ADHD, Mr. Ralidak may pursue assessments for the children.)
              -   Mr. Ralidak may have the children receive all vaccinations recommended by the
                  pediatrician (even over Ms. Goodnight’s objection), provided the following is
                  adhered to:
                      o The pediatrician must be provided with, and must consider, any
                          information Ms. Goodnight wishes to present, including but not limited to
                          information regarding any family medical history of allergies, medical
                          conditions, or adverse reactions to any vaccinations or medications.
                      o If after such information is presented, the pediatrician continues to
                          recommend the vaccinations, Mr. Ralidak’s consent to those vaccinations
                          will be legally sufficient, even over Ms. Goodnight’s objections.
                      o Mr. Ralidak must work with the pediatrician to spread out the vaccinations
                          to a reasonable degree. Ms. Goodnight must be consulted in this regard.
                          (For example, Ms. Goodnight stated that she and the naturopathic doctor
                          previously discussed a schedule to get the children caught up on
                          vaccinations. If she has such a schedule, it must be presented to the
                          pediatrician and considered, and adopted if the pediatrician finds it is
                          reasonable.)
                      o Mr. Ralidak must inform Ms. Goodnight of the final vaccination schedule
                          so that she can take steps to mitigate any side effects, and plan
                          vacations, extracurriculars, and other events accordingly.
         Decision-Making re: Name Change.

              -   The Court finds Ms. Goodnight’s efforts to change her children’s name to include
                  both her and Mr. Ralidak’s last names, is reasonable, in good faith, and in the
                  children’s best interests.
              -   As discussed is the Supplemental fingins, Mr. Ralidak’s objections are without
                  merit. He has no valid interest that will be harmed by the hyphenation of his
                  children’s last names to include both his name and Ms. Goodnight’s name.
              -   The Court assigns to Ms. Goodnight sole decision-making authority to petition to
                  change the children’s last names to “Goodnight-Ralidak.”
                      o Any other name-change petition initiated by either parent must be jointly
                          agreed upon or made according to the joint decision-making protocol
                          (unless a legal exception to notice requirements applies as a result of
                          gender expression, domestic violence, or other safety-related concern).
                      o If either parent changes the children’s names, the must provide notice to
                          the other party both before the hearing, so that the other parent may
                          attend, and after the hearing so that the other parent may know the result
                          (again, unless a legal exception to notice requirements applies as a result
                          of gender expression, domestic violence, or other safety-related concern).
                      o Nothing in this provision eliminates the ability of the children to initiate any
                          name change petition on their own behalf when they are old enough
                          under the law to do so.
         Values and Beliefs: The Court recognizes that the parents have very different values and
         beliefs from one another. Either parent may involve their children during their residential
         time in activities that are in line with the parent’s own values and beliefs (including
         religious, political, … etc.), either for or against. A parent may not object to the child’s
         attendance at any events with the other parent (or with that parent’s approval), merely
         on the basis of the activity being inconsistent with the first parent’s beliefs or values.
 RCW 26.09.016, .181, .187, .194               Parenting Plan
 Mandatory Form (07/2022)                       p. 10 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000149
         Consistency. The residential arrangements defined above are provided for in the best
         interests of the child. The child's interests are best served by a full and regular pattern of
         contact with both parents, responsiveness and cooperation by both parents, involvement
         by both parents in all aspects of the child's needs and a reasonably consistent routine of
         activities, values, and discipline throughout both homes. Absence, inconsistency, and
         conflict are opposed to the best interests of the child.
         Communication with Parents.
              -   Parents must make their child reasonably available to the other parent for texts,
                  phone, and video calls.
              -   Reasonably available means, at a minimum, the following:
                      o The children must be available for a brief (5 minute) video call before any
                           important event (such as testing, sporting events, performances … etc.)
                           and before bedtime each night. This is particularly important for the
                           youngest child, but is a requirement for all three children.
                      o The children must each be available for a 20-minute video call (separately
                           or together, at the residential parents’ preference) at least twice per week
                           with the non-residential parent. Once call must occur prior to the
                           scheduled date of the mid-week visit, and one must occur after
                           (regardless of whether the mid-week visit is cancelled).
                      o All communications must be unmonitored, meaning the residential parent
                           may not listen in, and must leave the room, or if outside must walk out of
                           hearing distance from the phone, for the duration of the call.
              -   However, there is an exception for if the children are traveling and do not have
                  access to communications. In such case, the residential parent must make an
                  effort to make the children available for a 20-minute call or communication at
                  least once per week. If that will not be possible (due to camping or in an area that
                  is not accessible to internet), the parent is required to notify the other parent at
                  least one week in advance. Being busy or merely traveling is not sufficient to
                  cancel the required calls; there must be a genuine lack of access to
                  communications.
              -   The children must be available to receive text messages from the non-residential
                  parent at all times, and must be permitted to initiate texts, phone calls, or video
                  calls with the other parent at any time, except that a parent may reasonably
                  restrict the child’s access to a communication device when the child is engaged
                  in meals, bedtime, school, scheduled extracurricular activities, or other organized
                  activity (i.e. religious functions, organized family functions …etc.).
         Activities. Each parent shall have the right and responsibility to ensure that the child
         attends school and other scheduled activities while in that parent's care. Activities shall
         not be scheduled to unreasonably interfere with the other parent's residential time with
         the child without prior agreement of the parent. Activities that fall solely on one parent's
         time may be scheduled without the other parent's agreement, but both parents shall
         have the right to participate.
         Change of Address. Each parent shall provide the other with the address and phone
         number of his or her residence, and email, and shall update such information promptly
         whenever it changes.
         Affections. Each parent agrees to exert every reasonable effort to maintain free access
         and unhampered contact and communication between the child and the other parent,


 RCW 26.09.016, .181, .187, .194              Parenting Plan
 Mandatory Form (07/2022)                      p. 11 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000150
         and to promote the emotions of affection, love and respect between them and the other
         parent.
         Enrichment Activities. Each parent shall be responsible for keeping themselves advised
         of athletic and social events in which the child participates. Both parents may participate
         in school and extracurricular activities for the child regardless of the residential schedule.
         Children's Welfare. Each parent shall provide the other parent promptly with receipt of
         any significant information regarding the welfare of the child including physical and
         mental health, performance in school, extracurricular activities, etc.
         Residential Absence. Each parent shall inform the other when that parent plans to be
         away from his or her residence with the child for more than two nights. The information
         to be provided shall include duration of the time away, the destination address(es), and
         contact phone numbers.
         Child's Involvement. Neither parent shall ask the child to make decisions or requests
         involving the residential schedule. Neither parent shall discuss the residential schedule
         with the child except for plans, which have already been agreed to by both parents in
         advance, except to ascertain the child's general interest in the activity/proposed event.
         Neither parent shall advise the child of the status of child support payments or other
         legal matters regarding the parents' relationship, parenting, or other issues. Neither
         parent shall use the child, directly or indirectly, to gather information about the other
         parent or take verbal messages to the other parent.


         Derogatory Comments. Neither parent shall make derogatory comments about the other
         parent or allow anyone else to do the same in the child's presence. Neither parent shall
         allow or encourage the child to make derogatory comments about the other parent. Each
         parent is charged with the duty to protect their children.

         Social Media and Allegedly Unsafe Individuals:

               -      The Court incorporates its oral ruling, as stated at the close of the trial on
                      06/04/2024 with respect to parents’ communications on social media, with other
                      parties, and parents’ decisions to involve other individuals in their children’s lives.
               -      The Court finds that many of the restrictions requested tread close to, if not over,
                      the line regarding the parents’ freedom of association and freedom of speech and
                      expression.
               -      In summary, the Court does not find that any particular individual discussed by
                      the parents presents a significant threat of harm to the children. The Court will
                      not, at this time, order the parents to keep any particular individual away from the
                      children, merely because of an alleged history of mental health concerns or
                      instability. Many individuals with a history of, or even presently expressing, mental
                      health concerns are safe, loving, kind individuals who can have an enormously
                      positive influence on children. Other individuals with mental health concerns are
                      emotionally damaging to the children they are around. It is a very fact-specific
                      inquiry, and the Court does not at present have sufficient information to find the
                      individual(s) discussed by the parents are potentially harmful. The Court does
                      however, urge both parents to be thoughtful about who they expose their children
                      to, and to consider the children’s best interests.
 RCW 26.09.016, .181, .187, .194                  Parenting Plan
 Mandatory Form (07/2022)                          p. 12 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000151
               -      Regarding the requested restrictions on the parents’ social media
                      communications, the Court finds that ordering the parents not to talk to their social
                      contacts online regarding the other parent amounts to an unconstitutional prior
                      restraint. The parents’ communications may cause harm, but they are entitled to
                      express their views. The Court will not restrain the parents from expressing
                      themselves, even if it means that their comments will be in the public view, and at
                      some point, may be viewable by the children. The Court does caution the parents
                      to consider their children’s best interests, and consider the impact their remarks
                      may have on the children, once the children inevitably go online and access social
                      media themselves.
               -      The Court also cautioned the parents that sharing the children’s information online
                      comes with considerable risks – both to the children and as regards potential
                      future legal liability for the parents, as laws on this matter are in flux and many
                      jurisdictions are considering imposing fines and other penalties on parents who
                      over-share their minor children’s private information on the internet and social
                      media platforms.


         Illness of Child. In the event of serious illness of the child, which affects the residential
         time of the child with a parent, the parent who misses residential time as a result of the
         illness shall be granted additional time to compensate for any time lost. Make up time
         shall be taken within 14 days or deemed waived.
         First Right of Refusal. Any absence that results in a parent not being able to personally
         supervise the children for a period of longer than 72 hours shall result in the other parent
         receiving the first right of refusal for childcare.
         Passports. The parent travelling last shall retain possession of the passports.
         International travel is strictly prohibited absent written agreement of the parties which
         shall not be unreasonably withheld. If passports are sought, the other parent must
         complete all necessary paperwork and send the paperwork to the parent applying for the
         children’s passports via certified mail within 14 days of notice via the parenting app.
         Monikers for Third Party Adults. The parties are prohibited from encouraging or
         supporting the use of the terms "father", "daddy", “mother”, "mommy" or any other
         derivative denoting parenthood to any other person besides Veronika and Mathew.
15.      Proposal
              Does not apply. This is a Court order if signed by a judge or commissioner below.
16.      Court Order
              This is a final Court order and replaces all other orders (temporary or final) previously
              entered in this case.
              Order of the Court: The Parties are ORDERED to follow the provisions outlined
              above.
              Other: The Court incorporates all findings of fact and conclusions of law as stated
              orally at the close of the trial, and as written in the “Order of the Court: Supplemental
              Findings and Conclusions” entered separately today.

 RCW 26.09.016, .181, .187, .194                  Parenting Plan
 Mandatory Form (07/2022)                          p. 13 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000152
If this is a court order, the parties and/or their lawyers (and any GAL) sign below.
This order (check any that apply):                   This order (check any that apply):
[ ] is an agreement of the parties.                  [ ] is an agreement of the parties.
[ ] is presented by me.                              [ ] is presented by me.
[ ] may be signed by the court without notice to me. [ ] may be signed by the court without notice to me.


Petitioner or lawyer signs here + WSBA #                 Respondent or lawyer signs here + WSBA #

Veronika Goodnight                                       Mathew Ralidak
Print Name                                  Date         Print Name                                    Date
This order (check any that apply):                   This order (check any that apply):
[ ] is an agreement of the parties.                  [ ] is an agreement of the parties.
[ ] is presented by me.                              [ ] is presented by me.
[ ] may be signed by the court without notice to me. [ ] may be signed by the court without notice to me.


Other party or lawyer signs here + WSBA #                Other party or Guardian ad Litem signs here


Print Name                                  Date         Print Name                                    Date




 RCW 26.09.016, .181, .187, .194                   Parenting Plan
 Mandatory Form (07/2022)                           p. 14 of 14
 FL All Family 140
Goodnight, Veronika
202504-PRR-349
DCYF - 000153
                             King County Superior Court
                          Judicial Electronic Signature Page

Case Number:          20-3-03830-3
Case Title:           GOODNIGHT ET AL VS RALIDAK

Document Title:       ORDER RE FINAL PARENTING PLAN


Signed By:            Rania Rampersad
Date:                 June 25, 2024




                      Judge : Rania Rampersad




This document is signed in accordance with the provisions in GR 30.
Certificate Hash:           FB29DAF7D7E0CEAB7C4172D07E94B3BF1420F433
Certificate effective date: 8/9/2023 3:55:36 PM
Certificate expiry date:    8/9/2028 3:55:36 PM
Certificate Issued by:        C=US, E=kcscefiling@kingcounty.gov, OU=KCDJA,
                              O=KCDJA, CN="Rania Rampersad:
                              SkluHOsk7hGiSPsYzbJ6iw=="


                                                                      Page 15 of 15



Goodnight, Veronika
202504-PRR-349
DCYF - 000154
                             Superior Court of Washington, County of King
    In re Parenting and Support of:
                                                            No. 20-3-03830-3 SEA
    E.L.R., A.W.R., and R.S.R.,
       Minors.                                              Final Order and Findings on Petition to
                                                            Change a Parenting Plan or Custody
                                                            Order
    Petitioner:
                                                            (ORMDD/ORDYMT)
         VERONIKA GOODNIGHT,
                                                            [ ] Clerk’s action required: 11

    And Respondent:
         MATHEW RALIDAK.


                         Final Order and Findings on Petition to Change
                                a Parenting Plan or Custody Order
   1.       This Order is based on:
             The Petition to Change a Parenting Plan or Custody Order,
             The children’s best interest,
             The Court’s decision that there were valid reasons to hear the Petition in the Sub. no.
               304, “Order on Adequate Cause to Change a Parenting/Custody Order,” pp. 1-2
               (entered 07/14/2023).
            And (check one):
            [X] the court hearing or trial on (date): 06/04/2024.
            The following people were at the hearing or trial (list parties, lawyers, and any guardians):
                   [x] these people testified (name/s):
                         Petitioner Veronika Goodnight, and
                         Respondent Mathew Ralidak.
                   [x] see also, “Order of the Court: Supplemental Findings and Conclusions” entered
   today.
 Findings & Conclusions
   2.       Jurisdiction (RCW 26.27.201–.221, .231, .261, .271).

    RCW 26.09.260, .270; 26.10.200        Final Or. and Findings on Petition to
    Mandatory Form (07/2022)              Change a Parenting/Custody Order
    FL Modify 610                                       p. 1 of 4
   Goodnight, Veronika
   202504-PRR-349
   DCYF - 000162
         [X] The court can decide this case for the children because (check all that apply; if a box
             applies to all of the children, you may write “the children” instead of listing names):
              [X] Washington order/exclusive, continuing jurisdiction – The parenting/custody
                  order was made by a Washington state court, and the court still has authority to
                  make other orders for (children’s names): Elora L. Ralidak, Aidan W. Ralidak,
                  and Raina S. Ralidak.
              AND (check one):
                      [X] Home state jurisdiction – Washington is the children’s home state
                          because (check all that apply):
                          [X] (Children’s names): Elora L. Ralidak, Aidan W. Ralidak, and Raina S.
                              Ralidak lived in Washington with a parent or someone acting as a
                              parent for at least the 6 months just before this case was filed, or if the
                              children were less than 6 months old when the case was filed, they
                              had lived in Washington with a parent or someone acting as a parent
                              since birth.
3.       Major change (RCW 26.09.260(1) and (2)).
         [X] Approved – The court approves a major change to the parenting order. The major
             change is approved because:
               The requested change is in the children’s best interest, and
               There has been a substantial change in the children’s situation or in the situation
                of the parent who did not request the major change. (Describe how the situation
                has changed, or describe a situation that the court did not know about when it
                made its order):
                  Father has moved from Everett to Duvall, now is less than 20 minutes away from
                  mother’s/children’s home, and children’s school. Initial parenting plan indicated that
                  if either parent were to move, it would be a substantial change in circumstances
                  warranting a change to the residential schedule. In addition, children have had
                  health complications and struggles in school arise since the last parenting plan.
                  See details in “Order of the Court: Supplemental Findings and Conclusions”
                  entered today, incorporated here by reference.
              Check reason/s for this change:
              [X] The children’s current living situation is harmful to their physical, mental, or
                  emotional health. It would be better for the children to change the order.
4.       Minor change (RCW 26.09.260(5), (7), and (9)).
         [X] Does not apply. No one requested a minor change.
5.       Restrictions on the parent with less parenting time
         [X] Does not apply.
6.       Other Changes (RCW 26.09.260(10))
         [ ] Does not apply.
         [X] Because of a substantial change in one parent’s/child’s situation, the court approves
             changes to the following parts of the Parenting Plan or Residential Schedule that are
             in the children’s best interest (check all that apply):
              [X] dispute resolution
 RCW 26.09.260, .270; 26.10.200        Final Or. and Findings on Petition to
 Mandatory Form (07/2022)              Change a Parenting/Custody Order
 FL Modify 610                                       p. 2 of 4
Goodnight, Veronika
202504-PRR-349
DCYF - 000163
                [X] decision-making
                [ ] transportation arrangements
                [X] other (specify): See details in “Order of the Court: Supplemental Findings and
                    Conclusions” entered today, incorporated herein by reference.
  7.       Child Support
           [X] Does not apply. No one asked to change child support.
           [X] Other findings: Although the change to a 50/50 parenting represents a substantial
               change of circumstances from the previous residential schedule wherein the children
               resided primarily with the Petitioner Ms. Goodnight, neither party presented the Court
               with updated financial information at the modification trial, and Mr. Ralidak’s petition
               to modify the parenting plan specifically stated “Child Support … No request. I am
               not asking the court to adjust or change child support.” “Petition to Change a
               Parenting Plan or Other Custody Order,” p. 3 (filed 06/15/2023). As the result, the
               Court is not modifying the child support.
                The Child Support Order entered 03/03/2022 is MAINTAINED.
  8.       Protection Order
           [X] Does not apply. No one requested a Protection Order in this case.
  9.       Restraining Order
           [X] Does not apply. No one requested a Restraining Order in this case.
  10.      Other Findings (if any)
           See “Court Order: Supplemental Findings and Conclusions” entered today, incorporated
           herein by reference.
 Court Orders
  11.      Decision (check all that apply):
           [X] Approved – The court approves the Petition. All temporary orders are ended. The
               court signed the following orders filed separately today.
                [X] Parenting Plan/Residential Schedule
  12.      Other Orders (if any)
         See “Court Order: Supplemental Findings and Conclusions” entered today, incorporated
         herein by reference.
  Ordered.
  06/24/2024                                eSignature to follow
  Date                                    Judge E. Rania Rampersad
  Petitioner and Respondent or their lawyers fill out below.
  This document (check any that apply):            This document (check any that apply):
  [ ] is an agreement of the parties               [ ] is an agreement of the parties
  [ ] is presented by me                           [ ] is presented by me
  [ ] may be signed by the court without notice to [ ] may be signed by the court without notice to
      me                                               me


  Petitioner signs here or lawyer signs here            WSBA #
   RCW 26.09.260, .270; 26.10.200      Final Or. and Findings on Petition to
   Mandatory Form (07/2022)            Change a Parenting/Custody Order
   FL Modify 610                                     p. 3 of 4
  Goodnight, Veronika
  202504-PRR-349
  DCYF - 000164
Print Name                                         Date


Respondent signs here or lawyer signs here         WSBA #


Print Name                                         Date




 RCW 26.09.260, .270; 26.10.200   Final Or. and Findings on Petition to
 Mandatory Form (07/2022)         Change a Parenting/Custody Order
 FL Modify 610                                  p. 4 of 4
Goodnight, Veronika
202504-PRR-349
DCYF - 000165
                             King County Superior Court
                          Judicial Electronic Signature Page

Case Number:          20-3-03830-3
Case Title:           GOODNIGHT ET AL VS RALIDAK

Document Title:       ORDER RE FINDINGS AND CONCLUSIONS MOD PP


Signed By:            Rania Rampersad
Date:                 June 25, 2024




                      Judge : Rania Rampersad




This document is signed in accordance with the provisions in GR 30.
Certificate Hash:           FB29DAF7D7E0CEAB7C4172D07E94B3BF1420F433
Certificate effective date: 8/9/2023 3:55:36 PM
Certificate expiry date:    8/9/2028 3:55:36 PM
Certificate Issued by:        C=US, E=kcscefiling@kingcounty.gov, OU=KCDJA,
                              O=KCDJA, CN="Rania Rampersad:
                              SkluHOsk7hGiSPsYzbJ6iw=="


                                                                      Page 5 of 5



Goodnight, Veronika
202504-PRR-349
DCYF - 000166
Goodnight, Veronika
202504-PRR-349
DCYF - 000167
Goodnight, Veronika
202504-PRR-349
DCYF - 000168
Goodnight, Veronika
202504-PRR-349
DCYF - 000169
Goodnight, Veronika
202504-PRR-349
DCYF - 000170
Goodnight, Veronika
202504-PRR-349
DCYF - 000171
                                                                                   Carnation Police Department




 Case # C25010391 - Summary Report Cover Sheet
 REPORT DATE / TIME                           AGENCY / DISTRICT / REPORTING AREA / SUBDIVISION 4 / SUBDIVISION 5   OFFENSE/INCIDENT START DATE / TIME - OFFENSE/INCIDENT END DATE /
                                                                                                                   TIME
 Apr 4, 2025 16:17                            Agency CARNATION / District R18 / Reporting Area
                                              R18001                                                               Apr 4, 2025 13:58 - 14:12

 OFFENSE-1
 OFFENSE CODE

 160 - CHILD ABUSE
 OFFENSE LOCATION                                                                                                  OFFENSE START DATE               OFFENSE END DATE

 4950 TOLT AVE, CARNATION, WA 98014                                                                                Apr 4, 2025 13:58                Apr 4, 2025 14:12

 INVOLVED PERSONS
 INVOLVEMENT            NAME                                        HOME ADDRESS                                   DOB / ESTIMATED AGE RANGE        RACE            SEX

 R-1, O-1               Mathew W. Ralidak                           31815 NE 162ND ST                              1986-RCW 13.50.1                 Unknown (U) Male
                                                                    DUVALL, WA 98019
 INVOLVEMENT            NAME                                        HOME ADDRESS                                   DOB / ESTIMATED AGE RANGE        RACE            SEX

 O-2                    Elora Goodnight-Ralidak                                                                    2015-03-21 (juvenile)            Unknown (U) Female
 INVOLVEMENT            NAME                                        HOME ADDRESS                                   DOB / ESTIMATED AGE RANGE        RACE            SEX

 S-1                    Veronika E. Goodnight                       33219 NE 66TH ST                               1982-02-15                       White (W)       Female
                                                                    CARNATION, WA 98014
 INVOLVEMENT            NAME                                        HOME ADDRESS                                   DOB / ESTIMATED AGE RANGE        RACE            SEX

 O-4                    COLIN MATTHEW                               RCW 13.50.100                                  1971RCW 13.50.10                 White (W)       Male
                        DERIEG                                      CARNATION, WA 98014
 INVOLVEMENT            NAME                                        HOME ADDRESS                                   DOB / ESTIMATED AGE RANGE        RACE            SEX
                                                                                                                          RCW 13.50.1
 O-5                    Michelle Frank                                                                             1996-                            White (W)       Female
 INVOLVEMENT            NAME                                        HOME ADDRESS                                   DOB / ESTIMATED AGE RANGE        RACE            SEX

 O-6                    Monica Galarneau                                                                           1985-RCW 13.50.1                 Unknown (U) Female
 INVOLVEMENT            NAME                                        HOME ADDRESS                                   DOB / ESTIMATED AGE RANGE        RACE            SEX

 V-1                    Raina Goodnight-Ralidak                                                                    2018-06-03 (juvenile)            Unknown (U) Female
 INVOLVEMENT            NAME                                        HOME ADDRESS                                   DOB / ESTIMATED AGE RANGE        RACE            SEX

 O-3                    Aidan Goodnight-Ralidak                                                                    2016-08-16 (juvenile)            Unknown (U) Male

 NARRATIVE

   Verbal disturbance between ex-spouses, reported abuse by mother of the youngest child.




 REPORTING OFFICER SIGNATURE / DATE                                                              SUPERVISOR SIGNATURE / DATE

 Jennifer Kellogg #000116210 Apr 5, 2025 09:07 (e-signature)                                     Tracy Owen #000069810 Apr 5, 2025 10:35 (e-signature)
 PRINT NAME                                                                                      PRINT NAME

 Jennifer Kellogg #000116210                                                                     Tracy Owen #000069810
Carnation Police Department                                                                                                                                                Pg 1 of 1
NOTE: Summarized report. More data regarding this report may exist in the RMS.
Mark43 RMS Form Goodnight,
                v2.0 generated byVeronika
                                  J. Kellogg #000116210 on Apr 5, 2025 15:22.

                  202504-PRR-349
                  DCYF - 000173
Case # C25010391 - Summary Report Carnation Police Department                                                                                                               Pg 1 of 4



 Case # C25010391 - Summary Report
 REPORT DATE / TIME                          AGENCY / DISTRICT / REPORTING AREA / SUBDIVISION 4 / SUBDIVISION 5      OFFENSE/INCIDENT START DATE / TIME - OFFENSE/INCIDENT END DATE /
                                                                                                                     TIME
 Apr 4, 2025 16:17                           Agency CARNATION / District R18 / Reporting Area
                                             R18001                                                                  Apr 4, 2025 13:58 - 14:12
 REPORT AUTHOR                                                                         WEATHER

 Jennifer Kellogg #000116210                                                           Clear
 REPORT TAKEN LOCATION

 4950 TOLT AVE, CARNATION, WA 98014
 SHOOTING                                    EMS / FIRE / OTHER LE AGENCIES ON SCENE

       YES          NO                             YES          NO
 EVENT STATISTICS

         0 - No Apparent Hazard                                                    1 - Hazard Existed
         2 - Gang Related                                                          3 - Deputy Assaulted - No Weapon
         4 - Deputy Assaulted - Weapon                                             5 - Hate Crime
         6 - Problem Solving Related                                               7 - Anti-Harrassment, Non-DV Only
         8 - Pursuit Involved                                                      9 - Domestic Violence
         Aid Required                                                              Alcohol Involved
         CC - Crisis Call                                                          CC - Mental Health Related
         CC - Suicidal                                                             CC - Use of Force
         COVID                                                                     Drugs Involved
         Eluding No Pursuits                                                       GVRU
         Juvenile Involved                                                         King County Parks
         N - Follow-up Over Phone                                                  Note 2 - Anti-Harassment/DVs require
                                                                                report
         Weapons Involved

 NARRATIVE

  Verbal disturbance between ex-spouses, reported abuse by mother of the youngest child.




 REPORTING PARTY-1
 REPORTING PARTY-1 (PERSON)                                                                                          DOB / ESTIMATED AGE RANGE

 R-1 Ralidak, Mathew W.                                                                                              1986-RCW 13.50.1
 SEX                   RACE / ETHNICITY                                                PHONE NUMBER

 Male                  Unknown (U) / Unknown                                           (856) 332-7796 (primary, Mobile Phone)
 HOME ADDRESS

 31815 NE 162ND ST, DUVALL, WA 98019
 REPORTING PARTY SIGNATURE




 OFFENSE-1
 OFFENSE CODE

 160 - CHILD ABUSE
 OFFENSE START DATE                                                OFFENSE END DATE                                  SUSPECTED COMPUTER/ HANDHELD DEVICE USE

 Apr 4, 2025 13:58                                                 Apr 4, 2025 14:12                                      YES           NO
 SUSPECTED ALCOHOL CONSUMPTION                                     SUSPECTED DRUG USE

       YES          NO                                                   YES         NO

 REPORTING OFFICER SIGNATURE / DATE                                                                   SUPERVISOR SIGNATURE / DATE

 Jennifer Kellogg #000116210 Apr 5, 2025 09:07 (e-signature)                                          Tracy Owen #000069810 Apr 5, 2025 10:35 (e-signature)
 PRINT NAME                                                                                           PRINT NAME

 Jennifer Kellogg #000116210                                                                          Tracy Owen #000069810
Carnation Police Department                                                                                                                                                  Pg 1 of 4
Mark43 RMS Form v2.0 generated by J. Kellogg #000116210 on Apr 5, 2025 15:22.

                 Goodnight, Veronika
                 202504-PRR-349
                 DCYF - 000174
Case # C25010391 - Summary Report Carnation Police Department                                                                                                       Pg 2 of 4

 OFFENSE LOCATION
 LOCATION NAME / STREET ADDRESS/LOCATION NAME / APT, UNIT, STE / DESCRIPTION

 4950 TOLT AVE
 CITY                                                                           STATE                           ZIP                               COUNTRY CODE

 CARNATION                                                                      WA                              98014                             US
 LOCATION CATEGORY                                                                             AGENCY / DISTRICT / REPORTING AREA / SUBDIVISION 4 / SUBDIVISION 5

 School - Elementary/ Secondary                                                                Agency CARNATION / District R18 / Reporting Area R18001
 VICTIMS-1
 VICTIMS-1 NAME (LAST, FIRST MIDDLE)                                                                            DOB / ESTIMATED AGE RANGE

 V-1 Goodnight-Ralidak, Raina                                                                                   2018-06-03 (juvenile)
 SEX                   RACE / ETHNICITY

 Female                Unknown (U)
 SUSPECTS-1
 SUSPECTS-1 NAME (LAST, FIRST MIDDLE)                                                                           DOB / ESTIMATED AGE RANGE

 S-1 Goodnight, Veronika E.                                                                                     1982-02-15
 SEX                   RACE / ETHNICITY                                         PHONE NUMBER

 Female                White (W) / Not Hispanic Or Latino                       (805) 895-0509 (primary, Mobile Phone)
 HOME ADDRESS

 33219 NE 66TH ST, CARNATION, WA 98014
 INVOLVED OTHER-1
 INVOLVED OTHER-1 (PERSON)                                                                                      DOB / ESTIMATED AGE RANGE

 O-1 Ralidak, Mathew W.                                                                                         1986-RCW 13.50.1
 SEX                   RACE / ETHNICITY                                         PHONE NUMBER

 Male                  Unknown (U) / Unknown                                    (856) 332-7796 (primary, Mobile Phone)
 HOME ADDRESS

 31815 NE 162ND ST, DUVALL, WA 98019
 INVOLVED OTHER-2
 INVOLVED OTHER-2 (PERSON)                                                                                      DOB / ESTIMATED AGE RANGE

 O-2 Goodnight-Ralidak, Elora                                                                                   2015-03-21 (juvenile)
 SEX                   RACE / ETHNICITY

 Female                Unknown (U)
 INVOLVED OTHER-3
 INVOLVED OTHER-3 (PERSON)                                                                                      DOB / ESTIMATED AGE RANGE

 O-3 Goodnight-Ralidak, Aidan                                                                                   2016-08-16 (juvenile)
 SEX                   RACE / ETHNICITY

 Male                  Unknown (U)
 INVOLVED OTHER-4
 INVOLVED OTHER-4 (PERSON)                                                                                      DOB / ESTIMATED AGE RANGE

 O-4 DERIEG, COLIN MATTHEW                                                                                      1971RCW 13.50.10
 SEX                   RACE / ETHNICITY

 Male                  White (W)
 HOME ADDRESS

  RCW 13.50.100 CARNATION, WA 98014
 INVOLVED OTHER-5
 INVOLVED OTHER-5 (PERSON)                                                                                      DOB / ESTIMATED AGE RANGE

 O-5 Frank, Michelle                                                                                            1996RCW 13.50.10
 SEX                   RACE / ETHNICITY                                         PHONE NUMBER

 Female                White (W)                                                RCW 13.50.100 primary, Mobile Phone)
 INVOLVED OTHER-6
 INVOLVED OTHER-6 (PERSON)                                                                                      DOB / ESTIMATED AGE RANGE

 O-6 Galarneau, Monica                                                                                          1985-RCW 13.50.1
 SEX                   RACE / ETHNICITY                                         PHONE NUMBER

 Female                Unknown (U)                                              RCW 13.50.100 (primary, Mobile Phone)

 REPORTING OFFICER SIGNATURE / DATE                                                            SUPERVISOR SIGNATURE / DATE

 Jennifer Kellogg #000116210 Apr 5, 2025 09:07 (e-signature)                                   Tracy Owen #000069810 Apr 5, 2025 10:35 (e-signature)
 PRINT NAME                                                                                    PRINT NAME

 Jennifer Kellogg #000116210                                                                   Tracy Owen #000069810
Carnation Police Department                                                                                                                                         Pg 2 of 4
Mark43 RMS Form v2.0 generated by J. Kellogg #000116210 on Apr 5, 2025 15:22.

                 Goodnight, Veronika
                 202504-PRR-349
                 DCYF - 000175
Case # C25010391 - Summary Report Carnation Police Department                                                                                          Pg 3 of 4


 METRO/SOUND TRANSIT
 IS THIS REPORT METRO TRANSIT OR SOUND TRANSIT RELATED?

 No

 RELATIONSHIPS ADDENDUM
 NAME                                                                           RELATIONSHIP                  SUBJECT

 Aidan Goodnight-Ralidak                                                        CHILD OF SIGNIFICANT          COLIN MATTHEW DERIEG
                                                                                OTHER
 NAME                                                                           RELATIONSHIP                  SUBJECT

 Aidan Goodnight-Ralidak                                                        CHILD OF                      Mathew W. Ralidak

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Aidan Goodnight-Ralidak                                                        ACQUAINTANCE OF               Michelle Frank

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Aidan Goodnight-Ralidak                                                        CHILD OF                      Veronika E. Goodnight

 NAME                                                                           RELATIONSHIP                  SUBJECT

 COLIN MATTHEW DERIEG                                                           ACQUAINTANCE OF               Michelle Frank

 NAME                                                                           RELATIONSHIP                  SUBJECT

 COLIN MATTHEW DERIEG                                                           ACQUAINTANCE OF               Monica Galarneau

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Elora Goodnight-Ralidak                                                        SIBLING OF                    Aidan Goodnight-Ralidak

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Elora Goodnight-Ralidak                                                        CHILD OF SIGNIFICANT          COLIN MATTHEW DERIEG
                                                                                OTHER
 NAME                                                                           RELATIONSHIP                  SUBJECT

 Elora Goodnight-Ralidak                                                        CHILD OF                      Mathew W. Ralidak

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Elora Goodnight-Ralidak                                                        ACQUAINTANCE OF               Michelle Frank

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Elora Goodnight-Ralidak                                                        CHILD OF                      Veronika E. Goodnight

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Mathew W. Ralidak                                                              ACQUAINTANCE OF               COLIN MATTHEW DERIEG

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Mathew W. Ralidak                                                              ACQUAINTANCE OF               Michelle Frank

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Mathew W. Ralidak                                                              SPOUSE OF                     Monica Galarneau

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Mathew W. Ralidak                                                              EX-SPOUSE OF                  Veronika E. Goodnight

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Michelle Frank                                                                 ACQUAINTANCE OF               Monica Galarneau

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Monica Galarneau                                                               STEP PARENT OF                Aidan Goodnight-Ralidak

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Monica Galarneau                                                               STEP PARENT OF                Elora Goodnight-Ralidak


 REPORTING OFFICER SIGNATURE / DATE                                                            SUPERVISOR SIGNATURE / DATE

 Jennifer Kellogg #000116210 Apr 5, 2025 09:07 (e-signature)                                   Tracy Owen #000069810 Apr 5, 2025 10:35 (e-signature)
 PRINT NAME                                                                                    PRINT NAME

 Jennifer Kellogg #000116210                                                                   Tracy Owen #000069810
Carnation Police Department                                                                                                                            Pg 3 of 4
Mark43 RMS Form v2.0 generated by J. Kellogg #000116210 on Apr 5, 2025 15:22.

                 Goodnight, Veronika
                 202504-PRR-349
                 DCYF - 000176
Case # C25010391 - Summary Report Carnation Police Department                                                                                          Pg 4 of 4


 NAME                                                                           RELATIONSHIP                  SUBJECT

 Monica Galarneau                                                               STEP PARENT OF                Raina Goodnight-Ralidak

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Raina Goodnight-Ralidak                                                        SIBLING OF                    Aidan Goodnight-Ralidak

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Raina Goodnight-Ralidak                                                        CHILD OF SIGNIFICANT          COLIN MATTHEW DERIEG
                                                                                OTHER
 NAME                                                                           RELATIONSHIP                  SUBJECT

 Raina Goodnight-Ralidak                                                        SIBLING OF                    Elora Goodnight-Ralidak

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Raina Goodnight-Ralidak                                                        CHILD OF                      Mathew W. Ralidak

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Raina Goodnight-Ralidak                                                        ACQUAINTANCE OF               Michelle Frank

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Raina Goodnight-Ralidak                                                        CHILD OF                      Veronika E. Goodnight

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Veronika E. Goodnight                                                          SIGNIFICANT OTHER OF COLIN MATTHEW DERIEG

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Veronika E. Goodnight                                                          ACQUAINTANCE OF               Michelle Frank

 NAME                                                                           RELATIONSHIP                  SUBJECT

 Veronika E. Goodnight                                                          ACQUAINTANCE OF               Monica Galarneau

 This report was generated in Mark43 and the e-signature was affixed using the undersigned officer's unique login and password. I certify
 (or declare) under penalty of perjury under the laws of the State of Washington that the foregoing is true and correct to the best of my
 knowledge and belief.
 ELECTRONICALLY SIGNED                                                          DATE                          PLACE

 Jennifer Kellogg                                                               04/05/2025                    King County, WA




 REPORTING OFFICER SIGNATURE / DATE                                                            SUPERVISOR SIGNATURE / DATE

 Jennifer Kellogg #000116210 Apr 5, 2025 09:07 (e-signature)                                   Tracy Owen #000069810 Apr 5, 2025 10:35 (e-signature)
 PRINT NAME                                                                                    PRINT NAME

 Jennifer Kellogg #000116210                                                                   Tracy Owen #000069810
Carnation Police Department                                                                                                                            Pg 4 of 4
Mark43 RMS Form v2.0 generated by J. Kellogg #000116210 on Apr 5, 2025 15:22.

                 Goodnight, Veronika
                 202504-PRR-349
                 DCYF - 000177
Case # C25010391 - Supplement - 1 Report Carnation Police Department                                                                                  Pg 1 of 2



 Case # C25010391 - Supplement - 1 Report
 REPORT DATE / TIME                          OFFENSE/INCIDENT START DATE / TIME - OFFENSE/INCIDENT END DATE /   REPORT AUTHOR
                                             TIME
 Apr 5, 2025 06:29                                                                                              Jennifer Kellogg #000116210
                                             Apr 4, 2025 13:58 - 14:12
 REPORT DESCRIPTION

 Primary incident report
 SUPPLEMENT TYPE – ONLY SELECT ONE

 Primary Incident Report

 NARRATIVE

  On April 4, 2025, I was dispatched at 1445 hours for a reported DV threats call at Carnation Elementary School, 4950 Told Ave.

  RP-1 Matthew Ralidak and S-1 Veronika Goodnight are divorced. Ralidak and Goodnight have three children in common, V-1 Raina
  Goodnight-Ralidak (6 yrs old), O-2 Elora Goodnight-Ralidak (8 yrs old), O-3 Aidan Goodnight-Ralidak (10 yrs old).

  O-4 Colin Derieg and Goodnight are currently dating.

  O-6 Monica Galarneau and Ralidak are currently married.

  O-5 Michelle Frank is the current principal for Carnation Elementary.

  Ralidak informed me of the following:

  He currently has a tense relationship with Goodnight. They currently share their children 50/50 according to their parenting plan. Ralidak
  informed me that there is an open CPS case involving Goodnight, a man she is living with, and RGR. Ralidak stated that according to
  RGR, Goodnight was making her kiss this man. Ralidak did not have any other information about this CPS case.

  While waiting, in his car, in line to pick up his children from school. At approximately 1358 hours Goodnight approached Ralidak’s car
  and started yelling at him. Goodnight was accusing Ralidak of calling CPS on her. Goodnight continued yelling and asking Ralidak
  questions about the children and Goodnight’s new living arrangements. At some point Ralidak noticed Derieg standing beside his car
  staring at him. Goodnight then went into the school office and back out toward Ralidak’s car. During this time Ralidak had called into the
  school’s office and told the principal, Frank, and another administrator about the odd behavior and scene Goodnight was making.

  Frank then came outside to speak with Goodnight. At approximately 1412 hours Goodnight and Derieg got into a maroon Chevy
  Silverado and left the school parking lot. Ralidak clarified that no threats were ever made by Goodnight or Derieg. Ralidak stated he felt
  intimidated by Derieg standing outside his car staring at him. While sharing the details of this incident Ralidak seemed visibly shaken
  and needed to take breaks, while talking with me, to hold back tears. All three children were not present during this incident.

  As I was leaving Ralidak showed me a text from Galarneau, who currently had all three children. Galarneau said that all three children
  had told her that Goodnight had slapped RGR and slammed her against a wall. Ralidak thought this might be retaliation because RGR
  had planned to tell Goodnight she no longer wanted to live with her.

  Ralidak did not mention any marks or bruises on RGR when he had seen her at the school pickup. The text from Galarneau did not
  describe any injuries on RGR. Ralidak and Galarneau have all three children over the weekend.

  Ralidak said he is worried for his children’s safety and wasn’t sure what to do. I gave Ralidak the case number and informed him that he
  should get in touch with a lawyer and ask about getting a protection order if he is feeling this way.

  Frank had informed me of the following:

  The office had received a call from Ralidak, so Frank and another administrator had gone outside to see what was going on. Frank
  spoke with Goodnight and told her “This isn’t the place”, in reference to not handling parenting issues on school grounds. Frank stated
  this is not the first time that Goodnight has caused a commotion or interrupted the children’s learning process.

  Frank then informed me that RGR had told her 1st grade teacher that her mother, Goodnight, had slapped her so hard she was thrown
  into the wall. Frank stated the teacher was in the process of reporting this incident to CPS.




 REPORTING OFFICER SIGNATURE / DATE                                                           SUPERVISOR SIGNATURE / DATE

 Jennifer Kellogg #000116210 Apr 5, 2025 09:07 (e-signature)                                  Tracy Owen #000069810 Apr 5, 2025 10:34 (e-signature)
 PRINT NAME                                                                                   PRINT NAME

 Jennifer Kellogg #000116210                                                                  Tracy Owen #000069810
Carnation Police Department                                                                                                                           Pg 1 of 2
Mark43 RMS Form v2.0 generated by J. Kellogg #000116210 on Apr 5, 2025 15:22.

                 Goodnight, Veronika
                 202504-PRR-349
                 DCYF - 000178
Case # C25010391 - Supplement - 1 Report Carnation Police Department                                                                                 Pg 2 of 2



  I reviewed footage taken by Ralidak and the school security footage. The footage showed Goodnight approaching Ralidak’s car. Then it
  looked like Goodnight had started yelling at Ralidak. It then showed Derieg standing a few feet away from the vehicle, staring inside. It
  did not appear that Derieg or Goodnight made any threatening gestures. Ralidak remained in his car during the entire incident. There
  was no audio to the footage.

  I sent Ralidak an evidence.com link to upload the footage he has and a screenshot of texts about the slapping incident. Ralidak is also in
  the process of obtaining the school’s security camera footage.

  Body worn camera was activated and footage uploaded to evidence.com.

  I determined there was no crime that occurred between Ralidak and Goodnight.

  CPS has been forwarded the case.

 LANGUAGE ACCESS SERVICES
 LIMITED ENGLISH PROFICIENCY
 LANGUAGE ASSISTANCE USED?

 No

 This report was generated in Mark43 and the e-signature was affixed using the undersigned officer's unique login and password. I certify
 (or declare) under penalty of perjury under the laws of the State of Washington that the foregoing is true and correct to the best of my
 knowledge and belief.
 ELECTRONICALLY SIGNED                                                          DATE                        PLACE

 Jennifer Kellogg                                                               04/05/2025                  King County, WA




 REPORTING OFFICER SIGNATURE / DATE                                                          SUPERVISOR SIGNATURE / DATE

 Jennifer Kellogg #000116210 Apr 5, 2025 09:07 (e-signature)                                 Tracy Owen #000069810 Apr 5, 2025 10:34 (e-signature)
 PRINT NAME                                                                                  PRINT NAME

 Jennifer Kellogg #000116210                                                                 Tracy Owen #000069810
Carnation Police Department                                                                                                                          Pg 2 of 2
Mark43 RMS Form v2.0 generated by J. Kellogg #000116210 on Apr 5, 2025 15:22.

                 Goodnight, Veronika
                 202504-PRR-349
                 DCYF - 000179
Goodnight, Veronika
202504-PRR-349
DCYF - 000180
Goodnight, Veronika
202504-PRR-349
DCYF - 000181