---
attachment_strategy: 6-attachment-approach
case_id: goodnight-v-ralidak
case_number: 20-3-03830-3-SEA
created: '2025-07-28'
cross_references:
- ~/Legal/02_SUPPORTING_MATTERS/DOH_Complaint/00_HANDOFF_SUMMARY.md
- ~/Legal/02_SUPPORTING_MATTERS/DOH_Complaint/FILING_CHECKLIST.md
- ~/Legal/01_ACTIVE_HEARING_AUG_25/EXHIBITS/B_Professional_Misconduct_Documentation.md
- ~/Legal/02_SUPPORTING_MATTERS/WMC_Evidence_Packages/
evidence_strength: smoking-gun
filing_agency: department-of-health
filing_method: online-submission
filing_strategy:
- Main complaint document
- 6 supporting attachments
- Smoking gun evidence prioritized
- Court order violations documented
- Professional license verification
- Systematic misconduct pattern
id: doh-complaint-filing-instructions
jurisdiction: washington-state
license_number: MC61294206
priority: critical
professional_target: danielle-smith-lmhca
related_documents:
- 00_HANDOFF_SUMMARY.md
- FILING_CHECKLIST.md
- DOH_COMPLAINT_DANIELLE_SMITH_COMPLETE.pdf
search_keywords:
- DOH filing instructions
- professional misconduct
- filing procedure
- regulatory complaint
semantic_concepts:
- professional accountability
status: ready-for-immediate-filing
title: Washington State DOH Professional Misconduct Complaint - Filing Instructions
type: procedural-instructions
updated: '2025-08-13'
uri: doc://legal/doh/filing-instructions
violation_type: court-order-violations
---
# 🎯 WASHINGTON STATE DEPARTMENT OF HEALTH COMPLAINT - FILING READY

**PROFESSIONAL MISCONDUCT COMPLAINT AGAINST DANIELLE SMITH, LMHCA**  
**License Number:** MC61294206  
**Date Prepared:** July 28, 2025  
**Status:** READY FOR IMMEDIATE FILING

---

## 📋 FILING PACKAGE CONTENTS

### **MAIN COMPLAINT**
- `DOH_COMPLAINT_DANIELLE_SMITH_COMPLETE.md` - Complete complaint document (convert to PDF for filing)

### **SUPPORTING ATTACHMENTS (6-Attachment Strategy)**

1. **ATTACHMENT_1_Therapy_Notes_May_1_2025.pdf** ⭐⭐⭐⭐⭐
   - **SMOKING GUN EVIDENCE**
   - Therapy session notes from May 1, 2025
   - Documents direct court order violation: "Client called stepmom, 'mom' throughout our session"
   - Professional documentation of misconduct without intervention

2. **ATTACHMENT_2_Final_Parenting_Plan_Monikers_Provision.pdf** ⭐⭐⭐⭐⭐
   - **LEGAL AUTHORITY VIOLATED**
   - eSigned court order establishing "monikers" prohibition
   - Judge Rania Rampersad, June 25, 2024
   - Legal foundation showing systematic violation

3. **ATTACHMENT_3_Professional_License_Verification.pdf** ⭐⭐⭐⭐⭐
   - **REGULATORY JURISDICTION**
   - Complete professional licensing information
   - Establishes DoH authority over MC61294206
   - Professional credentials and accountability framework

4. **ATTACHMENT_4_Police_Report_April_4_2025.pdf** ⭐⭐⭐⭐
   - **COORDINATED FALSE ALLEGATIONS**
   - Shows false allegations made against Veronika
   - Case closed with no findings - validates innocence
   - Demonstrates institutional pattern of false reporting

5. **ATTACHMENT_5_DCYF_Investigation_Records.pdf** ⭐⭐⭐⭐⭐
   - **SYSTEMATIC FALSE REPORTING PATTERN**
   - Official DCYF final response letter (ARRTS #202504-PRR-349)
   - Documents multiple CPS intakes all "screened out"
   - State agency authentication of case facts

6. **ATTACHMENT_6_DCYF_Official_Referral_to_DoH.pdf** ⭐⭐⭐⭐⭐
   - **STATE AGENCY VALIDATION**
   - DCYF Supervisor Jazie Smith, MSW official referral
   - Professional misconduct confirmed requiring DoH intervention
   - Official mandate for regulatory investigation

---

## 🚀 STRATEGIC POSITIONING

### **"WEAPONIZED THERAPY" NARRATIVE**
The 6-attachment package demonstrates:
- Licensed therapist enabled systematic court order violations
- Professional misconduct used to manufacture separation crisis
- Multi-agency false reporting pattern (all unfounded)
- State validation that regulatory intervention required

### **TIMING CRITICAL**
- File IMMEDIATELY before September 2, 2025 protection order decision
- Creates regulatory investigation pressure during family court proceedings
- Breaks court's "no acknowledgment" deadlock by showing Veronika is victim

### **LEGAL IMPACT**
- Independent professional validation for family court arguments
- Demonstrates systematic false reporting across agencies
- Shows 107-day separation enabled by professional misconduct
- Establishes precedent for professional accountability

---

## 📝 FILING INSTRUCTIONS

### **FORMAT REQUIREMENTS**
- **Main Complaint:** Convert `.md` to PDF for official filing
- **Attachments:** All provided in PDF format (legally optimal)
- **Organization:** Numbered attachments with clear descriptions

### **SUBMISSION METHOD**
- Online portal: Washington State Department of Health
- Professional licensing complaints division
- Include all 7 documents (1 complaint + 6 attachments)

### **FOLLOW-UP**
- Track complaint reference number
- Monitor investigation timeline (typically 30-60 days initial response)
- Coordinate with family court strategy for September 2 deadline

---

## ✅ QUALITY VALIDATION

- ✅ **Legal Authority:** Court order violation clearly documented
- ✅ **Professional Evidence:** Licensed professional documented misconduct
- ✅ **State Validation:** DCYF official referral confirms misconduct
- ✅ **Pattern Documentation:** Systematic false reporting across agencies
- ✅ **Strategic Timing:** Optimal for September 2 protection order impact
- ✅ **Complete Package:** All evidence professionally organized

---

## 🎯 BOTTOM LINE

**This DoH complaint package is PRODUCTION-READY and strategically positioned for maximum legal impact. The 6-attachment "weaponized therapy" strategy provides comprehensive evidence that professional misconduct enabled systematic court violations and manufactured the ongoing separation crisis.**

**FILE IMMEDIATELY for optimal timing with family court proceedings.**

---

**Prepared by:** TIA Legal Intelligence System  
**Date:** July 28, 2025  
**Status:** MISSION ACCOMPLISHED - READY FOR FILING