---
case_id: goodnight-v-ralidak
case_number: 20-3-03830-3-SEA
created: '2025-07-28'
cross_references:
- ~/Legal/02_SUPPORTING_MATTERS/DOH_Complaint/00_HANDOFF_SUMMARY.md
- ~/Legal/02_SUPPORTING_MATTERS/DOH_Complaint/README_FILING_INSTRUCTIONS.md
- ~/Legal/01_ACTIVE_HEARING_AUG_25/EXHIBITS/B_Professional_Misconduct_Documentation.md
evidence_strength: smoking-gun
filing_agency: department-of-health
filing_requirements:
- Main complaint PDF format
- 6 supporting attachments
- Professional license verification
- Court order violations documented
- Smoking gun evidence included
id: doh-complaint-filing-checklist
jurisdiction: washington-state
license_number: MC61294206
package_size: 13.3MB
priority: critical
professional_target: danielle-smith-lmhca
related_documents:
- 00_HANDOFF_SUMMARY.md
- README_FILING_INSTRUCTIONS.md
- DOH_COMPLAINT_DANIELLE_SMITH_COMPLETE.pdf
search_keywords:
- DOH filing
- checklist
- professional misconduct
- submission ready
semantic_concepts:
- regulatory filing
- professional accountability
status: ready-for-submission
submission_format: pdf-package
title: DOH Complaint Filing Checklist - Professional Misconduct Ready for Submission
total_attachments: 6
type: procedural-checklist
updated: '2025-08-13'
uri: doc://legal/doh/filing-checklist
violation_type: court-order-violations
---
# ✅ DOH COMPLAINT FILING CHECKLIST - READY FOR SUBMISSION

**Date:** July 28, 2025  
**Status:** ALL FILES CONVERTED TO PDF - LEGAL FILING READY

---

## 📋 COMPLETE FILING PACKAGE (ALL PDF FORMAT)

### **MAIN COMPLAINT**
✅ **DOH_COMPLAINT_DANIELLE_SMITH_COMPLETE.pdf** (36 KB)
- Professional misconduct complaint against Danielle Smith, LMHCA
- License MC61294206
- Complete regulatory violation documentation

### **SUPPORTING ATTACHMENTS**

✅ **ATTACHMENT_1_Therapy_Notes_May_1_2025.pdf** (399 KB)
- **SMOKING GUN EVIDENCE**
- Direct court order violation: "Client called stepmom, 'mom' throughout our session"
- Professional documentation without intervention

✅ **ATTACHMENT_2_Final_Parenting_Plan_Monikers_Provision.pdf** (1.0 MB)
- **LEGAL AUTHORITY VIOLATED**
- eSigned court order prohibiting "monikers" for third parties
- Judge Rania Rampersad authority

✅ **ATTACHMENT_3_Professional_License_Verification.pdf** (144 KB)
- **REGULATORY JURISDICTION**
- Complete licensing information MC61294206
- DoH authority establishment

✅ **ATTACHMENT_4_Police_Report_April_4_2025.pdf** (3.8 MB)
- **FALSE ALLEGATIONS PATTERN**
- Case closed with no findings
- Demonstrates coordinated institutional attack

✅ **ATTACHMENT_5_DCYF_Investigation_Records.pdf** (222 KB)
- **SYSTEMATIC FALSE REPORTING**
- Official DCYF final response (ARRTS #202504-PRR-349)
- Multiple CPS intakes all "screened out"

✅ **ATTACHMENT_6_DCYF_Official_Referral_to_DoH.pdf** (7.7 MB)
- **STATE VALIDATION**
- DCYF Supervisor official referral to DoH
- Professional misconduct confirmed

---

## 🚀 FILING INSTRUCTIONS

### **SUBMISSION READY**
- ✅ All documents in PDF format (legal standard)
- ✅ Professional presentation quality
- ✅ Complete evidence chain
- ✅ Strategic 6-attachment "weaponized therapy" narrative
- ✅ Total package size: 13.3 MB (within filing limits)

### **NEXT STEPS**
1. **Submit Online:** Washington State Department of Health professional licensing portal
2. **Track Reference Number:** For follow-up and status monitoring
3. **Timeline:** Expect 30-60 days for initial investigation response
4. **Coordinate:** With family court strategy for September 2 protection order decision

---

## 🎯 STRATEGIC IMPACT

**This filing package demonstrates:**
- Licensed professional documented systematic court violations
- Multi-agency false reporting pattern (all unfounded)
- Professional misconduct enabled 107-day separation crisis
- State agencies confirm regulatory intervention required

**TIMING CRITICAL:** File immediately for maximum impact on September 2 protection order renewal decision.

---

## ✅ QUALITY ASSURANCE COMPLETE

- ✅ **Format:** All PDF - meets legal filing requirements
- ✅ **Content:** Comprehensive professional misconduct evidence
- ✅ **Strategy:** 6-attachment "weaponized therapy" approach optimal
- ✅ **Timing:** Positioned for family court coordination
- ✅ **Documentation:** Complete regulatory violation chain

**STATUS: MISSION ACCOMPLISHED - READY FOR IMMEDIATE FILING**