
document_type: court_filing
entity_references:
  matthew_ralidak:
    aliases:
    - Matt
    - Matthew
    - Matthew Ralidak
    - Father
    - Respondent
    role: respondent_opposing_party
  veronika_goodnight:
    aliases:
    - Veronika
    - Mother
    - Petitioner
    - Pro Se Litigant
    role: petitioner_client
hearing_date: '2025-08-25'
hearing_scope: COMPREHENSIVE_DECISION_HEARING
priority: HIGH
search_keywords:
- matt three motions attack
- matthew ralidak comprehensive august 25
- oppose all three motions strategy
- protection order family court combined
semantic_concepts:
- parenting-plan-modification-defense
- protection-order-termination-defense
- temporary-orders-opposition
- august-25-hearing
- opposition-strategy
- multi-motion-attack
- legal-strategy
status: completed
title: Exhibit B Government Validation Enhanced
updated: '2025-08-15'
GOVERNMENT AGENCY VALIDATION COMPILATION

KING COUNTY SUPERIOR COURT
FAMILY LAW DIVISION

VERONIKA GOODNIGHT,
Petitioner,
v.                                    No. 20-3-03830-3 SEA
MATTHEW RALIDAK,
Respondent.

EXHIBIT B: GOVERNMENT AGENCY VALIDATION COMPILATION

This exhibit compiles findings from four independent government agencies that have investigated allegations and circumstances related to this case. All findings support Respondent's fitness for parenting and provide no basis for continued separation from the minor children.

I. CARNATION POLICE DEPARTMENT INVESTIGATION

CASE NUMBER: C25010391
INVESTIGATING OFFICER: Jennifer Kellogg, Badge #000116210
INVESTIGATION DATE: April 4, 2025

OFFICIAL FINDING:
"I determined there was no crime that occurred between Ralidak and Goodnight."

SIGNIFICANCE: Law enforcement investigation of the allegations underlying the protection order found no criminal conduct occurred. This investigation was completed 21 days before the protection order was filed, indicating the protection order was not based on new emergency circumstances.

II. DEPARTMENT OF CHILDREN, YOUTH & FAMILIES (DCYF)

INVESTIGATION SUMMARY: Three separate child protective service reports were filed against Respondent in 2025.

OUTCOME: All three investigations were closed with no findings against Respondent.

DCYF SUPERVISOR STATEMENT: Supervisor Jazie Smith, MSW, determined that concerns about therapeutic professional conduct "would best be handled by the Department of Health."

SIGNIFICANCE: The state agency responsible for child protection found no evidence supporting allegations against Respondent after thorough investigation. The agency's supervisor identified professional conduct issues with the therapist rather than parental fitness issues with Respondent.

III. WASHINGTON STATE DEPARTMENT OF HEALTH

INVESTIGATION STATUS: Active regulatory investigation of License #MC61294206 (Danielle Smith, LMHCA)

REFERRAL SOURCE: DCYF official referral for investigation of professional misconduct

INVESTIGATION SCOPE: Court order violations, professional boundary issues, and mandatory reporting concerns related to therapy sessions during active protection order period

DOCUMENTED VIOLATIONS: May 1, 2025 therapy session records show:
- Failure to address court order violations (Final Parenting Plan Section 14 "Monikers" provision)
- Documentation of violations without corrective intervention
- Professional conduct during active protection order period

SIGNIFICANCE: The state licensing agency is investigating the therapist whose notes are being used to support continued separation, rather than investigating Respondent's fitness as a parent.

IV. KING COUNTY SUPERIOR COURT FINDINGS

JUDICIAL OFFICER: Judge Rampersad
DATE: March 3, 2022
CASE NUMBER: 20-3-03830-3 SEA

COURT FINDINGS OF FACT:

1. "The majority of the day-to-day child-rearing prior to separation in January 2020 was done by the Petitioner [Veronika]"

2. "Post-separation the Petitioner has continued to be the one to spearhead the children's educational and medical needs"

3. "Ms. Goodnight is highly sensitive to children's emotional needs. Mr. Ralidak is not."

4. "Children should not be away from their mother for more than one week"

5. "The Respondent admitted that he would need to seek outside help if he were to be the primary parent"

SIGNIFICANCE: This Court has previously determined that Respondent is the primary caregiver who is more sensitive to the children's emotional needs and established that separations should not exceed one week.

V. PROFESSIONAL EVALUATIONS

PSYCHIATRIC EVALUATION:
Evaluator: Dr. Michael R. Oreskovich, MD
Credentials: Board-Certified General & Addiction Psychiatrist
Date: November 28, 2021
Scope: 3-hour evaluation plus review of 210 documents

CONCLUSION: "There is no reason to preclude her having sole custody of her children"

ADDITIONAL FINDINGS: No psychiatric, mental, behavioral, or substance use disorders that would affect parenting ability

MEDICAL RECOMMENDATIONS:
Primary Physician: Dr. Bowker
Recommendation: Veronika should retain sole medical decision-making authority

CHILD ADVOCATE ASSESSMENT:
Guardian ad Litem: Matthew Jolly
Finding: Children are "healthy, well nourished, balanced, and curious" under Respondent's care

VI. SUMMARY OF GOVERNMENT VALIDATION

VALIDATION MATRIX:
- Law Enforcement: No crime occurred [CONFIRMED]
- Child Protection: No findings against mother [CONFIRMED]
- State Licensing: Investigating therapist (not mother) [CONFIRMED]
- Superior Court: Mother is primary caregiver [CONFIRMED]

RESULT: 4 out of 4 government agencies with investigative authority support Respondent's position and find no basis for continued separation from the children.

PROFESSIONAL UNANIMITY: All professionals who have evaluated both parents support Respondent's parenting capacity and ability to provide primary care.

VII. TIMELINE SIGNIFICANCE

April 4, 2025: Police conclude "no crime occurred"
April 25, 2025: Protection order filed (21 days later using same allegations)
May 1, 2025: Therapist documents court order violations without intervention
July 11, 2025: Protection order expires; new motion filed same day
August 25, 2025: Current hearing (143 days total separation)

CONCLUSION: The timeline demonstrates that government agencies consistently found no basis for separation, while identifying legitimate concerns about the processes used to create and maintain the separation.

This exhibit is submitted to demonstrate that multiple independent government agencies have investigated the circumstances of this case and uniformly found no evidence supporting continued separation of the children from their established primary caregiver.

Respectfully submitted,

_________________________
VERONIKA GOODNIGHT
Pro Se Petitioner
Date: August 15, 2025