---
title: "Exhibit Preparation Checklist - September 10 Adequate Cause Opposition"
created: "2025-09-04"
updated: "2025-09-04"
document_type: "filing_checklist"
case_number: "20-3-03830-3-SEA"
hearing_date: "2025-09-10"
filing_deadline: "2025-09-06"
strategic_priority: "critical_preparation"
legal_tags: ["exhibit-preparation", "adequate-cause-opposition", "evidence-compilation"]
beth_topics: ["exhibit-organization", "professional-evidence", "government-validation", "court-filing-preparation"]
related:
  - description: "FL135 Declaration filing requiring these exhibits"
    relationship_strength: 1.0
    relationship_type: "filing_coordination"
    uri: "FL135_ADEQUATE_CAUSE_OPPOSITION_SEP10_2025.md"
---

# Exhibit Preparation Checklist
## September 10, 2025 - Adequate Cause Opposition Hearing

**Filing Deadline: September 6, 2025 (5:00 PM)**  
**Hearing: September 10, 2025 @ 1:00 PM, Courtroom W291**

---

## 📋 EXHIBIT LIST & PREPARATION STATUS

### **EXHIBIT A: Dr. Timothy Oreskovich Psychiatric Evaluation**

**Status: ✅ READY**  
**Source:** `/home/scottsen/Legal/01_ACTIVE_HEARING_AUG_25/EXHIBITS/A_Psychiatric_Evaluation_Dr_Oreskovich.md`

**Key Quotes to Highlight:**
- "No reason to preclude [mother] having sole custody"
- Board Certified Psychiatrist credentials
- 3-hour SCID-5 clinical interview methodology
- 210+ documents reviewed for comprehensive assessment

**Preparation Tasks:**
- [ ] Print clean copy for court filing
- [ ] Highlight key professional recommendations
- [ ] Prepare summary card for quick reference during hearing
- [ ] Verify all pages included and properly formatted

---

### **EXHIBIT B: Government Agency Investigation Records**

**Status: 🔄 NEEDS COMPILATION**

#### **B-1: DCYF Investigation Records**
**Source:** Multiple DCYF document locations
**Key Content:**
- 181 pages of investigation records
- All cases closed with no adverse findings
- Supervisor Jazie Smith May 2025 determination
- Initial April 2025 allegations NOT substantiated

**Action Required:**
- [ ] Compile complete DCYF record set
- [ ] Create summary cover sheet with key findings
- [ ] Highlight "no adverse findings" conclusions

#### **B-2: Police Investigation (Officer Kellogg)**  
**Key Content:**
- Investigation conclusion: "no crime occurred"
- Professional validation of maternal conduct
- Contradicts allegations requiring modification

**Action Required:**
- [ ] Locate complete police report
- [ ] Extract key conclusion quotes
- [ ] Prepare clean copy for filing

#### **B-3: Department of Health Documentation**
**Key Content:**
- Investigation of Respondent's therapy conduct
- Validation of maternal professional competence
- Context for therapeutic bias claims

**Action Required:**
- [ ] Gather DOH correspondence and documentation
- [ ] Summarize professional misconduct investigation status

---

### **EXHIBIT C: 2023 Court Records - Adequate Cause Pattern**

**Status: 🔍 NEEDS RESEARCH**

**Critical Content Needed:**
- July 2023 court order granting adequate cause to Respondent
- Documentation of case abandonment/no-show pattern
- Docket entries showing lack of follow-through
- Evidence of identical claims in current motion

**Research Tasks:**
- [ ] Contact King County Superior Court for 2023 records
- [ ] Request certified copies of relevant orders
- [ ] Document timeline of 2023 abandonment
- [ ] Compare 2023 claims to current 2025 motion language

**Alternative Sources:**
- [ ] Check existing case files for 2023 references
- [ ] Review attorney records if available
- [ ] Search EMAIL_EVIDENCE for any 2023 mentions

---

### **EXHIBIT D: Constitutional Analysis - 146+ Day Separation**

**Status: ✅ READY TO COMPILE**

**Content Elements:**
- Timeline showing 146+ days of ongoing separation
- Judge Rampersad 7-day maximum guidance reference
- Mathematical analysis: 146 ÷ 7 = 20.8x violation
- Constitutional due process framework
- Comparison to judicial standards and legal precedent

**Preparation Tasks:**
- [ ] Create visual timeline graphic
- [ ] Compile supporting legal research on separation limits
- [ ] Document constitutional framework citations
- [ ] Prepare clear mathematical violation presentation

---

### **EXHIBIT E: Professional Evidence Summary**

**Status: ✅ READY TO COMPILE**

**Summary Contents:**
- Dr. Oreskovich evaluation summary
- Government agency conclusions compilation
- Professional consensus documentation
- Contrast with Respondent's therapeutic bias claims

**Format:**
- [ ] Create professional summary chart
- [ ] Organize by source and conclusion
- [ ] Highlight unanimous support for current arrangement
- [ ] Contrast with lack of independent support for modification

---

## 📅 FILING TIMELINE & DEADLINES

### **September 4 (Today) - Preparation Phase**
- [x] FL135 Declaration drafted and ready
- [ ] **PRIORITY**: Begin Exhibit C research (2023 court records)
- [ ] Compile existing exhibits (A, D, E)
- [ ] Identify DCYF records location for Exhibit B

### **September 5 (Tomorrow) - Assembly Phase**  
- [ ] **MORNING**: Complete Exhibit C research/requests
- [ ] **AFTERNOON**: Finalize all exhibit compilation
- [ ] **EVENING**: Review complete filing package

### **September 6 (Filing Deadline) - Final Preparation**
- [ ] **MORNING**: Final document review and formatting
- [ ] **EARLY AFTERNOON**: File with King County Superior Court
- [ ] **LATE AFTERNOON**: Serve opposing counsel via email
- [ ] **EVENING**: Prepare hearing materials and backup copies

---

## 🎯 HEARING PREPARATION REQUIREMENTS

### **Court Filing Package (Due Sept 6)**
- [ ] Original FL135 Declaration
- [ ] Complete Exhibit A (Dr. Oreskovich)
- [ ] Complete Exhibit B (Government agencies)
- [ ] Complete Exhibit C (2023 precedent) 
- [ ] Complete Exhibit D (Constitutional analysis)
- [ ] Complete Exhibit E (Professional summary)
- [ ] Certificate of Service

### **Service Requirements**
- [ ] Email to jennifer@legalbymiller.com
- [ ] Email to camdyn@familylawlt.com  
- [ ] Service confirmation receipt

### **Hearing Day Materials (Sept 10)**
- [ ] Complete copy for court
- [ ] Personal reference copy
- [ ] Backup exhibits
- [ ] Key quotes summary card
- [ ] Constitutional math reference (146 ÷ 7 = 20.8x)

---

## ⚠️ CRITICAL ITEMS REQUIRING IMMEDIATE ATTENTION

### **🚨 HIGH PRIORITY - 2023 Court Records**
**Challenge:** Need documentation of 2023 adequate cause being granted and then abandoned  
**Solutions:**
1. **Court Clerk Request**: Call King County Superior Court records department
2. **Online Portal**: Check if 2023 records available electronically  
3. **Attorney Records**: Search existing files for any 2023 references
4. **Alternative Documentation**: Use Respondent's own 2023 motion for comparison

### **🔍 MEDIUM PRIORITY - DCYF Records Compilation**
**Challenge:** 181 pages scattered across multiple locations  
**Solutions:**
1. **Supervisor Jazie Smith Letter**: Focus on May 2025 no adverse findings  
2. **Investigation Summary**: Create compilation of key conclusions
3. **Case Closure Documentation**: Highlight all cases closed status

### **📋 ONGOING - Professional Evidence Organization**
**Status:** Most materials available, needs clean organization and presentation

---

## 📞 CONTACTS & RESOURCES

### **Court Information**
- **King County Superior Court Clerk**: (206) 477-1065
- **Records Department**: Request 2023 case materials
- **Filing Location**: 516 Third Avenue, Seattle, WA 98104

### **Professional Evidence Sources**
- **Dr. Oreskovich**: Existing evaluation materials ready
- **DCYF**: Supervisor Jazie Smith determination (May 2025)
- **Police**: Officer Kellogg investigation conclusion

### **Legal Research**
- **Constitutional Framework**: Due process, family integrity rights
- **RCW 26.09.260**: Adequate cause statutory requirements
- **Separation Standards**: Judicial guidance on maximum separation periods

---

**SUCCESS METRIC**: Complete, professional filing package delivered by September 6 deadline with all exhibits supporting the core argument that no substantial change in circumstances exists and that Respondent's motion continues a pattern of litigation abuse established in 2023.