---
title: "---\n\n\nauthors:"
created: "2025-08-15"
updated: "2025-08-16"
description: "government_validation: dcyf-official-referral-to-doh"
tags: ['analysis', 'automation', 'legal', 'reference', 'system']
---
---\n\n\nauthors:
- user:veronika
- agent:claude
case_id: goodnight-v-ralidak
case_number: 20-3-03830-3-SEA
category: timeline-analysis
court: king-county-family
created: '2025-08-15'
evidence_type: therapeutic-weaponization-timeline
exhibit_number: C
government_validation: dcyf-official-referral-to-doh
id: exhibit-c-therapeutic-timeline-analysis
jurisdiction: washington-state
key_professionals:
- danielle-smith-lmhca
- mario-gaspar-lmfta
- dan-claussen
manipulation_pattern: systematic-professional-capture
professional_misconduct: court-order-violations-documented
related_documents:
- description: MASTER INDEX - Therapeutic weaponization evidence compilation and navigation
  relationship_strength: 1.0
  relationship_type: primary-index
  uri: ../../02_SUPPORTING_MATTERS/THERAPEUTIC_WEAPONIZATION_EVIDENCE_INDEX.md
- description: Criminal enterprise analysis supporting therapeutic weaponization timeline
  relationship_strength: 1.0
  relationship_type: criminal-analysis
  uri: ../../03_CASE_ARCHIVE/04_EVIDENCE_REPOSITORY/Evidence_Archive/01_CORE_CASE/PROFESSIONAL_MISCONDUCT/10_THERAPIST_MISCONDUCT_SMOKING_GUN/00_LARCH_COUNSELING_CRIMINAL_ENTERPRISE_ANALYSIS.md
- description: Department of Health complaint documenting professional misconduct
  relationship_strength: 1.0
  relationship_type: regulatory-complaint
  uri: ../../DOH_COMPLAINT_DANIELLE_SMITH_COMPLETE.md
- description: Master timeline integrating therapeutic weaponization pattern
  relationship_strength: 1.0
  relationship_type: master-timeline-integration
  uri: ../../MASTER_TIMELINE_AUGUST_25_2025.md
search_keywords:
- therapeutic timeline
- professional documentation
- court order compliance
- timeline analysis
- therapeutic weaponization
- Matt manipulation
- evidence manufacturing
- professional capture
- therapy abuse
semantic_concepts:
- professional-capture
- evidence-manufacturing
- therapy-manipulation
status: professional_revision
subcategory: therapeutic-weaponization
tags:
- court-exhibit
- therapeutic-weaponization
- professional-misconduct
- timeline-analysis
- august-25-hearing
timeline_significance: evidence-manufacturing-coordination
title: 'Exhibit C: Therapeutic Services Timeline Analysis - Weaponization Documentation'
tone: professional_legal_standard
type: court-exhibit
updated: '2025-08-16'
uri: doc://legal/exhibit-c-therapeutic-timeline-analysis
weaponization_phases:
- professional-authority-capture-oct-2024
- false-evidence-manufacturing-april-2025
- court-order-violation-enablement-may-2025
- institutional-corruption-systematic
weaponization_theme: MATT_PRIMARY_MANIPULATION_TOOL
--- EXHIBIT C: THERAPEUTIC SERVICES TIMELINE ANALYSIS

**Court Exhibit for:** Goodnight v. Ralidak (20-3-03830-3 SEA)  
**Document Type:** Professional Timeline Analysis  
**Date Prepared:** August 15, 2025

---

## THERAPEUTIC SERVICES TIMELINE

### BASELINE PERIOD (OCTOBER 2024 - MARCH 2025)

**Service Initiation:** October 14, 2024  
**Initiating Parent:** Mother (Veronika Goodnight)  
**Professional:** Danielle Smith, LMHCA (License #MC61294206)  
**Institution:** Larch Counseling PLLC

**Initial Therapeutic Focus:**
- Child adjustment difficulties following family transitions
- Behavioral concerns during parental transitions
- Mother sought collaborative therapeutic approach
- Regular therapeutic sessions established

**Documented Therapeutic Content (October 2024 - March 2025):**
- "Child cries when at dads" - indicating distress during father's parenting time
- Adjustment challenges related to family separation
- No abuse allegations documented during this 6-month period
- Mother's attempts to participate in therapeutic planning

### CRITICAL PERIOD (APRIL 4-11, 2025)

**April 4, 2025 - Law Enforcement Investigation**
- Carnation Police Department responds to allegations
- Investigating Officer: Jennifer Kellogg, Badge #000116210
- **Official Finding:** "I determined there was no crime that occurred between Ralidak and Goodnight"

**April 7, 2025 - New Therapeutic Content**
- First documentation of physical discipline allegations in therapeutic records
- Timing: 3 days after police investigation concluded
- Change in therapeutic narrative focus

**April 11, 2025 - Legal Filing**
- Protection order filed incorporating therapeutic documentation
- Timing: 7 days after police investigation
- Therapeutic records cited as supporting evidence

### TIMELINE ANALYSIS

**Sequence of Events:**
1. **6+ months of therapy:** No abuse allegations documented
2. **Police investigation:** Finds no criminal conduct
3. **3 days later:** Abuse allegations appear in therapy notes
4. **4 days later:** Legal filing incorporates new therapeutic content

**Professional Documentation Patterns:**
- Extended baseline period with different therapeutic focus
- Rapid change in documented content following legal developments
- Use of qualifying language ("allegedly") indicating uncertainty
- Integration of therapeutic content with legal proceedings

---

## COURT ORDER COMPLIANCE DOCUMENTATION

### MAY 1, 2025 THERAPEUTIC SESSION

**Professional:** Danielle Smith, LMHCA (License #MC61294206)  
**Date:** May 1, 2025  
**Child:** R.S.R. (age 7)  
**Present:** Child, stepmother, therapist

**Professional Documentation:**
> "Client called stepmom, 'mom' throughout our session"

**Relevant Court Order (Final Parenting Plan Section 14):**
> "Monikers for Third Party Adults: The parties are prohibited from encouraging or supporting the use of the terms 'father', 'daddy', 'mother', 'mommy' or any other derivative denoting parenthood to any other person besides Veronika and Mathew."

### PROFESSIONAL RESPONSE TO COMPLIANCE ISSUE

**Therapeutic Intervention:** No documented corrective action taken during session

**Professional Obligation:** Licensed professionals should address court order compliance issues

**Documentation Standard:** Session notes record violation without intervention

**Regulatory Consequence:** DCYF Supervisor referred matter to Department of Health for investigation

---

## PROFESSIONAL MISCONDUCT INVESTIGATION

### DEPARTMENT OF HEALTH REFERRAL

**Referring Agency:** Department of Children, Youth & Families (DCYF)  
**Referring Supervisor:** Jazie Smith, MSW  
**Supervisor Quote:** "We are referring this matter to the Department of Health for investigation of professional misconduct"

**Investigation Scope:**
- Court order violations during therapeutic sessions
- Professional boundary maintenance during active legal proceedings
- Appropriate therapeutic interventions regarding family dynamics
- Compliance with professional licensing standards

### REGULATORY STATUS

**Current Status:** Active investigation by Washington State Department of Health  
**License Under Review:** MC61294206  
**Professional:** Danielle Smith, LMHCA  
**Investigation Areas:** Professional conduct, court order compliance, therapeutic boundaries

---

## CHILDREN'S DOCUMENTED EXPRESSIONS

### CHILD'S STATED PREFERENCES

**Date:** May 1, 2025  
**Source:** Therapeutic session documentation  
**Child's Statement:** "She does want to go back and live with mom"  
**Context:** Statement made during extended separation period  
**Professional Response:** Documented but therapeutic intervention unclear

### CHILD AWARENESS OF LEGAL PROCEEDINGS

**Documented Evidence:** Child demonstrated awareness of "protection order" proceedings  
**Professional Concern:** Child's knowledge of legal terminology suggests adult involvement  
**Therapeutic Standard:** Children should be protected from adult legal disputes  
**Professional Response:** No documented intervention to address inappropriate legal exposure

---

## THERAPEUTIC SERVICE DELIVERY ANALYSIS

### AUTHORITY VERIFICATION ISSUES

**Joint Legal Custody Status:** Both parents have equal rights to therapeutic decisions  
**Professional Practice:** Should verify legal authority before excluding parent  
**Case Application:** Extended exclusion of mother despite joint custody  
**Duration:** 7+ months of therapeutic services without proper parental involvement

### PROFESSIONAL BOUNDARIES

**Standard Practice:** Maintain neutrality in custody disputes  
**Case Application:** Therapeutic documentation used in legal proceedings  
**Professional Concern:** Therapy sessions may have enabled rather than addressed problematic patterns  
**Regulatory Response:** Department of Health investigation initiated

### COURT ORDER COMPLIANCE

**Professional Obligation:** Licensed professionals must comply with existing court orders  
**Documented Violation:** Court order prohibiting stepparent terms documented without correction  
**Professional Standard:** Should address compliance issues within therapeutic context  
**Regulatory Consequence:** Professional misconduct investigation initiated

---

## TIMELINE SIGNIFICANCE

### PROCEDURAL IMPLICATIONS

**Evidence Timeline:** Therapeutic content changes coincide with legal strategy needs  
**Professional Documentation:** Records show correlation between legal developments and therapeutic narrative  
**Court Consideration:** Timeline demonstrates relationship between therapeutic documentation and legal proceedings

### CHILD WELFARE CONSIDERATIONS

**Primary Concern:** Child's therapeutic needs versus legal strategy utilization  
**Professional Standard:** Therapeutic relationship should serve child's best interests  
**Documentation:** Child expressed desire to return to mother despite ongoing separation  
**Duration Impact:** Extended separation continues despite child's documented preferences

---

## CONCLUSION

This timeline analysis documents the relationship between therapeutic service delivery and legal proceedings, highlighting professional conduct concerns that have been referred to appropriate regulatory authorities. The evidence shows correlation between legal developments and changes in therapeutic documentation, raising questions about the appropriate use of therapeutic relationships in custody disputes.

The Department of Health investigation will determine whether professional standards were met in the provision of therapeutic services to the minor children during active legal proceedings.

---

**Exhibit Status:** Professional Timeline Analysis  
**Regulatory Status:** Under Department of Health Investigation  
**Court Use:** Supporting documentation for August 25, 2025 hearing  
**Professional Review:** Completed August 15, 2025