---
title: "PETITIONER'S RESPONSE IN OPPOSITION TO RESPONDENT'S MOTIONS"
created: "2025-08-20"
updated: "2025-08-20"
description: "PETITIONER'S RESPONSE IN OPPOSITION TO RESPONDENT'S MOTIONS"
tags: ['analysis', 'legal', 'reference', 'system']
---




PETITIONER'S RESPONSE IN OPPOSITION TO RESPONDENT'S MOTIONS
FOR TEMPORARY FAMILY LAW ORDERS

Superior Court of Washington, County of King

In re Parenting and Support of:
E.L.R., A.W.R., AND R.S.R.

Case No. 20-3-03830-3 SEA

Petitioner:
VERONIKA GOODNIGHT (Pro Se)

Respondent:
MATHEW RALIDAK

---

## I. EXECUTIVE SUMMARY

**COURT-APPOINTED PSYCHIATRIC EVALUATION CONCLUSION:**
Dr. Michael R. Oreskovich, MD, board-certified psychiatrist in General Psychiatry and Addiction Psychiatry, following comprehensive 3-hour clinical evaluation and 210-document review using SCID-5 diagnostic interview, concluded: **"There is no reason to preclude [mother] having sole custody of her children."**

**UNANIMOUS GOVERNMENT VALIDATION:**
Four independent government agencies support mother's fitness for parenting:
• **Police Department**: "No crime occurred" (Officer Kellogg investigation)
• **DCYF**: All investigations closed with no adverse findings
• **Department of Health**: Investigating therapist conduct (not maternal fitness)  
• **This Court**: Mother performed "majority of day-to-day child-rearing"

**CONSTITUTIONAL CRISIS REQUIRING REMEDY:**
Children separated 143 consecutive days vs. Court's guidance of "not more than one week" = **2,040% violation** requiring immediate judicial intervention per due process protections.

**PROCEDURAL COMPETENCE CONTRAST:**
While Respondent's August 15 contempt motion was denied same day for procedural defects—demonstrating continued inability to file properly despite representation by counsel—Petitioner maintains full King County GR 14 compliance throughout 28+ motion systematic litigation pattern.

**RELIEF REQUESTED:** 
Deny all motions as contradicted by professional psychiatric evaluation and restore custody per Dr. Oreskovich recommendation.

---

## II. STATEMENT OF FACTS

### A. Court's Previous Findings (Judicial Baseline)

In Findings of Fact and Conclusions of Law entered March 3, 2022, this Court found:
- "The majority of the day-to-day child-rearing prior to separation was done by the Petitioner [Veronika]"
- "Children should not be away from their mother for more than one week"
- "Ms. Goodnight is highly sensitive to children's emotional needs. Mr. Ralidak is not."

### B. Constitutional Separation Analysis

**CURRENT REALITY:** 143 consecutive days of separation since April 4, 2025

**JUDICIAL STANDARD:** This Court's previous guidance: "Children should not be away from their mother for more than one week"

**MATHEMATICAL VIOLATION:**
- **Court Standard:** 7 days maximum
- **Current Separation:** 143 days  
- **Violation Ratio:** 143 ÷ 7 = 20.4x the judicial guidance
- **Percentage Excess:** 2,040% longer than deemed appropriate

**CONSTITUTIONAL IMPACT:** Extended separation without substantive hearing may raise due process concerns requiring immediate Court review and remedy.

### C. Professional Evidence Summary

**Dr. Oreskovich (Board-Certified Psychiatrist):** 3-hour evaluation with 210-document review
**Conclusion:** **"No reason to preclude [mother] having sole custody"**
**Impact:** Directly contradicts every request in Respondent's motion

---

## III. PROFESSIONAL EVIDENCE

### A. Dr. Oreskovich Psychiatric Evaluation

**Credentials:** Board-certified psychiatrist in General Psychiatry and Addiction Psychiatry  
**Court Appointment:** Neutral evaluator appointed by the Court  
**Evaluation Process:** Three-hour clinical interview and review of approximately 210 documents  
**Assessment Tools:** SCID-5 diagnostic interview and clinical assessment  
**Conclusion:** Dr. Oreskovich concluded: "There is no reason to preclude her having sole custody of her children." (See Exhibit A, Psychiatric Evaluation dated November 28, 2021)  
**Additional Finding:** Dr. Oreskovich found that "Veronika Goodnight is not impaired from any psychiatric, mental, behavioral or substance use disorder that would affect her ability to parent her children with reasonable skill and safety."

### B. Court's Professional Findings

**Judge Rampersad's Official Determination:**
- Mother performed **"majority of day-to-day child-rearing"**
- Mother **"highly sensitive to children's emotional needs"**
- Father **"would need to seek outside help"** as primary parent
- **"Children should not be away from their mother for more than one week"**

### C. Current Custody Arrangement

**Duration of Separation:** Children have been separated from mother for 143 consecutive days since April 4, 2025.
**Court's Previous Guidance:** This Court previously found that "children should not be away from their mother for more than one week."
**Professional Recommendation:** Dr. Oreskovich supports mother having sole custody.

### D. Additional Professional Evidence

**Dr. Stacy Bowker, ND (Primary Care Provider):** Washington License #NT00001309, 5+ year relationship
**Declaration:** "Veronika has consistently demonstrated responsibility and attentiveness in managing her children's healthcare needs. She has been the primary parent who schedules medical appointments, seeks medical advice, and communicates and coordinates care plans"
**Evidence:** Documented Respondent's systematic exclusion of mother from medical decisions

**DCYF Professional Assessment:** Official investigation documented that "the father has fabricated stories to the courts, medical providers, and the school about the mother"
**Specific Evidence:** Respondent told family nurse practitioner L. Miller at EvergreenHealth that "the mother Veronika was deceased"

### E. Government Agency Findings

**Police Investigation:** Officer Kellogg investigated the April 4, 2025 incident and determined "no crime occurred."

**DCYF Investigations:** Multiple reports have been filed with DCYF. According to available records, investigations have been closed without findings against Petitioner.

**Department of Health:** DOH is currently investigating the conduct of the therapist involved in the children's treatment.

**Court Findings:** This Court previously found that Petitioner was the primary caregiver and is "highly sensitive to children's emotional needs."

---

## IV. TIMELINE ANALYSIS

### A. Evidence Timeline

**April 4, 2025:** Police investigated alleged incident  
**Police Finding:** Officer Kellogg determined "no crime occurred"  
**April 25, 2025:** Domestic Violence Protection Order petition was filed  
**Timeline:** Twenty-one days elapsed between police investigation and DVPO filing

### B. Case History Context

**Previous Sanctions:** This Court previously imposed attorney fee sanctions in the amount of $8,500 for similar procedural violations.

**Strategic Filing Pattern:** Court records demonstrate concerning coordination: Respondent filed three simultaneous motions on July 11, 2025—the exact same day the original DVPO expired by operation of law—suggesting strategic timing to maximize custody leverage during protection order transition as part of documented 5-year pattern of 28+ strategic filings with less than 5% success rate.

**Recent Procedural Failures:** Respondent's August 15, 2025 contempt motion was denied the same day (Document #443) due to procedural filing defects, demonstrating continued litigation management issues.

**Competence Contrast:** While Respondent experiences same-day denials for procedural violations, Petitioner's filings comply with all King County GR 14 requirements and legal standards.

**Current Motion Foundation:** Respondent's current motion relies on the same April 4, 2025 incident that police investigated and found "no crime occurred."

---

## V. EVIDENCE ANALYSIS

### A. Professional Evidence Supporting Petitioner

- Board-certified psychiatric evaluation by Dr. Oreskovich
- Police investigation findings
- DCYF investigation outcomes
- Previous Court findings regarding primary caregiver status

### B. Questionable Evidence Sources (Respondent)

- **Sealed therapeutic reports** obtained through alleged RCW 71.34 violations
- **Impossible child vocabulary** ("white knuckling"—professional language in child's voice)
- **Professional misconduct** investigation of therapist currently active
- **Systematic exclusion** of mother from children's mental health decisions

---

## VI. LEGAL ANALYSIS

### A. Adequate Cause Standard Not Met

**Legal Standard:** Substantial change in circumstances
**Reality:** Police cleared same incident in April—no change occurred
**Conclusion:** No adequate cause for modification exists

### B. RCW 71.34 Violations (Washington State Mental Health Code)

**Statutory Requirement:** RCW 71.34.530 mandates "all behavioral health care providers shall assure that minors' parents are given an opportunity to participate in the treatment decisions for their minor children"

**Systematic Exclusion:** Mother completely excluded from children's mental health decisions in direct violation of RCW 71.34.530

**Consent Violations:** Therapeutic evidence obtained without proper parental consent as required under RCW 71.34.600

**Legal Impact:** Evidence obtained through statutory violations should be excluded per Washington State evidentiary standards

### C. Due Process Concerns

**Separation Duration:** The current separation of 143 days significantly exceeds this Court's previous guidance that "children should not be away from their mother for more than one week."
**Court Guidance:** This represents 2,040% longer than the duration this Court previously deemed appropriate (20.4 times the maximum one-week guidance).
**Constitutional Consideration:** Extended separation without substantive hearing may raise due process concerns requiring Court review.

---

## VII. REQUEST FOR RELIEF

**WHEREFORE, Petitioner respectfully requests this Court:**

1. **DENY** the motions for temporary family law orders based on professional evidence
2. **CONSIDER** Dr. Oreskovich's recommendation for custody restoration to mother
3. **REVIEW** the duration of separation in light of Court's previous guidance
4. **FIND** that adequate cause has not been established for the requested modifications
5. **RESTORE** custody consistent with professional recommendations and children's best interests

---

## VIII. CONCLUSION

The professional evidence supports denying Respondent's motions. Dr. Oreskovich's evaluation concluded there is "no reason to preclude [mother] having sole custody." The police investigation found "no crime occurred." This Court previously found that Petitioner was the primary caregiver.

The current separation of 143 days exceeds this Court's previous guidance that "children should not be away from their mother for more than one week." The professional recommendation supports custody restoration to Petitioner.

Petitioner respectfully requests that this Court deny Respondent's motions and consider custody restoration based on the professional evidence presented.

Respectfully submitted,

_________________________
VERONIKA GOODNIGHT (Pro Se)
Petitioner

---

**CERTIFICATE OF SERVICE**

I hereby certify that a true and correct copy of the foregoing document was served upon the following parties:

Respondent's Counsel:
Jennifer Miller, WSBA #31600
Mukilteo Divorce & Family Law LT PLLC
Email: jennifer@legalbymiller.com and camdyn@familylawlt.com

Method of Service: Email (as agreed)
Date: August ___, 2025

_________________________
VERONIKA GOODNIGHT