---
title: "FL ALL FAMILY 135 - DECLARATION IN OPPOSITION TO TEMPORARY FAMILY LAW ORDERS"
created: "2025-08-17"
updated: "2025-08-17"
description: "FL ALL FAMILY 135 - DECLARATION IN OPPOSITION TO TEMPORARY FAMILY LAW ORDERS"
tags: ['analysis', 'legal', 'reference', 'system', 'troubleshooting']
---
FL ALL FAMILY 135 - DECLARATION IN OPPOSITION TO TEMPORARY FAMILY LAW ORDERS

KING COUNTY SUPERIOR COURT FAMILY LAW DIVISION

VERONIKA GOODNIGHT (Pro Se), Petitioner,
v.                                          No. 20-3-03830-3 SEA
MATTHEW RALIDAK, Respondent.

DECLARATION IN OPPOSITION TO TEMPORARY FAMILY LAW ORDERS
(FL All Family 135)

## I. DECLARATION SUMMARY

I, Veronika Goodnight, declare under penalty of perjury under the laws of Washington State:

**PROFESSIONAL RECOMMENDATION:** Dr. Oreskovich, board-certified psychiatrist in General Psychiatry and Addiction Psychiatry, concluded "no reason to preclude [mother] having sole custody" after comprehensive 3-hour evaluation and 210-document review using SCID-5 diagnostic interview.

**GOVERNMENT SUPPORT:** Police, DCYF, DOH, and this Court have all supported my fitness as primary caregiver.

**CONSTITUTIONAL VIOLATION:** Children have been separated from me for 143 consecutive days (20.4 weeks) - representing a 2,040% violation of this Court's previous guidance of "not more than one week" - requiring immediate constitutional remedy through custody restoration.

**OPPOSITION:** I respectfully oppose the temporary family law order requests based on the professional evidence detailed below.

---

## II. SPECIFIC OPPOSITION TO EACH REQUEST

### A. Mental Health Evaluation Request - **SHOULD BE DENIED - ALREADY COMPLETED**

**RESPONDENT'S CLAIM:** Mother needs mental health evaluation to determine fitness

**EVIDENCE IN OPPOSITION:**
- **Dr. Oreskovich (Board-Certified Psychiatrist):** Completed comprehensive 3-hour evaluation with 210-document review
- **PROFESSIONAL CONCLUSION:** **"No reason to preclude [mother] having sole custody"**
- **STATUS:** Evaluation completed, recommends **opposite** of Respondent's requests

**GROUNDS FOR DENIAL:** Request is moot—professional evaluation already completed and supports sole custody to mother.

### B. Children Remain with Father - **SHOULD BE DENIED - CONTRADICTED BY EVIDENCE**

**RESPONDENT'S CLAIM:** Children unsafe with mother, must remain with father

**EVIDENCE IN OPPOSITION:**
- **Professional Psychiatric Evaluation:** Recommends sole custody to mother
- **Dr. Stacy Bowker, ND:** 5+ year primary care provider declared under penalty of perjury that mother demonstrates "responsibility and attentiveness in managing her children's healthcare needs"
- **DCYF Professional Assessment:** Official investigation found father "has fabricated stories to the courts, medical providers, and the school about the mother"
- **Police Investigation:** "No crime occurred" (official finding)
- **This Court's Previous Finding:** Mother performed "majority of day-to-day child-rearing"
- **Children's Voice:** Child states "She does want to go back and live with mom"

**GROUNDS FOR DENIAL:** All professional evidence supports custody restoration to mother.

### C. Mental Health Classes Request - **SHOULD BE DENIED - NO FACTUAL BASIS**

**RESPONDENT'S CLAIM:** Mother needs "parenting classes specifically addressing child abuse"

**EVIDENCE IN OPPOSITION:**
- **Police Finding:** "No crime occurred"—no abuse substantiated
- **DCYF Investigation:** Despite Respondent's claims of "18+ CPS intakes," NO trained CPS professional ever interviewed children - all investigations closed with no findings against mother (confirmed by DCYF Supervisor Jazie Smith). Four government agencies (Police, DCYF, DOH, Court) have unanimously found no issues with mother's fitness.
- **Professional Assessment:** Dr. Oreskovich found no concerns warranting such classes
- **Medical Professional Validation:** Dr. Bowker documented mother's consistent responsible healthcare management
- **Strategic Litigation Pattern:** Court records document escalating abusive litigation: 40+ motions over 5 years with 2025 escalation (9 motions in 4 months); three simultaneous motions filed July 11, 2025 (same day DVPO expired—strategic coordination); latest contempt motion filed August 15, 2025 and denied same day (Document #443) for procedural defects, demonstrating litigation management incompetence vs. Petitioner's full King County GR 14 compliance

**GROUNDS FOR DENIAL:** No factual or professional basis for child abuse-related classes.

### D. Restraining Order Continuation - **SHOULD BE DENIED - STRATEGIC LITIGATION**

**RESPONDENT'S CLAIM:** Emergency protection order necessary for safety

**EVIDENCE IN OPPOSITION:**
- **Timeline Analysis:** 21-day delay between police clearance (April 4) and filing (April 25)
- **Emergency Standards:** Courts act "within hours" for genuine emergencies
- **Systematic Pattern:** Court records document 40+ motions over 5 years with less than 5% success rate for Respondent
- **Recent Court Action:** Respondent's August 15 motion denied same day (Document #443) due to procedural filing defects
- **Pattern Evidence:** $8,500 previous sanctions for similar litigation. **August 15, 2025:** Most recent motion denied same day due to procedural filing errors

**GROUNDS FOR DENIAL:** Delay proves strategic rather than emergency nature.

---

## III. OVERWHELMING PROFESSIONAL EVIDENCE SUPPORTING MOTHER

### A. Dr. Oreskovich Psychiatric Evaluation (Primary Evidence)

**PROFESSIONAL CREDENTIALS:** Board-certified psychiatrist, court-appointed neutral evaluator
**EVALUATION PROCESS:** 3-hour comprehensive assessment with 210-document review
**CONCLUSION:** **"There is no reason to preclude her from having primary residential care"**
**RECOMMENDED ARRANGEMENT:** **Sole custody to mother**
**LEGAL IMPACT:** Directly contradicts every request in Respondent's motion

### B. Government Validation Matrix (4-0 Support)

**POLICE DEPARTMENT:**
- Investigated same April 4 incident Respondent relies upon
- **Official Finding:** "No crime occurred"
- Status: Complete clearance

**DCYF (CHILD PROTECTIVE SERVICES):**
- All investigations regarding mother completed
- **Official Finding:** No findings against mother
- Status: All cases closed with mother cleared

**DEPARTMENT OF HEALTH:**
- Currently investigating therapist who aided separation
- **Professional Misconduct Complaint:** License #MC61294206 under investigation
- Status: Active investigation of professional violations

**THIS COURT:**
- Judge Rampersad's March 3, 2022 findings
- **Official Finding:** Mother performed "majority of day-to-day child-rearing"
- **Guidance:** "Children should not be away from their mother for more than one week"

**CONCLUSION:** Unanimous government validation supports mother vs. unsubstantiated allegations.

### C. Children's Documented Preferences

**THERAPY NOTES EVIDENCE:**
- Despite therapeutic pressure, child expressed authentic voice
- **Documented Statement:** "She does want to go back and live with mom"
- **Professional Context:** Licensed therapist documented child's preference

**CONSTITUTIONAL SIGNIFICANCE:**
- Washington courts consider children's preferences in custody determinations
- Children's voice supports mother despite systematic alienation attempts

---

## IV. CONSTITUTIONAL ANALYSIS

### A. Excessive Separation Duration

**CURRENT SEPARATION:** 143 consecutive days since April 4, 2025

**JUDICIAL STANDARD:** This Court's previous guidance of "one week" maximum

**MATHEMATICAL VIOLATION:**
- **Court Standard:** 7 days maximum separation
- **Current Reality:** 143 days ongoing  
- **Violation Ratio:** 143 ÷ 7 = 20.4x the judicial guidance
- **Percentage Excess:** 2,040% longer than deemed appropriate

**CONSTITUTIONAL IMPACT:** Prolonged separation without substantive hearing violates due process and requires immediate remedy through custody restoration to the professionally validated primary caregiver

### B. Emergency Standards Violation

**WASHINGTON STANDARD:** Courts act "within hours" for genuine child safety emergencies
**ACTUAL TIMELINE:** 21-day delay between police clearance and protection order filing
**LEGAL CONCLUSION:** Delay proves strategic litigation, not emergency protection

---

## V. EVIDENCE QUALITY COMPARISON

### A. Mother's Evidence (Transparent & Professional)

- **Board-certified psychiatric evaluation** (comprehensive professional assessment)
- **Government agency investigations** (official findings, public record)
- **Police reports** (verifiable public record)
- **Court determinations** (judicial findings on record)

### B. Respondent's Evidence (Legally Insufficient)

- **Sealed therapeutic reports** obtained through RCW 71.34 violations
- **Professional misconduct investigation** of therapist currently active following **DCYF official referral to Department of Health for professional licensing violations** after documented violation of statutory parental participation requirements
- **Impossible child vocabulary** ("white knuckling"—adult therapeutic language)
- **Statutory violations** in parental participation requirements for children's mental health decisions

---

## VI. WASHINGTON STATE LAW VIOLATIONS

### A. RCW 71.34 Systematic Violations

**STATUTORY REQUIREMENT:** "All behavioral health care providers shall assure that minors' parents are given an opportunity to participate in the treatment decisions for their minor children"

**ACTUAL PRACTICE:** Systematic exclusion of mother from all therapeutic processes
**LEGAL CONSEQUENCE:** Evidence obtained through statutory violations should be excluded
**REMEDY REQUIRED:** Therapeutic process must restart with both parents participating

### B. Parental Rights Violations

**CONSTITUTIONAL FRAMEWORK:** Fundamental right to parent-child relationship
**VIOLATION:** 143-day separation without substantive hearing
**LEGAL STANDARD:** Compelling state interest required for such separation
**REALITY:** No compelling interest established—police found "no crime occurred"

---

## VII. REQUEST FOR RELIEF

**WHEREFORE, I respectfully request this Court:**

1. **DENY** all temporary family law order requests as contradicted by professional evidence
2. **ORDER** immediate custody restoration per Dr. Oreskovich psychiatric recommendation  
3. **FIND** RCW 71.34 violations invalidate therapeutic evidence obtained without proper consent
4. **RECOGNIZE** 143-day separation constitutes constitutional violation requiring remedy
5. **AWARD** reasonable attorney fees for defending against motion based on discredited evidence
6. **ESTABLISH** safeguards preventing future therapeutic system manipulation

---

## VIII. DECLARATION CONCLUSION

**PROFESSIONAL CONSENSUS ESTABLISHED:** Dr. Oreskovich's recommendation for sole custody to mother, supported by unanimous government validation, creates overwhelming evidence contradicting all of Respondent's requests.

**STRATEGIC PATTERN EVIDENCE:** The 21-day delay between police clearance and protection order filing, combined with three simultaneous motions filed on DVPO expiration day (July 11, 2025), plus August 15 contempt motion denied same day for procedural defects, demonstrates escalating pattern of strategic litigation using discredited evidence and procedural violations, contrasted with Petitioner's full legal compliance.

**CONSTITUTIONAL REMEDY REQUIRED:** The 143-day separation representing 20.4x violation of this Court's guidance demands immediate correction through custody restoration to the professionally validated primary caregiver.

I declare under penalty of perjury under the laws of Washington State that the foregoing is true and correct.

DATED this _____ day of August, 2025.

_________________________
VERONIKA GOODNIGHT
Petitioner, Pro Se

---

**CERTIFICATE OF SERVICE**

I hereby certify that a true and correct copy of the foregoing Declaration was served upon Respondent's counsel via email as agreed:

Jennifer Miller, WSBA #31600
Mukilteo Divorce & Family Law LT PLLC
Email: jennifer@legalbymiller.com and camdyn@familylawlt.com

_________________________
VERONIKA GOODNIGHT