---
title: "Beth Legal Navigation Guide"
type: "legal-reference"
tier: 1
audience: "beginner"
beth_topics: ["legal", "navigation", "case-management", "documentation"]
estimated_read_time: "3 min"
summary: "Navigate your legal case files efficiently using Beth's intelligent document discovery"
---

# 🏛️ Beth Legal Navigation Guide

## Quick Navigation Commands

### Find Documents by Topic
```bash
# Find all authentication-related legal docs
tia beth explore "authentication"

# Find evidence related to therapy violations
tia beth explore "therapy violations"

# Find court filings and orders
tia beth explore "court orders"
```

### Search by Legal Keywords
```bash
# Find all documents mentioning specific terms
tia search content "adequate cause" --path ~/Legal
tia search content "protection order" --path ~/Legal
tia search content "parenting plan" --path ~/Legal
```

### Navigate Case Structure
```bash
# Explore case relationships
tia beth graph explore ~/Legal/01_ACTIVE_CASE/evidence/CASE_FILE.md

# Find related documents
tia beth explore "Goodnight v Ralidak"
```

## Document Tier System

- **Tier 1**: Master navigation, active hearing prep
- **Tier 2**: Core case evidence, supporting documents  
- **Tier 3**: Archive materials, reference documents
- **Tier 4**: Detailed analysis, working papers
- **Tier 5**: Raw evidence extractions, technical data

## Key Beth Topics for Legal Work

- `legal` - General legal documents
- `case-management` - Case organization
- `evidence` - Evidence files and analysis
- `court-filings` - Prepared legal documents
- `authentication` - Document verification
- `timeline` - Chronological case elements

## Integration with TIA Email System

```bash
# Search legal emails
tia email search "legal document" --case YourCase

# Process email evidence
tia email extract --legal-format
```

This navigation system helps you quickly find relevant documents across your complex case structure!